 
/*
** This was coped from MAIN-IBM so some things may be messy.
*/
 
#include "angband.h"
 
#ifdef USE_VME
 
/* System headers */
#include <string.h>
#include <ctype.h>
#include <stdio.h>
 
/* Some prototypes and definitions */
 
#define FIELD_SY 1
#define FIELD_SX 80
#define FIELD_EY 2
#define FIELD_EX 10
 
void GetAddr( int,int,char * );
void InitConsole();
void TerminateConsole();
void ResetScrBuf();
void AddScrBuf(char *,int);
char InKey();
void ScreenClear();
void ResetDISP();
int kbhit();
void ShowLine(int y,int x,int len);
void LoadProfile();
 
/* Changed lines marker. */
 
char DISP[26];
 
/* Max rows & columns number in screen (note that in older version
** than 2.7.9 we needed 25 lines, though 24th was unused. So it is set
** to 25 although screen actually has only 24 lines. (we just used to
** transfer 25th line into 24th.
** But in new version we no longer use it.
*/
 
int rows, cols;
 
/* Game cursor position on screen */
 
int curx=1;
int cury=1;
 
/*
 * Virtual Screen
 */
byte VirtualScreen[2048];
byte ScreenAttr[2048];
 
/* This array is used for "wiping" the screen, initialized in "init_wat()" */
byte wiper[256];
 
/* The main screen */
static term term_screen_body;
 
int ScreenRows(void)
{
    return 25;
}
 
int ScreenCols(void)
{
    return 80;
}
 
/* Update line on screen.
** Actually just set flag that we should update it.
*/
void ScreenUpdateLine(int line)
{
    DISP[line+1]=1;
}
 
/* Clear the whole screen */
void ScreenClear(void)
{
    int iy;
 
    for (iy = 0; iy < rows; iy++)
    {   memcpy(VirtualScreen + (iy*cols), wiper, cols );
        memset(ScreenAttr + (iy*cols), 0xF1, cols );
        ScreenUpdateLine(iy);
    }
}
 
 
/*
 * Nuke a Term
 */
static void Term_nuke_vm(term *t)
{
    TerminateConsole();
    puts("Console has been terminated(nuke).");
}
 
/* Move the cursor */
static errr Term_curs_vm(int x, int y, int z)
{
    /* Hack: mark line cursor was at as changed to ensure that old
    ** cursor would be removed.
    */
    DISP[cury]=1;
    curx=x+1;
    cury=y+1;
    return (0);
}
 
 
/*
 * The Angband color table
 *
 * Comment: white has been changed to blue to make screen look better.
*/
static const byte vm_color[] = {
 
    0xF1, 0xF1, 0xF7, 0xF3,
    0xF2, 0xF4, 0xF7, 0xF6,
    0xF7, 0xF7, 0xF5, 0xF6,
    0xF2, 0xF4, 0xF1, 0xF6
};
 
/*
 * Place some text on the screen using an attribute
 */
static errr Term_text_vm(int x, int y, int n, byte a, cptr s)
{
    register int i;
    register byte attr;
    register byte *dest;
    register byte *dest2;
 
    /* Attribute... */
    attr=vm_color[a];
 
    /* Allow negative length */
    if (n < 0) n = strlen(s);
 
    /* Paranoia */
    if (n > cols - x) n = cols - x;
 
    /* Access the destination */
    dest = VirtualScreen + ((cols * y) + x);
    dest2 = ScreenAttr + ((cols * y) + x);
 
    /* Virtually write the string */
    for (i = 0; (i < n) && s[i]; i++) {
        *dest++ = s[i];
        *dest2++=attr;
    }
 
    /* Dump the line */
    ScreenUpdateLine(y);
 
    /* Success */
    return (0);
}
 
 
/*
 * Erase part of line.
 */
static errr Term_wipe_vm(int x, int y, int w)
{
 
    /* Paranoia -- Verify the dimensions */
    if (cols < (w+x)) w = (cols-x);
 
    /* Wipe part of the virtual screen, and update */
    memcpy(VirtualScreen + (y*cols + x), wiper, w);
    memset(ScreenAttr + (y*cols + x), 0xF1, w);
    ScreenUpdateLine(y);
 
    /* Success */
    return (0);
}
 
/*
** Handle special request.
*/
 
static errr Term_xtra_vm(int n, int v)
{
    int i, j;
 
    /* Analyze the request */
    switch (n) {
 
       /* Make a noise */
       case TERM_XTRA_NOISE:
 
          /* No noises here! :) */
           return( 0 );
 
       /* Wait for a single event */
       case TERM_XTRA_EVENT:
 
           /* No wait key press check */
           if ((!v)&&(!kbhit())) return( 1 );
 
           /* Wait for a keypress */
           i = getkey();
 
           Term_keypress(i);
           /* Success */
           return( 0 );
 
       case TERM_XTRA_CLEAR:
           ScreenClear();
           return(0);
 
 
    }
 
    /* Unknown request */
    return (1);
}
 
/*
 * Initialize the VM/CNSconsole.
 */
 
errr init_vm()
{
    register i;
    term *t = &term_screen_body;
 
    short blank = ' ';
 
    static int done = FALSE;
 
    /* Paranoia -- Already done */
    if (done) return (-1);
 
    /* Build a "wiper line" of blank spaces */
    for (i = 0; i < 256; i++) wiper[i] = blank;
 
    /* Acquire the size of the screen */
    rows = ScreenRows();
    cols = ScreenCols();
 
    /* Make the virtual screen */
 
    InitConsole();
 
 
    for (i = 0; i < rows; i++) {
        /* Wipe that row */
        memcpy(VirtualScreen + (i*cols), wiper, cols);
        memset(ScreenAttr + (i*cols), 0xF1, cols);
    }
 
    /* Erase the screen */
    ScreenClear();
 
    /* Initialize the term -- very large key buffer */
    term_init(t, cols, rows - 1, 1024);
 
    /* Prepare the init/nuke hooks */
    t->nuke_hook = Term_nuke_vm;
 
    /* Connect the hooks */
    t->text_hook = Term_text_vm;
    t->wipe_hook = Term_wipe_vm;
    t->curs_hook = Term_curs_vm;
    t->xtra_hook = Term_xtra_vm;
 
    /* Save it */
    term_screen = t;
 
    /* Activate it */
    Term_activate(term_screen);
 
    /* Done */
    done = TRUE;
 
    /* Success */
    return 0;
}
 
/* Wait for keypress */
int
getkey( void )
{
    return((int)InKey());
}
 
/*********************************************************************/
/*********************************************************************/
/******************   Actual work with console   *********************/
/*********************************************************************/
 
 
/* Low-level functions */
int  CNSINIT(char *path,int device);
int  CNSTERM(char *path);
int  CNSREAD(char *path,char *buffer,int buflen);
int  CNSWRITE(char *path,char *buffer,int buflen);
 
#define _PF1    (0xF1)
#define _PF2    (0xF2)
#define _PF3    (0xF3)
#define _PF4    (0xF4)
#define _PF5    (0xF5)
#define _PF6    (0xF6)
#define _PF7    (0xF7)
#define _PF8    (0xF8)
#define _PF9    (0xF9)
#define _PF10   (0x7A)
#define _PF11   (0x7B)
#define _PF12   (0x7C)
#define _PF13   (0xC1)
#define _PF14   (0xC2)
#define _PF15   (0xC3)
#define _PF16   (0xC4)
#define _PF17   (0xC5)
#define _PF18   (0xC6)
#define _PF19   (0xC7)
#define _PF20   (0xC8)
#define _PF21   (0xC9)
#define _PF22   (0x4A)
#define _PF23   (0x4B)
#define _PF24   (0x4C)
 
#define _PA2    (0x6E)
#define _PA3    (0x6B)
 
#define _CLEAR  (0x60)
 
#define _ENTER  (0x7D)
 
extern char cnscrstb[];   /* Hardware 3270 cursor offsets */
 
/* Console identificator */
char *cons="console";
 
/* Console interrupt flag; should be set by assembler patch */
int CNSINTR;
/* Assembler function prototype; this handles console interrupt */
extern int CNSHD();
 
/* Buffer for output stream (VM/ESA uses streams to control terminals */
static char * ScrBuf;
/* Incoming buffer from console after cnsread */
static char * InBuf;
/* User entered command buffer (paranoia: make it so long no one will
** ever run short of it :)
*/
static char ComBuf[256];
/* Pointer to current position in ComBuf */
static char * ComPtr;
/* This array is used to clean up input field.
** Comment: erase everything user entered after we accepted it.
*/
static char wiping[]={0,0,0,0,0,0,0,0,0,0,0,0};
/* Flag: should we wipe input field ? */
static int wipe=0;
/* Counter: how many times did game checked if we pressed any key.
** Comment: after every 100th we update the screen.
** Comment2: because of slow work with screen it would be _very_
**           unwise to make it more often.
*/
static int kbhitcount;
/* Keep length of collected output stream */
static int BufLen;
/* Define array which will be used to bring actual cursor
** (not game cursor!!!) back to the beginning of input field.
*/
static char CursorHome[]={0,0,0,0x13};
/* Define array to make fields on the screen.
** Comment: 2 fields: input field(writable), and game field(protected).
** Comment2: We will change PSS settings into dumb repeating of color
**           setting if PSS fonts are not abailable.
*/
static char ScrField[]={0,0,0,0x29,0x03,0xC0,0xC1,0x42,0xF3,0x43,0xC1,\
                        0,0,0,0x29,0x03,0xC0,0x60,0x42,0xF1,0x43,0xC1};
/* Last command user entered (for repeating purposes */
static char LastCmd[256];
/* Array which holds PFkeys definitions */
static char PFcmd[25][80];
 
 
/* Actually initialize console ... */
void InitConsole( void )
 {
    /* Use this to activate full screen mode after console has been
    ** initialized.
    */
    unsigned char init[6] = {0xC2,0x11,0x40,0x40,0,0};
    int i;
    /* Array for checking is PSS fonts are loaded */
    char pss[256];
 
    /* Allocate memory */
    ScrBuf=malloc(4100);
    if(ScrBuf==NULL)
     {
        puts("Cannot mallocate memory for screen buffer!");
        exit(77);
     }
    /* Block system standarts... */
    system("cp set msg off");
    system("cp set emsg off");
    system("cp set imsg off");
    system("cp term brkkey none");
    /* Test PSS */
    system("desbuf");
    system("query display (stack");
    gets(pss);
    i=1;
    if(pss[63]!='P') i=0;
    if(pss[64]!='S') i=0;
    if(pss[65]!='S') i=0;
    if(pss[72]!='0') i=0;
    if(pss[73]!='1') i=0;
    if(pss[74]!='A') i=0;
    if(pss[75]!='B') i=0;
    if(i==0)
     {
      /* No PSS. Change PSS definition into repeated color definition */
        puts("WARNING: I will not use PSS fonts!");
        ScrField[9]=0x42;
        ScrField[10]=0xF3;
        ScrField[20]=0x42;
        ScrField[21]=0xF1;
     }
    ScrBuf[0]=0xC2;
    ScrBuf[1]=0;
    BufLen=1;
    /* Allocate memory */
    InBuf=malloc(200);
    if(InBuf==NULL)
     {
        puts("Cannot mallocate memory for screen buffer!");
        exit(77);
     }
    /* Okay, lets make some intial assigments */
    InBuf[0]=0;
    ComBuf[0]=0;
    ComPtr=ComBuf;
    LastCmd[0]=0;
    GetAddr(FIELD_SY,FIELD_SX,ScrField);
    GetAddr(FIELD_EY,FIELD_EX,ScrField+11);
    GetAddr(FIELD_SY,FIELD_SX+1,wiping);
    GetAddr(FIELD_SY,FIELD_SX+1,CursorHome);
    /* Initialize console */
    cnsxinit( cons,0x9,1,CNSHD );
    /* Activate full-screen mode */
    cnswrite( cons,init,6 );
    /* No lines on screen were changed */
    for(i=1;i<25;i++)
        DISP[i]=0;
    /* Corsor home... */
    AddScrBuf(CursorHome,sizeof(CursorHome));
    /* No console interrupt yet */
    CNSINTR=0;
    /* No check keypresses yet */
    kbhitcount=0;
    /* Let's load 'profile angband' for PFs settings */
    LoadProfile();
 }
 
void TerminateConsole( void )
 {
    free(ScrBuf);
    free(InBuf);
    /* Terminate console */
    cnsterm( cons );
    /* Restore system defaults.
    ** Comment: better we should have written them down at start but
    ** it is reasonably difficult to make, so just set standart values.
    */
    system("cp set msg on");
    system("cp set emsg on");
    system("cp set imsg on");
    system("cp term brkkey pa1");
 }
 
/* Reset collected output stream */
void ResetScrBuf()
 {
    int i;
 
    /* Where shall cursor be ? */
    GetAddr(cury,curx,ScrBuf+BufLen);
    BufLen+=3;
    /* Actually 'make' cursor : underline symbol */
    ScrBuf[BufLen]=0x28;
    ScrBuf[BufLen+1]=0x41;
    ScrBuf[BufLen+2]=0xF4;
    ScrBuf[BufLen+3]=0x28;
    ScrBuf[BufLen+4]=0x42;
    ScrBuf[BufLen+5]=*(ScreenAttr+(cury-1)*cols+curx-1);
    ScrBuf[BufLen+6]=*(VirtualScreen+(cury-1)*cols+curx-1);
    ScrBuf[BufLen+7]=0x28;
    ScrBuf[BufLen+8]=0x41;
    ScrBuf[BufLen+9]=0x00;
    BufLen+=10;
    /* Draw screen fields.
    ** Comment: paranoia, should always be there, but won't be any worse
    **          if we redraw them.
    */
    memcpy(ScrBuf+BufLen,ScrField,22);
    if(wipe)
     {
        /* If we should wipe input field, let's do it. */
        wipe=0;
        memcpy(ScrBuf+BufLen+22,wiper,sizeof(wiping));
        /* Actually write to terminal */
        cnswrite(cons,ScrBuf,BufLen+22+sizeof(wiping));
     }
    else
     {
        /* Actually write to terminal */
        cnswrite(cons,ScrBuf,BufLen+22);
     }
    /* Discard old output stream */
    ScrBuf[0]=0xC2;
    ScrBuf[1]=0;
    BufLen=1;
 }
 
/* Just add some more to output stream */
void AddScrBuf(char * ptr,int len)
 {
    /* Stream cannot be longer than 4k, so reset it */
    if (len+BufLen>4000) ResetScrBuf();
    memcpy(ScrBuf+BufLen,ptr,len);
    BufLen+=len;
 }
 
/* Calculate codes for cursor setting and write them down into *stream.
** Comment: system has _really crazy tables for this calculation so
**          we need function for this.
*/
void GetAddr( int y,int x,char *stream )
 {
    int sx,sy,len;
 
    len = y * 80 + x - 81;
 
    sx = len & 0x3F;
    sy = len >> 6;
 
    *stream++ = 0x11;
    /* Use standart array for cursor offsets (VMSERV TXTLIB) */
    *stream++ = cnscrstb[sy];
    *stream = cnscrstb[sx];
 }
 
/* Okay, program requested pressed key, let's return it */
char InKey()
 {
    char ret;
    char * info;
    int i;
    char *ptr,*ptrs;
    int PF;
    int prev;
 
    /* If we didn't finish previous line user entered just return
    ** next symbol.
    ** Comment: unlikely IBM PC and others user may enter string
    **          of any length (limited by input field length to 9
    **          symbols) and only them by pressing ENTER key or
    **          functional key make real console interrupt.
    **          So we should handle everything user entered.
    */
    if (*ComPtr)
     {
        ret=*ComPtr;
        ComPtr++;
        return(ret);
     }
    /* If we get here than user command buffer is empty and we have
    ** actually wait for new command.
    */
    /* Okay, update screen before :) */
    ResetDISP();
    /* Well, now wait till user enters something and read it. */
    cnsread(cons,InBuf,200);
    /* Oh, we already handling interrupt so, reset interrupt flag */
    CNSINTR=0;
    /* No previous cmd inserted yet */
    prev=0;
    /* User pressed CLEAR key. Redraw all screen then. */
    if (*InBuf==0x6D)
     {
        /* Hack: mark all lines as changed */
        for(i=1;i<26;i++)
            DISP[i]=1;
        /* Cursor home */
        AddScrBuf(CursorHome,sizeof(CursorHome));
        /* Redraw the whole screen */
        ResetDISP();
        /* Hack: we should return something, shouldn't we?
        ** Just return CR. It seems safest.
        */
        return(13);
     }
    /* Okay parse stream from console to make string only of
    ** user's input.
    */
    info=memchr(InBuf,0x1D,200);
    info+=2;
    info[9]=0;
    /* Mark that we should clear input field */
    wipe=1;
    /* Cursor home */
    AddScrBuf(CursorHome,sizeof(CursorHome));
    /* Pointer to current letter in buffered command set to start */
    ComPtr=ComBuf;
    /* Clear length buffer */
    ComBuf[0]=0;
    switch(*InBuf)
     {
        /* PA2 & PA1 */
        case 0x6E:;
        case 0x6C:
            /* These 2 keys are supposed to mean 'ESC' */
            return(27);
            break;
        /* Hack: determine which PF key was exactly pressed.
        ** See 'gw.h' for _PF definitions.
        */
        case _PF1:
            PF=1;
            break;
        case _PF2:
            PF=2;
            break;
        case _PF3:
            PF=3;
            break;
        case _PF4:
            PF=4;
            break;
        case _PF5:
            PF=5;
            break;
        case _PF6:
            PF=6;
            break;
        case _PF7:
            PF=7;
            break;
        case _PF8:
            PF=8;
            break;
        case _PF9:
            PF=9;
            break;
        case _PF10:
            PF=10;
            break;
        case _PF11:
            PF=11;
            break;
        case _PF12:
            PF=12;
            break;
        case _PF13:
            PF=13;
            break;
        case _PF14:
            PF=14;
            break;
        case _PF15:
            PF=15;
            break;
        case _PF16:
            PF=16;
            break;
        case _PF17:
            PF=17;
            break;
        case _PF18:
            PF=18;
            break;
        case _PF19:
            PF=19;
            break;
        case _PF20:
            PF=20;
            break;
        case _PF21:
            PF=21;
            break;
        case _PF22:
            PF=22;
            break;
        case _PF23:
            PF=23;
            break;
        case _PF24:
            PF=24;
            break;
        /* Uh, user pressed ENTER.
        ** Determine if we should add 'CR' at the end or not ?
        */
        case _ENTER:
            PF=0;
            /* Copy entered string into buffer */
            strcpy(ComBuf,info);
            /* Never end strings of length 1 or 0 with CR */
            if(strlen(ComBuf)<2) break;
            /* If string ends with R* or R& add CR */
            ptr=info+strlen(info)-1;
            if(*ptr=='*'||*ptr=='&')
             {
                ptr--;
                if(ptr<info) break;
                if(*ptr!='R') break;
                ptr=ComBuf+strlen(ComBuf);
                ptr[0]=13;
                ptr[1]=0;
                break;
             }
            /* Well, only numbers should be padded with CR.
            ** Comment: handle 18/... too.
            */
            if(!isdigit(*ptr)) break;
            ptr--;
            i=1;
            while(ptr>=info)
             {
                if(*ptr=='R') break;
                if(*ptr=='@'&&ptr==info)
                    break;
                if(*ptr=='/')
                 {
                    i=0;
                    if(*(ptr-1)!='8') break;
                    if(*(ptr-2)!='1') break;
                    if((ptr-2)!=info) break;
                    i=1;
                    break;
                 }
                if(!isdigit(*ptr))
                 {
                    i=0;
                    break;
                 }
                ptr--;
             }
            if(i)
                ptr=ComBuf+strlen(ComBuf);
                ptr[0]=13;
                ptr[1]=0;
            break;
        default:
            PF=0;
     }
    /* Okay let's proceed with parsing PFkeys commands */
    ptrs=PFcmd[PF];
    ptr=ComBuf;
    /* If key actually was PF and we didn't run into end of PF
    ** command definition...
    */
    while(*ptrs && PF)
     {
        /* If not '\' just copy symbol into buffer */
        if(*ptrs!='\\')
         {
            *ptr=*ptrs;
            ptr++;
            ptrs++;
            continue;
         }
        /* We have discovered '\'. Let's resolve it. */
        ptrs++;
        switch(*ptrs)
         {
            /* End of line ? Do nothing then. */
            case 0:
                break;
            /* User actually wants '\' */
            case '\\':
                *ptr='\\';
                ptr++;
                break;
            /* User wants his previous command inserted. */
            case 'p':
                /* Set flag that we used previous command */
                prev=1;
                strcpy(ptr,LastCmd);
                ptr=ComBuf+strlen(ComBuf);
                break;
            /* Insert string user actually entered */
            case 's':
                strcpy(ptr,info);
                ptr=ComBuf+strlen(ComBuf);
                break;
            /* User wants 'CR' */
            case 'n':
                *ptr=13;
                ptr++;
                break;
            /* ESC */
            case 'c':
                *ptr=27;
                ptr++;
                break;
            /* Hmm, urecognized command. Just copy letter. */
            default:
                *ptr=*ptrs;
                ptr++;
         }
        if(ptrs) ptrs++;
     }
    /* Terminate string with 0 if neccessary */
    if(PF) *ptr=0;
    /* Empty string? User probably wants to send CR. */
    if(!(*ComBuf))
     {
        return(13);
     }
    /* Okay, set pointer to next letter */
    ComPtr++;
    /* Backup last command if not empty */
    ptr=ComBuf;
    /* String still "empty" */
    i=1;
    while((*ptr)&&i)
     {
         if((*ptr!=13)&&(*ptr!=' ')&&(*ptr!='27'))
             i=0;
         ptr++;
     }
    /* Never update previous command if we inserted it.
    ** Comment: this is to avoid recursively multiplying previous
    **          commands.
    */
    if((!i)&&(!prev))
        strcpy(LastCmd,ComBuf);
    /* Return something */
    return(*ComBuf);
 }
 
/* Here we draw all changed lines */
void ResetDISP()
 {
    int i;
 
    /* No need to redraw screen in near future */
    kbhitcount=0;
    for(i=1;i<25;i++)
        if (DISP[i]!=0)
         {
            /* If line was changed, it won't stay changed any more */
            DISP[i]=0;
            /* We don't want to erase input field definitons from
            ** screen, so check it carefully.
            */
            switch(i)
             {
                case FIELD_SY:
                    ShowLine(i,1,FIELD_SX-1);
                    if (i==FIELD_EY)
                     {
                        ShowLine(i,FIELD_EX+1,80-FIELD_EX);
                     }
                    break;
                case FIELD_EY:
                    ShowLine(i,FIELD_EX+1,80-FIELD_EX);
                    break;
                default:
                    ShowLine(i,1,80);
             }
         }
    /* Okay, actually show something */
    ResetScrBuf();
 }
 
/* Did user press something? */
int kbhit()
 {
    kbhitcount++;
    if (kbhitcount>99)
     {
        /* We waited long enough, time to redraw screen.
        ** Comment: during sleep every 100th turn is shown.
        */
        kbhitcount=0;
        ResetDISP();
     }
    return(CNSINTR);
 }
 
/* Let's show requested line(or part of it). */
void ShowLine(int y,int x,int len)
 {
    char slbuf[512];
    char *ptr,*scr,*attr;
    int i;
    char curattr;
 
    ptr=slbuf+3;
    /* Hack: was used for older version to place 25th string on
    ** 24th.
    */
    if (y<25)
        GetAddr(y,x,slbuf);
    else
        GetAddr(24,x,slbuf);
    /* Set some adresses */
    curattr=0;
    scr=VirtualScreen+(y-1)*cols+x-1;
    attr=ScreenAttr+(y-1)*cols+x-1;
    /* Let's proceed with string. */
    for(i=0;i<len;i++)
     {
        /* Attribute has changed ? Let's add codes for chnaging color */
        if(*attr!=curattr)
         {
            *ptr++=0x28;
            *ptr++=0x42;
            *ptr++=*attr;
            curattr=*attr;
         }
        *ptr++=*scr;
        scr++;
        attr++;
     }
    /* Add string to output stream */
    AddScrBuf(slbuf,ptr-slbuf);
 }
 
void LoadProfile( void )
{
 
    FILE *fp;
    char line[128],*ptr,*pfptr,*p;
    int pf,i;
 
    for( i = 1 ; i <= 24 ; i++ ) strcpy( PFcmd[i],"\\s" );
 
    fp = fopen( "PROFILE ANGBAND","r" );
    if( !fp ) return;
    {   while( fgets( line,128,fp ) )
        {   if( *line == '#' ) continue;
            ptr = strstr( line,"PF" );
            if( !ptr ) continue;
            ptr += 2;
            p = ptr;
            while( isdigit( *p ) ) ++p;
            *p++ = 0;
            pf = atoi( ptr );
            if( pf < 1 || pf > 24 ) continue;
            ptr = strchr( p,'"' );
            ++ptr;
            p = strchr( ptr,'"' );
            if( !p )
            {   puts( "'\"' missing in PROFILE ANGBAND." );
                continue;
            }
            *p = 0;
            strcpy( PFcmd[pf],ptr );
        }
    }
}
 
#endif /* USE_VME */
