  global BudgetWindows
  set n [Unique]
  set win .budget$n
  set BudgetWindows [linsert $BudgetWindows 0 $win]

  LinkWindow $head.budget $win
  LinkWindow $win.head $head

# catch "destroy $win"
  toplevel $win -screen $display

  SetHelp $win Window

  bind $win <Visibility> {BudgetVisible %W [string compare %s FullyObscured]}
  bind $win <Map> {BudgetVisible %W 1}
  bind $win <Unmap> {BudgetVisible %W 0}

  wm title $win {SimCity Budget}
  wm iconname $win {SimCity Budget}
  wm group $win $head
  wm geometry $win 320x400+5+5
  wm positionfrom $win user
  wm maxsize $win 1000 1000
  wm minsize $win 150 200
  wm protocol $win WM_DELETE_WINDOW "BudgetCancel $win"

  frame $win.rightframe\
    -borderwidth 0

  frame $win.rightframe.roadframe\
    -borderwidth 2\
    -relief raised

  label $win.rightframe.roadframe.label\
    -relief flat\
    -font [Font $win Large]\
    -text {            Road Fund            }

  frame $win.rightframe.roadframe.frame\
    -borderwidth 4\
    -relief flat
  LinkWindow $win.road $win.rightframe.roadframe.frame

  label $win.rightframe.roadframe.frame.request\
    -relief flat\
    -font [Font $win Medium]\
    -text {100% of $0 = $0}

  scale $win.rightframe.roadframe.frame.fund\
    -command {BudgetSetRoadFund}\
    -orient horizontal\
    -showvalue false\
    -sliderlength 15\
    -to 100\
    -width 10

  pack append $win.rightframe.roadframe.frame\
    $win.rightframe.roadframe.frame.fund      {top frame center expand fill} \
    $win.rightframe.roadframe.frame.request   {top frame center expand fill}

  pack append $win.rightframe.roadframe\
    $win.rightframe.roadframe.label     {top frame center fillx} \
    $win.rightframe.roadframe.frame     {top frame center expand fill}


  frame $win.rightframe.fireframe\
    -borderwidth 2\
    -relief raised

  label $win.rightframe.fireframe.label\
    -font [Font $win Large]\
    -relief flat\
    -text {Fire Fund}

  frame $win.rightframe.fireframe.frame\
    -borderwidth 4\
    -relief flat
  LinkWindow $win.fire $win.rightframe.fireframe.frame

  label $win.rightframe.fireframe.frame.request\
    -relief flat\
    -font [Font $win Medium]\
    -text {100% of $0 = $0}

  scale $win.rightframe.fireframe.frame.fund\
    -command {BudgetSetFireFund}\
    -orient horizontal\
    -showvalue false\
    -sliderlength 15\
    -to 100\
    -width 10

  pack append $win.rightframe.fireframe.frame\
    $win.rightframe.fireframe.frame.fund      {top frame center expand fill} \
    $win.rightframe.fireframe.frame.request   {top frame center expand fill}

  pack append $win.rightframe.fireframe\
    $win.rightframe.fireframe.label     {top frame center fillx} \
    $win.rightframe.fireframe.frame     {top frame center expand fill}


  frame $win.rightframe.policeframe\
    -borderwidth 2\
    -relief raised

  label $win.rightframe.policeframe.label\
    -relief flat\
    -font [Font $win Large]\
    -text {Police Fund}

  frame $win.rightframe.policeframe.frame\
    -borderwidth 4\
    -relief flat
  LinkWindow $win.police $win.rightframe.policeframe.frame

  label $win.rightframe.policeframe.frame.request\
    -relief flat\
    -font [Font $win Medium]\
    -text {100% of $0 = $0}

  scale $win.rightframe.policeframe.frame.fund\
    -command {BudgetSetPoliceFund}\
    -orient horizontal\
    -showvalue false\
    -sliderlength 15\
    -to 100\
    -width 10

  pack append $win.rightframe.policeframe.frame\
    $win.rightframe.policeframe.frame.fund      {top frame center expand fill}\
    $win.rightframe.policeframe.frame.request   {top frame center expand fill}

  pack append $win.rightframe.policeframe\
    $win.rightframe.policeframe.label     {top frame center fillx} \
    $win.rightframe.policeframe.frame     {top frame center expand fill}


  frame $win.rightframe.taxrateframe\
    -borderwidth 2\
    -relief raised

  label $win.rightframe.taxrateframe.label\
    -relief flat\
    -font [Font $win Large]\
    -text {Tax Rate}

  frame $win.rightframe.taxrateframe.frame\
    -borderwidth 4\
    -relief flat

  label $win.rightframe.taxrateframe.frame.rate\
    -relief flat\
    -font [Font $win Medium]\
    -text {7%}
  LinkWindow $win.taxlabel $win.rightframe.taxrateframe.frame.rate

  scale $win.rightframe.taxrateframe.frame.scale\
    -command {BudgetSetTaxRate}\
    -orient horizontal\
    -showvalue false\
    -sliderlength 15\
    -to 20\
    -width 10
  LinkWindow $win.taxrate $win.rightframe.taxrateframe.frame.scale

  pack append $win.rightframe.taxrateframe.frame\
    $win.rightframe.taxrateframe.frame.scale    {top frame center expand fill}\
    $win.rightframe.taxrateframe.frame.rate     {top frame center expand fill}

  pack append $win.rightframe.taxrateframe\
    $win.rightframe.taxrateframe.label    {top frame center fillx} \
    $win.rightframe.taxrateframe.frame    {top frame center expand fill}


  pack append $win.rightframe\
    $win.rightframe.roadframe    {top frame center expand fill} \
    $win.rightframe.fireframe    {top frame center expand fill} \
    $win.rightframe.policeframe  {top frame center expand fill} \
    $win.rightframe.taxrateframe {top frame center expand fill}


  frame $win.leftframe\
    -borderwidth 0

  frame $win.leftframe.collectedframe\
    -borderwidth 2\
    -relief raised

  label $win.leftframe.collectedframe.label\
    -relief flat\
    -font [Font $win Large]\
    -text {Taxes Collected}

  label $win.leftframe.collectedframe.value\
    -relief flat\
    -font [Font $win Medium]\
    -text {$0}
  LinkWindow $win.collected $win.leftframe.collectedframe.value

  pack append $win.leftframe.collectedframe\
    $win.leftframe.collectedframe.label   {top frame center fillx} \
    $win.leftframe.collectedframe.value   {top frame center expand fill} 

  frame $win.leftframe.cashflowframe\
    -borderwidth 2\
    -relief raised
  LinkWindow $win.cashflow $win.leftframe.cashflowframe.value

  label $win.leftframe.cashflowframe.label\
    -relief flat\
    -font [Font $win Large]\
    -text {Cash Flow}

  label $win.leftframe.cashflowframe.value\
    -relief flat\
    -font [Font $win Medium]\
    -text {+$0}

  pack append $win.leftframe.cashflowframe\
    $win.leftframe.cashflowframe.label   {top frame center fillx} \
    $win.leftframe.cashflowframe.value   {top frame center expand fill} 

  frame $win.leftframe.previousframe\
    -borderwidth 2\
    -relief raised
  LinkWindow $win.previous $win.leftframe.previousframe.value

  label $win.leftframe.previousframe.label\
    -relief flat\
    -font [Font $win Large]\
    -text {Previous Funds}

  label $win.leftframe.previousframe.value\
    -relief flat\
    -font [Font $win Medium]\
    -text {$0}

  pack append $win.leftframe.previousframe\
    $win.leftframe.previousframe.label   {top frame center fillx} \
    $win.leftframe.previousframe.value   {top frame center expand fill} 

  frame $win.leftframe.currentframe\
    -borderwidth 2\
    -relief raised
  LinkWindow $win.current $win.leftframe.currentframe.value

  label $win.leftframe.currentframe.label\
    -relief flat\
    -font [Font $win Large]\
    -text {Current Funds}

  label $win.leftframe.currentframe.value\
    -relief flat\
    -font [Font $win Medium]\
    -text {$0}

  pack append $win.leftframe.currentframe\
    $win.leftframe.currentframe.label   {top frame center fillx} \
    $win.leftframe.currentframe.value   {top frame center expand fill} 

  pack append $win.leftframe\
    $win.leftframe.collectedframe   {top frame center expand fill} \
    $win.leftframe.cashflowframe    {top frame center expand fill} \
    $win.leftframe.previousframe    {top frame center expand fill} \
    $win.leftframe.currentframe     {top frame center expand fill}

  frame $win.bottomframe\
    -borderwidth 0

  frame $win.bottomframe.voteframe \
    -borderwidth 0 \
    -relief raised
  LinkWindow $win.voteframe $win.bottomframe.voteframe

  button $win.bottomframe.voteframe.continue\
    -text {Continue}\
    -font [Font $win Large]\
    -relief raised \
    -command "DoVote $win Budget BudgetContinue {}"
  LinkWindow $win.vote $win.bottomframe.voteframe.continue

  pack append $win.bottomframe.voteframe\
    $win.bottomframe.voteframe.continue	{top frame center fillx}

  BindVotingButton $win $win.bottomframe.voteframe.continue Budget

  button $win.bottomframe.reset\
    -text {Reset}\
    -font [Font $win Large]\
    -command "BudgetReset"

  button $win.bottomframe.cancel\
    -text {Cancel}\
    -font [Font $win Large]\
    -command "BudgetCancel"

  button $win.bottomframe.timer\
    -text {Timeout in 0 seconds ...}\
    -font [Font $win Large]\
    -command "ToggleBudgetTimer"
  LinkWindow $win.timer $win.bottomframe.timer

  pack append $win.bottomframe\
    $win.bottomframe.voteframe	{top frame center expand fillx}\
    $win.bottomframe.reset	{top frame center expand fillx}\
    $win.bottomframe.cancel	{top frame center expand fillx}\
    $win.bottomframe.timer	{top frame center expand fillx}

  pack append $win\
    $win.bottomframe  {bottom frame center fillx} \
    $win.leftframe    {left frame center expand fill} \
    $win.rightframe   {right frame center expand fill}

  sim UpdateBudgets

  update idletasks
  return $win
