/***********************************************************
*  Mirror Magic II -- McDuffins Revenge                    *
*----------------------------------------------------------*
*  1994 Artsoft Development                               *
*        Holger Schemel                                    *
*        33659 Bielefeld-Senne                             *
*        Telefon: (0521) 493245                            *
*        eMail: aeglos@valinor.ms.sub.org                  *
*               aeglos@uni-paderborn.de                    *
*               q99492@pbhrzx.uni-paderborn.de             *
*----------------------------------------------------------*
*  misc.c                                                  *
*                                                          *
*  Letzte Aenderung: 29.09.1994                            *
***********************************************************/

#include "misc.h"

unsigned long be2long(unsigned long *be)	/* big-endian -> longword */
{
  unsigned char *ptr = (unsigned char *)be;

  return(ptr[0]<<24 | ptr[1]<<16 | ptr[2]<<8 | ptr[3]);
}

char *int2str(int ct, int nr)
{
  static char str[20];

  sprintf(str,"%09d",ct);
  return(&str[strlen(str)-nr]);
}

int RND(int max)
{
  return(rand() % max);
}

BOOL anim_restart=TRUE;
long anim_delay=0;

void InitAnimation()
{
  if (!toons_status)
    return;

  anim_restart=TRUE;
  anim_delay=Counter()+RND(200);
}

void StopAnimation()
{
  if (!toons_status)
    return;

  redraw_mask|=REDRAW_FIELD;
  BackToFront();
}

void DoAnimation()
{
  static figure=0;

  if (!toons_status)
    return;

  if (anim_restart)
  {
    if (anim_delay>Counter())
      return;

    figure=RND(5);
  }

  switch(figure)
  {
    case 0:
      anim_restart=AnimDwarf(anim_restart);
      break;
    case 1:
      anim_restart=AnimJumper(anim_restart);
      break;
    case 2:
      anim_restart=AnimClown(anim_restart);
      break;
    case 3:
      anim_restart=AnimBird1(anim_restart);
      break;
    case 4:
      anim_restart=AnimBird2(anim_restart);
      break;
    default:
      break;
  }

  if (anim_restart)
    InitAnimation();
}

BOOL AnimDwarf(BOOL restart)
{
  int width,height;
  int pad_x,pad_y;
  int xp,xs;
  static int l,p;
  static AC,Ac=0;

  height=DWARF_YSIZE;
  pad_x=pad_y=4;

  if (restart)
    l=p=0;
  else if (l>556)
    return(TRUE);

  AC=Counter2();
  if (AC>=Ac && AC<=Ac+100)
    return(FALSE);
  Ac=AC;

  if (++p>7)
    p=0;
  if (l<DWARF_XSIZE)
  {
    width=l;
    xs=-2;
    xp=DWARF_XSIZE-l;
  }
  else 
  {
    width=DWARF_XSIZE;
    xs=l-DWARF_XSIZE-2;
    xp=0;
  }
  if (l>516)
    width=556-l;

  DrawAnim(DWARF_X+p*DWARF_XSIZE+xp,DWARF_Y, width,height,
	   SX+xs,WIN_YSIZE-6-DWARF_YSIZE, pad_x,pad_y);
  l+=4;
  return(FALSE);
}

BOOL AnimJumper(BOOL restart)
{
  int width,height;
  int pad_x,pad_y;
  int xp,xs;
  static int l,p;
  static AC,Ac=0;

  height=JUMPER_YSIZE;
  pad_x=pad_y=4;

  if (restart)
  {
    l=562;
    p=0;
  }
  else if (l<=0)
    return(TRUE);

  AC=Counter2();
  if (AC>=Ac && AC<=Ac+100)
    return(FALSE);
  Ac=AC;

  if (++p>7)
    p=0;
  if (l<JUMPER_XSIZE) 
  { 
    width=l; 
    xs=-2; 
    xp=JUMPER_XSIZE-l; 
  } 
  else 
  {
    width=JUMPER_XSIZE;
    xs=l-JUMPER_XSIZE-2;
    xp=0;
  }
  if (l>516) 
    width=564-l;

  DrawAnim(JUMPER_X+p*JUMPER_XSIZE+xp,JUMPER_Y, width,height,
	   SX+xs,WIN_YSIZE-6-JUMPER_YSIZE, pad_x,pad_y);
  l-=4;
  return(FALSE);
}

BOOL AnimClown(BOOL restart)
{
  int width,height;
  int pad_x,pad_y;
  int xp=0,yp,ys;
  static int l,xs;
  static AC,Ac=0;

  width=CLOWN_XSIZE;
  pad_x=pad_y=4;

  if (restart)
  {
    l=496;
    xs=RND(SXSIZE-CLOWN_XSIZE);
  }
  else if (l<=0)
    return(TRUE);

  AC=Counter2();
  if (AC>=Ac && AC<=Ac+100)
    return(FALSE);
  Ac=AC;

  if (l<CLOWN_YSIZE) 
  { 
    height=l; 
    ys=-2; 
    yp=CLOWN_YSIZE-l; 
  } 
  else 
  {
    height=CLOWN_YSIZE; 
    ys=l-CLOWN_YSIZE-2;
    yp=0;
  }
  if (l>388) 
    height=498-l;

  DrawAnim(CLOWN_X,CLOWN_Y+yp, width,height,
	   SX+xs,SY+ys, pad_x,pad_y);
  l-=4;
  return(FALSE);
}

BOOL AnimBird1(BOOL restart)
{
  int width,height;
  int pad_x,pad_y;
  int xp,xs;
  static int l,p,ys,delta;
  static AC,Ac=0;

  height=BIRD_YSIZE;
  pad_x=pad_y=4;

  if (restart)
  {
    l=p=0;
    delta=1;
    ys=RND(WIN_YSIZE-60);
  }
  else if (l>548)
    return(TRUE);

  AC=Counter2();
  if (AC>=Ac && AC<=Ac+50)
    return(FALSE);
  Ac=AC;

  p+=delta;
  if (p<1 || p>6)
    delta*=-1;
  if (l<BIRD_XSIZE)
  {
    width=l;
    xs=-2;
    xp=BIRD_XSIZE-l;
  }
  else 
  {
    width=BIRD_XSIZE;
    xs=l-BIRD_XSIZE-2;
    xp=0;
  }
  if (l>508)
    width=548-l;

  DrawAnim(BIRD_X+p*BIRD_XSIZE+xp,BIRD_Y, width,height,
	   SX+xs,SY+ys, pad_x,pad_y);
  l+=4;
  return(FALSE);
}

BOOL AnimBird2(BOOL restart)
{
  int width,height;
  int pad_x,pad_y;
  int xp,xs;
  static int l,p,ys,delta;
  static AC,Ac=0;

  height=BIRD_YSIZE;
  pad_x=pad_y=4;

  if (restart)
  {
    l=562;
    p=0;
    delta=1;
    ys=RND(WIN_YSIZE-60);
  }
  else if (l<=-4)
    return(TRUE);

  AC=Counter2();
  if (AC>=Ac && AC<=Ac+50)
    return(FALSE);
  Ac=AC;

  p+=delta;
  if (p<1 || p>6)
    delta*=-1;
  if (l<BIRD_XSIZE) 
  { 
    width=l; 
    xs=-2; 
    xp=BIRD_XSIZE-l; 
  } 
  else 
  {
    width=BIRD_XSIZE;
    xs=l-BIRD_XSIZE-2;
    xp=0;
  }
  if (l>516) 
    width=548-l;

  DrawAnim(BIRD_X+(p+8)*BIRD_XSIZE+xp,BIRD_Y, width,height,
	   SX+xs,ys, pad_x,pad_y);
  l-=4;
  return(FALSE);
}

void DrawAnim(int src_x, int src_y, int width, int height,
	      int dest_x, int dest_y, int pad_x, int pad_y)
{
  int buf_x=200, buf_y=0;

  XCopyArea(display,pix[DB_BACK],pix[DB_DOOR],gc, dest_x-pad_x,dest_y-pad_y,
	    width+2*pad_x,height+2*pad_y, buf_x,buf_y);
  XSetClipOrigin(display,clip_gc[BACK],buf_x-src_x+pad_x,buf_y-src_y+pad_y);
  XCopyArea(display,pix[BACK],pix[DB_DOOR],clip_gc[BACK], src_x,src_y,
	    width,height, buf_x+pad_x,buf_y+pad_y);
  XCopyArea(display,pix[DB_DOOR],window,gc, buf_x,buf_y,
	    width+2*pad_x,height+2*pad_y, dest_x-pad_x,dest_y-pad_y);

  XFlush(display);
}

void DrawBM(int a)
{
}

void SwapBM(int a)
{
}

/* code for usleep() -- used if compiled on SYSV systems */

#ifdef SYSV
/*
 *  NAME:
 *      usleep     -- This is the precision timer for Test Set
 *                    Automation. It uses the select(2) system
 *                    call to delay for the desired number of
 *                    micro-seconds. This call returns ZERO
 *                    (which is usually ignored) on successful
 *                    completion, -1 otherwise.=20
 *
 *  ALGORITHM:
 *      1) We range check the passed in microseconds and log a
 *         warning message if appropriate. We then return without
 *         delay, flagging an error.=20
 *      2) Load the Seconds and micro-seconds portion of the
 *         interval timer structure.
 *      3) Call select(2) with no file descriptors set, just the
 *         timer, this results in either delaying the proper
 *         ammount of time or being interupted early by a signal.
 *
 *  HISTORY:
 *      Added when the need for a subsecond timer was evident.
 *
 *  AUTHOR:
 *      Michael J. Dyer                   Telephone:   AT&T 414.647.4044
 *      General Electric Medical Systems        GE DialComm  8 *767.4044
 *      P.O. Box 414  Mail Stop 12-27         Sect'y   AT&T 414.647.4584
 *      Milwaukee, Wisconsin  USA 53201                      8 *767.4584
 *      internet:  mike@sherlock.med.ge.com     GEMS WIZARD e-mail: DYER
 */

#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/types.h>

int     usleep( unsigned long int microSeconds )
{
        unsigned int            Seconds, uSec;
        int                     nfds, readfds, writefds, exceptfds;
        struct  timeval         Timer;

        nfds = readfds = writefds = exceptfds = 0;

        if( (microSeconds == (unsigned long) 0)
                || microSeconds > (unsigned long) 4000000 )
        {
                errno = ERANGE;         /* value out of range */
                perror( "usleep time out of range ( 0 -> 4000000 ) " );
                return -1;
        }

        Seconds = microSeconds / (unsigned long) 1000000;
        uSec    = microSeconds % (unsigned long) 1000000;

        Timer.tv_sec            = Seconds;
        Timer.tv_usec           = uSec;

        if( select( nfds, &readfds, &writefds, &exceptfds, &Timer ) < 0 )
        {
                perror( "usleep (select) failed" );
                return -1;
        }

        return 0;
}
#endif
