/* ckill -- Nov 18, 1994
 * by Nico Tranquilli
 * Email: tranquil@cli.di.unipi.it
 * URL: http://www.cli.di.unipi.it/~tranquil
 * Dept.of Computer Science, University of Pisa - ITALY
 *
 * version 1.6  -- modified: Apr 30, 1995
 * Platforms: SunOS, Solaris, Xenix, HP-UX, Linux, NeXTSTEP
 */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>

/*#define M_SUN_SunOS4*/      /* <-- uncomment for SunOS4 and Linux */
/*#define M_SUN_Solaris*/     /* <-- uncomment for Solaris          */
/*#define M_XENIX*/           /* <-- uncomment for Xenix            */
/*#define M_HPUX*/            /* <-- uncomment for HP               */
/*#define NeXT*/              /* <-- uncomment for NeXTSTEP         */

#define VERSION "1.6"
#define PS      "/bin/ps"

#define DEFAULTSIG	SIGKILL		/* KILL */

#if (defined(M_HPUX) || defined(M_XENIX) || defined(NeXT) || defined(M_SUN_Solaris))
#  define STY1
#endif

#if (defined(M_HPUX) || defined (M_XENIX) || defined (M_SUN_Solaris))
#  define PSSW   "-el"
#else
#  ifdef NeXT
#    define PSSW  "-gxcwl"
#  else
#    define PSSW   "-gxwj"
#  endif
#endif

#ifdef NeXT
 typedef int pid_t;
#endif

struct ps_str
  {
       char flags[20];
       uid_t uid;
       char user[10];
       pid_t pid;
       pid_t ppid;
       pid_t pgid;
       pid_t tpgid;
       int cp;
       int priority;
       int nice;
       float cpu;
       float mem;
       unsigned int size;
       unsigned int rss;
       char wchan[50];
       char tt[10];
       char stat[10];
       char start[10];
       char time[10];
       char command[500];
  };

char *getlogin ();
struct ps_str *ps_split ();
char *campo ();
int isin();
void printsigs();
int ci_strcmp();

main (argc, argv)
     int argc;
     char *argv[];
{
     pid_t pid, ppid;
     int flag,yflag;
     FILE *fp;
     struct ps_str *prc;
     char ps[150];
     char yn[10];
     char linea[500], head[200];
     int nnn = 0, iii = 0, bbb = 0, ttt = 0, jjj = 0, xxx = 0, lll = 0,
      sss = 0, yyy = 0, ppp = 0, zzz = 0, signal=DEFAULTSIG;
     char i_name[10];
     pid_t i_pid;
     uid_t uid;
     int found = 0;

     pid = getpid ();
     ppid = getppid ();

     while (*++argv)
       {
	    argc--;
	    if (argv[0][0] == '-')
	      {
		   char *ar;

		   ar = argv[0];
		   while (*++ar)
		     {
                        if (isdigit(*ar))
			    signal=*ar;
			else 
			    switch (*ar)
			    {
			    case 'h':
				 fprintf (stderr, "ckill v%s, by Nico Tranquilli\n", VERSION);
#ifndef STY1
				 fprintf (stderr, "Usage: ckill [-ilkyhztbjxsnp] [name || pid]\n");
#else
				 fprintf (stderr, "Usage: ckill [-ilkyhztbsnp] [name || pid]\n");
#endif
				 fprintf (stderr, "   -z = excludes all processes not suspended by a ctrl-z\n");
				 fprintf (stderr, "   -t = excludes all processes associated to a tty\n");
				 fprintf (stderr, "   -b = excludes all processes not direct children of init\n");
#ifndef STY1
				 fprintf (stderr, "   -j = includes processes belonging to a group not associated to any tty\n");
				 fprintf (stderr, "   -x = includes indiscriminately all processes children of session leaders belonging to root\n");
#endif
				 fprintf (stderr, "   -s = includes this process (ckill) , its children and the parent shell that spawned it\n");
				 fprintf (stderr, "   -n name = includes all processes with `name' (sets j,x,s and resets t,b)\n");
				 fprintf (stderr, "   -p pid = kills the process with the specified `pid' (sets j,x,s and resets t,b)\n");
				 fprintf (stderr, "   -k signal = sends the specified `signal' instead than the KILL signal\n");
				 fprintf (stderr, "   -lk = lists signals\n");
				 fprintf (stderr, "   -l = lists the processes that would be affected by the command\n");
				 fprintf (stderr, "   -i = interactive mode\n");
				 fprintf (stderr, "   -y = defaults to answer 'yes'  for all the processes affected\n");
				 fprintf (stderr, "   -h = this help\n");
				 fprintf (stderr, "\nSend comments to tranquil@cli.di.unipi.it\n");
				 exit (0);
			    case 'y':
				 yyy = 1;
				 break;
			    case 's':
				 sss = 1;
				 break;
			    case 'i':
				 iii = 1;
				 break;
			    case 'x':
				 xxx = 1;
				 break;
			    case 'z':
				 zzz = 1;
				 break;
			    case 'b':
				 bbb = 1;
				 break;
			    case 't':
				 ttt = 1;
				 break;
			    case 'j':
				 jjj = 1;
				 break;
			    case 'l':
				 lll = 1;
				 break;
			    case 'n':
				 nnn = 1;
				 if (argc == 1)
				   {
					fprintf (stderr, "ckill: wrong number of arguments: '-n' requires a process name.\n");
					fprintf (stderr, "Try `ckill -h' for more information.\n");
					exit (-1);
				   }
				 strcpy (i_name, *++argv);
				 break;
			    case 'p':
				 ppp = 1;
				 if (argc == 1)
				   {
					fprintf (stderr, "ckill: wrong number of arguments: '-p' requires a PID!\n");
					fprintf (stderr, "Try `ckill -h' for more information.\n");
					exit (-1);
				   }
				 i_pid = atoi (*++argv);
				 if (!isdigit ((*argv)[0]))
				   {
					fprintf (stderr, "ckill: type mismatch: PID must be numeric !\n");
					fprintf (stderr, "Try `ckill -h' for more information.\n");
					exit (-1);
				   }
				 break;
			    case 'k':
				 if (argc==1)
				 {
					if (!lll) {
						fprintf (stderr, "ckill: wrong number of arguments: '-k' requires a signal name (or number)\n");
                                        	fprintf (stderr, "Try `ckill -h' for more information.\n");
                                        	exit (-1);
					} else {
						printsigs();
						exit (0);
					}
				 }
                                 if (isdigit((*++argv)[0]))
					signal=(*argv)[0];
				 else {
					if (!ci_strcmp(*argv,"HUP")) {
						signal=SIGHUP;
						continue;
					}
					if (!ci_strcmp(*argv,"INT")) {
						signal=SIGINT;
						continue;
					}
					if (!ci_strcmp(*argv,"QUIT")) {
						signal=SIGQUIT;
						continue;
					}
					if (!ci_strcmp(*argv,"ILL")) {
						signal=SIGILL;
						continue;
					}
					if (!ci_strcmp(*argv,"TRAP")) {
						signal=SIGTRAP;
						continue;
					}
					if (!ci_strcmp(*argv,"IOT")) {
						signal=SIGIOT;
						continue;
					}
					if (!ci_strcmp(*argv,"FPE")) {
						signal=SIGFPE;
						continue;
					}
					if (!ci_strcmp(*argv,"KILL")) {
						signal=SIGKILL;
						continue;
					}
					if (!ci_strcmp(*argv,"USR1")) {
						signal=SIGUSR1;
						continue;
					}
					if (!ci_strcmp(*argv,"SEGV")) {
						signal=SIGSEGV;
						continue;
					}
					if (!ci_strcmp(*argv,"USR2")) {
						signal=SIGUSR2;
						continue;
					}
					if (!ci_strcmp(*argv,"PIPE")) {
						signal=SIGPIPE;
						continue;
					}
					if (!ci_strcmp(*argv,"ALRM")) {
						signal=SIGALRM;
						continue;
					}
					if (!ci_strcmp(*argv,"TERM")) {
						signal=SIGTERM;
						continue;
					}
					if (!ci_strcmp(*argv,"CHLD")) {
						signal=SIGCHLD;
						continue;
					}
					if (!ci_strcmp(*argv,"CONT")) {
						signal=SIGCONT;
						continue;
					}
					if (!ci_strcmp(*argv,"STOP")) {
						signal=SIGSTOP;
						continue;
					}
					if (!ci_strcmp(*argv,"TSTP")) {
						signal=SIGTSTP;
						continue;
					}
					if (!ci_strcmp(*argv,"TTIN")) {
						signal=SIGTTIN;
						continue;
					}
					if (!ci_strcmp(*argv,"TTOU")) {
						signal=SIGTTOU;
						continue;
					}
					if (!ci_strcmp(*argv,"WINCH")) {
						signal=SIGWINCH;
						continue;
					}
					fprintf(stderr,"ckill: %s: unknown signal.\n",*argv);
					fprintf(stderr,"`ckill -lk' lists signals.\n");
				        exit (-1);
				 }
			    default:
				 fprintf (stderr, "ckill: syntax error in arguments\n");
				 fprintf (stderr, "Try `ckill -h' for more information.\n");
				 exit (-1);
			    }
		     }
	      }
	    else
	      {
		   fprintf (stderr, "ckill: syntax error in arguments\n");
		   fprintf (stderr, "Try `ckill -h' for more information.\n");
		   exit (-1);
	      }
       }
     uid = getuid ();
     sprintf (ps, "%s %s", PS, PSSW);
     fp = popen (ps, "r");
     flag = 0;
     while (fgets (linea, sizeof (linea), fp))
       {
	    linea[strlen (linea) - 1] = (char) NULL;
	    if (lll && !flag)
	      {
		   strcpy (head, linea);
		   flag = 1;
		   continue;
	      }
	    prc = ps_split (linea);
	    if (uid != prc->uid)
		 continue;
	    if (!ppp && !nnn && !sss && (prc->pid == pid || prc->pgid == pid || ppid == prc->pid || pid == prc->ppid))
		 continue;

	    if (!ppp && !nnn && !xxx && prc->tpgid == -1 && prc->ppid != 1)
		 continue;
	    if (!ppp && !nnn && !jjj && !xxx && prc->tpgid == -1)
		 continue;
	    if (!ppp && !nnn && bbb && prc->ppid != 1)
		 continue;
	    if (!ppp && !nnn && ttt && strcmp (prc->tt, "?"))
		 continue;
	    if (!ppp && !nnn && zzz && isin (prc->stat, 'T'))
		 continue;
	    if (nnn && (strncmp (prc->command, i_name, strlen (i_name)) ||
			(prc->command[strlen (i_name)] && prc->command[strlen (i_name)] != ' ')))
		 continue;
	    if (ppp && prc->pid != i_pid)
		 continue;
	    if (ppp || nnn)
		 found = 1;
	    if (lll)
	      {
		   if (flag == 1)
		     {
#                       ifdef STY1
			  puts (" PPID   PID      TT    STAT   UID  TIME COMMAND            affected");
#                       else
			  printf("%-71s affected\n",head);
#			endif
			  flag = 2;
		     }
#              ifdef STY1
		   printf ("%5d%6d%8s%8s%6d%6s %-20s",
			   prc->ppid, prc->pid, prc->tt, prc->stat,
			   prc->uid, prc->time, prc->command);
#              else
		   linea[73]=0;
		   printf ("%-73s",linea);
#              endif
	      }
	    yn[0] = 0;
	    if (!strcmp (prc->tt, "?") || yyy || !isin (prc->stat, 'T') || nnn || ppp)
	      {
		   yn[0] = 'y';
		   if (!lll)
		   	putchar (7);
	      }
	    else
		 yn[0] = 'n';
	    (prc->command)[12]=0;
	    if (iii && !lll)
	      {
		   printf ("(%c) PROCESS: %-12s PID:%-7d TTY:%-22s  kill ? [%c] ", (!isin (prc->stat, 'T') ? 'Z' : ' '), prc->command, prc->pid, (!strcmp (prc->tt, "?") ? "(no control terminal)" : prc->tt), yn[0]);
		   gets (yn);
	      }
            yflag=0;
	    if (((!strcmp (prc->tt, "?") || yyy || !isin (prc->stat, 'T')) && yn[0] == (char) NULL) || (yn[0] == 'y'))
	      {
                   if (!lll) {
		   	kill (prc->pid, signal);
		   	if (!iii)
				printf ("(%c) PROCESS: %-12s PID:%-7d TTY:%-18s   Killed !\n", (!isin (prc->stat, 'T') ? 'Z' : ' '), prc->command, prc->pid, (!strcmp (prc->tt, "?") ? "(no control terminal)" : prc->tt));
		   } else {
                        puts("  [y]");
			yflag=1;
		   }
	      }
	      if (lll && !yflag)
                    puts("  [n]");
       }
     fclose (fp);
     if ((nnn || ppp) && !found)
       {
	    fprintf (stderr, "ckill: no such process.\n");
	    exit (-1);
       }
     else
	  exit (0);

}
struct ps_str *ps_split (stringa)
     char *stringa;
{
     static struct ps_str sprc;

#ifdef M_XENIX
     /* Xenix
      * ps -el: F S   UID   PID  PPID  C PRI NI  ADDR SZ    WCHAN TTY  TIME CMD
      *         3 S     0     0     0  0   0 20    7d  0    2b084   ?  0:00 swapper
      */
     sprc.uid = atoi (campo (stringa, 3));
     sprc.pid = atoi (campo (stringa, 4));
     sprc.ppid = atoi (campo (stringa, 5));
     sprc.pgid = 0;
     sprc.tpgid = 0;
     strcpy (sprc.command, campo (stringa + 61, 1));
     strcpy (sprc.time, campo (stringa + 55, 1));
     strcpy (sprc.tt, strcmp (sprc.command, "<defunct>") ?
	     campo (stringa + 51, 1) : "?");
     strcpy (sprc.stat, campo (stringa, 2));
#else
#if (defined(M_HPUX) || defined(M_SUN_Solaris))
     /* HP-UX , Solaris
      * ps -el :   F S UID PID PPID C PRI NI   ADDR SZ WCHAN TTY TIME COMD
      *            3 S   0   0    0 0 128 20 1d6758  0       ?   1:04 swapper
      *
      */

     sprc.uid = atoi (campo (stringa, 3));
     sprc.pid = atoi (campo (stringa, 4));
     sprc.ppid = atoi (campo (stringa, 5));
     sprc.pgid = 0;
     sprc.tpgid = 0;
     strcpy (sprc.command, campo (stringa+57, 3));
     strcpy (sprc.time, campo (stringa+57, 2));
     strcpy (sprc.tt, campo (stringa+57, 1));
	     
     strcpy (sprc.stat, campo (stringa, 2));
#else
#ifdef NeXT
/* F  UID   PID  PPID CP PRI BASE VSIZE RSIZE WCHAN STAT TT  TIME COMMAND */
        sprc.uid = atoi(campo(stringa,2));
        sprc.pid = atoi(campo(stringa,3));
        sprc.ppid = atoi(campo(stringa,4));
        sprc.pgid = 0;
        sprc.tpgid = 0;
        strcpy(sprc.command, campo(stringa, 14));
        strcpy(sprc.time, campo(stringa, 13));
        strcpy(sprc.tt, campo(stringa, 12));
        strcpy(sprc.stat, campo(stringa, 11));
#else
     /* SunOS4, Linux
      * ps -gaxcwj : PPID PID PGID SID TT TPGID STAT UID TIME COMMAND
      *                 0   0    0   0 ?     -1   DO   0 0:17 swapper
      */

     sprc.uid = atoi (campo (stringa, 8));
     sprc.pid = atoi (campo (stringa, 2));
     sprc.ppid = atoi (campo (stringa, 1));
     sprc.pgid = atoi (campo (stringa, 3));
     sprc.tpgid = atoi (campo (stringa, 6));
     strcpy (sprc.command, campo (stringa, 10));
     strcpy (sprc.time, campo (stringa, 9));
     strcpy (sprc.tt, campo (stringa, 5));
     strcpy (sprc.stat, campo (stringa, 7));
#endif
#endif
#endif
     return &sprc;
}

char *campo (string1, num)
     char *string1;
     int num;
{
     static char stringa[1000];
     char *ret;
     int i;
     for (i = 0; string1[i] != 0; i++)
	  if (string1[i] != ' ')
	       break;
     strcpy (stringa, string1 + i);

     ret = stringa;
     for (i = 0; stringa[i] != (char) NULL; i++)
       {
	    if (stringa[i] == ' ' || stringa[i] == '\t')
	      {
		   stringa[i] = (char) NULL;
		   if (!--num)
			return ret;
		   i++;
		   while (stringa[i] == ' ' || stringa[i] == '\t')
			i++;
		   ret = stringa + i;
	      }
       }
     if (num == 1)
	  return ret;
     return (char *) NULL;
}

int isin (string, c)
     char *string;
     char c;
{
     while (*string)
	  if (*string++ == c)
	       return 0;
     return 1;
}
void printsigs()
{
	fprintf(stderr,"Valid signals are: \tHUP INT QUIT ILL TRAP IOT FPE KILL USR1 SEGV USR2\n\t\t\tPIPE ALRM TERM CHLD CONT STOP TSTP TTIN TTOU WINCH\n");
}
int ci_strcmp(str1,str2)
char *str1, *str2;
{
        while (*str1 && *str2) {
                if (tolower(*str1) != tolower(*str2))
                        break;
                str1++;
                str2++;
        }
        return ( *str1 || *str2 ? 1 : 0 );
}
