/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "avi_configure.h"

extern char            *codec_path;

void file_ok (GtkWidget *w, GtkFileSelection *fs)
{
  codec_path = gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_selector));
  gtk_entry_set_text(GTK_ENTRY(path_entry), codec_path); 
  gtk_widget_hide(file_selector);
}

void file_sel_destroy (GtkWidget *widget, gpointer data)
{
  if( file_selector )
    gtk_widget_hide(file_selector);
}

void
create_file_sel()
{
  
  /* the file selection widget */
 
  file_selector = gtk_file_selection_new("Please select the divx32 dll file path"); 
  
  /* multiple selection */
  gtk_clist_set_selection_mode(GTK_CLIST(GTK_FILE_SELECTION(file_selector)->file_list), GTK_SELECTION_BROWSE);
 
  /* Connect the ok_button to file_ok_sel function */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (file_selector)->ok_button),
                             "clicked", (GtkSignalFunc) file_ok, file_selector );
         
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (file_selector)->cancel_button),
                                    "clicked", (GtkSignalFunc) file_sel_destroy,
                                    GTK_OBJECT (file_selector));

  gtk_signal_connect(GTK_OBJECT(file_selector), "destroy", GTK_SIGNAL_FUNC(file_sel_destroy), &file_selector);

}

void
on_path_entry_changed                  (GtkEditable     *editable,
                                        gpointer         user_data)
{
  codec_path = gtk_entry_get_text(GTK_ENTRY(path_entry)); 
}


void
on_browse_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  create_file_sel();
  gtk_widget_show(file_selector);
}


void
on_avi_ok_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(avi_config);
}


void
on_avi_cancel_enter                    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(avi_config);
}


void
on_avi_config_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{

}

void create_avi_config (void)
{
  avi_config = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (avi_config), "avi_config", avi_config);
  gtk_widget_set_usize (avi_config, 330, 119);
  gtk_window_set_title (GTK_WINDOW (avi_config), "Win32 Codec(s) Configuration");
  gtk_window_set_position (GTK_WINDOW (avi_config), GTK_WIN_POS_CENTER);
  gtk_window_set_default_size (GTK_WINDOW (avi_config), 300, 200);
  gtk_window_set_policy (GTK_WINDOW (avi_config), FALSE, FALSE, FALSE);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (avi_config), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (avi_config), vbox1);

  frame1 = gtk_frame_new (" Win32 DLL'S Path : ");
  gtk_widget_ref (frame1);
  gtk_object_set_data_full (GTK_OBJECT (avi_config), "frame1", frame1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox1), frame1, TRUE, TRUE, 0);
  gtk_widget_set_usize (frame1, -2, 40);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 3);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (avi_config), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_container_add (GTK_CONTAINER (frame1), hbox2);
  gtk_container_set_border_width (GTK_CONTAINER (hbox2), 4);

  path_entry = gtk_entry_new ();
  gtk_widget_ref (path_entry);
  gtk_object_set_data_full (GTK_OBJECT (avi_config), "path_entry", path_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (path_entry);
  gtk_box_pack_start (GTK_BOX (hbox2), path_entry, TRUE, TRUE, 0);
  gtk_entry_set_text (GTK_ENTRY (path_entry), codec_path);

  browse = gtk_button_new_with_label ("Browse...");
  gtk_widget_ref (browse);
  gtk_object_set_data_full (GTK_OBJECT (avi_config), "browse", browse,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (browse);
  gtk_box_pack_start (GTK_BOX (hbox2), browse, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (browse), 13);

  fixed1 = gtk_fixed_new ();
  gtk_widget_ref (fixed1);
  gtk_object_set_data_full (GTK_OBJECT (avi_config), "fixed1", fixed1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fixed1);
  gtk_box_pack_start (GTK_BOX (vbox1), fixed1, TRUE, TRUE, 0);
  gtk_widget_set_usize (fixed1, -2, 5);
  gtk_container_set_border_width (GTK_CONTAINER (fixed1), 3);

  avi_ok = gtk_button_new_with_label ("OK");
  gtk_widget_ref (avi_ok);
  gtk_object_set_data_full (GTK_OBJECT (avi_config), "avi_ok", avi_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (avi_ok);
  gtk_fixed_put (GTK_FIXED (fixed1), avi_ok, 168, 0);
  gtk_widget_set_uposition (avi_ok, 168, 0);
  gtk_widget_set_usize (avi_ok, 75, 32);

  avi_cancel = gtk_button_new_with_label ("Cancel");
  gtk_widget_ref (avi_cancel);
  gtk_object_set_data_full (GTK_OBJECT (avi_config), "avi_cancel", avi_cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (avi_cancel);
  gtk_fixed_put (GTK_FIXED (fixed1), avi_cancel, 248, 0);
  gtk_widget_set_uposition (avi_cancel, 248, 0);
  gtk_widget_set_usize (avi_cancel, 75, 32);

  gtk_signal_connect (GTK_OBJECT (avi_config), "destroy",
                      GTK_SIGNAL_FUNC (on_avi_config_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (path_entry), "changed",
                      GTK_SIGNAL_FUNC (on_path_entry_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (browse), "clicked",
                      GTK_SIGNAL_FUNC (on_browse_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (avi_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_avi_ok_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (avi_cancel), "clicked",
                      GTK_SIGNAL_FUNC (on_avi_cancel_enter),
                      NULL);

}

void show_avi_config (void)
{
  gtk_widget_show(avi_config);
}


