/* AVI codec */

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <iostream.h>
#include <assert.h>
/*
#include <sys/ioctl.h>
#include <sys/soundcard.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>

#include <avifile.h>
#include <videodecoder.h>
#include <pthread.h>
#include <audiodecoder.h>
#include <SDL/SDL.h>
*/
#include <aviplay.h>

#define TRACE(X) printf(X)

extern "C" {

#include "avi_codec.h"
#include "avi_configure.h"

XMPSCodec avi_codec = {

  NULL,
  NULL,
  "AVI Codec (DIVX ;-))",
  1,

  avi_init,
  avi_about,
  avi_configure,
  avi_load_options,
  avi_save_options,
  avi_is_our_file,
  avi_open,
  avi_play,
  avi_stop,
  avi_pause,
  avi_rewind,
  avi_seek,
  avi_close,
  avi_get_volume,
  avi_set_volume,
  avi_file_info_box,

  avi_set_surface,
  avi_set_callback,

  avi_get_status,
  avi_has_file,
  avi_video_info,
  avi_scale,
  avi_get_actual_position,
  avi_get_file_size,
  avi_move_into_display,
  avi_get_available_formats
};


/*
  AviReadFile clip;
  AviReadStream* stream;
  VideoDecoder decoder;
  char bitmapinfo[100];//BITMAPINFOHEADER
  static char* outpic;	
  int has_file = 0;
  int w, h;
  pthread_t video_p, audio_p;
  AviReadStream* audiostream;
  AudioDecoder selector;
  WAVEFORMATEX audio;
  char audio_ext[100];
  int audio_fd;
  int audio_status;
  unsigned Snd_Limit;
  unsigned last_audio_size;
  unsigned frames_audio;   
  out_format f;           
  long long time_start;  
  long long time_current;
  long long time_audio;
  double frame_start;
  SDL_Surface *our_surface;
  FILE *file;
  static int file_size;
*/
 static XMPSCodecStatus avi_status;
 XMPS_DisplayCallback avi_xmps_callback;

XMPSCodec *get_codec_info(void)
{
  return &avi_codec;
}

void avi_init(void)
{
  avi_status = CODEC_STOPPED;
}

static AviPlayer* player=NULL;

static void drawfunc(char* data)
{    
    if(player==0)
	return;//who called us?	
    if(avi_xmps_callback)
	avi_xmps_callback((byte *) data, 0, 0, player->width(), player->height());
}
static void killhandler(int result)
{
}
static double lastpos=0;
static void posfunc(double pos)
{
    lastpos=pos;
}
int avi_open(char *filename)
{
    TRACE("avi_open\n");
    if(player)return -1;
    player=new AviPlayer;
    int result=player->initPlayer(filename, 16);
    if(result!=0)
    {
	delete player;
	player=0;
	return result;
    }
    player->setDrawCallback(&drawfunc);
    player->setPosCallback(&posfunc);
    player->setKillHandler(&killhandler);
    player->start();
    player->pause(1);
    return 0;	
}
void avi_play()
{
    TRACE("avi_play\n");
    if(player==0)return;
    player->play();
}

void	avi_about(void)
{

}

void	avi_configure(void)
{
  create_avi_config();
  show_avi_config();
}

void	avi_load_options(ConfigFile *cfg)
{
    return;
/*
  codec_path = (char *) malloc(256);
  codec_path = "/donnees";
  
  if( cfg )
    {
      xmps_cfg_read_string(cfg, "DivX Codec", "codec_path", &codec_path);
    }
*/    
}

void	avi_save_options(ConfigFile *cfg)
{
    return;
//  xmps_cfg_write_string(cfg, "DivX Codec", "codec_path", codec_path);
}

int	avi_is_our_file(char *filename)
{
  TRACE("avi_is_our_file\n");
  AviReadFile clip;
  int result=clip.OpenFile(filename);
  if( result != 0 )
    {
      clip.CloseFile();
      return 0;
    }
  clip.CloseFile();
  return 1;
}

void avi_stop(void)
{
    TRACE("avi_stop\n");
    if(player==0)
	return;
    player->stop();
    avi_status = CODEC_STOPPED;
}

void avi_pause(void)
{
    TRACE("avi_pause\n");
    if(player==0)
	return;
    player->pause(1);
    avi_status = CODEC_STOPPED;
}

void            avi_rewind(void)
{
  
}

void            avi_seek(int percent)
{
    TRACE("avi_seek\n");
    if(player==0)
	return;
    player->reseek_exact(player->GetVideoLength()*percent/100.);
}

void            avi_get_volume()
{
  
}

void            avi_set_volume(int volume)
{

}

void            avi_file_info_box(char *filename)
{

}

void            avi_close(void)
{
    if(player==0)return;
    player->close();
    delete player;
    player=0;
}

void            avi_set_surface (int type, void *surface)
{
/*  switch( type )
    {
    case SDL:
      break;
    default:
      outpic = (char *) surface;
      break;
    }*/
}

void            avi_set_callback (XMPS_DisplayCallback callback)
{
  avi_xmps_callback = callback;
}

XMPSCodecStatus avi_get_status(void)
{
  return avi_status;
}


int             avi_has_file(void)
{
  return (player!=0);
}

void            avi_video_info(XMPSVideoInfo *info)
{
    if(player==0)
	return;
    if(info==0)
	return;
    info->width  = player->width();
    info->height = player->height();
}

void avi_scale(int x, int y)
{
//Scaling here???
//I think that scaling should be done by hardware or at least by output plugin ...  
}

unsigned int    avi_get_actual_position(void)
{
    if(player==0)
	return 0;
    return (unsigned int)lastpos;
}

unsigned int    avi_get_file_size(char *filename)
{
    FILE* file = fopen(filename, "r");
    fseek(file, 0, SEEK_END);
    int  file_size = ftell(file);
    return file_size;
}

int             avi_move_into_display(int x, int y)
{
  return 0;
}


XMPSVideoFormat avi_get_available_formats(void)
{
  return XMPS_VIDEO_RGB555;
}

}; // extern

