/********************************************************

	This is sample video codec DLL
	Copyright 2000 Eugene Smith (divx@euro.ru)
	Last modified: 27.06.2000

*********************************************************/


#include <stdio.h>
#include <wine/windef.h>
#include <wine/driver.h>
#include <wine/vfw.h>
int __attribute__((__stdcall__)) DriverProc(int drv_id, HANDLE hdrvr, int msg, int arg1, int arg2)
{
    int dwRes;
    switch (msg) {
    case DRV_LOAD:
    // Sent when the driver is loaded. This is always   
    // the first message received by a driver. 
	printf("DriverProc(DRV_LOAD)\n");
        dwRes = 1L;  // returns 0L to fail
        break;

    case DRV_ENABLE:
	printf("DriverProc(DRV_ENABLE)\n");
        dwRes = 1L;  
        break;

    case DRV_FREE:
    // Sent when the driver is about to be discarded.
    // This is the last message a driver receives
    // before it is freed.
	printf("DriverProc(DRV_FREE)\n");
        dwRes = 1L;  // return value ignored
        break;

    case DRV_OPEN:
    // Sent when the driver is opened.
	printf("DriverProc(DRV_OPEN)\n");
        dwRes = 1L;  // returns 0L to fail
        break;       // value subsequently used
                     // for dwDriverId.

    case DRV_CLOSE:
    // Sent when the driver is closed. Drivers are
    // unloaded when the open count reaches zero.
    	printf("DriverProc(DRV_CLOSE)\n");
        dwRes = 1L;  // returns 0L to fail
        break;

    case ICM_COMPRESS_BEGIN :     // begins sequence compression
    case ICM_COMPRESS :	         // compresses frame
    case ICM_COMPRESS_END :       // ends sequence compression
    case ICM_COMPRESS_GET_FORMAT :// arg1=(BITMAPINFOHEADER*) bh
    				// arg2=(BITMAPINFOHEADER*) obh
          			//   writes into obh default compressed
                                  //   format that corresponds to bh 
    case ICM_COMPRESS_GET_SIZE :  //returns maximum possible size of output frame
    case ICM_COMPRESS_QUERY :     // arg1=(BITMAPINFOHEADER*) bh
    				// arg2=(BITMAPINFOHEADER*) obh
          			//   Can we compress bh into obh?
    case ICM_DECOMPRESS_BEGIN :
    case ICM_DECOMPRESS :
    case ICM_DECOMPRESS_END :
    case ICM_DECOMPRESS_GET_FORMAT :
    case ICM_DECOMPRESS_QUERY :

    case ICM_GETQUALITY ://for compression. 0-10000.
    case ICM_SETQUALITY :
    default:    
        printf("videodll::DriverProc(%d, %X, %X) called\n", msg, arg1, arg2);
        return ICERR_UNSUPPORTED;
    }
    return dwRes;
}    