/********************************************************

	Video encoder implementation
	Copyright 2000 Eugene Smith (divx@euro.ru)
	Last modified: 23.06.2000

*********************************************************/

#include <videoencoder.h>
#include <time.h>
#include <registry.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#define HKEY_CLASSES_ROOT       (0x80000000)
#define HKEY_CURRENT_USER       (0x80000001)
#define HKEY_LOCAL_MACHINE      (0x80000002)
#define HKEY_USERS              (0x80000003)
#define HKEY_PERFORMANCE_DATA   (0x80000004)
#define HKEY_CURRENT_CONFIG     (0x80000005)
#define HKEY_DYN_DATA           (0x80000006)
#define REG_DWORD		4	/* DWORD in little endian format */

#ifdef TIMING
static unsigned int localcount()
{
    int a;
    __asm__("rdtsc\n\t"
    :"=a"(a)
    :
    :"edx");
    return a;
}

class CPU_Freq
{
    double freq;
    public:
    CPU_Freq();
    operator double() const {return freq;}
};
CPU_Freq::CPU_Freq()
{
	FILE *f = fopen ("/proc/cpuinfo", "r");
	char line[200];
	if (!f)
	{
	    printf("Can't open /proc/cpuinfo for reading\n");
	    {
		int i=time(NULL);
		int x,y;
		while(i==time(NULL));
		x=localcount();
		i++;
		while(i==time(NULL));
		y=localcount();
		freq=(double)(y-x)/1000.;
	    }
	    return;
	}    
	while (fgets(line,200,f)!=NULL) 
	{
		char	*s,*value;

		/* NOTE: the ':' is the only character we can rely on */
		if (!(value = strchr(line,':')))
			continue;
		/* terminate the valuename */
		*value++ = '\0';
		/* skip any leading spaces */
		while (*value==' ') value++;
		if ((s=strchr(value,'\n')))
			*s='\0';

		/* 2.1 method */
		if (!strncasecmp(line, "cpu MHz",strlen("cpu MHz"))) 
		{
		    sscanf(value, "%lf", &freq);
		    printf("%lf MHz processor detected\n", freq);
		    freq*=1000;
		    break;
		}
		continue;
	}
	fclose(f);
}

static CPU_Freq freq;
#endif
int VideoEncoder::SetRegValue(int fccHandler, const char* name, int value)
{
   int result, status, newkey;
   if(name==0)
   	return -1;
   char* full_name=new char[strlen(name)+10]; 
   char hn[5];
   if(full_name==0)
   	return -1;
   strcpy(full_name, "Software\\LinuxLoader\\");
   hn[0]=tolower(fccHandler & 0xFF);
   fccHandler>>=8;
   hn[1]=tolower(fccHandler & 0xFF);
   fccHandler>>=8;
   hn[2]=tolower(fccHandler & 0xFF);
   fccHandler>>=8;
   hn[3]=tolower(fccHandler & 0xFF);
   hn[4]=0;
   strcat(full_name, hn);
   result=RegCreateKeyExA(HKEY_CURRENT_USER, full_name, 0, 0, 0, 0, 0,
    &newkey, &status);
   if(result!=0)
   {
    delete full_name;
    return -1;
   }
   result=RegSetValueExA(newkey, name, 0, REG_DWORD, &value, 4);
   delete full_name;
   RegCloseKey(newkey);
   return result;
}
int VideoEncoder::GetRegValue(int fccHandler, const char* name, int* place)
{
   int result, status, newkey, count;
   if(name==0)
   	return -1;
   if(place==0)
   	return -1;
   char* full_name=new char[strlen(name)+10]; 
   char hn[5];
   if(full_name==0)
   	return -1;
   strcpy(full_name, "Software\\LinuxLoader\\");
   hn[0]=tolower(fccHandler & 0xFF);
   fccHandler>>=8;
   hn[1]=tolower(fccHandler & 0xFF);
   fccHandler>>=8;
   hn[2]=tolower(fccHandler & 0xFF);
   fccHandler>>=8;
   hn[3]=tolower(fccHandler & 0xFF);
   hn[4]=0;
   strcat(full_name, hn);
   result=RegOpenKeyExA(HKEY_CURRENT_USER, full_name, 0, 0, &newkey);
   if(result!=0)
   {
    delete full_name;
    return -1;
   }                                                    
   count=4;
   result=RegQueryValueExA(newkey, name, 0, 0, &status, &count);
   if(count!=4)result=-1;
   delete full_name;
   RegCloseKey(newkey);
   if(result==0)*place=status;
   return result;
}
int VideoEncoder::Init(int compressor, const char* format)
{
    if(m_iState>0)
	return -1;//already initialized
    if(format==0)
	return -1;
    memcpy(&m_bh, format, sizeof(m_bh));
    memset(&m_obh, 0, sizeof(m_obh));
    m_obh.biSize=sizeof(m_obh);
    hic=ICOpen(
    	0x63646976,//vidc
	compressor,
	ICMODE_COMPRESS);
    m_comp_id=compressor;
    if(hic==0)
    {
	printf("VideoEncoder:: ICOpen failed\n");
	return -1;
    }
//    if(m_dBitRate)
//	ac6
    HRESULT h=ICCompressGetFormat(hic, &m_bh, &m_obh);
    if(h!=0)
    {
	printf("VideoEncoder:: Can't handle this format\n");
	ICClose(hic);
	return -1;
    }
    ICGetDefaultQuality(hic, &m_iQual);
    m_iState=1;		
    if(ICGetDefaultKeyFrameRate(hic, &m_iKfFreq)!=0)
 	m_iKfFreq=0xFFFF;
    if(m_bh.biSizeImage==0)
    	m_bh.biSizeImage=m_bh.biWidth*m_bh.biHeight*((m_bh.biBitCount+7)/8);
    return 0;
}
int VideoEncoder::Start()
{
    if(m_iState!=1)
	return -1;//wrong state
    HRESULT h=ICCompressBegin(hic, &m_bh, &m_obh);
    if(h!=0)
    {
	printf("VideoEncoder::Start: ICCompressBegin() failed ( shouldn't happen )\n");
	return -1;
    }
    m_iFrameNum=0;
    m_iState=2;
    return 0;		
}
int VideoEncoder::Stop()
{
    if(m_iState!=2)
	return -1;//wrong state
    HRESULT h=ICCompressEnd(hic);
    if(h!=0)
    {
	printf("VideoEncoder::Stop: ICCompressEnd() failed ( shouldn't happen )\n");
	return -1;
    }
    m_iState=1;
    return 0;		
}
int VideoEncoder::Close()
{
    if(m_iState==0)
	return -1;
    ICClose(hic);
    if(m_prev)delete m_prev;
    m_iState=0;
}
int VideoEncoder::QueryOutputSize()
{
    if(m_iState==0)
	return -1;
	
    return ICCompressGetSize(hic, &m_bh, &m_obh);    
}
int VideoEncoder::EncodeFrame(char* src, char* dest, int* is_keyframe, int* size, int* lpckid)
{
	int st1, st2;
        static BITMAPINFOHEADER m_prevbh;
        if(m_iState!=2)
	    return -1;
#ifdef TIMING
	st1=localcount();    
#endif	
	int result=ICCompress(hic, (m_iKfFreq ? ((m_iFrameNum%m_iKfFreq)? 0 : ICCOMPRESS_KEYFRAME) : 0),
	  &m_obh, dest, &m_bh, src,
	  (long*)lpckid, (long*)is_keyframe, m_iFrameNum, 0, 
	  m_iQual, &m_prevbh, m_prev);
	if(result==0)
	{
	    if(m_prev==0)m_prev=new char[m_bh.biSizeImage];
	    memcpy(m_prev, src, m_bh.biSizeImage);
	    //if(m_prev==0)m_prev=new char[ICCompressGetSize(hic, &m_bh, &m_obh)];
	    //memcpy(m_prev, dest, m_obh.biSizeImage);
             m_prevbh=m_bh;
	}    
#ifdef TIMING
	st2=localcount();
	printf("ICCompress: %f ms\n", (double)(st2-st1)/freq);
#endif
	m_iFrameNum++;
	*size=m_obh.biSizeImage;
	return result;
}
int VideoEncoder::SetQuality(int quality)
{
    if(m_iState==0)
	return -1;
    if(quality<0)
	return -1;	
    if(quality>10000)
	return -1;
    m_iQual=quality;	
}
int VideoEncoder::SetKeyFrame(int freq)
{
    if(m_iState==0)
	return -1;
    if(freq<=0)
	ICGetDefaultKeyFrameRate(hic, &m_iKfFreq);
    else
	m_iKfFreq=freq;	
    return 0;	
}

int VideoEncoder::SetExtendedAttr(int comp_id, char* attribute, int value)
{
   int result, status, newkey, count;
    
    if(attribute==0)
	return -1;
    switch(comp_id)
    {
    case fccIV50:
        
 	if(strcmp(attribute, "QuickCompress")==0)
     	{
		result=RegCreateKeyExA(HKEY_CURRENT_USER, "Software\\Intel\\Indeo\\5.0", 0, 0, 0, 0, 0,
	   		&newkey, &status);
           	if(result!=0)
		{
		    printf("VideoEncoder::SetExtAttr: registry failure\n");
		    return -1;
		}    
		result=RegSetValueExA(newkey, "QuickCompress", 0, REG_DWORD, &value, 4);
           	if(result!=0)
		{
		    printf("VideoEncoder::SetExtAttr: registry failure 2\n");
		    return -1;
		}    
   		RegCloseKey(newkey);
   		return result;
	}   	
    
    	printf("Unknown attribute '%s' for Intel Indeo 5.0 compressor\n");
    break;

    case fccIV41:
        
 	if(strcmp(attribute, "QuickCompress")==0)
     	{
		result=RegCreateKeyExA(HKEY_CURRENT_USER, "Software\\Intel\\Indeo\\4.1", 0, 0, 0, 0, 0,
	   		&newkey, &status);
           	if(result!=0)return -1;
		result=RegSetValueExA(newkey, "QuickCompress", 0, REG_DWORD, &value, 4);
   		RegCloseKey(newkey);
   		return result;
	}   	
    
    	printf("Unknown attribute '%s' for Intel Indeo 4.1 compressor\n");
    break;
    
    case fccDIV3:
    case fccDIV4:
    if(
    (strcmp(attribute, "BitRate")==0) || (strcmp(attribute, "Crispness")==0) || (strcmp(attribute, "KeyFrames")==0)
       ) 
       return SetRegValue(comp_id, attribute, value);
    
    printf("Unknown attribute '%s' for DivX compressor\n");
    break;
    }
    return -1;
}
VideoEncoder::~VideoEncoder()
{
    if(m_iState>0)
	Close();
}    	