#include <stdio.h>
#include <videoencoder.h>

int main()
{
    VideoEncoder enc;
    FILE* f1=fopen("./uncompr.bmp", "rb");
    fseek(f1, 14, SEEK_SET);
    char bh[0x28];
    fread(bh, 0x28, 1, f1);
    char pic[384*288*3];
    fread(pic, 384*288*3, 1, f1);
    char* compressed;
    enc.SetExtendedAttr(fccIV50, "QuickCompress", 1);
    if(enc.Init(fccIV50, bh)!=0)
//    if(enc.Init(mmioFOURCC('d', 'i', 'v', '3'), bh)!=0)
    {
	printf("Init() failed\n");
	return -1;
    }
    enc.SetKeyFrame(10);
    int size=enc.QueryOutputSize();
    if(size<=0)
    {
	printf("QueryOutputSize() failed\n");
	return -1;
    }
    else printf("Driver reported %d as a maximum output size\n", size);
    compressed=new char[size];
    enc.Start();
    int keyf;
    for(int i=0; i<30; i++)
    {
    if(enc.EncodeFrame(pic, compressed, &keyf, &size)!=0)
    {
	printf("EncodeFrame() failed\n");
    }else printf("Frame %d encoded as %d ( %s ) into %d bytes\n", i, keyf, keyf&16?"Key frame":"Delta frame", size);
    }
    enc.Stop();

    fclose(f1);
    f1=fopen("./compr.qw", "wb");
    fwrite(compressed, size, 1, f1);
    delete compressed;
    fclose(f1);

    ICDoSomething();
    return 0;
}
