// acmtest.cpp : Defines the entry point for the console application.
//
#include <stdio.h>
#include <wine/winerror.h>
#include <wine/msacm.h>
#include <string.h>
extern "C" void MSACM_RegisterAllDrivers(void);
char cfmt[]={0x61, 0x01, 0x02, 0x00, 0x22, 0x56, 0x00, 0x00, 
0xa5, 0x0f, 0x00, 0x00, 0xba, 0x00, 0x10, 0x00,
0x0a, 0x00, 0x00, 0x04, 0x00, 0x00, 0x01, 0x00,
0xba, 0x00, 0x00, 0x00};

int main(int argc, char* argv[])
{

	FILE* f_in=fopen("./test.raw", "rb");
	FILE* f_out=fopen("./test.out", "wb");
	HRESULT hr;
	unsigned char in_data[1116];
	fread(in_data, sizeof(in_data), 1, f_in);

    	unsigned char out_data[882000];

	
	MSACM_RegisterAllDrivers();
	WAVEFORMATEX wf;
	wf.nChannels=2;
	wf.nAvgBytesPerSec=88200;
	wf.nSamplesPerSec=22050;
	wf.wFormatTag=WAVE_FORMAT_PCM ;
	wf.nBlockAlign=2;
	wf.wBitsPerSample=32;
	wf.cbSize=0;

	HACMSTREAM srcstream;
	hr=acmStreamOpen(
		&srcstream,    
		(HACMDRIVER)NULL,       
		(WAVEFORMATEX*)cfmt,  
		(WAVEFORMATEX*)&wf,  
		NULL,  
		0,     
		0,     
		ACM_STREAMOPENF_NONREALTIME );
	
	if(hr!=S_OK)
	{
		if(hr==ACMERR_NOTPOSSIBLE)
		{
			printf("Unappropriate audio format\n\n");
			goto error;
		}
		printf("StreamOpen %X\n\n", hr);
		goto error;
	}
	ACMSTREAMHEADER ash;
	memset(&ash, 0, sizeof(ash));
	ash.cbStruct=sizeof(ash);
	ash.fdwStatus=0;
	ash.dwUser=0; 
	ash.pbSrc=in_data; 
	ash.cbSrcLength=sizeof(in_data); 
	ash.pbDst=out_data; 
	ash.cbDstLength=sizeof(out_data); 
   
	hr=acmStreamPrepareHeader(
	  srcstream,          
	  &ash,  
		0);
	if(hr!=S_OK)
	{
		printf("PrepareHeader %X\n\n", hr);
		goto error;
	}

	hr=acmStreamConvert(
		  srcstream,          
		  &ash,  
		  0
		);
	if(hr!=S_OK)
	{
		printf("Convert %X\n\n", hr);
		goto error;
	}

	printf("Uncompressed %d bytes\n", ash.cbDstLengthUsed);

	fwrite(out_data, sizeof(out_data), 1, f_out);
	fclose(f_out);
	
	hr=acmStreamUnprepareHeader(
		srcstream,          
		&ash,  
		0);
error:		
	printf("Hello World!\n");
	return 0;

}

