/********************************************************

	Video decoder interface
	Copyright 2000 Eugene Smith (divx@euro.ru)
	Last modified: 18.06.2000

*********************************************************/


#include <stdio.h>
#include <math.h>

#include <wine/driver.h>
#include <wine/vfw.h>

#include <default.h>

class VideoDecoder
{
    COMPVARS m_cv;
    int m_iState;
    BITMAPINFOHEADER m_bh, m_obh;
    char* m_outFrame;
public:
    VideoDecoder():m_outFrame(0),m_iState(0){}
    ~VideoDecoder()
    {
	if(m_iState==2)Stop();
	if(m_iState==1)Close();
    }	
    int Init(const char*);//BITMAPINFOHEADER*
    int Close();
    int Start();
    int Stop();
    char* GetFrame()
    {
	return m_outFrame;
    }	
    int DecodeFrame(char* src, int size, int is_keyframe);
    int SetBitDepth(int bits);
    int SetExtendedMode(int mode, int size);//mode=mmioFOURCC('Y', 'U', 'Y', '2')
    //size=12 (in bits)
    int SetColorSpace(int csp);
};    
    