#include <avifile.h>
#include <videodecoder.h>
#include <audiodecoder.h>
#include <vector>

using namespace std;

#define STAT_SIZE 25

class Statistic
{
    struct field
    {
	int start;
	int size;
        int max_size;
	char* name;
	float* values;
	field():name(0), values(0), max_size(0) {}
	field(char* name, int msize=STAT_SIZE):start(0), size(0), max_size(msize)
	{
             if(max_size<=0)max_size=STAT_SIZE;
	    this->name=new char[strlen(name)+1];
	    strcpy(this->name, name);
	    values=new float[max_size];
	}
	field(const field& p)
	{

	    if(p.name)
	    {
		name=new char[strlen(p.name)+1];
		strcpy(name, p.name);
	    }
	    if(p.values)
	    {
		values=new float[p.max_size];
		memcpy(values, p.values, sizeof(float)*p.max_size);
	    }
	    start=p.start;
	    size=p.size;
            max_size=p.max_size;
	}
	~field()
	{
	    if(name)delete name;
	    if(values)delete values;
	}
	float average() const
	{
	    float sum=0;
	    if(size==0)
		return 0;
	    if(values==0)
		return 0;
	    int i;
	    if(size!=max_size)
		for(i=(start%max_size); i!=((start+size)%max_size); i++,i%=max_size)
		    sum+=values[i];
		else
		for(i=0; i<max_size; i++)
		    sum+=values[i];

	    return sum/size;
	}
	void insert(float v)
	{
	    if(values==0)
		return;
	    values[(start+size)%max_size]=v;
	    if(size<max_size)
		size++;
	    else
		start++;
	    start%=max_size;
	}
    };
    vector<field> fields;
public:
    Statistic()
    {
	fields.clear();
    }
    void AddField(char* name, int freq=0)
    {
	field f(name, freq);
	fields.push_back(f);
    }
    void Insert(char* name, float value)
    {
	int i;
	for(i=0; i<fields.size(); i++)
	if(strcmp(fields[i].name, name)==0)
	{
	    fields[i].insert(value);
	    return;
	}
    }
    float average(const char* name) const
    {
	int i;
	for(i=0; i<fields.size(); i++)
	    if(strcmp(fields[i].name, name)==0)
		return fields[i].average();
	return 0;	    
    }
/*    QString string()
    {
	char* buffer=new char[50*fields.size()];
	buffer[0]=0;
	QString answer;
        	for(int i=0; i<fields.size(); i++)
	{
	    if(i!=0)
		strcat(buffer, "/");
//		answer+=";";
	    sprintf(buffer+strlen(buffer), "%.1f", fields[i].average());
//	    answer+=QString(fields[i].name);
//	    answer+=": ";
//	    answer+=QString(fields[i].average());
//	    answer+=" ms ";
	}
	answer=QString(buffer);
//	printf("%s\n", buffer);
	return answer;
    }*/
};

/***************************************************

   Here aviplay interface goes
   
****************************************************/  

inline unsigned int localcount()
{
    int a;
    __asm__("rdtsc\n\t"
    :"=a"(a)
    :
    :"edx");
    return a;
}

typedef void (*DRAWFUNC)(char*);
typedef void (*KILLHANDLER)(int);
typedef void (*NEWPOS)(double);
void* main_thread(void*);
class AviPlayer
{
    friend void* main_thread(void*);
    friend void* doAudioOut(void*);
protected:
    double getAsync(int update=0);
    void doVideoOut();
    int frames_video;
    int frame_drop;
    int initialized;
    int paused;
    int m_width;
    int m_height;
    DRAWFUNC drawfunc;
    KILLHANDLER killhandler;
    NEWPOS newpos;
    AviReadFile clip;
    AviReadStream* stream;
    AviReadStream* audiostream;
    Statistic drop;
public:
    AviPlayer();
    ~AviPlayer();
    int initPlayer(const char* filename, int bitdepth);
    int width(){return m_width;}
    int height(){return m_height;}
//	void draw(const char*);
    void setDrawCallback(DRAWFUNC func)
    {
        drawfunc=func;
    }    
    void setKillHandler(KILLHANDLER handler)
    {
	killhandler=handler;
    }    
    void setPosCallback(NEWPOS pos)
    {
        newpos=pos;
    }    
    double reseek(double pos);
    int reseek_exact(double pos);
    void play(){paused=0;time_start=0;}
    void start();
    void stop();
    void close();
    void pause(bool state)
    {
        if(!state)time_start=0;
        paused=state;
    }
    double GetAudioLength() const
    {
        if(audiostream)return audiostream->GetLength();
        return 0;
    }    
    double GetVideoLength() const
    {
        if(stream)return stream->GetLength();
        return 0;
    }    
    double GetDrop() const
    {
        return drop.average("Drop");
    }
    VideoDecoder decoder;
    AudioDecoder selector;
    char bitmapinfo[100];//BITMAPINFOHEADER
    WAVEFORMATEX audio;
    char audio_ext[100];
    char* outpic;//local buffer
    int audio_fd;// /dev/dsp
//    int audio_status;// indicates that audio was initialized
    unsigned Snd_Limit;// DMA buffer size
    int esd;
    unsigned last_audio_size; // the amount of data in DMA buffer immediately
    		          // after we wrote to the /dev/dsp last time
    unsigned frames_audio;    // total size of data written to /dev/dsp
			  // 1 here means 1/44100 second
    out_format f;  		  // Format of uncompressed data that we write to /dev/dsp
    long long time_start;	//used in syncing video with time
    long long time_current;
//	long long time_audio;
    long long audio_time;
    double audio_realpos;
    double frame_start;
    int debug_status; //used for debugging console output
/*
	Statistic stat;
         Statistic total;*/
	 
     int quit;
     int nosound;
     pthread_t audio_thread;
     pthread_t main_thread;
    
     pthread_mutex_t mutex;
     pthread_cond_t cond;
     void* doAudioExtract();
     
    unsigned char audio_frame[800000];
    int frame_pos;
    int frame_size;
    int frame_max;
    volatile int frame_in;
    volatile int frame_out;
};

class CPU_Freq
{
    double freq;
public:
    CPU_Freq();
    operator double() const {return freq;}
};

void CtrlCHandler(int);