/********************************************************

	AVI player object
	Copyright 2000 Eugene Smith (divx@euro.ru)
	Last modified: 13.07.2000

*********************************************************/

//#undef USE_ESD
#define DEBUG_TOCONSOLE
//#define QUIET

#ifndef QUIET
#define debug_out(X) Debug cout<<X<<": "<<(t2-t1)/freq<<" ms"<<endl
#ifndef TIMING
#define Debug  if(debug_status==0)
#else
#define Debug 
#endif /*TIMING*/
#else
#define debug_out(X)
#define Debug if(0)
#endif /*QUIET*/

#include <stdio.h>
#include <iostream>

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <iostream.h>
#include <assert.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
//#include <signal.h>

#ifdef USE_ESD
#include <esd.h>
#else
#include <sys/soundcard.h>
#endif

#include "aviplay.h"

using namespace std;
static double old_freq()
{
    int i=time(NULL);
    int x,y;
    while(i==time(NULL));
    x=localcount();
    i++;
    while(i==time(NULL));
    y=localcount();
    return (double)(y-x)/1000.;
}
CPU_Freq::CPU_Freq()
{
	FILE *f = fopen ("/proc/cpuinfo", "r");
	char line[200];
	char model[200]="unknown";
	char flags[500]="";
	char	*s,*value;
	
	freq=-1;
	if (!f)
	{
	    printf("Can't open /proc/cpuinfo for reading\n");
	    freq=old_freq();
	    //old method of determining CPU frequency
	    return;
	}    
	while (fgets(line,200,f)!=NULL) 
	{

		/* NOTE: the ':' is the only character we can rely on */
		if (!(value = strchr(line,':')))
			continue;
		/* terminate the valuename */
		*value++ = '\0';
		/* skip any leading spaces */
		while (*value==' ') value++;
		if ((s=strchr(value,'\n')))
			*s='\0';

		if (!strncasecmp(line, "cpu MHz",strlen("cpu MHz"))) 
		{
		    sscanf(value, "%lf", &freq);
		    freq*=1000;
		}
		if(!strncasecmp(line, "model name", strlen("model name")))
		    strncpy(model, value, sizeof(model)-1);
		if(!strncasecmp(line, "flags", strlen("flags")))
		    strncpy(flags, value, sizeof(flags)-1);
		continue;
		
	}
	if(freq<0)freq=old_freq();
	printf("%.3lf MHz %s processor detected\n", freq/1000., model);
        printf("Available flags: %s\n", flags);
        if(strstr(flags, "tsc")==0)
        {
	    printf("ERROR: no time-stamp counter found! Quitting.\n");
	    exit(1);
	}
#ifdef MMX
	if(strstr(flags, "mmx")==0)
	{
	    printf("ERROR: using MMX binary on non-MMX system. Quitting.\n");
	    exit(1);
	}
#endif
	fclose(f);
}

CPU_Freq freq;

static long long longcount()
{
    unsigned int i;
    unsigned int j;
    __asm__("rdtsc\n\t":"=a"(i), "=d"(j):);
    return ((long long)j<<32)+(long long)i;
}

static inline float to_float(long long t2, long long t1)
{
    long long qw=t2-t1;
    qw=(long long)(qw/freq);//milliseconds;
    return ((int)qw)/1000.;
}

#define min(X,Y) ((X)<(Y)?(X):(Y))
#define max(X,Y) ((X)>(Y)?(X):(Y))

void AviPlayer::doVideoOut()
{
    int t1, t2;
    unsigned samp_size;
    int flags;
    t1=localcount();
    stream->QuerySampleSize(&samp_size);
    stream->GetFrameFlags(&flags);
    char* frame=new char[3*samp_size];
    stream->ReadSample(frame, samp_size);
    if(samp_size!=0)
    {
    	t2=localcount();
	debug_out("Video reading");
    	t1=localcount();
    	decoder.DecodeFrame(frame, samp_size, flags & AVIIF_KEYFRAME);
    	t2=localcount();
    	debug_out("Video decompression");
   }
   delete frame;
   frames_video++;
}
//thread func
void* doAudioOut(void* arg)
{
    AviPlayer& a=*(AviPlayer*)arg;

    int& esd=a.esd;
    int& audio_fd=a.audio_fd;
    int& quit=a.quit;
    AudioDecoder& selector=a.selector;
    int& nosound=a.nosound;
    int Snd_Limit=a.Snd_Limit;
    out_format& f=a.f;
    pthread_mutex_t* mutex=&a.mutex;
    pthread_cond_t* cond=&a.cond;
    while(!quit)
    {
	if(f.valid!=OUT_FORMAT_VALID)
    	{
	    usleep(10000);
	    continue;
	}
	pthread_mutex_lock(mutex);
	if(a.frame_in == a.frame_out)
	    pthread_cond_wait(cond, mutex);
        int size = 8192;
	if((a.frame_in > a.frame_out) && (a.frame_in - a.frame_out < 8192)) size = a.frame_in - a.frame_out;
	if((a.frame_in < a.frame_out) && (a.frame_max - a.frame_out < 8192)) size = a.frame_max - a.frame_out;
	int startpos=a.frame_out;
	if(a.frame_out == a.frame_max) a.frame_out = 0;
        pthread_mutex_unlock(mutex);
#ifndef USE_ESD
	audio_buf_info zz;
	ioctl(audio_fd, SNDCTL_DSP_GETOSPACE, &zz);
/*	printf("doAudioOut: %d bytes in card, %d bytes in buffer\n",
	    a.Snd_Limit-zz.bytes, a.frame_size);*/
	if(zz.bytes==0)
	{
	    usleep(20000);
	    continue;
	}    
#endif	    
        int result=write(audio_fd, a.audio_frame+a.frame_out, size);
	if(result==0)
	{
	    usleep(20000);
	}
	else
	{
	    pthread_mutex_lock(mutex);
	    a.frame_out += result;
	    a.frame_size -= result;
	    pthread_mutex_unlock(mutex);
    	    a.audio_time=longcount();
#ifdef USE_ESD
#warning FIXME: correct delay?
	    a.audio_realpos=a.audiostream->GetTime()
		-double(16*ESD_BUF_SIZE+a.frame_size)/(1+a.f.is_stereo)/2/a.f.freq;
#else
	    ioctl(audio_fd, SNDCTL_DSP_GETOSPACE, &zz);
	    a.audio_realpos=a.audiostream->GetTime()
		-double(a.frame_size+(signed)a.Snd_Limit-zz.bytes)/(1+a.f.is_stereo)/2/a.f.freq;
#endif		
    
	}    
    }
    return 0;
}

void* AviPlayer::doAudioExtract()
{
    int t1, t2;
    int frames_written=0;
    int debug_status;
#ifndef USE_ESD    
    audio_buf_info zz;
#endif
    unsigned samp_size;
    unsigned char input[6000];
    static int input_pos=0;
    int format_needed=(f.valid!=OUT_FORMAT_VALID);
    WAVEFORMATEX wf;
    
    if(quit)return 0;
    if(frame_size>40000)
        return 0;

    if(audiostream->Eof())
    {
	quit=1;
	return 0;
    }	
//        audiostream=0;
//        ::close(audio_fd);
//        audio_fd=-1;
    frames_written++;
    debug_status=frames_written%25;
    audiostream->QuerySampleSize(&samp_size);
    audiostream->GetAudioFormatInfo(&wf, 0);
#warning FIXME
//#warning Too high values result in frame drops, while low can rise assertion 0!=in_size
	int AUBUFF=min(6000, max(wf.nAvgBytesPerSec/20, 1200));
	assert(samp_size!=0);
	int num_samples=(AUBUFF-input_pos)/samp_size;
        t1=localcount();
        audiostream->ReadSample((char*)input+input_pos, AUBUFF-input_pos, num_samples);

        t2=localcount();
	debug_out("Audio reading");
	t1=localcount();
	unsigned in_size=input_pos+samp_size*num_samples;
	input_pos=in_size;
	int ocnt=selector.decode_frames(input, audio_frame+frame_in, 
	//     num_of_bytes_input*(in_size/num_of_bytes_input),
	     in_size,
	     sizeof(audio_frame)-frame_in, format_needed?&f:0);
	t2=localcount();
	debug_out("Audio decompression");
	t1=localcount();
	if(format_needed && (f.valid==OUT_FORMAT_VALID))
	{
	    int tmp;
#ifndef QUIET
	    cout << "Setting format " << f.freq << "/16/" << (f.is_stereo?"stereo":"mono") << endl;
#endif
#ifndef USE_ESD
	    printf("fd %d\n", audio_fd);
	    tmp=f.is_stereo;
	    if(ioctl(audio_fd, SNDCTL_DSP_STEREO, &tmp)!=0)
		perror("ioctl(stereo)");
	    tmp=16;
	    if(ioctl(audio_fd, SNDCTL_DSP_SAMPLESIZE, &tmp)!=0)
		perror("ioctl(samplesize)");
	    tmp=f.freq;
	    if(ioctl(audio_fd, SNDCTL_DSP_SPEED, &tmp)!=0)
		perror("ioctl(speed)");
#else
	    audio_fd=esd_play_stream(ESD_STREAM | ESD_PLAY | (f.is_stereo?ESD_STEREO : ESD_MONO) | ESD_BITS16,
		f.freq, NULL, "aviplay");
	    if(audio_fd==-1)
	    {
		cout<< "Failed to open ESD stream"<<endl;
		audiostream=NULL;
		return (void*)-1;
	    }	
#endif
	    format_needed=0;
	}
	if(in_size==0)
	{
#ifndef QUIET
	    printf("WARNING: audio decoder returned 0 as in_size\n");
#endif
	    in_size=input_pos;
	    ocnt=0;//no output data
	}
	if(f.valid==OUT_FORMAT_VALID)
	{
	    pthread_mutex_lock(&mutex);
	    int new_pos = frame_in + ocnt;
	    while(new_pos > frame_max) {
	       memcpy(audio_frame, audio_frame + frame_max, new_pos - frame_max);
	       new_pos  = new_pos - frame_max;
	    }
	    frame_in = new_pos;
	    frame_size += ocnt;
	    pthread_mutex_unlock(&mutex);
	    pthread_cond_broadcast(&cond);
	}
    memcpy(input, input+in_size, input_pos-in_size);
    input_pos-=in_size;
    return 0;
}

double AviPlayer::getAsync(int update)
{
	unsigned int t1,t2;
	t1=localcount();
	double stream_time;	
	if(time_start==0)
	{
            time_start=longcount();
	    if(stream)
	        frame_start=stream->GetTime();
	    audio_time=time_start;
	}
	time_current=longcount();
	double actual_time=0;
#ifndef USE_ESD
	audio_buf_info zz;
	ioctl(audio_fd, SNDCTL_DSP_GETOSPACE, &zz);
	if(audiostream)// if there's audio stream in file, we synchronize pic with audio.
//	    actual_time=audiostream->GetTime()-double(frame_size+(signed)Snd_Limit-zz.bytes)/(1+f.is_stereo)/2/f.freq;
	    actual_time=audio_realpos+to_float(time_current, audio_time);
	else// Otherwise we use P5+ timestamp counter for it.
	    actual_time=frame_start+to_float(time_current, time_start);
#else
#warning FIXME
	if(audiostream)
	    actual_time=audio_realpos+to_float(time_current, audio_time);
	else
            actual_time=frame_start+to_float(time_current, time_start);
#endif
	if(stream)
	    stream_time=stream->GetTime();
	else
	    stream_time=actual_time;
/*	    
#ifndef USE_ESD
	Debug cout<<"Used buffer: "<<1000.*double((signed)Snd_Limit-zz.bytes)/(1+f.is_stereo)/2/f.freq<<" ms"<<endl;
#endif
*/
	Debug cout<<"####  Audio mismatch: "
	    <<actual_time-to_float(time_current, time_start)
	    <<"  Video pos: "
	    <<stream_time
	    <<"  ####"<<endl;
	if(update)
	    if(newpos)
		if(frames_video%25==0)
		    (*newpos)(stream_time);
	t2=localcount();
	debug_out("Init");
	double async=stream_time-actual_time;
	return async;
}

void* main_thread(void* arg) 
{
    AviPlayer& a=*(AviPlayer*)arg;
    AviReadStream* stream=a.stream;
    VideoDecoder& decoder=a.decoder;
    int& initialized=a.initialized;
    int& quit=a.quit;
    int& nosound=a.nosound;
    int Snd_Limit=a.Snd_Limit;
    KILLHANDLER& killhandler=a.killhandler;
    DRAWFUNC& drawfunc=a.drawfunc;
    NEWPOS& newpos=a.newpos;
    
    unsigned int g1, g2;
    unsigned int t1, t2;
    while(1){
	g1=localcount();
	int novideo=0;
	int drop_frame=0;

	if(!initialized)
	{
	    usleep(10000);
	    continue;
	}    
	if(quit)
	    return 0;    

	double async=a.getAsync(1);
	    
	if(stream)
	    if(stream->Eof())
	    {
		(*killhandler)(0);
		return NULL;
	    }	

#ifdef DEBUG_TOCONSOLE
	int debug_status=a.frames_video % 25;
#else
	int debug_status=1;
#endif
	if(async>.1)
	{
#ifndef USE_ESD	
	    audio_buf_info zz;
	    ioctl(a.audio_fd, SNDCTL_DSP_GETOSPACE, &zz);
	    double frame_time=double(a.frame_size+(signed)Snd_Limit-zz.bytes)/(1+a.f.is_stereo)/2/a.f.freq;
#else
	    double frame_time=double(a.frame_size)/(1+a.f.is_stereo)/2/a.f.freq;
#endif
	    if(frame_time>.05)
		usleep((int)min(1000000*(async-.1), 1000000*(frame_time-.05)));
		//audio buffer should contain
		//at least 50 ms of data
	}	
	async=a.getAsync();
	//
	//  If we've run out of audio data, let's put it into /dev/dsp
	//	as fast as we can.
	//
	if(async>=.1)
	    novideo=1;
	//
	//	otherwise,
	//
	if(novideo==0)
	//
	//	unless pic is older than audio for at least 100 ms,
	//	we will draw one frame.
	//
	if(async<=-.2)
	    drop_frame=1;
	else
	    if(async<=-.1)
		drop_frame=!(a.frames_video%3);//yes
	
	Debug cout<<"async: "<<1000*async<<endl;
		
	if(((drop_frame==0) && (novideo==0)) || a.paused)
	{
    	    t1=localcount();
    	    (*drawfunc)(decoder.GetFrame());
    	    t2=localcount();
	    debug_out("video_draw");
	    drop_frame=0;
    	}
	else
	{
	    if(drop_frame && (!a.paused))
	    {
#ifndef QUIET
#ifdef DEBUG_TOCONSOLE
		cout<<" !!!!!!!!!!!!!!!!! FRAME DROP !!!!!!!!!!!!!! "<<endl;
#else
		cout<<"!"<<flush;
#endif
#endif
		a.frame_drop++;
	    }
	}
        a.drop.Insert("Drop", drop_frame*100.);
        t1=localcount();
	if(a.audiostream)
    	    if((!a.audiostream->Eof()))
    	       if(!a.paused)
#ifndef USE_ESD
	           if(async>-.2)
#else
	           if(async>-.2)
#endif	       
                     a.doAudioExtract();
	t2=localcount();
        debug_out("audio_extract");		 
	t1=localcount();
	if(stream)
    	    if((!stream->Eof()))
		if(novideo==0)
		    if(!a.paused)
			a.doVideoOut();
	t2=localcount();
        debug_out("video_out");		 
	
        if(a.paused)
	{
    	    (*drawfunc)(decoder.GetFrame());
	    usleep(50000);
        }
	g2=localcount();
	Debug cout<<"\t\t\t\t\t\tTotal: "<<(g2-g1)/550000.<<" ms"<<endl;

    }//while(1)
}

AviPlayer::AviPlayer()
{
    stream=audiostream=0;
    last_audio_size=0;
    frame_in=frame_out=frame_pos=frame_size=0;
    frame_max=400000;
    frames_audio=0;
    f.freq=44100;
    f.is_stereo=1;
    f.valid=0;
    initialized=0;
    paused=0;
    quit=0;
    time_start=time_current=0;
    frame_start=0;
    frames_video=0;
    frame_drop=0;
}

AviPlayer::~AviPlayer()
{
    ICDoSomething();
    close();
}

int AviPlayer::initPlayer(const char* filename, int bitdepth)
{

    int result=clip.OpenFile(filename);
    if(result!=0)
	return -1;

    cout<<"File successfully opened"<<endl;
    cout<<clip.StreamCount()<<" streams"<<endl;

    audiostream=clip.GetStream(0, AviReadStream::Audio);
    if(audiostream==0)
    {
	cout<<"WARNING: File does not contain audio streams"<<endl;
    }
    else
    {
    	audiostream->GetAudioFormatInfo((void*)&audio, (char**)&audio_ext);
	int audio_status=selector.Init(&audio, audio_ext);
	if(audio_status!=0)audiostream=0;
	if(audiostream)
	{
	
#ifndef USE_ESD
	audio_fd=open("/dev/dsp", O_RDWR);
	if(audio_fd<=0)
        {
	    cerr << "WARNING: Can't open audio device" << endl;
	    selector.Close();
	    audiostream=0;
	}
#else
	esd=esd_open_sound(NULL);
	if(esd<0)
        {
	    cerr << "WARNING: Can't open ESD connection" << endl;
	    selector.Close();
	    audiostream=0;
	}
#endif
	else
	{
#ifndef USE_ESD
	    ioctl(audio_fd, SNDCTL_DSP_SYNC, NULL);
	    audio_buf_info zz;
	    ioctl(audio_fd, SNDCTL_DSP_GETOSPACE, &zz);
	    Snd_Limit=zz.fragments*zz.fragsize;
#endif
	}
	}
    }
    stream=clip.GetStream(0, AviReadStream::Video);

    if(stream==0)
    {
	cout<<"WARNING: File does not contain video streams"<<endl;
    }	
    else
    {
        stream->GetVideoFormatInfo(bitmapinfo);
	result=decoder.Init(bitmapinfo);
	if(result!=0)
	{
	    cout<<"ERROR: Failed to initialize decoder object"<<endl;
	    return -1;
	}
	if(bitdepth==15)bitdepth++;
	result=decoder.SetBitDepth(bitdepth);
	if(result!=0)
	{
	    cout<<"ERROR: Decoder does not support current bit depth"<<endl;
	    return -1;
	}    
	decoder.Start();
    }
    nosound=0;
    pthread_mutex_init(&mutex, NULL);
    pthread_cond_init(&cond, NULL);
    int w=288,h=20;
    if(stream)
    {
	w=*(int*)(bitmapinfo+4);
	h=*(int*)(bitmapinfo+8);
    }

    m_width=w;
    m_height=h;
    frames_video=0;
    frame_drop=0;
    drop.AddField("Drop", 250);
    return 0;
}

void AviPlayer::start()
{
    if(initialized==1)return;
    audio_realpos=0;
    audio_time=longcount();
    quit=0;
    if(stream)
        stream->SeekToTime(0);
    if(audiostream)
        audiostream->SeekToTime(0);

    if(audiostream)
	pthread_create(&audio_thread, NULL, doAudioOut, (void*)this);
    if(stream)
	pthread_create(&main_thread, NULL, ::main_thread, (void*)this);
    initialized=1;
}

void AviPlayer::stop()
{
    initialized=0;
    time_start=0;
}

void AviPlayer::close()
{
    quit=1;
    if(audiostream)
    	pthread_join(audio_thread, NULL);
    if(stream)
	pthread_join(main_thread, NULL);
    pthread_cond_destroy(&cond);
    pthread_mutex_destroy(&mutex);
    if(audio_fd)
	::close(audio_fd);
    clip.CloseFile();
    audiostream=0;
    stream=0;
    decoder.Close();
#ifdef USE_ESD    
    esd_close(esd);
    esd=-1;
#endif    
    audio_fd=-1;
    if(frames_video)
	cout<<"Played "<<frames_video<<" video frames ( " << frame_drop*100./frames_video << "% drop )" << endl;
/*
#warning FIXME
    if(pthread_self()==main_thread)
	pthread_exit(NULL);	*/
}

double AviPlayer::reseek(double pos)
{
#ifndef QUIET
    cout<<"Seek pos: "<<pos<<endl;
#endif
    if(stream)
        pos=stream->SeekToTime(pos);
#ifndef QUIET
    cout<<"Keyframe pos: "<<pos<<endl;
#endif
    if(audiostream)
        audiostream->SeekToTime(pos);
    decoder.Stop();
    pthread_mutex_lock(&mutex);
    frame_in=frame_out=frame_size=0;
    pthread_mutex_unlock(&mutex);
#ifndef USE_ESD
    if(audio_fd!=0)
	ioctl(audio_fd, SNDCTL_DSP_RESET, NULL);
#endif	
    decoder.Start();
    if(paused)
	doVideoOut();
    time_start=0;
    return pos;
}

int AviPlayer::reseek_exact(double pos)
{
    double pos2=0;
    initialized=0;
    if(stream)
	pos2=stream->SeekToTime(pos);
    if(audiostream)
	audiostream->SeekToTime(pos);	
    if(pos2<0)
    {
	if(stream)stream->SeekToTime(0);
	if(audiostream)audiostream->SeekToTime(0);
	time_start=0;
	initialized=1;
	return -1;
    }	
    if(pos2>pos)
    {
	cout<<"ERROR: reseek_exact: pos2>pos"<<endl;
	return -1;
    }	
    if(stream)
    {
	decoder.Stop();
	decoder.Start();
	while(stream->GetTime()<pos)
	    doVideoOut();
    }
    initialized=1;
    time_start=0;
    return 0;
}