/********************************************************

	AviReadStream/AviReadFile class implementation
	Copyright 2000 Eugene Smith (divx@euro.ru)
	Last modified: 13.07.2000

*********************************************************/


#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <avifile.h>
#include <sched.h>

#include <vector>

#define BUFFERING 100

using namespace std;
#define min(X, Y) (((X)<(Y))?(X):(Y))
#define _assert(X, Y) \
if(!(X)) \
{ \
    printf("Assertion failed during " ## Y ## "\n"); \
    return E_ERROR; \
}    

struct thread_arg
{
    int fd;
    req* req_buf;
    int* buffers_busy;
    int* quit;
    pthread_mutex_t* mutex_in;
    pthread_cond_t* cond_in;
    pthread_mutex_t* mutex_out;
    pthread_cond_t* cond_out;
};    
static int minimal(req* req_buf)
{
    int ans=0;
    int streams=-1;
    int i;
// Determine number of streams
#warning FIXME
    for(i=0; i<BUFFERING; i++)
	if(req_buf[i].st!=req::BUFFER_CLEAN)
	    if((signed)req_buf[i].id>streams)
		streams=req_buf[i].id;
    if(streams<0)
	return 0;//req_buf is completely clean

// Init	priority table
    unsigned* bases=new unsigned[streams+1];

    for(i=0; i<streams; i++)bases[i]=(unsigned)-1;
    for(i=0; i<BUFFERING; i++)
	if(req_buf[i].st!=req::BUFFER_CLEAN)
	    if(req_buf[i].position<bases[req_buf[i].id])
    		bases[req_buf[i].id]=req_buf[i].position;
// Find lowest waiting chunk
    unsigned val=(unsigned)-1;
    for(i=0; i<BUFFERING; i++)
	if(req_buf[i].st==req::BUFFER_WAITING)
	{
	    if(req_buf[i].position<bases[req_buf[i].id])
	    {
		printf("Logic error: waiting chunk with pos < current \n");
		continue;
	    }	
	    if(req_buf[i].position-bases[req_buf[i].id]<val)
	    {
		ans=i;
		val=req_buf[i].position-bases[req_buf[i].id];
	    }
	}    	
    return ans;	    
}
void* readfunc(void* arg)
{
    thread_arg a;
    memcpy(&a, arg, sizeof(a));
//    printf("Created thread with arg %X\n", a.buffers_busy);
    delete arg;
    int qz=0;
    while(1)
    {
//    	printf("Waiting for cond_in at %X, busy buffers %d\n", lcount(), buffers_busy);
        if(*(a.quit))return 0;
//	printf("readfunc: %d buffers at %X\n", *(a.buffers_busy), a.buffers_busy);
        pthread_mutex_lock(a.mutex_out);
//    	printf("readfunc(): locked mutex_in\n");
	if(*(a.buffers_busy)==0)pthread_cond_wait(a.cond_in, a.mutex_out);
//    	printf("readfunc(): unlocking mutex_in\n");
	pthread_mutex_unlock(a.mutex_out);
//    	printf("readfunc(): unlocked mutex_in\n");
//	printf("Received cond_in at %X, busy buffers %d\n", lcount(), buffers_busy);
//        for(int i=0; i<sizeof(req_buf)/sizeof(req_buf[0]); i++)
//	{
	    int i=minimal(a.req_buf);
	    if(a.req_buf[i].st==req::BUFFER_WAITING)
	    {
		pthread_mutex_lock(a.mutex_out);
		a.req_buf[i].st=req::BUFFER_WRITING;
	        pthread_mutex_unlock(a.mutex_out);
		a.req_buf[i].memory=new char[a.req_buf[i].size];
		lseek(a.fd, a.req_buf[i].offset, SEEK_SET);
		read(a.fd, a.req_buf[i].memory, a.req_buf[i].size);
                 qz++;
//                 if(qz%10==0)
//		printf("Readfunc:  %f ms\n", (t2-t1)/550000.);
  		pthread_mutex_lock(a.mutex_out);
		a.req_buf[i].st=req::BUFFER_READY;
//    		pthread_mutex_lock(a.mutex_in);
		(*(a.buffers_busy))--;
//	        pthread_mutex_unlock(a.mutex_in);
		pthread_mutex_unlock(a.mutex_out);
		pthread_cond_broadcast(a.cond_out);
//		printf("Broadcasting cond_out at %X\n", lcount());
	    }
//	}     
    }		    
}

InputStream::InputStream(int fd):m_fd(fd),cache(new Cache(BUFFERING))
{
    int pos=lseek(m_fd, 0, SEEK_CUR);
    length=lseek(m_fd, 0, SEEK_END);
    seek(pos);
}
int Cache::Create(int m_fd)
{
    thread_arg* str;
    int result;
    int i;
    pthread_mutex_init(&mutex_in, 0);
    pthread_mutex_init(&mutex_out, 0);
    for(i=0; i<BUFFERING; i++)
    {
	req_buf[i].st=req::BUFFER_CLEAN;
	req_buf[i].memory=0;
    }	
    result=pthread_cond_init(&cond_in, NULL);
    if(result!=0)perror("Creating cond_in");
    result=pthread_cond_init(&cond_out, NULL);
    if(result!=0)perror("Creating cond_out");
    str=new thread_arg;
    str->fd=m_fd;
    str->mutex_in=&mutex_in;
    str->mutex_out=&mutex_out;
    str->cond_in=&cond_in;
    str->cond_out=&cond_out;
    str->req_buf=req_buf;
    str->buffers_busy=&buffers_busy;
    str->quit=&m_quit;
//    printf("Creating thread with arg %X %X\n", str->buffers_busy, &buffers_busy);
    result=pthread_create(&thread, 0, &readfunc, str);
    if(result!=0)perror("Creating thread");
    m_status=ASYNC;
//    Sync();
//    usleep(100000);
}
Cache::~Cache()
{
    m_quit=1;
    if(m_status==ASYNC)
    {
	pthread_cond_broadcast(&cond_in);
	pthread_join(thread, NULL);
	pthread_cond_destroy(&cond_in);	    
	pthread_cond_destroy(&cond_out);	    
	pthread_mutex_destroy(&mutex_in);	    
        pthread_mutex_destroy(&mutex_out);	    
	for(int i=0; i<m_size; i++)
	    if(req_buf[i].memory)
		delete req_buf[i].memory;
	delete req_buf;	    
    }	
}
InputStream::~InputStream()
{
    if(cache)
	delete cache;
    cache=0;
}
//#warning
int Cache::Read(char* buffer, unsigned id, unsigned position, unsigned size, unsigned in_pos)
// offset_t offset, char* buffer, unsigned size)
{
    int t1, t2;
//    t1=lcount();
    if(id>=MAXSTREAMS)return E_ERROR;
    if(position>=m_lengths[id])return E_ERROR;
    offset_t offset=m_tables[id][position].dwChunkOffset;
    unsigned max_size=m_tables[id][position].dwChunkLength;

    m_positions[id]=position;
    Update();
in1:
    for(int i=0; i<m_size; i++)
    {
	if(req_buf[i].offset==offset && req_buf[i].size==max_size && req_buf[i].st!=req::BUFFER_CLEAN)
	{
//	    printf("Waiting for cond_out at %X, buffer %d, "
//	    "offset %d, size %d, status %d\n", lcount(), i,
//	    req_buf[i].offset, req_buf[i].size, req_buf[i].st);
	    if(req_buf[i].st!=req::BUFFER_READY)
	    {
//		printf("Locking mutex_out\n");
	        pthread_mutex_lock(&mutex_out);
//		printf("Locked mutex_out\n");
		while(req_buf[i].st!=req::BUFFER_READY)
		    pthread_cond_wait(&cond_out, &mutex_out);
//		printf("Unlocking mutex_out\n");
	    	pthread_mutex_unlock(&mutex_out);
//		printf("Unlocked mutex_out\n");
//		printf("Received cond_out at %X\n", lcount());
//		printf("Status is %d\n", req_buf[i].st);
	    }
//	    printf("Starting read\n");
	    memcpy(buffer, req_buf[i].memory+in_pos, size);
//	    printf("Ending read\n");
//	    printf("Deleting\n");
//	    pthread_mutex_lock(&mutex_out);
//	    delete req_buf[i].memory;
//	    req_buf[i].memory=0;
//	    req_buf[i].st=req::BUFFER_CLEAN;
//	    t2=lcount();
//	    pthread_mutex_unlock(&mutex_out);
//	    printf("Success\n");
//	    printf("Read: read %d bytes at %f ms\n", 
//	     req_buf[i].size, (t2-t1)/550000.);
	    return size;
	}    	
    }
//  printf("Read: no buffer found\n");
    Prefetch(id, position);

    goto in1;
}

int InputStream::Read(char* buffer, unsigned size)
{
    int ans=read(m_fd, buffer, size);
    return ans;
}

    
int Cache::Prefetch(unsigned id, unsigned position)
//offset_t offset, unsigned size)
{
//    printf("Prefetch(%d, %d)\n", id, position);
    if(id>=MAXSTREAMS)return E_ERROR;
    if(position>=m_lengths[id])return E_ERROR;
    offset_t offset=m_tables[id][position].dwChunkOffset;
    unsigned size=m_tables[id][position].dwChunkLength;
//    printf("Prefetch():resolved to %d,%d\n", offset, size);
    for(int i=0; i<m_size; i++)
    {
	if(req_buf[i].st==req::BUFFER_CLEAN)
	{
//	    printf("Locking mutex_in\n");
	    pthread_mutex_lock(&mutex_out);
	    req_buf[i].offset=offset;
	    req_buf[i].size=size;
	    req_buf[i].id=id;
	    req_buf[i].position=position;
	    req_buf[i].st=req::BUFFER_WAITING;
//	    printf("Broadcasting cond_in at %X\n", lcount());
	    buffers_busy++;
	    pthread_cond_broadcast(&cond_in);
	    pthread_mutex_unlock(&mutex_out);
//	    printf("Unlocked mutex_in\n");
	    sched_yield();
	    return 0;
	}
    }	    
    printf("Prefetch: can't find free buffer\n");
    return E_ERROR;
} 


int Cache::Clear()
{
    printf("Clearing cache\n");
    pthread_mutex_lock(&mutex_out);
    for(int i=0; i<m_size; i++)
    {
	if(req_buf[i].st==req::BUFFER_WRITING)
	    pthread_cond_wait(&cond_out, &mutex_out);
	    else
	if(req_buf[i].st==req::BUFFER_WAITING)
	    req_buf[i].st=req::BUFFER_CLEAN;
	if(req_buf[i].st==req::BUFFER_READY)
	{
	    delete req_buf[i].memory;
	    req_buf[i].memory=0;
    	    req_buf[i].st=req::BUFFER_CLEAN;
	}	    
    }
//    pthread_mutex_lock(&mutex_in);
    buffers_busy=0;
//    pthread_mutex_unlock(&mutex_in);
    pthread_mutex_unlock(&mutex_out);
    printf("Clearing cache OK\n");
//    Sync();
//    usleep(100000);
    return 0;    
}

int Cache::Update()
{
    pthread_mutex_lock(&mutex_out);
    int free_reqs=0;
    char** flags;
    int i;
    static int caller=0;
    flags=new (char*)[MAXSTREAMS];
    for(i=0; i<MAXSTREAMS; i++)
    {
	flags[i]=new char[m_size];
	memset(flags[i], 0, m_size);
    }    
    for(i=0; i<m_size; i++)
    {
	if(req_buf[i].st==req::BUFFER_READY)
	if(req_buf[i].position<m_positions[req_buf[i].id])
	{
//	    printf("Deleting buffer %d\n", i);
	    delete req_buf[i].memory;
//	    printf("Deleting buffer %d OK\n", i);
	    req_buf[i].memory=0;
    	    req_buf[i].st=req::BUFFER_CLEAN;
	}
	if(req_buf[i].st==req::BUFFER_CLEAN)
	    free_reqs++;
	else
	{
	    int th=req_buf[i].position-m_positions[req_buf[i].id];
	    if(th<m_size)
		flags[req_buf[i].id][th]=1;
	}	
    }
    caller++;
    if(caller%100==0)
    {
	int waiting=0, writing=0, ready=0;
	int priority=-1;
	int cpr;
	for(i=0; i<m_size; i++)
	{
	    if(req_buf[i].st==req::BUFFER_CLEAN)continue;
//	    printf("%d: stream %d, pos %d, ", i, req_buf[i].id, req_buf[i].position);
	    switch(req_buf[i].st)
	    {
		case req::BUFFER_WAITING:
		    waiting++;
		    cpr=req_buf[i].position-m_positions[req_buf[i].id];
		    if(priority<0)priority=cpr;
		    if(priority>cpr)priority=cpr;
		    break;
//		    printf("waiting\n");break;
		case req::BUFFER_WRITING:
		    writing++;
		    break;
//		    printf("writing\n");break;
		case req::BUFFER_READY:
		    ready++;
		    break;
//		    printf("ready\n");break;
	    }
	}
	if(waiting==0)
	    printf("Cache full ( %d chunks )\n", ready);
	else
	    printf("Cache status: %d waiting ( lowest priority %d ), %d writing, %d ready, %d clean\n", 
		waiting, priority, writing, ready, free_reqs);
    }	    	    
    pthread_mutex_unlock(&mutex_out);
    int c_id=0, c_pos=1;
//    printf("%d free reqs\n", free_reqs);
    free_reqs-=2;
    while(free_reqs>0)
    {
	if(c_pos+m_positions[c_id]>=m_lengths[c_id])
	    break;
	if(c_pos>=m_size)
	    break;
	if(m_tables[c_id]!=0)
	if(flags[c_id][c_pos]==0)
	{
	    if(m_lengths[c_id]<=(m_positions[c_id]+c_pos))
		continue;
	    Prefetch(c_id, m_positions[c_id]+c_pos);
	    free_reqs--;	
	}
	c_id++;
	if(c_id==MAXSTREAMS)
	{	
	    c_id=0;
	    c_pos++;
	}        
    }
}
static int list(InputStream* fd)
{
    if(fd==0)
	return E_ERROR;
    unsigned id, size;
    id=fd->read_int();
    size=fd->read_int();
//    read(fd, &id, 4);
//    read(fd, &size, 4);
    _assert(id==mmioFOURCC('L', 'I', 'S', 'T'), "LIST");
    return size;
}	
HRESULT AviReadStream::Eof() const
{
    return(m_position>=table_size);
}
HRESULT AviReadStream::Init(unsigned m_str, InputStream* _fd)
{
    unsigned id;
    m_id=m_str;
    m_is=_fd;
//    printf("AviReadStream::Init(%d, %d)\n", m_str, _fd);
    id=m_is->read_int();
//    read(m_fd, &id, 4);
    _assert(id==listtypeSTREAMHEADER, "strl init");
    id=m_is->read_int();
//    read(m_fd, &id, 4);
    _assert(id==ckidSTREAMHEADER, "strh init");
    id=m_is->read_int();
//    read(m_fd, &id, 4);
//    id=m_is->read_int();
//    read(m_fd, &m_header, min(id, sizeof(AVIStreamHeader)));
    offset_t header_pos=m_is->pos();
//    printf("pos %d id %d\n", header_pos, id);
    m_is->Read((char*)&m_header, min(id, sizeof(AVIStreamHeader)));
    if(id<sizeof(AVIStreamHeader))
    {
	printf("WARNING: Incomplete stream header\n");
    }
    else if(id>sizeof(AVIStreamHeader))	
	m_is->seek(header_pos+id);
// seek(m_fd, id-sizeof(AVIStreamHeader), SEEK_CUR);
        
    id=m_is->read_int();
//     read(m_fd, &id, 4);
    _assert(id==ckidSTREAMFORMAT, "strf init");
    id=m_is->read_int();
//     read(m_fd, &id, 4);
    m_format=new char[id];
    if(m_format==0)
    {
	printf("Memory problem or corrupt file\n");
	return E_ERROR;
    }	
    m_format_size=id;
//    read(m_fd, m_format, id);
    m_is->Read(m_format, id);
    if(GetType()==Video)
    {
	printf("Video stream %d: %f frames/s, %f seconds\n", m_id, (double)m_header.dwRate/m_header.dwScale, (double)GetLength());  
    }
    else
    printf("Stream %d: rate %d, scale %d, size %d\n", m_id, m_header.dwRate, m_header.dwScale, m_header.dwLength);
    m_position=0;
    m_ch_off=0;
    m_sample=0;
    start_offset=0;
    chunk_table=0;
    table_size=0;
    return 0;
}    


AviReadStream::StreamType AviReadStream::GetType() const
{
    if(m_header.fccType==streamtypeVIDEO)
	return Video;
	else
        if(m_header.fccType==streamtypeAUDIO)
	    return Audio;
	    else
	    return Other;
}		
AviReadStream::~AviReadStream()	
{
    if(m_format)
        delete m_format;
}
#ifndef _WAVEFORMATEX_
#define _WAVEFORMATEX_
#include <wine/pshpack2.h>
typedef struct {
    WORD	wFormatTag;	/* format type */
    WORD	nChannels;	/* number of channels (i.e. mono, stereo...) */
    DWORD	nSamplesPerSec;	/* sample rate */
    DWORD	nAvgBytesPerSec;/* for buffer estimation */
    WORD	nBlockAlign;	/* block size of data */
    WORD	wBitsPerSample;	/* number of bits per sample of mono data */
    WORD	cbSize;		/* the count in bytes of the size of */
				/* extra information (after cbSize) */
} WAVEFORMATEX, *LPWAVEFORMATEX, *NPWAVEFORMATEX, *PWAVEFORMATEX;
#include <wine/poppack.h>
#endif

HRESULT AviReadStream::GetAudioFormatInfo(void* bi, char** ext)
{
    if(m_header.fccType!=streamtypeAUDIO)
	return E_ERROR;
    if(bi==0)
        return E_ERROR;
    memcpy(bi, m_format, sizeof(WAVEFORMATEX));
    if(ext==0)
        return 0;
    if(((LPWAVEFORMATEX)bi)->cbSize>0)
    {
	if(m_format_size<(sizeof(LPWAVEFORMATEX)+((LPWAVEFORMATEX)bi)->cbSize))
	{
	    printf("WARNING: GetAudioFormatInfo: bad audio structure\n");
	    *ext=0;
	    return E_ERROR;
	}    
	*ext=new char[((LPWAVEFORMATEX)bi)->cbSize];
	memcpy(ext, m_format+sizeof(WAVEFORMATEX), ((LPWAVEFORMATEX)bi)->cbSize);
	return 0;
    }	
    else
    *ext=0;
    return 0;
}    
HRESULT AviReadStream::GetVideoFormatInfo(void* bi)
{
    if(bi==0)
        return E_ERROR;
    memcpy(bi, m_format, m_format_size);
    return 0;
}    
HRESULT AviReadStream::GetFrameFlags(int* flags)
{
    if(flags==0)
	return E_ERROR;
    if(chunk_table)
    {
//        if(table_size*m_header.dwRate != m_header.dwLength)
//        {`
//           printf("Logic error 2\n");
//	    return E_ERROR;
//     	}
        *flags=chunk_table[m_position].dwFlags;
    }
    else
    {
	//handle broken files	?
	return E_NOTIMPL;
    }
}    	
/*	
HRESULT AviReadStream::Release()
{
    m_lockcount--;
    if(m_lockcount==0)
    delete this;
}	    
*/
HRESULT AviReadStream::SetStreamProperties(offset_t _start_offset, AVIINDEXENTRY* _chunk_table,
	    unsigned _table_size, unsigned table_type)
{
    start_offset=_start_offset;
    m_table_type=table_type;
    table_size=0;
//    printf("AviReadStream %d SetProperties: %d %d\n", m_id, _start_offset, _table_size);
//    if(m_header.dwSampleSize==0)
#warning fixme - unreasonable memory waste
    chunk_table=new AVIINDEXENTRY[min(m_header.dwLength, _table_size)];
//    else
//	chunk_table=new AVIINDEXENTRY[m_header.dwLength];
    if(chunk_table==NULL)
    {
	printf("ERROR\n");
	return E_ERROR;
    }	
    //memcpy(chunk_table, _chunk_table);
    
    for(unsigned i=0; i<_table_size; i++)
    {
	int chunk_low, chunk_high;
	int chunk_id=_chunk_table[i].ckid&0xFFFF;
	chunk_high=(chunk_id & 0xFF);
	chunk_low=(chunk_id & 0xFF00)>>8;
	if(chunk_low>='A')
	    chunk_low=chunk_low+10-'A';
	else
	    chunk_low=chunk_low-'0';
	if(chunk_high>='A')
	    chunk_high=chunk_high+10-'A';
	else
	    chunk_high=chunk_high-'0';
	chunk_id=chunk_low+(chunk_high<<4);
	if(m_id!=chunk_id)
	    continue;
	memcpy(chunk_table+table_size, _chunk_table+i, sizeof(AVIINDEXENTRY));
	chunk_table[table_size].dwChunkOffset+=_start_offset;
	table_size++;
	if(table_size>m_header.dwLength)
	{
	    printf("Logic error: table_size>m_header.dwLength\n");
	    printf("Table_size %d, full table %d\n", table_size, _table_size);
	    return 0;
	}	    
//	if(table_size*m_header.dwRate>m_header.dwLength)
//	{
//	}    
    }
//    chunk_table=_chunk_table;
    return 0;
}    

HRESULT AviReadStream::Seek(unsigned pos)
{
//    printf("dwlength: %d\n", m_header.dwLength);
    if(pos>=m_header.dwLength)
	return E_ERROR;
    if(m_is==0)
	return E_ERROR;
    m_is->Clear();	
    if(m_header.dwSampleSize==0)
    {
        m_position=pos;
	m_sample=pos;
	return 0;
    }
    else
    {
	unsigned temp=pos*m_header.dwSampleSize;
	unsigned sum=0;
	for(unsigned i=0; i<m_header.dwLength; i++)
	{
	    sum+=chunk_table[i].dwChunkLength;
	    if(sum>temp)
	    {
		m_position=i;
		m_ch_off=temp+chunk_table[i].dwChunkLength-sum;
		m_sample=pos;
		return 0;
	    }
	}        	
    	return E_ERROR;
    }	
}    

double AviReadStream::SeekToTime(double time)
{
    if(GetType()==Audio)
    {
        if(Seek(time*(double)m_header.dwRate/m_header.dwScale)!=0)
    	    return -1;
	return time;
    }
    else if(GetType()==Video)
    {
	unsigned pos=(unsigned)(time*(double)m_header.dwRate/m_header.dwScale);
	if(m_table_type==1)
	while(1)
	{    
	    if(pos>=m_header.dwLength)
		return -1;
	    if(chunk_table[pos].dwFlags & AVIIF_KEYFRAME)
		break;
	    if(pos==0)
		break;
	    pos--;
	}
	Seek(pos);
	double qq=pos*(double)m_header.dwScale/m_header.dwRate;	
	return qq;
    }
    else
    {
	printf("Seeking in unknown stream type\n");
	return -1;
    }	
}
    
HRESULT AviReadStream::ReadSample(char* buffer, unsigned bufsize, unsigned number)
{
    unsigned my_size;
    if(buffer==0)
	return E_ERROR;
    if(m_is==0)
	return E_ERROR;
    if((number!=1) && (m_header.dwSampleSize==0))
        return E_ERROR;
    if(QuerySampleSize(&my_size)<0)
	return E_ERROR;
    if(bufsize<my_size*number)
    {
	printf("Not enough memory\n");
	return E_ERROR;
    }
    //printf("Reading %d bytes from %X\n", my_size, lseek(m_fd, 0, SEEK_CUR));
    if(m_header.dwSampleSize==0)
    {
//        lseek(m_fd, chunk_table[m_position].dwChunkOffset, SEEK_SET);
//	read(m_fd, buffer, my_size);
//	m_is->Read(chunk_table[m_position].dwChunkOffset, buffer, my_size);
	m_is->Read(buffer, m_id, m_position, my_size);
	m_position++;
	m_sample++;
//        if(m_position<table_size)
//	{
//	    m_is->Prefetch(chunk_table[m_position].dwChunkOffset,
//	     chunk_table[m_position].dwChunkLength);
//	}     
    }
    else
    {
	my_size*=number;
	while(my_size>0)
	{
	    int rd;
//	    printf("Stream pos: %d:%d\n", m_position, m_ch_off);
//	    lseek(m_fd, chunk_table[m_position].dwChunkOffset+m_ch_off, SEEK_SET);
//	    rd=read(m_fd, buffer, min(my_size, chunk_table[m_position].dwChunkLength-m_ch_off));
#warning FIXME
	    rd=m_is->Read(buffer, m_id, m_position, 
	    min(my_size, chunk_table[m_position].dwChunkLength-m_ch_off),
		    m_ch_off);
	    if(rd<0)break;
	    
	    my_size-=rd;
	    buffer+=rd;
	    m_ch_off+=rd;
	    while(m_ch_off>=chunk_table[m_position].dwChunkLength)
	    {
		m_ch_off-=chunk_table[m_position].dwChunkLength;
    		m_position++;
	    }
	    if(Eof())
		return (my_size>0)?E_ERROR:0;
	}      
	m_sample+=number;
//        if(m_position>=m_header.dwLength)
//	    m_position--;
    }	   
 
    return 0;
}    
HRESULT AviReadStream::QuerySampleSize(unsigned* size)
{
    if(m_header.dwSampleSize>0)
    {
	*size=m_header.dwSampleSize;
	return 0;
    }else		
    if(chunk_table)
    {
//        if(table_size*m_header.dwRate != m_header.dwLength)
//        {
//            printf("Logic error 1\n");
//	    printf("%d*%d vs %d\n", table_size, m_header.dwScale, m_header.dwLength);
//	    return E_ERROR;
//    	}
//	printf("Position: %X %X %X %X\n", 
//	    chunk_table[m_position].ckid,
//	    chunk_table[m_position].dwFlags,
//	    chunk_table[m_position].dwChunkLength,
//	    chunk_table[m_position].dwChunkOffset);
    	*size=chunk_table[m_position].dwChunkLength;
	return 0;
    }
    else
    {
	//handle broken files	?
	return E_NOTIMPL;
    }
}
//returns current time
double AviReadStream::GetTime() const
{
    return m_sample*(double)m_header.dwScale/m_header.dwRate;
}

double AviReadStream::GetLength() const
{
    return m_header.dwLength*(double)m_header.dwScale/m_header.dwRate;
}


















#define fpos(X) lseek(X, 0, SEEK_CUR)

AviReadFile::~AviReadFile()
{
    if(m_is)
	delete m_is;	
    if(m_fd>=0)
	close(m_fd);
    if(m_streams)
	delete[] m_streams;
    if(chunk_table)
	delete chunk_table;
}	

HRESULT AviReadFile::OpenFile(const char* name)
{
    m_fd=open(name, O_RDONLY);
    _assert(m_fd>=0, "opening file");
    m_is=new InputStream(m_fd);
    unsigned id;
    //read(m_fd, &id, 4);
    id=m_is->read_int();
    if(id!=mmioFOURCC('R', 'I', 'F', 'F'))
    {
	printf("Not an AVI file!\n");
	return E_ERROR;
    }	
//    read(m_fd, &id, 4);//file size
    id=m_is->read_int();
    unsigned fsize=id+8;
//    read(m_fd, &id, 4);
    id=m_is->read_int();
//    _assert((id==formtypeAVI) || (id==mmioFOURCC('W', 'A', 'V', 'E')), "AVI ");
    _assert(id==formtypeAVI, "AVI ");
    int sys_size=list(m_is);
    if(sys_size<0)
        return E_ERROR;
//    offset_t sys_start=fpos(m_fd);
    offset_t sys_start=m_is->pos();
//    read(m_fd, &id, 4);
    id=m_is->read_int();
    _assert(id==listtypeAVIHEADER, "AVIHEADER");
//    read(m_fd, &id, 4);
    id=m_is->read_int();
    _assert(id==ckidAVIMAINHDR, "MAINHEADER");
//    read(m_fd, &id, 4);
    id=m_is->read_int();
//    read(m_fd, &m_header, sizeof(m_header));
    m_is->Read((char*)&m_header, sizeof(m_header));
    if(sys_size<0)
        return E_ERROR;
    m_streams=new AviReadStream[m_header.dwStreams];
    if(m_streams==NULL)
    {
	printf("ERROR: Can't allocate %d AviReadStreams\n", m_header.dwStreams);
	return E_ERROR;
    }	
    for(int i=0; i<m_header.dwStreams; i++)
    {
        int stream_size=list(m_is);
	if(stream_size<0)
	    return E_ERROR;
	offset_t stream_pos=m_is->pos();
	if(m_streams[i].Init(i, m_is)<0)
	    return E_ERROR;
	m_is->seek(stream_size+stream_pos);
//	lseek(m_fd, stream_size+stream_pos, SEEK_SET);
    }	    
    //lseek(m_fd, sys_start+sys_size, SEEK_SET);
    m_is->seek(sys_start+sys_size);
    //skip until LIST chunk
    unsigned temp_id, temp_len;
    while(1)
    {
//        if(read(m_fd, &temp_id, 4)<0)break;
	temp_id=m_is->read_int();
	temp_len=m_is->read_int();
	if(m_is->eof())break;
//	read(m_fd, &temp_len, 4);
	if(temp_id==mmioFOURCC('L', 'I', 'S', 'T'))
	    break;
//	lseek(m_fd, temp_len, SEEK_CUR);
	m_is->seek_cur(2*((temp_len+1)/2));
//	m_is->seek_cur(temp_len);
    }
    int data_start=m_is->pos();  
    //now we know where index table is situated
    int table_type=1;
    InitChunkTable(data_start+temp_len); 
    if(chunk_table==0)
    {
	printf("Trying alt chunk table mode\n");
	InitAltChunkTable(data_start);
	table_type=0;
    }	
    if(chunk_table==0)
    {
	delete[] m_streams;
	::close(m_fd);
	delete m_is;
	m_is=0;
	m_fd=-1;
	m_streams=0;
	return -1;
    }    	
    for(unsigned i=0; i<m_header.dwStreams; i++)
    {
	m_streams[i].SetStreamProperties(data_start+8, chunk_table, table_size, table_type);
	m_is->AddStream(i, m_streams[i].chunk_table, 0, m_streams[i].table_size);
    }	
    m_is->Async();
    return 0;
}

void AviReadFile::InitChunkTable(offset_t pos)
{
    int temp;
//    lseek(m_fd, pos, SEEK_SET);
    m_is->seek(pos);
    temp=m_is->read_int();
//    read(m_fd, &temp, 4);
    if(temp==ckidAVINEWINDEX)
    {
//	read(m_fd, &table_size, 4);
	table_size=m_is->read_int();
	table_size/=sizeof(AVIINDEXENTRY);
	chunk_table=new AVIINDEXENTRY[table_size];
	if(chunk_table==0)
	{
	    printf("Not enough memory\n");
	    table_size=0;
	    return;
	}    
//	chunk_table=(AVIINDEXENTRY*)malloc(table_size*sizeof(AVIINDEXENTRY));
//	read(m_fd, chunk_table, table_size*sizeof(AVIINDEXENTRY));
	m_is->Read((char*)chunk_table, table_size*sizeof(AVIINDEXENTRY));
	printf("Chunk table: %d entries, offset %X\n", table_size, pos);
    } 
    else
    {
	chunk_table=0;
	table_size=0;
	printf("No valid chunk table found!\n");
    }
}
// MS AviFile does it the same way    	
void AviReadFile::InitAltChunkTable(offset_t pos)
{
    m_is->seek(pos);
    if(m_is->read_int()!=listtypeAVIMOVIE)
	return;
    vector<AVIINDEXENTRY> index;	
    while(!m_is->eof())
    {
	AVIINDEXENTRY entry;
	unsigned temp_id=m_is->read_int();
	unsigned temp_len=m_is->read_int();
	unsigned chunk_low, chunk_high;
	unsigned chunk_id=temp_id&0xFFFF;
//	printf("Pos: %X id: %X len: %X\n", m_is->pos(), temp_id, temp_len);
	chunk_high=(chunk_id & 0xFF);
	chunk_low=(chunk_id & 0xFF00)>>8;
	if(chunk_low>='A')
	    chunk_low=chunk_low+10-'A';
	else
	    chunk_low=chunk_low-'0';
	if(chunk_high>='A')
	    chunk_high=chunk_high+10-'A';
	else
	    chunk_high=chunk_high-'0';
	chunk_id=chunk_low+(chunk_high<<4);
	if(chunk_id>=m_header.dwStreams)
	    break;
	entry.dwChunkOffset=m_is->pos()-pos-8;
	entry.ckid=temp_id;
	entry.dwChunkLength=temp_len;
	entry.dwFlags=0;//maybe wrong
	index.push_back(entry);
	m_is->seek_cur(2*((temp_len+1)/2));
    }
    
    table_size=index.size();
    if(table_size==0)
	return;
    chunk_table=new AVIINDEXENTRY[table_size];
    if(chunk_table==0)
	return;
    memcpy(chunk_table, &index[0], table_size*sizeof(AVIINDEXENTRY));
    printf("Fake chunk table: %d entries\n", table_size);
}   
	
    	
	
    
    
    

unsigned AviReadFile::StreamCount()
{
    return m_header.dwStreams;
}    
unsigned AviReadFile::VideoStreamCount()
{
    unsigned i=0,j;
    for(j=0; j<m_header.dwStreams; j++)
	if(m_streams[j].GetType()==AviReadStream::Video)
	    i++;
    return i;
}    
unsigned AviReadFile::AudioStreamCount()
{
    unsigned i=0,j;
    for(j=0; j<m_header.dwStreams; j++)
	if(m_streams[j].GetType()==AviReadStream::Audio)
	    i++;
    return i;
}    
AviReadStream* AviReadFile::GetStream(unsigned stream_id)
{
    if(stream_id<0)
	return NULL;
    if(stream_id>=m_header.dwStreams)
	return NULL;
    return m_streams+stream_id;
}
AviReadStream* AviReadFile::GetStream(unsigned stream_id, AviReadStream::StreamType type)
{
    if(stream_id<0)
	return NULL;
    if(stream_id>=m_header.dwStreams)
	return NULL;
    unsigned i=0,j;
    for(j=0; j<m_header.dwStreams; j++)
    	if(m_streams[j].GetType()==type)
	{
	    if(stream_id==i)
		return m_streams+j;
	    i++;    
	}
    return NULL;
}

HRESULT AviReadFile::GetFileHeader(MainAVIHeader* header)
{
    if(header)
        memcpy(header, &m_header, sizeof(m_header));
    return 0;
}
HRESULT AviReadFile::CloseFile()
{
    close(m_fd);
    m_fd=-1;
    delete m_is;
    m_is=0;
    return 0;
}