#include "gsm61dec.h"
#include "xa_gsm_state.h"

int MSGSM_Decoder::Init(WAVEFORMATEX* wf, void*)
{
    GSM_Init();
    local_wf=*wf;
    return 0;
}
int MSGSM_Decoder::decode_frames(unsigned char* in_data, unsigned char* out_data,
	    unsigned& in_size, unsigned out_size, out_format* format)
{
    int num_samples=in_size/65;
    int ocnt=XA_ADecode_GSMM_PCMxM(num_samples*65, num_samples,
		(char*)in_data, out_data, out_size);
    if(format)
    {
	format->is_stereo=0;//mono
	format->freq=local_wf.nSamplesPerSec;//unsure
         //format->freq=44100;
	format->valid=OUT_FORMAT_VALID;
    }		
    if(ocnt<out_size)
    {
	in_size=num_samples*65;
	return ocnt;
    }
    else
    {
	in_size=(ocnt/640)*65;
	return ocnt-ocnt%640;
    }				
}
