.TH DIALOG 1 "10 June 1994" "Dialog Version 0.4"
.SH NAME
dialog \- display dialog boxes from shell scripts
.SH SYNOPSIS
.B dialog --clear
.br
.BI "dialog --create-rc " file
.br
.B dialog
[
.B \-\-title
.I title
]
[
.B \-\-backtitle
.I backtitle
]
[
.B \-\-clear
]
[
.B \-\-separate\-output
]
.B box-options
.SH DESCRIPTION
.B Dialog
is a program that will let you to present a variety of questions or
display messages using dialog boxes from a shell script. Currently,
these types of dialog boxes are implemented: 
.LP
.BR yes/no " box," " menu" " box," " input" " box,"
.BR message " box," " text" " box," " info" " box,"
.BR checklist " box," " radiolist" " box, and" " guage" " box."
.SH OPTIONS
.TP
.B \-\-clear
The screen will be cleared to the
.BR "screen attribute" " on exit."
.TP
.BI \-\-create-rc " file"
.RB "Since " dialog " supports run-time configuration,"
this can be used to dump a sample configuration file to the file specified
by
.IR file "."
.TP
.BI \-\-separate\-output
For checklist widgets, output result one line at a time, with no
quoting.  This facilitates parsing by another program.
.TP
.BI \-\-title " title"
Specifies a
.I title
string to be displayed at the top of the dialog box.
.TP
.BI \-\-backtitle " backtitle"
Specifies a
.I backtitle
string to be displayed on the backdrop, at the top of the screen.
.TP
.B Box Options
.TP
.BI \-\-yesno " text height width"
.RB A " yes/no" " dialog box of size"
.I height
rows by
.I width
columns will be displayed. The string specified by
.I text
is displayed inside the dialog box. If this string is too long to be fitted
in one line, it will be automatically divided into multiple lines at
appropriate places. The
.I text
string may also contain the sub-string
.I
"\en"
or newline characters
.I `\en\'
to control line breaking explicitly.  This dialog box is useful for
asking questions that require the user to answer either yes or no.
.RB "The dialog box has a" " Yes" " button and a " No
button, in which the user can switch between by pressing the
.IR TAB " key."
.TP
.BI \-\-msgbox " text height width"
.RB A " message" " box is very similar to a" " yes/no" " box."
The only difference between a
.B message
box and a
.B yes/no
box is that a
.B message
box has only a single
.B OK
button. You can use this dialog box to display any message you like.
After reading the message, the user can press the
.I ENTER
key so that
.B dialog
will exit and the calling shell script can continue its operation.
.TP
.BI \-\-infobox " text height width"
.RB An " info" " box is basically a" " message" " box."
However, in this case,
.B dialog
will exit immediately after displaying the message to the user. The
screen is not cleared when
.B dialog
exits, so that the message will remain on the screen until the calling
shell script clears it later. This is useful when you want to inform
the user that some operations are carrying on that may require some
time to finish.
.TP
.BI \-\-inputbox " text height width [init]"
.RB "An " input " box is useful when you want to ask questions that"
require the user to input a string as the answer. If init is supplied
it is used to initialize the input string.
When inputing the
string, the
.I BACKSPACE
key can be used to correct typing errors. If the input string is longer than
can be fitted in the dialog box, the input field will be scrolled. On exit,
the input string will be printed on
.IR stderr "."
.TP
.BI \-\-textbox " file height width"
.RB A " text" " box lets you display the contents of a text file in a"
dialog box. It is like a simple text file viewer. The user can move
through the file by using the
.IR UP/DOWN ", " PGUP/PGDN
.RI and " HOME/END" " keys available on most keyboards."
If the lines are too long to be displayed in the box, the
.I LEFT/RIGHT
keys can be used to scroll the text region horizontally. For more
convenience, forward and backward searching functions are also provided.
.IP "\fB\-\-menu \fItext height width menu-height \fR[ \fItag item \fR] \fI..."
As its name suggests, a
.B menu
box is a dialog box that can be used to present a list of choices in
the form of a menu for the user to choose. Each menu entry consists of a
.IR tag " string and an " item " string. The"
.I tag
gives the entry a name to distinguish it from the other entries in the
menu. The
.I item
is a short description of the option that the entry represents. The
user can move between the menu entries by pressing the
.I UP/DOWN
keys, the first letter of the
.I tag
as a hot-key, or the number keys
.IR 1-9 ". There are"
.I menu-height
entries displayed in the menu at one time, but the menu will be
scrolled if there are more entries than that. When
.B dialog
exits, the
.I tag
of the chosen menu entry will be printed on
.IR stderr "."
.IP "\fB\-\-checklist \fItext height width list-height \fR[ \fItag item status \fR] \fI..."
.RB "A " checklist " box is similar to a " menu " box in that there are"
multiple entries presented in the form of a menu. Instead of choosing
one entry among the entries, each entry can be turned on or off by the
user. The initial on/off state of each entry is specified by
.IR status "."
On exit, a list of the
.I tag
strings of those entries that are turned on will be printed on
.IR stderr "."

.IP "\fB\-\-radiolist \fItext height width list-height \fR [ \fItag item status \fR] \fI..."
.RB "A " radiolist " box is similar to a " menu " box.  The only difference is"
that you can indicate which entry is currently selected, by setting its
.IR status " to " on "."

.IP "\fB\-\-guage \fItext height width percent\fR"
.RB "A " guage " box displays a meter along the bottom of the box.
The meter indicates the percentage.  New percentages are read from
standard input, one integer per line.  The meter is updated
to reflect each new percentage.  If stdin is XXX, then subsequent
lines up to another XXX are used for a new prompt.
The guage exits when EOF is reached on stdin.

.SH "RUN-TIME CONFIGURATION"
.TP 4
1.
Create a sample configuration file by typing:
.LP
.in +1i
"dialog --create-rc <file>"
.TP 4
2.
At start,
.B dialog
determines the settings to use as follows:
.RS
.TP 4
a)
if environment variable
.B DIALOGRC
is set, it's value determines the name of the configuration file.
.TP 4
b)
if the file in (a) can't be found, use the file
.I $HOME/.dialogrc
as the configuration file.
.TP 4
c)
if the file in (b) can't be found, use compiled in defaults.
.RE
.TP 4
3.
Edit the sample configuration file and copy it to some place that
.B dialog
can find, as stated in step 2 above.
.SH ENVIROMENT
.TP 15
.B DIALOGRC
Define this variable if you want to specify the name of the configuration file
to use.
.SH FILES
.TP 20
.I $HOME/.dialogrc
default configuration file
.SH DIAGNOSTICS
Exit status is 0 if
.BR dialog " is exited by pressing the " Yes " or " OK
button, and 1 if the
.BR No " or " Cancel
button is pressed. Otherwise, if errors occur inside
.B dialog
or
.B dialog
is exited by pressing the
.I ESC
key, the exit status is -1.
.SH BUGS
Text files containing
.I tab
characters may cause problems with
.B text
box.
.I Tab
characters in text files must first be expanded to spaces before being
.RB "displayed by " text " box."
.TP
Screen update is too slow.
.SH AUTHOR
Savio Lam (lam836@cs.cuhk.hk) - version 0.3
.LP
Stuart Herbert (S.Herbert@sheffield.ac.uk) - patch for version 0.4
