/* gitmatch.c -- an utility used internally by git to match file names against
   different shell-like patterns. */

/* Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Tudor Hulubei and Andrei Pitis.  */


#include <stdio.h>

#include "fnmatch.h"


char *program;


int usage()
{
    fprintf(stderr, "%s: GIT internal program.\n", program);
    exit(255);
}


/*
 * argv[1] = string
 * argv[2], argv[3], ... = patterns
 * return value = no of pattern that matches.
 */
 
int main(argc, argv)
    int argc;
    char *argv[];
{
    int i, flags = FNM_PERIOD | FNM_PATHNAME;

    program = argv[0];

    if (argc < 3)
	usage();

    for (i = 0; i < argc - 2; i++)
	if (fnmatch(argv[i + 2], argv[1], flags) != FNM_NOMATCH)
	    return i + 1;

    return 0;
}
