#!/bin/sh -e

VERSION=$2
TAR=../jenkins-json_$VERSION.orig.tar.gz
DIR=jenkins-json-$VERSION
mkdir -p $DIR
# Expand the upstream tarball
tar -xzf $TAR -C $DIR --strip-components=1
# Repack excluding stuff we don't need
DATE="Fri Oct 21 12:29:52 BST 2011"
tar -c --exclude '*.jar' --exclude '*.class' \
  --exclude 'CVS' --exclude '.svn' --mtime="$DATE" $DIR | \
  gzip -9fn -c - > $TAR

rm -rf $DIR
