.\" dpkg manual page - dpkg-name(1)
.\"
.\" Copyright © 1995-1996 Erick Branderhorst
.\" Copyright © 2007-2013, 2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-name 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
dpkg\-name \- rename Debian packages to full package names
.
.SH SYNOPSIS
.B dpkg\-name
.RI [ option ...]
.RB [ \-\- ]
.IR file ...
.
.SH DESCRIPTION
.PP
This manual page documents the
.B dpkg\-name
program which provides an easy way to rename
.B Debian
packages into their full package names. A full package name consists of
.IB package _ version _ architecture . package-type
as specified in the control file of the package. The \fIversion\fP part
of the filename
consists of the upstream version information optionally followed by a
hyphen and the revision information. The \fIpackage-type\fP part comes
from that field if present or fallbacks to \fBdeb\fP.
.
.SH OPTIONS
.TP
.BR \-a ", " \-\-no\-architecture
The destination filename will not have the architecture information.
.TP
.BR \-k ", " \-\-symlink
Create a symlink, instead of moving.
.TP
.BR \-o ", " \-\-overwrite
Existing files will be overwritten if they have the same name as the
destination filename.
.TP
.BR \-s ", " \-\-subdir " [\fIdir\fP]"
Files will be moved into a subdirectory. If the directory given as argument exists
the files will be moved into that directory otherwise the name of
the target directory is extracted from the section field in the
control part of the package. The target directory will be
«unstable/binary\-\fIarchitecture\fP/\fIsection\fP».
If the section is not found in the control, then \fBno\-section\fP is assumed,
and in this case, as well as for sections \fBnon\-free\fP and \fBcontrib\fP
the target directory is «\fIsection\fP/binary\-\fIarchitecture\fP».
The section field is not required so a lot of packages will find their way
to the \fBno\-section\fP area.
Use this option with care, it's messy.
.TP
.BR \-c ", " \-\-create\-dir
This option can used together with the \fB\-s\fP option. If a target
directory isn't found it will be created automatically.
.B Use this option with care.
.TP
.BR \-? ", " \-\-help
Show the usage message and exit.
.TP
.BR \-v ", " \-\-version
Show the version and exit.
.
.SH ENVIRONMENT
.TP
.B DPKG_COLORS
Sets the color mode (since dpkg 1.18.5).
The currently accepted values are: \fBauto\fP (default), \fBalways\fP and
\fBnever\fP.
.TP
.B DPKG_NLS
If set, it will be used to decide whether to activate Native Language Support,
also known as internationalization (or i18n) support (since dpkg 1.19.0).
The accepted values are: \fB0\fP and \fB1\fP (default).
.
.SH BUGS
Some packages don't follow the name structure
.IB package _ version _ architecture .deb\fR.\fP
Packages renamed by \fBdpkg\-name\fP
will follow this structure. Generally this will have no impact on how
packages are installed by
.BR dselect (1)/ dpkg (1),
but other installation tools
might depend on this naming structure.
.
.SH EXAMPLES
.TP
.B dpkg\-name bar\-foo.deb
The file \fBbar\-foo.deb\fP will be renamed to bar\-foo_1.0\-2_i386.deb or
something similar (depending on whatever information is in the control
part of \fBbar\-foo.deb\fP).
.TP
.B find /root/debian/ \-name '*.deb' | xargs \-n 1 dpkg\-name \-a
All files with the extension \fBdeb\fP in the directory /root/debian and its
subdirectory's will be renamed by \fBdpkg\-name\fP if required into names
with no architecture information.
.TP
.B find \-name '*.deb' | xargs \-n 1 dpkg\-name \-a \-o \-s \-c
.B Don't do this.
Your archive will be messed up completely because a lot of packages
don't come with section information.
.B Don't do this.
.TP
.B dpkg\-deb \-\-build debian\-tmp && dpkg\-name \-o \-s .. debian\-tmp.deb
This can be used when building new packages.
.
.SH SEE ALSO
.BR deb (5),
.BR deb\-control (5),
.BR dpkg (1),
.BR dpkg\-deb (1),
.BR find (1),
.BR xargs (1).
