# creates a .qz file frm a 1 of N spec
#  Copyright (C) 1992-2000 Michigan State University
#
#  The CAPA system is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  The CAPA system is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with the CAPA system; see the file COPYING.  If not,
#  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#
#  As a special exception, you have permission to link this program
#  with the TtH/TtM library and distribute executables, as long as you
#  follow the requirements of the GNU GPL in regard to all of the
#  software in the executable aside from TtH/TtM.

proc export {} {
    global problem

    set file [ tk_getSaveFile -defaultextension .qz \
		  -filetypes {{{Quizzer file} {.qz}}}  ]
    if { $file == "" } {
	tk_messageBox -icon info -type ok -message "Information not saved"
	return
    }
    
    set fileid [open $file "w"]
    
    exportQZHeader $fileid

    for { set i 1 } { $i <= $problem(num) } { incr i } {
	switch $problem(prob.$i.type) {
	    "Multiple Choice" 
	    {
		MCexportHeader $fileid $i
		MCexportLeafs $fileid $i
		MCexportAns $fileid $i 
	    }
	    -
	    {
		tk_messageBox -icon error \
	         -message "Problem type $problem(prob.$i.type) not supported" \
		    -type ok
	    }
	}
    }

    exportQZFooter $fileid 

    close $fileid
    
    tk_messageBox -icon info -message "Exported to $file" -type ok
}

proc exportQZHeader { fileid } {
    global problem

    puts $fileid "//Created by HACK GUI to qz files"
    puts $fileid "//CAPA system software is copyrighted by Michigan State University."
    puts $fileid "//"
    puts $fileid "/IMP \"../Tools/StdMacros\""
    puts $fileid "/IMP \"../Tools/StdUnits\""
    if { $problem(includes) != "" } {
    }
    puts $fileid "/IMP \"HWTop\""
}

proc exportQZFooter { fileid } {
    global problem

    puts $fileid "//*********************"
    puts $fileid "/END($problem(endline))"
}

