#! /bin/bash

# SPDX-FileCopyrightText: 2024 Gerald Wiese
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Usage:
# 1. bash scripts/security.sh

# Commands equal package names on PyPI

# Run pip-audit to check dependencies for known vulnerabilities
echo "Running pip-audit"
pip-audit . || exit_status=$?

# Bandit is a tool designed to find common security issues in Python code
printf "\n\n\nRunning bandit\n"
bandit -r . || exit_status=$?

# Don't exit 0 if we had errors
exit "${exit_status:-0}"
