// Copyright (C) 2000-2001 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "server.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

static unsigned keyindex(const char *keyword) 
{
	unsigned key = 0;

	while(*keyword)
		key ^= key << 1 ^ (*(keyword++) & 0x1f);

	return key % KEYWORD_INDEX_SIZE;
}

#ifdef	XML_SCRIPTS

TrunkImage::TrunkImage() :
ScriptImage(driver, "/bayonne/xmlscript"), URLStream(), XMLStream()
{
	main = current = NULL;
};

#ifdef	COMMON_ASYNC_OVERRIDE
int TrunkImage::aRead(char *buffer, size_t len, timeout_t timeout)
{
#ifdef	HAVE_AIO_H
	struct aoicb iob;
	struct aiocb *iobp = &iob;
	struct timespec tv;

	tv.tv_sec = timeout / 1000;
	timeout %= 1000;
	tv.tv_usec = timeout * 1000;

	memset(&iob, 0, sizeof(iob));
	iob.aio_fildes = so;
	iob.aio_buf = (void *)buffer;
	iob.aio_sigevent.sigev_notify = SIGEV_NONE;
	iob.aio_nbytes = len;
	if(!aio_write(&iob))
	{
		aio_suspend((&iobp, 1, &tv);
		return aio_return(&iob);
	}
#ifdef	ENOSYS
	else if(errno == ENOSYS)
		return ::read(so, buffer, len);
#endif
	return -1;
#else
	return ::read(so, buffer, len);
#endif
}
#endif

int TrunkImage::read(unsigned char *buffer, int len)
{
	URLStream::read((char *)buffer, len);
	return gcount();
}

void TrunkImage::purge(void)
{
	URLStream::close();
	ScriptImage::purge();
	main = current = NULL;
}

void TrunkImage::getCompile(const char *name)
{
	Compile *cc = (Compile *)alloc(sizeof(Compile));
	Name *script = (Name *)alloc(sizeof(Name));
	unsigned key;

	memset(cc, 0, sizeof(Compile));
	memset(script, 0, sizeof(Name));
	script->name = (char *)alloc(strlen(name) + 2);
	if(*name != '#')
	{
		script->name[0] = '#';
		strcpy(script->name + 1, name);
	}
	else
		strcpy(script->name, name);

	key = keyindex(script->name);
	script->mask = getDefaultMask();
	script->next = index[key];
	index[key] = script;

	cc->script = script;

	if(!strcmp(script->name, "#"))
		main = cc;

	if(cc != main && current)
		putCompile(current);

	current = cc;
}

void TrunkImage::putCompile(Compile *cc)
{
	Name *script;
	Line *line;
	int bit;

	if(!cc)
		return;

	setCompile(0);
	while(current->looplevel[0])
		addCompile(0, "loop", NULL);	
	addCompile(0, "exit", NULL);
	script = cc->script;
	for(bit = 0; bit < 32; ++bit)
	{
		if(!script->trap[bit])
			continue;

		setCompile(bit + 1);
		while(current->looplevel[bit + 1])
			addCompile(0, "loop", NULL);
		addCompile(0, "exit", NULL);
	}

	line = script->first;
	if(!line)
		return;

	while(line)
	{
		line->mask &= script->mask;
		line = line->next;
	}
}

void TrunkImage::setCompile(unsigned trap)
{
	Name *script = current->script;
	current->trap = trap;
	
	if(!trap)
		current->last = script->first;
	else
		current->last = script->trap[trap - 1];
	
	while(current->last)
	{
		if(!current->last->next)
			break;
		current->last = current->last->next;
	}
}	

void TrunkImage::addCompile(unsigned long mask, const char *cmd, const char **args)
{
	char cmdname[65];
	Name *script = current->script;
	Line *line = (Line *)alloc(sizeof(Line));
	char *arg;
	unsigned trap = current->trap;
	bool prescan = false;
	const char **arglist = args;

	if(trap)
	{
		if(!mask)
			mask = getDefaultMask() & ~(1<<(trap - 1));
	}
	else 
		mask = ~mask;

	if(!current->last)
	{
		if(!current->trap)
			script->first = line;
		else
			script->trap[trap - 1] = line;
	}
	else
		current->last->next = line;

	line->next = NULL;
	line->mask = mask;
	line->loop = 0;

	if(!stricmp(cmd, "repeat") || !stricmp(cmd, "for") || !stricmp(cmd, "do") || !stricmp(cmd, "foreach"))
	{
		if(!current->looplevel[trap])
			++current->loopid[trap];
		++current->looplevel[trap];
		line->loop = current->loopid[trap] * 256 + 
			current->looplevel[trap];
	}
	if(!stricmp(cmd, "loop"))
	{
		line->loop = current->loopid[trap] * 256 + 
			current->looplevel[trap];
		if(current->looplevel[trap])
			--current->looplevel[trap];
	}
	line->line = ++current->line;
	line->argc = 0;
	line->cmd = (char *)cmd;
	strcpy(cmdname, cmd);
	arg = strchr(cmdname, '.');
	if(arg)
		*arg = 0;	
	line->method = getHandler(cmdname);
	if(!args)
	{
		line->args = NULL;
		current->last = line;
		return;
	}
	while(args[line->argc])
		++line->argc;
	
	line->args = (char **)alloc((line->argc + 1) * sizeof(char *));
	memcpy(line->args, args, sizeof(char *) * (line->argc + 1));
	current->last = line;
}

const char *TrunkImage::getAttribute(const char *key, const char *value)
{
	char **a = attrib;
	while(*a)
	{
		if(!stricmp(*a, key))
			return *(++a);
		a += 2;
	}
	return value;
}

void TrunkImage::setToken(const unsigned char **a)
{
	buffer[0] = 0;
	bp = buffer;
	char **ap = attrib;

	if(!a)
	{
		attrib[0] = 0;
		return;
	}

	while(*a)
	{
		*ap = (char *)alloc(strlen((char *)*a) + 1);
		strcpy(*(ap++), (char *)*(a++));
	}
	*(ap) = NULL;
}

const char *TrunkImage::getToken(void)
{
	char *token = ScriptImage::getToken();
	char *nt;

	if(!token)
		return NULL;

	nt = (char *)alloc(strlen(token) + 1);
	if(*token == '=')
	{
		strcpy(nt, token + 1);
		strcat(nt, "=");
	}
	else
		strcpy(nt, token);
	return nt;
}

#endif

#ifdef	CCXX_NAMESPACES
};
#endif
