/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright 2022 Collabora Ltd.
 *
 * AUTOMATICALLY GENERATED BY v4l2-tracer-gen.pl DO NOT EDIT
 */

#include "v4l2-tracer-common.h"

void trace_v4l2_ctrl_h264_sps_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_h264_sps_obj = json_object_new_object();
	struct v4l2_ctrl_h264_sps *p = static_cast<struct v4l2_ctrl_h264_sps*>(ptr);
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "profile_idc", json_object_new_int(p->profile_idc));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "constraint_set_flags", json_object_new_string(fl2s(p->constraint_set_flags, v4l2_h264_sps_flag_def).c_str()));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "level_idc", json_object_new_int(p->level_idc));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "seq_parameter_set_id", json_object_new_int(p->seq_parameter_set_id));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "chroma_format_idc", json_object_new_int(p->chroma_format_idc));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "bit_depth_luma_minus8", json_object_new_int(p->bit_depth_luma_minus8));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "bit_depth_chroma_minus8", json_object_new_int(p->bit_depth_chroma_minus8));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "log2_max_frame_num_minus4", json_object_new_int(p->log2_max_frame_num_minus4));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "pic_order_cnt_type", json_object_new_int(p->pic_order_cnt_type));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "log2_max_pic_order_cnt_lsb_minus4", json_object_new_int(p->log2_max_pic_order_cnt_lsb_minus4));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "max_num_ref_frames", json_object_new_int(p->max_num_ref_frames));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "num_ref_frames_in_pic_order_cnt_cycle", json_object_new_int(p->num_ref_frames_in_pic_order_cnt_cycle));
	/* __s32 offset_for_ref_frame[255] */
	json_object *offset_for_ref_frame_obj = json_object_new_array();
	for (size_t i = 0; i < 255; i++) {
		json_object_array_add(offset_for_ref_frame_obj, json_object_new_int(p->offset_for_ref_frame[i]));
	}
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "offset_for_ref_frame", offset_for_ref_frame_obj);

	json_object_object_add(v4l2_ctrl_h264_sps_obj, "offset_for_non_ref_pic", json_object_new_int(p->offset_for_non_ref_pic));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "offset_for_top_to_bottom_field", json_object_new_int(p->offset_for_top_to_bottom_field));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "pic_width_in_mbs_minus1", json_object_new_int(p->pic_width_in_mbs_minus1));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "pic_height_in_map_units_minus1", json_object_new_int(p->pic_height_in_map_units_minus1));
	json_object_object_add(v4l2_ctrl_h264_sps_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_h264_sps_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_ctrl_h264_sps", v4l2_ctrl_h264_sps_obj);
}

void trace_v4l2_ctrl_h264_pps_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_h264_pps_obj = json_object_new_object();
	struct v4l2_ctrl_h264_pps *p = static_cast<struct v4l2_ctrl_h264_pps*>(ptr);
	json_object_object_add(v4l2_ctrl_h264_pps_obj, "pic_parameter_set_id", json_object_new_int(p->pic_parameter_set_id));
	json_object_object_add(v4l2_ctrl_h264_pps_obj, "seq_parameter_set_id", json_object_new_int(p->seq_parameter_set_id));
	json_object_object_add(v4l2_ctrl_h264_pps_obj, "num_slice_groups_minus1", json_object_new_int(p->num_slice_groups_minus1));
	json_object_object_add(v4l2_ctrl_h264_pps_obj, "num_ref_idx_l0_default_active_minus1", json_object_new_int(p->num_ref_idx_l0_default_active_minus1));
	json_object_object_add(v4l2_ctrl_h264_pps_obj, "num_ref_idx_l1_default_active_minus1", json_object_new_int(p->num_ref_idx_l1_default_active_minus1));
	json_object_object_add(v4l2_ctrl_h264_pps_obj, "weighted_bipred_idc", json_object_new_int(p->weighted_bipred_idc));
	json_object_object_add(v4l2_ctrl_h264_pps_obj, "pic_init_qp_minus26", json_object_new_int(p->pic_init_qp_minus26));
	json_object_object_add(v4l2_ctrl_h264_pps_obj, "pic_init_qs_minus26", json_object_new_int(p->pic_init_qs_minus26));
	json_object_object_add(v4l2_ctrl_h264_pps_obj, "chroma_qp_index_offset", json_object_new_int(p->chroma_qp_index_offset));
	json_object_object_add(v4l2_ctrl_h264_pps_obj, "second_chroma_qp_index_offset", json_object_new_int(p->second_chroma_qp_index_offset));
	json_object_object_add(v4l2_ctrl_h264_pps_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_h264_pps_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_ctrl_h264_pps", v4l2_ctrl_h264_pps_obj);
}

void trace_v4l2_ctrl_h264_scaling_matrix_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_h264_scaling_matrix_obj = json_object_new_object();
	struct v4l2_ctrl_h264_scaling_matrix *p = static_cast<struct v4l2_ctrl_h264_scaling_matrix*>(ptr);
	/* __u8 scaling_list_4x4[6][16] */
	json_object *scaling_list_4x4_obj = json_object_new_array();
	for (size_t i = 0; i < 6; i++) {
		for (size_t j = 0; j < 16; j++) {
			json_object_array_add(scaling_list_4x4_obj, json_object_new_int(p->scaling_list_4x4[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_h264_scaling_matrix_obj, "scaling_list_4x4", scaling_list_4x4_obj);

	/* __u8 scaling_list_8x8[6][64] */
	json_object *scaling_list_8x8_obj = json_object_new_array();
	for (size_t i = 0; i < 6; i++) {
		for (size_t j = 0; j < 64; j++) {
			json_object_array_add(scaling_list_8x8_obj, json_object_new_int(p->scaling_list_8x8[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_h264_scaling_matrix_obj, "scaling_list_8x8", scaling_list_8x8_obj);

	json_object_object_add(parent_obj, "v4l2_ctrl_h264_scaling_matrix", v4l2_ctrl_h264_scaling_matrix_obj);
}

void trace_v4l2_h264_weight_factors_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_h264_weight_factors_obj = json_object_new_object();
	struct v4l2_h264_weight_factors *p = static_cast<struct v4l2_h264_weight_factors*>(ptr);
	/* __s16 luma_weight[32] */
	json_object *luma_weight_obj = json_object_new_array();
	for (size_t i = 0; i < 32; i++) {
		json_object_array_add(luma_weight_obj, json_object_new_int(p->luma_weight[i]));
	}
	json_object_object_add(v4l2_h264_weight_factors_obj, "luma_weight", luma_weight_obj);

	/* __s16 luma_offset[32] */
	json_object *luma_offset_obj = json_object_new_array();
	for (size_t i = 0; i < 32; i++) {
		json_object_array_add(luma_offset_obj, json_object_new_int(p->luma_offset[i]));
	}
	json_object_object_add(v4l2_h264_weight_factors_obj, "luma_offset", luma_offset_obj);

	/* __s16 chroma_weight[32][2] */
	json_object *chroma_weight_obj = json_object_new_array();
	for (size_t i = 0; i < 32; i++) {
		for (size_t j = 0; j < 2; j++) {
			json_object_array_add(chroma_weight_obj, json_object_new_int(p->chroma_weight[i][j]));
		}
	}
	json_object_object_add(v4l2_h264_weight_factors_obj, "chroma_weight", chroma_weight_obj);

	/* __s16 chroma_offset[32][2] */
	json_object *chroma_offset_obj = json_object_new_array();
	for (size_t i = 0; i < 32; i++) {
		for (size_t j = 0; j < 2; j++) {
			json_object_array_add(chroma_offset_obj, json_object_new_int(p->chroma_offset[i][j]));
		}
	}
	json_object_object_add(v4l2_h264_weight_factors_obj, "chroma_offset", chroma_offset_obj);

	json_object_object_add(parent_obj, "v4l2_h264_weight_factors", v4l2_h264_weight_factors_obj);
}

void trace_v4l2_ctrl_h264_pred_weights_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_h264_pred_weights_obj = json_object_new_object();
	struct v4l2_ctrl_h264_pred_weights *p = static_cast<struct v4l2_ctrl_h264_pred_weights*>(ptr);
	json_object_object_add(v4l2_ctrl_h264_pred_weights_obj, "luma_log2_weight_denom", json_object_new_int(p->luma_log2_weight_denom));
	json_object_object_add(v4l2_ctrl_h264_pred_weights_obj, "chroma_log2_weight_denom", json_object_new_int(p->chroma_log2_weight_denom));
	/* struct v4l2_h264_weight_factors weight_factors[2] */
	json_object *weight_factors_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		json_object *element_obj = json_object_new_object();
		trace_v4l2_h264_weight_factors_gen(&(p->weight_factors[i]), element_obj);
		json_object *element_no_key_obj;
		json_object_object_get_ex(element_obj, "v4l2_h264_weight_factors", &element_no_key_obj);
		json_object_array_add(weight_factors_obj, element_no_key_obj);
	}
	json_object_object_add(v4l2_ctrl_h264_pred_weights_obj, "weight_factors", weight_factors_obj);

	json_object_object_add(parent_obj, "v4l2_ctrl_h264_pred_weights", v4l2_ctrl_h264_pred_weights_obj);
}

void trace_v4l2_h264_reference_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_h264_reference_obj = json_object_new_object();
	struct v4l2_h264_reference *p = static_cast<struct v4l2_h264_reference*>(ptr);
	json_object_object_add(v4l2_h264_reference_obj, "fields", json_object_new_int(p->fields));
	json_object_object_add(v4l2_h264_reference_obj, "index", json_object_new_int(p->index));
	json_object_object_add(parent_obj, "v4l2_h264_reference", v4l2_h264_reference_obj);
}

void trace_v4l2_ctrl_h264_slice_params_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_h264_slice_params_obj = json_object_new_object();
	struct v4l2_ctrl_h264_slice_params *p = static_cast<struct v4l2_ctrl_h264_slice_params*>(ptr);
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "header_bit_size", json_object_new_int64(p->header_bit_size));
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "first_mb_in_slice", json_object_new_int64(p->first_mb_in_slice));
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "slice_type", json_object_new_int(p->slice_type));
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "colour_plane_id", json_object_new_int(p->colour_plane_id));
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "redundant_pic_cnt", json_object_new_int(p->redundant_pic_cnt));
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "cabac_init_idc", json_object_new_int(p->cabac_init_idc));
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "slice_qp_delta", json_object_new_int(p->slice_qp_delta));
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "slice_qs_delta", json_object_new_int(p->slice_qs_delta));
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "disable_deblocking_filter_idc", json_object_new_int(p->disable_deblocking_filter_idc));
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "slice_alpha_c0_offset_div2", json_object_new_int(p->slice_alpha_c0_offset_div2));
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "slice_beta_offset_div2", json_object_new_int(p->slice_beta_offset_div2));
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "num_ref_idx_l0_active_minus1", json_object_new_int(p->num_ref_idx_l0_active_minus1));
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "num_ref_idx_l1_active_minus1", json_object_new_int(p->num_ref_idx_l1_active_minus1));
	/* struct v4l2_h264_reference ref_pic_list0[V4L2_H264_REF_LIST_LEN] */
	json_object *ref_pic_list0_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_H264_REF_LIST_LEN; i++) {
		json_object *element_obj = json_object_new_object();
		trace_v4l2_h264_reference_gen(&(p->ref_pic_list0[i]), element_obj);
		json_object *element_no_key_obj;
		json_object_object_get_ex(element_obj, "v4l2_h264_reference", &element_no_key_obj);
		json_object_array_add(ref_pic_list0_obj, element_no_key_obj);
	}
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "ref_pic_list0", ref_pic_list0_obj);

	/* struct v4l2_h264_reference ref_pic_list1[V4L2_H264_REF_LIST_LEN] */
	json_object *ref_pic_list1_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_H264_REF_LIST_LEN; i++) {
		json_object *element_obj = json_object_new_object();
		trace_v4l2_h264_reference_gen(&(p->ref_pic_list1[i]), element_obj);
		json_object *element_no_key_obj;
		json_object_object_get_ex(element_obj, "v4l2_h264_reference", &element_no_key_obj);
		json_object_array_add(ref_pic_list1_obj, element_no_key_obj);
	}
	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "ref_pic_list1", ref_pic_list1_obj);

	json_object_object_add(v4l2_ctrl_h264_slice_params_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_h264_slice_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_ctrl_h264_slice_params", v4l2_ctrl_h264_slice_params_obj);
}

void trace_v4l2_h264_dpb_entry_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_h264_dpb_entry_obj = json_object_new_object();
	struct v4l2_h264_dpb_entry *p = static_cast<struct v4l2_h264_dpb_entry*>(ptr);
	json_object_object_add(v4l2_h264_dpb_entry_obj, "reference_ts", json_object_new_uint64(p->reference_ts));
	json_object_object_add(v4l2_h264_dpb_entry_obj, "pic_num", json_object_new_int64(p->pic_num));
	json_object_object_add(v4l2_h264_dpb_entry_obj, "frame_num", json_object_new_int(p->frame_num));
	json_object_object_add(v4l2_h264_dpb_entry_obj, "fields", json_object_new_int(p->fields));
	json_object_object_add(v4l2_h264_dpb_entry_obj, "top_field_order_cnt", json_object_new_int(p->top_field_order_cnt));
	json_object_object_add(v4l2_h264_dpb_entry_obj, "bottom_field_order_cnt", json_object_new_int(p->bottom_field_order_cnt));
	json_object_object_add(v4l2_h264_dpb_entry_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_h264_dpb_entry_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_h264_dpb_entry", v4l2_h264_dpb_entry_obj);
}

void trace_v4l2_ctrl_h264_decode_params_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_h264_decode_params_obj = json_object_new_object();
	struct v4l2_ctrl_h264_decode_params *p = static_cast<struct v4l2_ctrl_h264_decode_params*>(ptr);
	/* struct v4l2_h264_dpb_entry dpb[V4L2_H264_NUM_DPB_ENTRIES] */
	json_object *dpb_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_H264_NUM_DPB_ENTRIES; i++) {
		json_object *element_obj = json_object_new_object();
		trace_v4l2_h264_dpb_entry_gen(&(p->dpb[i]), element_obj);
		json_object *element_no_key_obj;
		json_object_object_get_ex(element_obj, "v4l2_h264_dpb_entry", &element_no_key_obj);
		json_object_array_add(dpb_obj, element_no_key_obj);
	}
	json_object_object_add(v4l2_ctrl_h264_decode_params_obj, "dpb", dpb_obj);

	json_object_object_add(v4l2_ctrl_h264_decode_params_obj, "nal_ref_idc", json_object_new_int(p->nal_ref_idc));
	json_object_object_add(v4l2_ctrl_h264_decode_params_obj, "frame_num", json_object_new_int(p->frame_num));
	json_object_object_add(v4l2_ctrl_h264_decode_params_obj, "top_field_order_cnt", json_object_new_int(p->top_field_order_cnt));
	json_object_object_add(v4l2_ctrl_h264_decode_params_obj, "bottom_field_order_cnt", json_object_new_int(p->bottom_field_order_cnt));
	json_object_object_add(v4l2_ctrl_h264_decode_params_obj, "idr_pic_id", json_object_new_int(p->idr_pic_id));
	json_object_object_add(v4l2_ctrl_h264_decode_params_obj, "pic_order_cnt_lsb", json_object_new_int(p->pic_order_cnt_lsb));
	json_object_object_add(v4l2_ctrl_h264_decode_params_obj, "delta_pic_order_cnt_bottom", json_object_new_int(p->delta_pic_order_cnt_bottom));
	json_object_object_add(v4l2_ctrl_h264_decode_params_obj, "delta_pic_order_cnt0", json_object_new_int(p->delta_pic_order_cnt0));
	json_object_object_add(v4l2_ctrl_h264_decode_params_obj, "delta_pic_order_cnt1", json_object_new_int(p->delta_pic_order_cnt1));
	json_object_object_add(v4l2_ctrl_h264_decode_params_obj, "dec_ref_pic_marking_bit_size", json_object_new_int64(p->dec_ref_pic_marking_bit_size));
	json_object_object_add(v4l2_ctrl_h264_decode_params_obj, "pic_order_cnt_bit_size", json_object_new_int64(p->pic_order_cnt_bit_size));
	json_object_object_add(v4l2_ctrl_h264_decode_params_obj, "slice_group_change_cycle", json_object_new_int64(p->slice_group_change_cycle));
	json_object_object_add(v4l2_ctrl_h264_decode_params_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_h264_decode_param_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_ctrl_h264_decode_params", v4l2_ctrl_h264_decode_params_obj);
}

void trace_v4l2_ctrl_fwht_params_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_fwht_params_obj = json_object_new_object();
	struct v4l2_ctrl_fwht_params *p = static_cast<struct v4l2_ctrl_fwht_params*>(ptr);
	json_object_object_add(v4l2_ctrl_fwht_params_obj, "backward_ref_ts", json_object_new_uint64(p->backward_ref_ts));
	json_object_object_add(v4l2_ctrl_fwht_params_obj, "version", json_object_new_int64(p->version));
	json_object_object_add(v4l2_ctrl_fwht_params_obj, "width", json_object_new_int64(p->width));
	json_object_object_add(v4l2_ctrl_fwht_params_obj, "height", json_object_new_int64(p->height));
	json_object_object_add(v4l2_ctrl_fwht_params_obj, "flags", json_object_new_string(fl2s_fwht(p->flags).c_str()));
	json_object_object_add(v4l2_ctrl_fwht_params_obj, "colorspace", json_object_new_string(val2s(p->colorspace, v4l2_colorspace_val_def).c_str()));
	json_object_object_add(v4l2_ctrl_fwht_params_obj, "xfer_func", json_object_new_string(val2s(p->xfer_func, v4l2_xfer_func_val_def).c_str()));
	json_object_object_add(v4l2_ctrl_fwht_params_obj, "ycbcr_enc", json_object_new_string(val2s(p->ycbcr_enc, v4l2_ycbcr_encoding_val_def).c_str()));
	json_object_object_add(v4l2_ctrl_fwht_params_obj, "quantization", json_object_new_string(val2s(p->quantization, v4l2_quantization_val_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_ctrl_fwht_params", v4l2_ctrl_fwht_params_obj);
}

void trace_v4l2_vp8_segment_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_vp8_segment_obj = json_object_new_object();
	struct v4l2_vp8_segment *p = static_cast<struct v4l2_vp8_segment*>(ptr);
	/* __s8 quant_update[4] */
	json_object *quant_update_obj = json_object_new_array();
	for (size_t i = 0; i < 4; i++) {
		json_object_array_add(quant_update_obj, json_object_new_int(p->quant_update[i]));
	}
	json_object_object_add(v4l2_vp8_segment_obj, "quant_update", quant_update_obj);

	/* __s8 lf_update[4] */
	json_object *lf_update_obj = json_object_new_array();
	for (size_t i = 0; i < 4; i++) {
		json_object_array_add(lf_update_obj, json_object_new_int(p->lf_update[i]));
	}
	json_object_object_add(v4l2_vp8_segment_obj, "lf_update", lf_update_obj);

	/* __u8 segment_probs[3] */
	json_object *segment_probs_obj = json_object_new_array();
	for (size_t i = 0; i < 3; i++) {
		json_object_array_add(segment_probs_obj, json_object_new_int(p->segment_probs[i]));
	}
	json_object_object_add(v4l2_vp8_segment_obj, "segment_probs", segment_probs_obj);

	json_object_object_add(v4l2_vp8_segment_obj, "padding", json_object_new_int(p->padding));
	json_object_object_add(v4l2_vp8_segment_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_vp8_segment_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_vp8_segment", v4l2_vp8_segment_obj);
}

void trace_v4l2_vp8_loop_filter_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_vp8_loop_filter_obj = json_object_new_object();
	struct v4l2_vp8_loop_filter *p = static_cast<struct v4l2_vp8_loop_filter*>(ptr);
	/* __s8 ref_frm_delta[4] */
	json_object *ref_frm_delta_obj = json_object_new_array();
	for (size_t i = 0; i < 4; i++) {
		json_object_array_add(ref_frm_delta_obj, json_object_new_int(p->ref_frm_delta[i]));
	}
	json_object_object_add(v4l2_vp8_loop_filter_obj, "ref_frm_delta", ref_frm_delta_obj);

	/* __s8 mb_mode_delta[4] */
	json_object *mb_mode_delta_obj = json_object_new_array();
	for (size_t i = 0; i < 4; i++) {
		json_object_array_add(mb_mode_delta_obj, json_object_new_int(p->mb_mode_delta[i]));
	}
	json_object_object_add(v4l2_vp8_loop_filter_obj, "mb_mode_delta", mb_mode_delta_obj);

	json_object_object_add(v4l2_vp8_loop_filter_obj, "sharpness_level", json_object_new_int(p->sharpness_level));
	json_object_object_add(v4l2_vp8_loop_filter_obj, "level", json_object_new_int(p->level));
	json_object_object_add(v4l2_vp8_loop_filter_obj, "padding", json_object_new_int(p->padding));
	json_object_object_add(v4l2_vp8_loop_filter_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_vp8_loop_filter_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_vp8_loop_filter", v4l2_vp8_loop_filter_obj);
}

void trace_v4l2_vp8_quantization_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_vp8_quantization_obj = json_object_new_object();
	struct v4l2_vp8_quantization *p = static_cast<struct v4l2_vp8_quantization*>(ptr);
	json_object_object_add(v4l2_vp8_quantization_obj, "y_ac_qi", json_object_new_int(p->y_ac_qi));
	json_object_object_add(v4l2_vp8_quantization_obj, "y_dc_delta", json_object_new_int(p->y_dc_delta));
	json_object_object_add(v4l2_vp8_quantization_obj, "y2_dc_delta", json_object_new_int(p->y2_dc_delta));
	json_object_object_add(v4l2_vp8_quantization_obj, "y2_ac_delta", json_object_new_int(p->y2_ac_delta));
	json_object_object_add(v4l2_vp8_quantization_obj, "uv_dc_delta", json_object_new_int(p->uv_dc_delta));
	json_object_object_add(v4l2_vp8_quantization_obj, "uv_ac_delta", json_object_new_int(p->uv_ac_delta));
	json_object_object_add(v4l2_vp8_quantization_obj, "padding", json_object_new_int(p->padding));
	json_object_object_add(parent_obj, "v4l2_vp8_quantization", v4l2_vp8_quantization_obj);
}

void trace_v4l2_vp8_entropy_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_vp8_entropy_obj = json_object_new_object();
	struct v4l2_vp8_entropy *p = static_cast<struct v4l2_vp8_entropy*>(ptr);
	/* __u8 coeff_probs[4][8][3][V4L2_VP8_COEFF_PROB_CNT] */
	json_object *coeff_probs_obj = json_object_new_array();
	for (size_t i = 0; i < 4; i++) {
		for (size_t j = 0; j < 8; j++) {
			for (size_t k = 0; k < 3; k++) {
				for (size_t l = 0; l < V4L2_VP8_COEFF_PROB_CNT; l++) {
					json_object_array_add(coeff_probs_obj, json_object_new_int(p->coeff_probs[i][j][k][l]));
				}
			}
		}
	}
	json_object_object_add(v4l2_vp8_entropy_obj, "coeff_probs", coeff_probs_obj);

	/* __u8 y_mode_probs[4] */
	json_object *y_mode_probs_obj = json_object_new_array();
	for (size_t i = 0; i < 4; i++) {
		json_object_array_add(y_mode_probs_obj, json_object_new_int(p->y_mode_probs[i]));
	}
	json_object_object_add(v4l2_vp8_entropy_obj, "y_mode_probs", y_mode_probs_obj);

	/* __u8 uv_mode_probs[3] */
	json_object *uv_mode_probs_obj = json_object_new_array();
	for (size_t i = 0; i < 3; i++) {
		json_object_array_add(uv_mode_probs_obj, json_object_new_int(p->uv_mode_probs[i]));
	}
	json_object_object_add(v4l2_vp8_entropy_obj, "uv_mode_probs", uv_mode_probs_obj);

	/* __u8 mv_probs[2][V4L2_VP8_MV_PROB_CNT] */
	json_object *mv_probs_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		for (size_t j = 0; j < V4L2_VP8_MV_PROB_CNT; j++) {
			json_object_array_add(mv_probs_obj, json_object_new_int(p->mv_probs[i][j]));
		}
	}
	json_object_object_add(v4l2_vp8_entropy_obj, "mv_probs", mv_probs_obj);

	/* __u8 padding[3] */
	json_object *padding_obj = json_object_new_array();
	for (size_t i = 0; i < 3; i++) {
		json_object_array_add(padding_obj, json_object_new_int(p->padding[i]));
	}
	json_object_object_add(v4l2_vp8_entropy_obj, "padding", padding_obj);

	json_object_object_add(parent_obj, "v4l2_vp8_entropy", v4l2_vp8_entropy_obj);
}

void trace_v4l2_vp8_entropy_coder_state_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_vp8_entropy_coder_state_obj = json_object_new_object();
	struct v4l2_vp8_entropy_coder_state *p = static_cast<struct v4l2_vp8_entropy_coder_state*>(ptr);
	json_object_object_add(v4l2_vp8_entropy_coder_state_obj, "range", json_object_new_int(p->range));
	json_object_object_add(v4l2_vp8_entropy_coder_state_obj, "value", json_object_new_int(p->value));
	json_object_object_add(v4l2_vp8_entropy_coder_state_obj, "bit_count", json_object_new_int(p->bit_count));
	json_object_object_add(v4l2_vp8_entropy_coder_state_obj, "padding", json_object_new_int(p->padding));
	json_object_object_add(parent_obj, "v4l2_vp8_entropy_coder_state", v4l2_vp8_entropy_coder_state_obj);
}

void trace_v4l2_ctrl_vp8_frame_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_vp8_frame_obj = json_object_new_object();
	struct v4l2_ctrl_vp8_frame *p = static_cast<struct v4l2_ctrl_vp8_frame*>(ptr);
	/* struct v4l2_vp8_segment segment */
	trace_v4l2_vp8_segment_gen(&p->segment, v4l2_ctrl_vp8_frame_obj);
	/* struct v4l2_vp8_loop_filter lf */
	trace_v4l2_vp8_loop_filter_gen(&p->lf, v4l2_ctrl_vp8_frame_obj);
	/* struct v4l2_vp8_quantization quant */
	trace_v4l2_vp8_quantization_gen(&p->quant, v4l2_ctrl_vp8_frame_obj);
	/* struct v4l2_vp8_entropy entropy */
	trace_v4l2_vp8_entropy_gen(&p->entropy, v4l2_ctrl_vp8_frame_obj);
	/* struct v4l2_vp8_entropy_coder_state coder_state */
	trace_v4l2_vp8_entropy_coder_state_gen(&p->coder_state, v4l2_ctrl_vp8_frame_obj);
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "width", json_object_new_int(p->width));
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "height", json_object_new_int(p->height));
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "horizontal_scale", json_object_new_int(p->horizontal_scale));
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "vertical_scale", json_object_new_int(p->vertical_scale));
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "version", json_object_new_int(p->version));
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "prob_skip_false", json_object_new_int(p->prob_skip_false));
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "prob_intra", json_object_new_int(p->prob_intra));
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "prob_last", json_object_new_int(p->prob_last));
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "prob_gf", json_object_new_int(p->prob_gf));
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "num_dct_parts", json_object_new_int(p->num_dct_parts));
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "first_part_size", json_object_new_int64(p->first_part_size));
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "first_part_header_bits", json_object_new_int64(p->first_part_header_bits));
	/* __u32 dct_part_sizes[8] */
	json_object *dct_part_sizes_obj = json_object_new_array();
	for (size_t i = 0; i < 8; i++) {
		json_object_array_add(dct_part_sizes_obj, json_object_new_int64(p->dct_part_sizes[i]));
	}
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "dct_part_sizes", dct_part_sizes_obj);

	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "last_frame_ts", json_object_new_uint64(p->last_frame_ts));
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "golden_frame_ts", json_object_new_uint64(p->golden_frame_ts));
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "alt_frame_ts", json_object_new_uint64(p->alt_frame_ts));
	json_object_object_add(v4l2_ctrl_vp8_frame_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_vp8_frame_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_ctrl_vp8_frame", v4l2_ctrl_vp8_frame_obj);
}

void trace_v4l2_ctrl_mpeg2_sequence_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_mpeg2_sequence_obj = json_object_new_object();
	struct v4l2_ctrl_mpeg2_sequence *p = static_cast<struct v4l2_ctrl_mpeg2_sequence*>(ptr);
	json_object_object_add(v4l2_ctrl_mpeg2_sequence_obj, "horizontal_size", json_object_new_int(p->horizontal_size));
	json_object_object_add(v4l2_ctrl_mpeg2_sequence_obj, "vertical_size", json_object_new_int(p->vertical_size));
	json_object_object_add(v4l2_ctrl_mpeg2_sequence_obj, "vbv_buffer_size", json_object_new_int64(p->vbv_buffer_size));
	json_object_object_add(v4l2_ctrl_mpeg2_sequence_obj, "profile_and_level_indication", json_object_new_int(p->profile_and_level_indication));
	json_object_object_add(v4l2_ctrl_mpeg2_sequence_obj, "chroma_format", json_object_new_int(p->chroma_format));
	json_object_object_add(v4l2_ctrl_mpeg2_sequence_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_mpeg2_seq_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_ctrl_mpeg2_sequence", v4l2_ctrl_mpeg2_sequence_obj);
}

void trace_v4l2_ctrl_mpeg2_picture_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_mpeg2_picture_obj = json_object_new_object();
	struct v4l2_ctrl_mpeg2_picture *p = static_cast<struct v4l2_ctrl_mpeg2_picture*>(ptr);
	json_object_object_add(v4l2_ctrl_mpeg2_picture_obj, "backward_ref_ts", json_object_new_uint64(p->backward_ref_ts));
	json_object_object_add(v4l2_ctrl_mpeg2_picture_obj, "forward_ref_ts", json_object_new_uint64(p->forward_ref_ts));
	json_object_object_add(v4l2_ctrl_mpeg2_picture_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_mpeg2_pic_flag_def).c_str()));
	/* __u8	f_code[2][2] */
	json_object *f_code_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		for (size_t j = 0; j < 2; j++) {
			json_object_array_add(f_code_obj, json_object_new_int(p->f_code[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_mpeg2_picture_obj, "f_code", f_code_obj);

	json_object_object_add(v4l2_ctrl_mpeg2_picture_obj, "picture_coding_type", json_object_new_int(p->picture_coding_type));
	json_object_object_add(v4l2_ctrl_mpeg2_picture_obj, "picture_structure", json_object_new_int(p->picture_structure));
	json_object_object_add(v4l2_ctrl_mpeg2_picture_obj, "intra_dc_precision", json_object_new_int(p->intra_dc_precision));
	json_object_object_add(parent_obj, "v4l2_ctrl_mpeg2_picture", v4l2_ctrl_mpeg2_picture_obj);
}

void trace_v4l2_ctrl_mpeg2_quantisation_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_mpeg2_quantisation_obj = json_object_new_object();
	struct v4l2_ctrl_mpeg2_quantisation *p = static_cast<struct v4l2_ctrl_mpeg2_quantisation*>(ptr);
	/* __u8	intra_quantiser_matrix[64] */
	json_object *intra_quantiser_matrix_obj = json_object_new_array();
	for (size_t i = 0; i < 64; i++) {
		json_object_array_add(intra_quantiser_matrix_obj, json_object_new_int(p->intra_quantiser_matrix[i]));
	}
	json_object_object_add(v4l2_ctrl_mpeg2_quantisation_obj, "intra_quantiser_matrix", intra_quantiser_matrix_obj);

	/* __u8	non_intra_quantiser_matrix[64] */
	json_object *non_intra_quantiser_matrix_obj = json_object_new_array();
	for (size_t i = 0; i < 64; i++) {
		json_object_array_add(non_intra_quantiser_matrix_obj, json_object_new_int(p->non_intra_quantiser_matrix[i]));
	}
	json_object_object_add(v4l2_ctrl_mpeg2_quantisation_obj, "non_intra_quantiser_matrix", non_intra_quantiser_matrix_obj);

	/* __u8	chroma_intra_quantiser_matrix[64] */
	json_object *chroma_intra_quantiser_matrix_obj = json_object_new_array();
	for (size_t i = 0; i < 64; i++) {
		json_object_array_add(chroma_intra_quantiser_matrix_obj, json_object_new_int(p->chroma_intra_quantiser_matrix[i]));
	}
	json_object_object_add(v4l2_ctrl_mpeg2_quantisation_obj, "chroma_intra_quantiser_matrix", chroma_intra_quantiser_matrix_obj);

	/* __u8	chroma_non_intra_quantiser_matrix[64] */
	json_object *chroma_non_intra_quantiser_matrix_obj = json_object_new_array();
	for (size_t i = 0; i < 64; i++) {
		json_object_array_add(chroma_non_intra_quantiser_matrix_obj, json_object_new_int(p->chroma_non_intra_quantiser_matrix[i]));
	}
	json_object_object_add(v4l2_ctrl_mpeg2_quantisation_obj, "chroma_non_intra_quantiser_matrix", chroma_non_intra_quantiser_matrix_obj);

	json_object_object_add(parent_obj, "v4l2_ctrl_mpeg2_quantisation", v4l2_ctrl_mpeg2_quantisation_obj);
}

void trace_v4l2_ctrl_hevc_sps_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_hevc_sps_obj = json_object_new_object();
	struct v4l2_ctrl_hevc_sps *p = static_cast<struct v4l2_ctrl_hevc_sps*>(ptr);
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "video_parameter_set_id", json_object_new_int(p->video_parameter_set_id));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "seq_parameter_set_id", json_object_new_int(p->seq_parameter_set_id));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "pic_width_in_luma_samples", json_object_new_int(p->pic_width_in_luma_samples));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "pic_height_in_luma_samples", json_object_new_int(p->pic_height_in_luma_samples));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "bit_depth_luma_minus8", json_object_new_int(p->bit_depth_luma_minus8));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "bit_depth_chroma_minus8", json_object_new_int(p->bit_depth_chroma_minus8));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "log2_max_pic_order_cnt_lsb_minus4", json_object_new_int(p->log2_max_pic_order_cnt_lsb_minus4));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "sps_max_dec_pic_buffering_minus1", json_object_new_int(p->sps_max_dec_pic_buffering_minus1));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "sps_max_num_reorder_pics", json_object_new_int(p->sps_max_num_reorder_pics));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "sps_max_latency_increase_plus1", json_object_new_int(p->sps_max_latency_increase_plus1));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "log2_min_luma_coding_block_size_minus3", json_object_new_int(p->log2_min_luma_coding_block_size_minus3));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "log2_diff_max_min_luma_coding_block_size", json_object_new_int(p->log2_diff_max_min_luma_coding_block_size));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "log2_min_luma_transform_block_size_minus2", json_object_new_int(p->log2_min_luma_transform_block_size_minus2));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "log2_diff_max_min_luma_transform_block_size", json_object_new_int(p->log2_diff_max_min_luma_transform_block_size));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "max_transform_hierarchy_depth_inter", json_object_new_int(p->max_transform_hierarchy_depth_inter));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "max_transform_hierarchy_depth_intra", json_object_new_int(p->max_transform_hierarchy_depth_intra));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "pcm_sample_bit_depth_luma_minus1", json_object_new_int(p->pcm_sample_bit_depth_luma_minus1));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "pcm_sample_bit_depth_chroma_minus1", json_object_new_int(p->pcm_sample_bit_depth_chroma_minus1));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "log2_min_pcm_luma_coding_block_size_minus3", json_object_new_int(p->log2_min_pcm_luma_coding_block_size_minus3));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "log2_diff_max_min_pcm_luma_coding_block_size", json_object_new_int(p->log2_diff_max_min_pcm_luma_coding_block_size));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "num_short_term_ref_pic_sets", json_object_new_int(p->num_short_term_ref_pic_sets));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "num_long_term_ref_pics_sps", json_object_new_int(p->num_long_term_ref_pics_sps));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "chroma_format_idc", json_object_new_int(p->chroma_format_idc));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "sps_max_sub_layers_minus1", json_object_new_int(p->sps_max_sub_layers_minus1));
	json_object_object_add(v4l2_ctrl_hevc_sps_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_hevc_sps_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_ctrl_hevc_sps", v4l2_ctrl_hevc_sps_obj);
}

void trace_v4l2_ctrl_hevc_pps_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_hevc_pps_obj = json_object_new_object();
	struct v4l2_ctrl_hevc_pps *p = static_cast<struct v4l2_ctrl_hevc_pps*>(ptr);
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "pic_parameter_set_id", json_object_new_int(p->pic_parameter_set_id));
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "num_extra_slice_header_bits", json_object_new_int(p->num_extra_slice_header_bits));
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "num_ref_idx_l0_default_active_minus1", json_object_new_int(p->num_ref_idx_l0_default_active_minus1));
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "num_ref_idx_l1_default_active_minus1", json_object_new_int(p->num_ref_idx_l1_default_active_minus1));
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "init_qp_minus26", json_object_new_int(p->init_qp_minus26));
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "diff_cu_qp_delta_depth", json_object_new_int(p->diff_cu_qp_delta_depth));
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "pps_cb_qp_offset", json_object_new_int(p->pps_cb_qp_offset));
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "pps_cr_qp_offset", json_object_new_int(p->pps_cr_qp_offset));
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "num_tile_columns_minus1", json_object_new_int(p->num_tile_columns_minus1));
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "num_tile_rows_minus1", json_object_new_int(p->num_tile_rows_minus1));
	/* __u8	column_width_minus1[20] */
	json_object *column_width_minus1_obj = json_object_new_array();
	for (size_t i = 0; i < 20; i++) {
		json_object_array_add(column_width_minus1_obj, json_object_new_int(p->column_width_minus1[i]));
	}
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "column_width_minus1", column_width_minus1_obj);

	/* __u8	row_height_minus1[22] */
	json_object *row_height_minus1_obj = json_object_new_array();
	for (size_t i = 0; i < 22; i++) {
		json_object_array_add(row_height_minus1_obj, json_object_new_int(p->row_height_minus1[i]));
	}
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "row_height_minus1", row_height_minus1_obj);

	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "pps_beta_offset_div2", json_object_new_int(p->pps_beta_offset_div2));
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "pps_tc_offset_div2", json_object_new_int(p->pps_tc_offset_div2));
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "log2_parallel_merge_level_minus2", json_object_new_int(p->log2_parallel_merge_level_minus2));
	json_object_object_add(v4l2_ctrl_hevc_pps_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_hevc_pps_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_ctrl_hevc_pps", v4l2_ctrl_hevc_pps_obj);
}

void trace_v4l2_hevc_dpb_entry_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_hevc_dpb_entry_obj = json_object_new_object();
	struct v4l2_hevc_dpb_entry *p = static_cast<struct v4l2_hevc_dpb_entry*>(ptr);
	json_object_object_add(v4l2_hevc_dpb_entry_obj, "timestamp", json_object_new_uint64(p->timestamp));
	json_object_object_add(v4l2_hevc_dpb_entry_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_hevc_pps_flag_def).c_str()));
	json_object_object_add(v4l2_hevc_dpb_entry_obj, "field_pic", json_object_new_int(p->field_pic));
	json_object_object_add(v4l2_hevc_dpb_entry_obj, "pic_order_cnt_val", json_object_new_int(p->pic_order_cnt_val));
	json_object_object_add(parent_obj, "v4l2_hevc_dpb_entry", v4l2_hevc_dpb_entry_obj);
}

void trace_v4l2_hevc_pred_weight_table_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_hevc_pred_weight_table_obj = json_object_new_object();
	struct v4l2_hevc_pred_weight_table *p = static_cast<struct v4l2_hevc_pred_weight_table*>(ptr);
	/* __s8	delta_luma_weight_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *delta_luma_weight_l0_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
		json_object_array_add(delta_luma_weight_l0_obj, json_object_new_int(p->delta_luma_weight_l0[i]));
	}
	json_object_object_add(v4l2_hevc_pred_weight_table_obj, "delta_luma_weight_l0", delta_luma_weight_l0_obj);

	/* __s8	luma_offset_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *luma_offset_l0_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
		json_object_array_add(luma_offset_l0_obj, json_object_new_int(p->luma_offset_l0[i]));
	}
	json_object_object_add(v4l2_hevc_pred_weight_table_obj, "luma_offset_l0", luma_offset_l0_obj);

	/* __s8	delta_chroma_weight_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX][2] */
	json_object *delta_chroma_weight_l0_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
		for (size_t j = 0; j < 2; j++) {
			json_object_array_add(delta_chroma_weight_l0_obj, json_object_new_int(p->delta_chroma_weight_l0[i][j]));
		}
	}
	json_object_object_add(v4l2_hevc_pred_weight_table_obj, "delta_chroma_weight_l0", delta_chroma_weight_l0_obj);

	/* __s8	chroma_offset_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX][2] */
	json_object *chroma_offset_l0_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
		for (size_t j = 0; j < 2; j++) {
			json_object_array_add(chroma_offset_l0_obj, json_object_new_int(p->chroma_offset_l0[i][j]));
		}
	}
	json_object_object_add(v4l2_hevc_pred_weight_table_obj, "chroma_offset_l0", chroma_offset_l0_obj);

	/* __s8	delta_luma_weight_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *delta_luma_weight_l1_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
		json_object_array_add(delta_luma_weight_l1_obj, json_object_new_int(p->delta_luma_weight_l1[i]));
	}
	json_object_object_add(v4l2_hevc_pred_weight_table_obj, "delta_luma_weight_l1", delta_luma_weight_l1_obj);

	/* __s8	luma_offset_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *luma_offset_l1_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
		json_object_array_add(luma_offset_l1_obj, json_object_new_int(p->luma_offset_l1[i]));
	}
	json_object_object_add(v4l2_hevc_pred_weight_table_obj, "luma_offset_l1", luma_offset_l1_obj);

	/* __s8	delta_chroma_weight_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX][2] */
	json_object *delta_chroma_weight_l1_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
		for (size_t j = 0; j < 2; j++) {
			json_object_array_add(delta_chroma_weight_l1_obj, json_object_new_int(p->delta_chroma_weight_l1[i][j]));
		}
	}
	json_object_object_add(v4l2_hevc_pred_weight_table_obj, "delta_chroma_weight_l1", delta_chroma_weight_l1_obj);

	/* __s8	chroma_offset_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX][2] */
	json_object *chroma_offset_l1_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
		for (size_t j = 0; j < 2; j++) {
			json_object_array_add(chroma_offset_l1_obj, json_object_new_int(p->chroma_offset_l1[i][j]));
		}
	}
	json_object_object_add(v4l2_hevc_pred_weight_table_obj, "chroma_offset_l1", chroma_offset_l1_obj);

	json_object_object_add(v4l2_hevc_pred_weight_table_obj, "luma_log2_weight_denom", json_object_new_int(p->luma_log2_weight_denom));
	json_object_object_add(v4l2_hevc_pred_weight_table_obj, "delta_chroma_log2_weight_denom", json_object_new_int(p->delta_chroma_log2_weight_denom));
	json_object_object_add(parent_obj, "v4l2_hevc_pred_weight_table", v4l2_hevc_pred_weight_table_obj);
}

void trace_v4l2_ctrl_hevc_slice_params_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_hevc_slice_params_obj = json_object_new_object();
	struct v4l2_ctrl_hevc_slice_params *p = static_cast<struct v4l2_ctrl_hevc_slice_params*>(ptr);
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "bit_size", json_object_new_int64(p->bit_size));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "data_byte_offset", json_object_new_int64(p->data_byte_offset));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "num_entry_point_offsets", json_object_new_int64(p->num_entry_point_offsets));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "nal_unit_type", json_object_new_int(p->nal_unit_type));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "nuh_temporal_id_plus1", json_object_new_int(p->nuh_temporal_id_plus1));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "slice_type", json_object_new_int(p->slice_type));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "colour_plane_id", json_object_new_int(p->colour_plane_id));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "slice_pic_order_cnt", json_object_new_int(p->slice_pic_order_cnt));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "num_ref_idx_l0_active_minus1", json_object_new_int(p->num_ref_idx_l0_active_minus1));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "num_ref_idx_l1_active_minus1", json_object_new_int(p->num_ref_idx_l1_active_minus1));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "collocated_ref_idx", json_object_new_int(p->collocated_ref_idx));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "five_minus_max_num_merge_cand", json_object_new_int(p->five_minus_max_num_merge_cand));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "slice_qp_delta", json_object_new_int(p->slice_qp_delta));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "slice_cb_qp_offset", json_object_new_int(p->slice_cb_qp_offset));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "slice_cr_qp_offset", json_object_new_int(p->slice_cr_qp_offset));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "slice_act_y_qp_offset", json_object_new_int(p->slice_act_y_qp_offset));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "slice_act_cb_qp_offset", json_object_new_int(p->slice_act_cb_qp_offset));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "slice_act_cr_qp_offset", json_object_new_int(p->slice_act_cr_qp_offset));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "slice_beta_offset_div2", json_object_new_int(p->slice_beta_offset_div2));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "slice_tc_offset_div2", json_object_new_int(p->slice_tc_offset_div2));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "pic_struct", json_object_new_int(p->pic_struct));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "slice_segment_addr", json_object_new_int64(p->slice_segment_addr));
	/* __u8	ref_idx_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *ref_idx_l0_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
		json_object_array_add(ref_idx_l0_obj, json_object_new_int(p->ref_idx_l0[i]));
	}
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "ref_idx_l0", ref_idx_l0_obj);

	/* __u8	ref_idx_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *ref_idx_l1_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
		json_object_array_add(ref_idx_l1_obj, json_object_new_int(p->ref_idx_l1[i]));
	}
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "ref_idx_l1", ref_idx_l1_obj);

	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "short_term_ref_pic_set_size", json_object_new_int(p->short_term_ref_pic_set_size));
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "long_term_ref_pic_set_size", json_object_new_int(p->long_term_ref_pic_set_size));
	/* struct v4l2_hevc_pred_weight_table pred_weight_table */
	trace_v4l2_hevc_pred_weight_table_gen(&p->pred_weight_table, v4l2_ctrl_hevc_slice_params_obj);
	json_object_object_add(v4l2_ctrl_hevc_slice_params_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_hevc_slice_params_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_ctrl_hevc_slice_params", v4l2_ctrl_hevc_slice_params_obj);
}

void trace_v4l2_ctrl_hevc_decode_params_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_hevc_decode_params_obj = json_object_new_object();
	struct v4l2_ctrl_hevc_decode_params *p = static_cast<struct v4l2_ctrl_hevc_decode_params*>(ptr);
	json_object_object_add(v4l2_ctrl_hevc_decode_params_obj, "pic_order_cnt_val", json_object_new_int(p->pic_order_cnt_val));
	json_object_object_add(v4l2_ctrl_hevc_decode_params_obj, "short_term_ref_pic_set_size", json_object_new_int(p->short_term_ref_pic_set_size));
	json_object_object_add(v4l2_ctrl_hevc_decode_params_obj, "long_term_ref_pic_set_size", json_object_new_int(p->long_term_ref_pic_set_size));
	json_object_object_add(v4l2_ctrl_hevc_decode_params_obj, "num_active_dpb_entries", json_object_new_int(p->num_active_dpb_entries));
	json_object_object_add(v4l2_ctrl_hevc_decode_params_obj, "num_poc_st_curr_before", json_object_new_int(p->num_poc_st_curr_before));
	json_object_object_add(v4l2_ctrl_hevc_decode_params_obj, "num_poc_st_curr_after", json_object_new_int(p->num_poc_st_curr_after));
	json_object_object_add(v4l2_ctrl_hevc_decode_params_obj, "num_poc_lt_curr", json_object_new_int(p->num_poc_lt_curr));
	/* __u8	poc_st_curr_before[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *poc_st_curr_before_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
		json_object_array_add(poc_st_curr_before_obj, json_object_new_int(p->poc_st_curr_before[i]));
	}
	json_object_object_add(v4l2_ctrl_hevc_decode_params_obj, "poc_st_curr_before", poc_st_curr_before_obj);

	/* __u8	poc_st_curr_after[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *poc_st_curr_after_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
		json_object_array_add(poc_st_curr_after_obj, json_object_new_int(p->poc_st_curr_after[i]));
	}
	json_object_object_add(v4l2_ctrl_hevc_decode_params_obj, "poc_st_curr_after", poc_st_curr_after_obj);

	/* __u8	poc_lt_curr[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *poc_lt_curr_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
		json_object_array_add(poc_lt_curr_obj, json_object_new_int(p->poc_lt_curr[i]));
	}
	json_object_object_add(v4l2_ctrl_hevc_decode_params_obj, "poc_lt_curr", poc_lt_curr_obj);

	json_object_object_add(v4l2_ctrl_hevc_decode_params_obj, "num_delta_pocs_of_ref_rps_idx", json_object_new_int(p->num_delta_pocs_of_ref_rps_idx));
	/* struct	v4l2_hevc_dpb_entry dpb[V4L2_HEVC_DPB_ENTRIES_NUM_MAX] */
	json_object *dpb_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_HEVC_DPB_ENTRIES_NUM_MAX; i++) {
		json_object *element_obj = json_object_new_object();
		trace_v4l2_hevc_dpb_entry_gen(&(p->dpb[i]), element_obj);
		json_object *element_no_key_obj;
		json_object_object_get_ex(element_obj, "v4l2_hevc_dpb_entry", &element_no_key_obj);
		json_object_array_add(dpb_obj, element_no_key_obj);
	}
	json_object_object_add(v4l2_ctrl_hevc_decode_params_obj, "dpb", dpb_obj);

	json_object_object_add(v4l2_ctrl_hevc_decode_params_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_hevc_decode_param_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_ctrl_hevc_decode_params", v4l2_ctrl_hevc_decode_params_obj);
}

void trace_v4l2_ctrl_hevc_scaling_matrix_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_hevc_scaling_matrix_obj = json_object_new_object();
	struct v4l2_ctrl_hevc_scaling_matrix *p = static_cast<struct v4l2_ctrl_hevc_scaling_matrix*>(ptr);
	/* __u8	scaling_list_4x4[6][16] */
	json_object *scaling_list_4x4_obj = json_object_new_array();
	for (size_t i = 0; i < 6; i++) {
		for (size_t j = 0; j < 16; j++) {
			json_object_array_add(scaling_list_4x4_obj, json_object_new_int(p->scaling_list_4x4[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_hevc_scaling_matrix_obj, "scaling_list_4x4", scaling_list_4x4_obj);

	/* __u8	scaling_list_8x8[6][64] */
	json_object *scaling_list_8x8_obj = json_object_new_array();
	for (size_t i = 0; i < 6; i++) {
		for (size_t j = 0; j < 64; j++) {
			json_object_array_add(scaling_list_8x8_obj, json_object_new_int(p->scaling_list_8x8[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_hevc_scaling_matrix_obj, "scaling_list_8x8", scaling_list_8x8_obj);

	/* __u8	scaling_list_16x16[6][64] */
	json_object *scaling_list_16x16_obj = json_object_new_array();
	for (size_t i = 0; i < 6; i++) {
		for (size_t j = 0; j < 64; j++) {
			json_object_array_add(scaling_list_16x16_obj, json_object_new_int(p->scaling_list_16x16[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_hevc_scaling_matrix_obj, "scaling_list_16x16", scaling_list_16x16_obj);

	/* __u8	scaling_list_32x32[2][64] */
	json_object *scaling_list_32x32_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		for (size_t j = 0; j < 64; j++) {
			json_object_array_add(scaling_list_32x32_obj, json_object_new_int(p->scaling_list_32x32[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_hevc_scaling_matrix_obj, "scaling_list_32x32", scaling_list_32x32_obj);

	/* __u8	scaling_list_dc_coef_16x16[6] */
	json_object *scaling_list_dc_coef_16x16_obj = json_object_new_array();
	for (size_t i = 0; i < 6; i++) {
		json_object_array_add(scaling_list_dc_coef_16x16_obj, json_object_new_int(p->scaling_list_dc_coef_16x16[i]));
	}
	json_object_object_add(v4l2_ctrl_hevc_scaling_matrix_obj, "scaling_list_dc_coef_16x16", scaling_list_dc_coef_16x16_obj);

	/* __u8	scaling_list_dc_coef_32x32[2] */
	json_object *scaling_list_dc_coef_32x32_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		json_object_array_add(scaling_list_dc_coef_32x32_obj, json_object_new_int(p->scaling_list_dc_coef_32x32[i]));
	}
	json_object_object_add(v4l2_ctrl_hevc_scaling_matrix_obj, "scaling_list_dc_coef_32x32", scaling_list_dc_coef_32x32_obj);

	json_object_object_add(parent_obj, "v4l2_ctrl_hevc_scaling_matrix", v4l2_ctrl_hevc_scaling_matrix_obj);
}

void trace_v4l2_vp9_loop_filter_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_vp9_loop_filter_obj = json_object_new_object();
	struct v4l2_vp9_loop_filter *p = static_cast<struct v4l2_vp9_loop_filter*>(ptr);
	/* __s8 ref_deltas[4] */
	json_object *ref_deltas_obj = json_object_new_array();
	for (size_t i = 0; i < 4; i++) {
		json_object_array_add(ref_deltas_obj, json_object_new_int(p->ref_deltas[i]));
	}
	json_object_object_add(v4l2_vp9_loop_filter_obj, "ref_deltas", ref_deltas_obj);

	/* __s8 mode_deltas[2] */
	json_object *mode_deltas_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		json_object_array_add(mode_deltas_obj, json_object_new_int(p->mode_deltas[i]));
	}
	json_object_object_add(v4l2_vp9_loop_filter_obj, "mode_deltas", mode_deltas_obj);

	json_object_object_add(v4l2_vp9_loop_filter_obj, "level", json_object_new_int(p->level));
	json_object_object_add(v4l2_vp9_loop_filter_obj, "sharpness", json_object_new_int(p->sharpness));
	json_object_object_add(v4l2_vp9_loop_filter_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_vp9_loop_filter_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_vp9_loop_filter", v4l2_vp9_loop_filter_obj);
}

void trace_v4l2_vp9_quantization_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_vp9_quantization_obj = json_object_new_object();
	struct v4l2_vp9_quantization *p = static_cast<struct v4l2_vp9_quantization*>(ptr);
	json_object_object_add(v4l2_vp9_quantization_obj, "base_q_idx", json_object_new_int(p->base_q_idx));
	json_object_object_add(v4l2_vp9_quantization_obj, "delta_q_y_dc", json_object_new_int(p->delta_q_y_dc));
	json_object_object_add(v4l2_vp9_quantization_obj, "delta_q_uv_dc", json_object_new_int(p->delta_q_uv_dc));
	json_object_object_add(v4l2_vp9_quantization_obj, "delta_q_uv_ac", json_object_new_int(p->delta_q_uv_ac));
	json_object_object_add(parent_obj, "v4l2_vp9_quantization", v4l2_vp9_quantization_obj);
}

void trace_v4l2_vp9_segmentation_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_vp9_segmentation_obj = json_object_new_object();
	struct v4l2_vp9_segmentation *p = static_cast<struct v4l2_vp9_segmentation*>(ptr);
	/* __s16 feature_data[8][4] */
	json_object *feature_data_obj = json_object_new_array();
	for (size_t i = 0; i < 8; i++) {
		for (size_t j = 0; j < 4; j++) {
			json_object_array_add(feature_data_obj, json_object_new_int(p->feature_data[i][j]));
		}
	}
	json_object_object_add(v4l2_vp9_segmentation_obj, "feature_data", feature_data_obj);

	/* __u8 feature_enabled[8] */
	json_object *feature_enabled_obj = json_object_new_array();
	for (size_t i = 0; i < 8; i++) {
		json_object_array_add(feature_enabled_obj, json_object_new_int(p->feature_enabled[i]));
	}
	json_object_object_add(v4l2_vp9_segmentation_obj, "feature_enabled", feature_enabled_obj);

	/* __u8 tree_probs[7] */
	json_object *tree_probs_obj = json_object_new_array();
	for (size_t i = 0; i < 7; i++) {
		json_object_array_add(tree_probs_obj, json_object_new_int(p->tree_probs[i]));
	}
	json_object_object_add(v4l2_vp9_segmentation_obj, "tree_probs", tree_probs_obj);

	/* __u8 pred_probs[3] */
	json_object *pred_probs_obj = json_object_new_array();
	for (size_t i = 0; i < 3; i++) {
		json_object_array_add(pred_probs_obj, json_object_new_int(p->pred_probs[i]));
	}
	json_object_object_add(v4l2_vp9_segmentation_obj, "pred_probs", pred_probs_obj);

	json_object_object_add(v4l2_vp9_segmentation_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_vp9_segmentation_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_vp9_segmentation", v4l2_vp9_segmentation_obj);
}

void trace_v4l2_ctrl_vp9_frame_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_vp9_frame_obj = json_object_new_object();
	struct v4l2_ctrl_vp9_frame *p = static_cast<struct v4l2_ctrl_vp9_frame*>(ptr);
	/* struct v4l2_vp9_loop_filter lf */
	trace_v4l2_vp9_loop_filter_gen(&p->lf, v4l2_ctrl_vp9_frame_obj);
	/* struct v4l2_vp9_quantization quant */
	trace_v4l2_vp9_quantization_gen(&p->quant, v4l2_ctrl_vp9_frame_obj);
	/* struct v4l2_vp9_segmentation seg */
	trace_v4l2_vp9_segmentation_gen(&p->seg, v4l2_ctrl_vp9_frame_obj);
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_vp9_frame_flag_def).c_str()));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "compressed_header_size", json_object_new_int(p->compressed_header_size));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "uncompressed_header_size", json_object_new_int(p->uncompressed_header_size));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "frame_width_minus_1", json_object_new_int(p->frame_width_minus_1));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "frame_height_minus_1", json_object_new_int(p->frame_height_minus_1));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "render_width_minus_1", json_object_new_int(p->render_width_minus_1));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "render_height_minus_1", json_object_new_int(p->render_height_minus_1));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "last_frame_ts", json_object_new_uint64(p->last_frame_ts));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "golden_frame_ts", json_object_new_uint64(p->golden_frame_ts));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "alt_frame_ts", json_object_new_uint64(p->alt_frame_ts));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "ref_frame_sign_bias", json_object_new_int(p->ref_frame_sign_bias));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "reset_frame_context", json_object_new_int(p->reset_frame_context));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "frame_context_idx", json_object_new_int(p->frame_context_idx));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "profile", json_object_new_int(p->profile));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "bit_depth", json_object_new_int(p->bit_depth));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "interpolation_filter", json_object_new_int(p->interpolation_filter));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "tile_cols_log2", json_object_new_int(p->tile_cols_log2));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "tile_rows_log2", json_object_new_int(p->tile_rows_log2));
	json_object_object_add(v4l2_ctrl_vp9_frame_obj, "reference_mode", json_object_new_int(p->reference_mode));
	json_object_object_add(parent_obj, "v4l2_ctrl_vp9_frame", v4l2_ctrl_vp9_frame_obj);
}

void trace_v4l2_vp9_mv_probs_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_vp9_mv_probs_obj = json_object_new_object();
	struct v4l2_vp9_mv_probs *p = static_cast<struct v4l2_vp9_mv_probs*>(ptr);
	/* __u8 joint[3] */
	json_object *joint_obj = json_object_new_array();
	for (size_t i = 0; i < 3; i++) {
		json_object_array_add(joint_obj, json_object_new_int(p->joint[i]));
	}
	json_object_object_add(v4l2_vp9_mv_probs_obj, "joint", joint_obj);

	/* __u8 sign[2] */
	json_object *sign_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		json_object_array_add(sign_obj, json_object_new_int(p->sign[i]));
	}
	json_object_object_add(v4l2_vp9_mv_probs_obj, "sign", sign_obj);

	/* __u8 classes[2][10] */
	json_object *classes_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		for (size_t j = 0; j < 10; j++) {
			json_object_array_add(classes_obj, json_object_new_int(p->classes[i][j]));
		}
	}
	json_object_object_add(v4l2_vp9_mv_probs_obj, "classes", classes_obj);

	/* __u8 class0_bit[2] */
	json_object *class0_bit_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		json_object_array_add(class0_bit_obj, json_object_new_int(p->class0_bit[i]));
	}
	json_object_object_add(v4l2_vp9_mv_probs_obj, "class0_bit", class0_bit_obj);

	/* __u8 bits[2][10] */
	json_object *bits_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		for (size_t j = 0; j < 10; j++) {
			json_object_array_add(bits_obj, json_object_new_int(p->bits[i][j]));
		}
	}
	json_object_object_add(v4l2_vp9_mv_probs_obj, "bits", bits_obj);

	/* __u8 class0_fr[2][2][3] */
	json_object *class0_fr_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		for (size_t j = 0; j < 2; j++) {
			for (size_t k = 0; k < 3; k++) {
				json_object_array_add(class0_fr_obj, json_object_new_int(p->class0_fr[i][j][k]));
			}
		}
	}
	json_object_object_add(v4l2_vp9_mv_probs_obj, "class0_fr", class0_fr_obj);

	/* __u8 fr[2][3] */
	json_object *fr_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		for (size_t j = 0; j < 3; j++) {
			json_object_array_add(fr_obj, json_object_new_int(p->fr[i][j]));
		}
	}
	json_object_object_add(v4l2_vp9_mv_probs_obj, "fr", fr_obj);

	/* __u8 class0_hp[2] */
	json_object *class0_hp_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		json_object_array_add(class0_hp_obj, json_object_new_int(p->class0_hp[i]));
	}
	json_object_object_add(v4l2_vp9_mv_probs_obj, "class0_hp", class0_hp_obj);

	/* __u8 hp[2] */
	json_object *hp_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		json_object_array_add(hp_obj, json_object_new_int(p->hp[i]));
	}
	json_object_object_add(v4l2_vp9_mv_probs_obj, "hp", hp_obj);

	json_object_object_add(parent_obj, "v4l2_vp9_mv_probs", v4l2_vp9_mv_probs_obj);
}

void trace_v4l2_ctrl_vp9_compressed_hdr_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_vp9_compressed_hdr_obj = json_object_new_object();
	struct v4l2_ctrl_vp9_compressed_hdr *p = static_cast<struct v4l2_ctrl_vp9_compressed_hdr*>(ptr);
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "tx_mode", json_object_new_int(p->tx_mode));
	/* __u8 tx8[2][1] */
	json_object *tx8_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		for (size_t j = 0; j < 1; j++) {
			json_object_array_add(tx8_obj, json_object_new_int(p->tx8[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "tx8", tx8_obj);

	/* __u8 tx16[2][2] */
	json_object *tx16_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		for (size_t j = 0; j < 2; j++) {
			json_object_array_add(tx16_obj, json_object_new_int(p->tx16[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "tx16", tx16_obj);

	/* __u8 tx32[2][3] */
	json_object *tx32_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		for (size_t j = 0; j < 3; j++) {
			json_object_array_add(tx32_obj, json_object_new_int(p->tx32[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "tx32", tx32_obj);

	/* __u8 coef[4][2][2][6][6][3] */
	json_object *coef_obj = json_object_new_array();
	for (size_t i = 0; i < 4; i++) {
		for (size_t j = 0; j < 2; j++) {
			for (size_t k = 0; k < 2; k++) {
				for (size_t l = 0; l < 6; l++) {
					for (size_t m = 0; m < 6; m++) {
						for (size_t n = 0; n < 3; n++) {
							json_object_array_add(coef_obj, json_object_new_int(p->coef[i][j][k][l][m][n]));
						}
					}
				}
			}
		}
	}
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "coef", coef_obj);

	/* __u8 skip[3] */
	json_object *skip_obj = json_object_new_array();
	for (size_t i = 0; i < 3; i++) {
		json_object_array_add(skip_obj, json_object_new_int(p->skip[i]));
	}
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "skip", skip_obj);

	/* __u8 inter_mode[7][3] */
	json_object *inter_mode_obj = json_object_new_array();
	for (size_t i = 0; i < 7; i++) {
		for (size_t j = 0; j < 3; j++) {
			json_object_array_add(inter_mode_obj, json_object_new_int(p->inter_mode[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "inter_mode", inter_mode_obj);

	/* __u8 interp_filter[4][2] */
	json_object *interp_filter_obj = json_object_new_array();
	for (size_t i = 0; i < 4; i++) {
		for (size_t j = 0; j < 2; j++) {
			json_object_array_add(interp_filter_obj, json_object_new_int(p->interp_filter[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "interp_filter", interp_filter_obj);

	/* __u8 is_inter[4] */
	json_object *is_inter_obj = json_object_new_array();
	for (size_t i = 0; i < 4; i++) {
		json_object_array_add(is_inter_obj, json_object_new_int(p->is_inter[i]));
	}
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "is_inter", is_inter_obj);

	/* __u8 comp_mode[5] */
	json_object *comp_mode_obj = json_object_new_array();
	for (size_t i = 0; i < 5; i++) {
		json_object_array_add(comp_mode_obj, json_object_new_int(p->comp_mode[i]));
	}
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "comp_mode", comp_mode_obj);

	/* __u8 single_ref[5][2] */
	json_object *single_ref_obj = json_object_new_array();
	for (size_t i = 0; i < 5; i++) {
		for (size_t j = 0; j < 2; j++) {
			json_object_array_add(single_ref_obj, json_object_new_int(p->single_ref[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "single_ref", single_ref_obj);

	/* __u8 comp_ref[5] */
	json_object *comp_ref_obj = json_object_new_array();
	for (size_t i = 0; i < 5; i++) {
		json_object_array_add(comp_ref_obj, json_object_new_int(p->comp_ref[i]));
	}
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "comp_ref", comp_ref_obj);

	/* __u8 y_mode[4][9] */
	json_object *y_mode_obj = json_object_new_array();
	for (size_t i = 0; i < 4; i++) {
		for (size_t j = 0; j < 9; j++) {
			json_object_array_add(y_mode_obj, json_object_new_int(p->y_mode[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "y_mode", y_mode_obj);

	/* __u8 uv_mode[10][9] */
	json_object *uv_mode_obj = json_object_new_array();
	for (size_t i = 0; i < 10; i++) {
		for (size_t j = 0; j < 9; j++) {
			json_object_array_add(uv_mode_obj, json_object_new_int(p->uv_mode[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "uv_mode", uv_mode_obj);

	/* __u8 partition[16][3] */
	json_object *partition_obj = json_object_new_array();
	for (size_t i = 0; i < 16; i++) {
		for (size_t j = 0; j < 3; j++) {
			json_object_array_add(partition_obj, json_object_new_int(p->partition[i][j]));
		}
	}
	json_object_object_add(v4l2_ctrl_vp9_compressed_hdr_obj, "partition", partition_obj);

	/* struct v4l2_vp9_mv_probs mv */
	trace_v4l2_vp9_mv_probs_gen(&p->mv, v4l2_ctrl_vp9_compressed_hdr_obj);
	json_object_object_add(parent_obj, "v4l2_ctrl_vp9_compressed_hdr", v4l2_ctrl_vp9_compressed_hdr_obj);
}

void trace_v4l2_ctrl_av1_sequence_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_av1_sequence_obj = json_object_new_object();
	struct v4l2_ctrl_av1_sequence *p = static_cast<struct v4l2_ctrl_av1_sequence*>(ptr);
	json_object_object_add(v4l2_ctrl_av1_sequence_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_av1_sequence_flag_def).c_str()));
	json_object_object_add(v4l2_ctrl_av1_sequence_obj, "seq_profile", json_object_new_int(p->seq_profile));
	json_object_object_add(v4l2_ctrl_av1_sequence_obj, "order_hint_bits", json_object_new_int(p->order_hint_bits));
	json_object_object_add(v4l2_ctrl_av1_sequence_obj, "bit_depth", json_object_new_int(p->bit_depth));
	json_object_object_add(v4l2_ctrl_av1_sequence_obj, "max_frame_width_minus_1", json_object_new_int(p->max_frame_width_minus_1));
	json_object_object_add(v4l2_ctrl_av1_sequence_obj, "max_frame_height_minus_1", json_object_new_int(p->max_frame_height_minus_1));
	json_object_object_add(parent_obj, "v4l2_ctrl_av1_sequence", v4l2_ctrl_av1_sequence_obj);
}

void trace_v4l2_ctrl_av1_tile_group_entry_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_av1_tile_group_entry_obj = json_object_new_object();
	struct v4l2_ctrl_av1_tile_group_entry *p = static_cast<struct v4l2_ctrl_av1_tile_group_entry*>(ptr);
	json_object_object_add(v4l2_ctrl_av1_tile_group_entry_obj, "tile_offset", json_object_new_int64(p->tile_offset));
	json_object_object_add(v4l2_ctrl_av1_tile_group_entry_obj, "tile_size", json_object_new_int64(p->tile_size));
	json_object_object_add(v4l2_ctrl_av1_tile_group_entry_obj, "tile_row", json_object_new_int64(p->tile_row));
	json_object_object_add(v4l2_ctrl_av1_tile_group_entry_obj, "tile_col", json_object_new_int64(p->tile_col));
	json_object_object_add(parent_obj, "v4l2_ctrl_av1_tile_group_entry", v4l2_ctrl_av1_tile_group_entry_obj);
}

void trace_v4l2_av1_global_motion_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_av1_global_motion_obj = json_object_new_object();
	struct v4l2_av1_global_motion *p = static_cast<struct v4l2_av1_global_motion*>(ptr);
	/* __u8 flags[V4L2_AV1_TOTAL_REFS_PER_FRAME] */
	json_object *flags_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_TOTAL_REFS_PER_FRAME; i++) {
		json_object_array_add(flags_obj, json_object_new_int(p->flags[i]));
	}
	json_object_object_add(v4l2_av1_global_motion_obj, "flags", flags_obj);

	/* enum v4l2_av1_warp_model type[V4L2_AV1_TOTAL_REFS_PER_FRAME] */
	json_object *type_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_TOTAL_REFS_PER_FRAME; i++) {
		json_object_array_add(type_obj, json_object_new_int(p->type[i]));
	}
	json_object_object_add(v4l2_av1_global_motion_obj, "type", type_obj);

	/* __s32 params[V4L2_AV1_TOTAL_REFS_PER_FRAME][6] */
	json_object *params_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_TOTAL_REFS_PER_FRAME; i++) {
		for (size_t j = 0; j < 6; j++) {
			json_object_array_add(params_obj, json_object_new_int(p->params[i][j]));
		}
	}
	json_object_object_add(v4l2_av1_global_motion_obj, "params", params_obj);

	json_object_object_add(v4l2_av1_global_motion_obj, "invalid", json_object_new_int(p->invalid));
	json_object_object_add(parent_obj, "v4l2_av1_global_motion", v4l2_av1_global_motion_obj);
}

void trace_v4l2_av1_loop_restoration_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_av1_loop_restoration_obj = json_object_new_object();
	struct v4l2_av1_loop_restoration *p = static_cast<struct v4l2_av1_loop_restoration*>(ptr);
	json_object_object_add(v4l2_av1_loop_restoration_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_av1_loop_restoration_flag_def).c_str()));
	json_object_object_add(v4l2_av1_loop_restoration_obj, "lr_unit_shift", json_object_new_int(p->lr_unit_shift));
	json_object_object_add(v4l2_av1_loop_restoration_obj, "lr_uv_shift", json_object_new_int(p->lr_uv_shift));
	/* enum v4l2_av1_frame_restoration_type frame_restoration_type[V4L2_AV1_NUM_PLANES_MAX] */
	json_object *frame_restoration_type_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_NUM_PLANES_MAX; i++) {
		json_object_array_add(frame_restoration_type_obj, json_object_new_int(p->frame_restoration_type[i]));
	}
	json_object_object_add(v4l2_av1_loop_restoration_obj, "frame_restoration_type", frame_restoration_type_obj);

	/* __u32 loop_restoration_size[V4L2_AV1_MAX_NUM_PLANES] */
	json_object *loop_restoration_size_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_MAX_NUM_PLANES; i++) {
		json_object_array_add(loop_restoration_size_obj, json_object_new_int64(p->loop_restoration_size[i]));
	}
	json_object_object_add(v4l2_av1_loop_restoration_obj, "loop_restoration_size", loop_restoration_size_obj);

	json_object_object_add(parent_obj, "v4l2_av1_loop_restoration", v4l2_av1_loop_restoration_obj);
}

void trace_v4l2_av1_cdef_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_av1_cdef_obj = json_object_new_object();
	struct v4l2_av1_cdef *p = static_cast<struct v4l2_av1_cdef*>(ptr);
	json_object_object_add(v4l2_av1_cdef_obj, "damping_minus_3", json_object_new_int(p->damping_minus_3));
	json_object_object_add(v4l2_av1_cdef_obj, "bits", json_object_new_int(p->bits));
	/* __u8 y_pri_strength[V4L2_AV1_CDEF_MAX] */
	json_object *y_pri_strength_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_CDEF_MAX; i++) {
		json_object_array_add(y_pri_strength_obj, json_object_new_int(p->y_pri_strength[i]));
	}
	json_object_object_add(v4l2_av1_cdef_obj, "y_pri_strength", y_pri_strength_obj);

	/* __u8 y_sec_strength[V4L2_AV1_CDEF_MAX] */
	json_object *y_sec_strength_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_CDEF_MAX; i++) {
		json_object_array_add(y_sec_strength_obj, json_object_new_int(p->y_sec_strength[i]));
	}
	json_object_object_add(v4l2_av1_cdef_obj, "y_sec_strength", y_sec_strength_obj);

	/* __u8 uv_pri_strength[V4L2_AV1_CDEF_MAX] */
	json_object *uv_pri_strength_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_CDEF_MAX; i++) {
		json_object_array_add(uv_pri_strength_obj, json_object_new_int(p->uv_pri_strength[i]));
	}
	json_object_object_add(v4l2_av1_cdef_obj, "uv_pri_strength", uv_pri_strength_obj);

	/* __u8 uv_sec_strength[V4L2_AV1_CDEF_MAX] */
	json_object *uv_sec_strength_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_CDEF_MAX; i++) {
		json_object_array_add(uv_sec_strength_obj, json_object_new_int(p->uv_sec_strength[i]));
	}
	json_object_object_add(v4l2_av1_cdef_obj, "uv_sec_strength", uv_sec_strength_obj);

	json_object_object_add(parent_obj, "v4l2_av1_cdef", v4l2_av1_cdef_obj);
}

void trace_v4l2_av1_segmentation_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_av1_segmentation_obj = json_object_new_object();
	struct v4l2_av1_segmentation *p = static_cast<struct v4l2_av1_segmentation*>(ptr);
	json_object_object_add(v4l2_av1_segmentation_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_av1_segmentation_flag_def).c_str()));
	json_object_object_add(v4l2_av1_segmentation_obj, "last_active_seg_id", json_object_new_int(p->last_active_seg_id));
	/* __u8 feature_enabled[V4L2_AV1_MAX_SEGMENTS] */
	json_object *feature_enabled_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_MAX_SEGMENTS; i++) {
		json_object_array_add(feature_enabled_obj, json_object_new_int(p->feature_enabled[i]));
	}
	json_object_object_add(v4l2_av1_segmentation_obj, "feature_enabled", feature_enabled_obj);

	/* __s16 feature_data[V4L2_AV1_MAX_SEGMENTS][V4L2_AV1_SEG_LVL_MAX] */
	json_object *feature_data_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_MAX_SEGMENTS; i++) {
		for (size_t j = 0; j < V4L2_AV1_SEG_LVL_MAX; j++) {
			json_object_array_add(feature_data_obj, json_object_new_int(p->feature_data[i][j]));
		}
	}
	json_object_object_add(v4l2_av1_segmentation_obj, "feature_data", feature_data_obj);

	json_object_object_add(parent_obj, "v4l2_av1_segmentation", v4l2_av1_segmentation_obj);
}

void trace_v4l2_av1_loop_filter_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_av1_loop_filter_obj = json_object_new_object();
	struct v4l2_av1_loop_filter *p = static_cast<struct v4l2_av1_loop_filter*>(ptr);
	json_object_object_add(v4l2_av1_loop_filter_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_av1_loop_filter_flag_def).c_str()));
	/* __u8 level[4] */
	json_object *level_obj = json_object_new_array();
	for (size_t i = 0; i < 4; i++) {
		json_object_array_add(level_obj, json_object_new_int(p->level[i]));
	}
	json_object_object_add(v4l2_av1_loop_filter_obj, "level", level_obj);

	json_object_object_add(v4l2_av1_loop_filter_obj, "sharpness", json_object_new_int(p->sharpness));
	/* __s8 ref_deltas[V4L2_AV1_TOTAL_REFS_PER_FRAME] */
	json_object *ref_deltas_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_TOTAL_REFS_PER_FRAME; i++) {
		json_object_array_add(ref_deltas_obj, json_object_new_int(p->ref_deltas[i]));
	}
	json_object_object_add(v4l2_av1_loop_filter_obj, "ref_deltas", ref_deltas_obj);

	/* __s8 mode_deltas[2] */
	json_object *mode_deltas_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		json_object_array_add(mode_deltas_obj, json_object_new_int(p->mode_deltas[i]));
	}
	json_object_object_add(v4l2_av1_loop_filter_obj, "mode_deltas", mode_deltas_obj);

	json_object_object_add(v4l2_av1_loop_filter_obj, "delta_lf_res", json_object_new_int(p->delta_lf_res));
	json_object_object_add(parent_obj, "v4l2_av1_loop_filter", v4l2_av1_loop_filter_obj);
}

void trace_v4l2_av1_quantization_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_av1_quantization_obj = json_object_new_object();
	struct v4l2_av1_quantization *p = static_cast<struct v4l2_av1_quantization*>(ptr);
	json_object_object_add(v4l2_av1_quantization_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_av1_quantization_flag_def).c_str()));
	json_object_object_add(v4l2_av1_quantization_obj, "base_q_idx", json_object_new_int(p->base_q_idx));
	json_object_object_add(v4l2_av1_quantization_obj, "delta_q_y_dc", json_object_new_int(p->delta_q_y_dc));
	json_object_object_add(v4l2_av1_quantization_obj, "delta_q_u_dc", json_object_new_int(p->delta_q_u_dc));
	json_object_object_add(v4l2_av1_quantization_obj, "delta_q_u_ac", json_object_new_int(p->delta_q_u_ac));
	json_object_object_add(v4l2_av1_quantization_obj, "delta_q_v_dc", json_object_new_int(p->delta_q_v_dc));
	json_object_object_add(v4l2_av1_quantization_obj, "delta_q_v_ac", json_object_new_int(p->delta_q_v_ac));
	json_object_object_add(v4l2_av1_quantization_obj, "qm_y", json_object_new_int(p->qm_y));
	json_object_object_add(v4l2_av1_quantization_obj, "qm_u", json_object_new_int(p->qm_u));
	json_object_object_add(v4l2_av1_quantization_obj, "qm_v", json_object_new_int(p->qm_v));
	json_object_object_add(v4l2_av1_quantization_obj, "delta_q_res", json_object_new_int(p->delta_q_res));
	json_object_object_add(parent_obj, "v4l2_av1_quantization", v4l2_av1_quantization_obj);
}

void trace_v4l2_av1_tile_info_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_av1_tile_info_obj = json_object_new_object();
	struct v4l2_av1_tile_info *p = static_cast<struct v4l2_av1_tile_info*>(ptr);
	json_object_object_add(v4l2_av1_tile_info_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_av1_tile_info_flag_def).c_str()));
	json_object_object_add(v4l2_av1_tile_info_obj, "context_update_tile_id", json_object_new_int(p->context_update_tile_id));
	json_object_object_add(v4l2_av1_tile_info_obj, "tile_cols", json_object_new_int(p->tile_cols));
	json_object_object_add(v4l2_av1_tile_info_obj, "tile_rows", json_object_new_int(p->tile_rows));
	/* __u32 mi_col_starts[V4L2_AV1_MAX_TILE_COLS + 1] */
	json_object *mi_col_starts_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_MAX_TILE_COLS + 1; i++) {
		json_object_array_add(mi_col_starts_obj, json_object_new_int64(p->mi_col_starts[i]));
	}
	json_object_object_add(v4l2_av1_tile_info_obj, "mi_col_starts", mi_col_starts_obj);

	/* __u32 mi_row_starts[V4L2_AV1_MAX_TILE_ROWS + 1] */
	json_object *mi_row_starts_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_MAX_TILE_ROWS + 1; i++) {
		json_object_array_add(mi_row_starts_obj, json_object_new_int64(p->mi_row_starts[i]));
	}
	json_object_object_add(v4l2_av1_tile_info_obj, "mi_row_starts", mi_row_starts_obj);

	/* __u32 width_in_sbs_minus_1[V4L2_AV1_MAX_TILE_COLS] */
	json_object *width_in_sbs_minus_1_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_MAX_TILE_COLS; i++) {
		json_object_array_add(width_in_sbs_minus_1_obj, json_object_new_int64(p->width_in_sbs_minus_1[i]));
	}
	json_object_object_add(v4l2_av1_tile_info_obj, "width_in_sbs_minus_1", width_in_sbs_minus_1_obj);

	/* __u32 height_in_sbs_minus_1[V4L2_AV1_MAX_TILE_ROWS] */
	json_object *height_in_sbs_minus_1_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_MAX_TILE_ROWS; i++) {
		json_object_array_add(height_in_sbs_minus_1_obj, json_object_new_int64(p->height_in_sbs_minus_1[i]));
	}
	json_object_object_add(v4l2_av1_tile_info_obj, "height_in_sbs_minus_1", height_in_sbs_minus_1_obj);

	json_object_object_add(v4l2_av1_tile_info_obj, "tile_size_bytes", json_object_new_int(p->tile_size_bytes));
	json_object_object_add(parent_obj, "v4l2_av1_tile_info", v4l2_av1_tile_info_obj);
}

void trace_v4l2_ctrl_av1_frame_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_av1_frame_obj = json_object_new_object();
	struct v4l2_ctrl_av1_frame *p = static_cast<struct v4l2_ctrl_av1_frame*>(ptr);
	/* struct v4l2_av1_tile_info tile_info */
	trace_v4l2_av1_tile_info_gen(&p->tile_info, v4l2_ctrl_av1_frame_obj);
	/* struct v4l2_av1_quantization quantization */
	trace_v4l2_av1_quantization_gen(&p->quantization, v4l2_ctrl_av1_frame_obj);
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "superres_denom", json_object_new_int(p->superres_denom));
	/* struct v4l2_av1_segmentation segmentation */
	trace_v4l2_av1_segmentation_gen(&p->segmentation, v4l2_ctrl_av1_frame_obj);
	/* struct v4l2_av1_loop_filter loop_filter */
	trace_v4l2_av1_loop_filter_gen(&p->loop_filter, v4l2_ctrl_av1_frame_obj);
	/* struct v4l2_av1_cdef cdef */
	trace_v4l2_av1_cdef_gen(&p->cdef, v4l2_ctrl_av1_frame_obj);
	/* __u8 skip_mode_frame[2] */
	json_object *skip_mode_frame_obj = json_object_new_array();
	for (size_t i = 0; i < 2; i++) {
		json_object_array_add(skip_mode_frame_obj, json_object_new_int(p->skip_mode_frame[i]));
	}
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "skip_mode_frame", skip_mode_frame_obj);

	json_object_object_add(v4l2_ctrl_av1_frame_obj, "primary_ref_frame", json_object_new_int(p->primary_ref_frame));
	/* struct v4l2_av1_loop_restoration loop_restoration */
	trace_v4l2_av1_loop_restoration_gen(&p->loop_restoration, v4l2_ctrl_av1_frame_obj);
	/* struct v4l2_av1_global_motion global_motion */
	trace_v4l2_av1_global_motion_gen(&p->global_motion, v4l2_ctrl_av1_frame_obj);
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_av1_frame_flag_def).c_str()));
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "frame_type", json_object_new_int(p->frame_type));
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "order_hint", json_object_new_int64(p->order_hint));
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "upscaled_width", json_object_new_int64(p->upscaled_width));
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "interpolation_filter", json_object_new_int(p->interpolation_filter));
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "tx_mode", json_object_new_int(p->tx_mode));
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "frame_width_minus_1", json_object_new_int64(p->frame_width_minus_1));
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "frame_height_minus_1", json_object_new_int64(p->frame_height_minus_1));
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "render_width_minus_1", json_object_new_int(p->render_width_minus_1));
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "render_height_minus_1", json_object_new_int(p->render_height_minus_1));
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "current_frame_id", json_object_new_int64(p->current_frame_id));
	/* __u32 buffer_removal_time[V4L2_AV1_MAX_OPERATING_POINTS] */
	json_object *buffer_removal_time_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_MAX_OPERATING_POINTS; i++) {
		json_object_array_add(buffer_removal_time_obj, json_object_new_int64(p->buffer_removal_time[i]));
	}
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "buffer_removal_time", buffer_removal_time_obj);

	/* __u32 order_hints[V4L2_AV1_TOTAL_REFS_PER_FRAME] */
	json_object *order_hints_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_TOTAL_REFS_PER_FRAME; i++) {
		json_object_array_add(order_hints_obj, json_object_new_int64(p->order_hints[i]));
	}
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "order_hints", order_hints_obj);

	/* __u64 reference_frame_ts[V4L2_AV1_TOTAL_REFS_PER_FRAME] */
	json_object *reference_frame_ts_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_TOTAL_REFS_PER_FRAME; i++) {
		json_object_array_add(reference_frame_ts_obj, json_object_new_uint64(p->reference_frame_ts[i]));
	}
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "reference_frame_ts", reference_frame_ts_obj);

	/* __s8 ref_frame_idx[V4L2_AV1_REFS_PER_FRAME] */
	json_object *ref_frame_idx_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_REFS_PER_FRAME; i++) {
		json_object_array_add(ref_frame_idx_obj, json_object_new_int(p->ref_frame_idx[i]));
	}
	json_object_object_add(v4l2_ctrl_av1_frame_obj, "ref_frame_idx", ref_frame_idx_obj);

	json_object_object_add(v4l2_ctrl_av1_frame_obj, "refresh_frame_flags", json_object_new_string(fl2s(p->refresh_frame_flags, v4l2_av1_frame_flag_def).c_str()));
	json_object_object_add(parent_obj, "v4l2_ctrl_av1_frame", v4l2_ctrl_av1_frame_obj);
}

void trace_v4l2_ctrl_av1_film_grain_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_av1_film_grain_obj = json_object_new_object();
	struct v4l2_ctrl_av1_film_grain *p = static_cast<struct v4l2_ctrl_av1_film_grain*>(ptr);
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_av1_film_grain_flag_def).c_str()));
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "cr_mult", json_object_new_int(p->cr_mult));
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "grain_seed", json_object_new_int(p->grain_seed));
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "film_grain_params_ref_idx", json_object_new_int(p->film_grain_params_ref_idx));
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "num_y_points", json_object_new_int(p->num_y_points));
	/* __u8 point_y_value[V4L2_AV1_MAX_NUM_Y_POINTS] */
	json_object *point_y_value_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_MAX_NUM_Y_POINTS; i++) {
		json_object_array_add(point_y_value_obj, json_object_new_int(p->point_y_value[i]));
	}
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "point_y_value", point_y_value_obj);

	/* __u8 point_y_scaling[V4L2_AV1_MAX_NUM_Y_POINTS] */
	json_object *point_y_scaling_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_MAX_NUM_Y_POINTS; i++) {
		json_object_array_add(point_y_scaling_obj, json_object_new_int(p->point_y_scaling[i]));
	}
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "point_y_scaling", point_y_scaling_obj);

	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "num_cb_points", json_object_new_int(p->num_cb_points));
	/* __u8 point_cb_value[V4L2_AV1_MAX_NUM_CB_POINTS] */
	json_object *point_cb_value_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_MAX_NUM_CB_POINTS; i++) {
		json_object_array_add(point_cb_value_obj, json_object_new_int(p->point_cb_value[i]));
	}
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "point_cb_value", point_cb_value_obj);

	/* __u8 point_cb_scaling[V4L2_AV1_MAX_NUM_CB_POINTS] */
	json_object *point_cb_scaling_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_MAX_NUM_CB_POINTS; i++) {
		json_object_array_add(point_cb_scaling_obj, json_object_new_int(p->point_cb_scaling[i]));
	}
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "point_cb_scaling", point_cb_scaling_obj);

	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "num_cr_points", json_object_new_int(p->num_cr_points));
	/* __u8 point_cr_value[V4L2_AV1_MAX_NUM_CR_POINTS] */
	json_object *point_cr_value_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_MAX_NUM_CR_POINTS; i++) {
		json_object_array_add(point_cr_value_obj, json_object_new_int(p->point_cr_value[i]));
	}
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "point_cr_value", point_cr_value_obj);

	/* __u8 point_cr_scaling[V4L2_AV1_MAX_NUM_CR_POINTS] */
	json_object *point_cr_scaling_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_MAX_NUM_CR_POINTS; i++) {
		json_object_array_add(point_cr_scaling_obj, json_object_new_int(p->point_cr_scaling[i]));
	}
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "point_cr_scaling", point_cr_scaling_obj);

	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "grain_scaling_minus_8", json_object_new_int(p->grain_scaling_minus_8));
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "ar_coeff_lag", json_object_new_int(p->ar_coeff_lag));
	/* __u8 ar_coeffs_y_plus_128[V4L2_AV1_AR_COEFFS_SIZE] */
	json_object *ar_coeffs_y_plus_128_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_AR_COEFFS_SIZE; i++) {
		json_object_array_add(ar_coeffs_y_plus_128_obj, json_object_new_int(p->ar_coeffs_y_plus_128[i]));
	}
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "ar_coeffs_y_plus_128", ar_coeffs_y_plus_128_obj);

	/* __u8 ar_coeffs_cb_plus_128[V4L2_AV1_AR_COEFFS_SIZE] */
	json_object *ar_coeffs_cb_plus_128_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_AR_COEFFS_SIZE; i++) {
		json_object_array_add(ar_coeffs_cb_plus_128_obj, json_object_new_int(p->ar_coeffs_cb_plus_128[i]));
	}
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "ar_coeffs_cb_plus_128", ar_coeffs_cb_plus_128_obj);

	/* __u8 ar_coeffs_cr_plus_128[V4L2_AV1_AR_COEFFS_SIZE] */
	json_object *ar_coeffs_cr_plus_128_obj = json_object_new_array();
	for (size_t i = 0; i < V4L2_AV1_AR_COEFFS_SIZE; i++) {
		json_object_array_add(ar_coeffs_cr_plus_128_obj, json_object_new_int(p->ar_coeffs_cr_plus_128[i]));
	}
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "ar_coeffs_cr_plus_128", ar_coeffs_cr_plus_128_obj);

	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "ar_coeff_shift_minus_6", json_object_new_int(p->ar_coeff_shift_minus_6));
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "grain_scale_shift", json_object_new_int(p->grain_scale_shift));
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "cb_mult", json_object_new_int(p->cb_mult));
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "cb_luma_mult", json_object_new_int(p->cb_luma_mult));
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "cr_luma_mult", json_object_new_int(p->cr_luma_mult));
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "cb_offset", json_object_new_int(p->cb_offset));
	json_object_object_add(v4l2_ctrl_av1_film_grain_obj, "cr_offset", json_object_new_int(p->cr_offset));
	json_object_object_add(parent_obj, "v4l2_ctrl_av1_film_grain", v4l2_ctrl_av1_film_grain_obj);
}

void trace_v4l2_ctrl_hdr10_cll_info_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_hdr10_cll_info_obj = json_object_new_object();
	struct v4l2_ctrl_hdr10_cll_info *p = static_cast<struct v4l2_ctrl_hdr10_cll_info*>(ptr);
	json_object_object_add(v4l2_ctrl_hdr10_cll_info_obj, "max_content_light_level", json_object_new_int(p->max_content_light_level));
	json_object_object_add(v4l2_ctrl_hdr10_cll_info_obj, "max_pic_average_light_level", json_object_new_int(p->max_pic_average_light_level));
	json_object_object_add(parent_obj, "v4l2_ctrl_hdr10_cll_info", v4l2_ctrl_hdr10_cll_info_obj);
}

void trace_v4l2_ctrl_hdr10_mastering_display_gen(void *ptr, json_object *parent_obj)
{
	json_object *v4l2_ctrl_hdr10_mastering_display_obj = json_object_new_object();
	struct v4l2_ctrl_hdr10_mastering_display *p = static_cast<struct v4l2_ctrl_hdr10_mastering_display*>(ptr);
	/* __u16 display_primaries_x[3] */
	json_object *display_primaries_x_obj = json_object_new_array();
	for (size_t i = 0; i < 3; i++) {
		json_object_array_add(display_primaries_x_obj, json_object_new_int(p->display_primaries_x[i]));
	}
	json_object_object_add(v4l2_ctrl_hdr10_mastering_display_obj, "display_primaries_x", display_primaries_x_obj);

	/* __u16 display_primaries_y[3] */
	json_object *display_primaries_y_obj = json_object_new_array();
	for (size_t i = 0; i < 3; i++) {
		json_object_array_add(display_primaries_y_obj, json_object_new_int(p->display_primaries_y[i]));
	}
	json_object_object_add(v4l2_ctrl_hdr10_mastering_display_obj, "display_primaries_y", display_primaries_y_obj);

	json_object_object_add(v4l2_ctrl_hdr10_mastering_display_obj, "white_point_x", json_object_new_int(p->white_point_x));
	json_object_object_add(v4l2_ctrl_hdr10_mastering_display_obj, "white_point_y", json_object_new_int(p->white_point_y));
	json_object_object_add(v4l2_ctrl_hdr10_mastering_display_obj, "max_display_mastering_luminance", json_object_new_int64(p->max_display_mastering_luminance));
	json_object_object_add(v4l2_ctrl_hdr10_mastering_display_obj, "min_display_mastering_luminance", json_object_new_int64(p->min_display_mastering_luminance));
	json_object_object_add(parent_obj, "v4l2_ctrl_hdr10_mastering_display", v4l2_ctrl_hdr10_mastering_display_obj);
}

void trace_v4l2_rect_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_rect_obj = json_object_new_object();
	struct v4l2_rect *p = static_cast<struct v4l2_rect*>(arg);

	json_object_object_add(v4l2_rect_obj, "left", json_object_new_int(p->left));
	json_object_object_add(v4l2_rect_obj, "top", json_object_new_int(p->top));
	json_object_object_add(v4l2_rect_obj, "width", json_object_new_int64(p->width));
	json_object_object_add(v4l2_rect_obj, "height", json_object_new_int64(p->height));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_rect", v4l2_rect_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_rect_obj);
}

void trace_v4l2_fract_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_fract_obj = json_object_new_object();
	struct v4l2_fract *p = static_cast<struct v4l2_fract*>(arg);

	json_object_object_add(v4l2_fract_obj, "numerator", json_object_new_int64(p->numerator));
	json_object_object_add(v4l2_fract_obj, "denominator", json_object_new_int64(p->denominator));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_fract", v4l2_fract_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_fract_obj);
}

void trace_v4l2_area_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_area_obj = json_object_new_object();
	struct v4l2_area *p = static_cast<struct v4l2_area*>(arg);

	json_object_object_add(v4l2_area_obj, "width", json_object_new_int64(p->width));
	json_object_object_add(v4l2_area_obj, "height", json_object_new_int64(p->height));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_area", v4l2_area_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_area_obj);
}

void trace_v4l2_capability_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_capability_obj = json_object_new_object();
	struct v4l2_capability *p = static_cast<struct v4l2_capability*>(arg);

	json_object_object_add(v4l2_capability_obj, "driver", json_object_new_string(reinterpret_cast<const char *>(p->driver)));
	json_object_object_add(v4l2_capability_obj, "card", json_object_new_string(reinterpret_cast<const char *>(p->card)));
	json_object_object_add(v4l2_capability_obj, "bus_info", json_object_new_string(reinterpret_cast<const char *>(p->bus_info)));
	json_object_object_add(v4l2_capability_obj, "version", json_object_new_string(ver2s(p->version).c_str()));
	json_object_object_add(v4l2_capability_obj, "capabilities", json_object_new_string(fl2s(p->capabilities, v4l2_cap_flag_def).c_str()));
	json_object_object_add(v4l2_capability_obj, "device_caps", json_object_new_string(fl2s(p->device_caps, v4l2_cap_flag_def).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_capability", v4l2_capability_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_capability_obj);
}

void trace_v4l2_pix_format_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_pix_format_obj = json_object_new_object();
	struct v4l2_pix_format *p = static_cast<struct v4l2_pix_format*>(arg);

	json_object_object_add(v4l2_pix_format_obj, "width", json_object_new_int64(p->width));
	json_object_object_add(v4l2_pix_format_obj, "height", json_object_new_int64(p->height));
	json_object_object_add(v4l2_pix_format_obj, "pixelformat", json_object_new_string(val2s(p->pixelformat, v4l2_pix_fmt_val_def).c_str()));
	json_object_object_add(v4l2_pix_format_obj, "field", json_object_new_string(val2s(p->field, v4l2_field_val_def).c_str()));
	json_object_object_add(v4l2_pix_format_obj, "bytesperline", json_object_new_int64(p->bytesperline));
	json_object_object_add(v4l2_pix_format_obj, "sizeimage", json_object_new_int64(p->sizeimage));
	json_object_object_add(v4l2_pix_format_obj, "colorspace", json_object_new_string(val2s(p->colorspace, v4l2_colorspace_val_def).c_str()));
	if (p->priv == V4L2_PIX_FMT_PRIV_MAGIC)
		json_object_object_add(v4l2_pix_format_obj, "priv", json_object_new_string("V4L2_PIX_FMT_PRIV_MAGIC"));
	else
		json_object_object_add(v4l2_pix_format_obj, "priv", json_object_new_string(""));
	json_object_object_add(v4l2_pix_format_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_pix_fmt_flag_def).c_str()));
	//union
	json_object_object_add(v4l2_pix_format_obj, "ycbcr_enc", json_object_new_string(val2s(p->ycbcr_enc, v4l2_ycbcr_encoding_val_def).c_str()));
	json_object_object_add(v4l2_pix_format_obj, "hsv_enc", json_object_new_int64(p->hsv_enc));
	//end of union 	};
	json_object_object_add(v4l2_pix_format_obj, "quantization", json_object_new_string(val2s(p->quantization, v4l2_quantization_val_def).c_str()));
	json_object_object_add(v4l2_pix_format_obj, "xfer_func", json_object_new_string(val2s(p->xfer_func, v4l2_xfer_func_val_def).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_pix_format", v4l2_pix_format_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_pix_format_obj);
}

void trace_v4l2_fmtdesc_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_fmtdesc_obj = json_object_new_object();
	struct v4l2_fmtdesc *p = static_cast<struct v4l2_fmtdesc*>(arg);

	json_object_object_add(v4l2_fmtdesc_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_fmtdesc_obj, "type", json_object_new_string(val2s(p->type, v4l2_buf_type_val_def).c_str()));
	json_object_object_add(v4l2_fmtdesc_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_fmt_flag_def).c_str()));
	json_object_object_add(v4l2_fmtdesc_obj, "description", json_object_new_string(reinterpret_cast<const char *>(p->description)));
	json_object_object_add(v4l2_fmtdesc_obj, "pixelformat", json_object_new_string(val2s(p->pixelformat, v4l2_pix_fmt_val_def).c_str()));
	json_object_object_add(v4l2_fmtdesc_obj, "mbus_code", json_object_new_int64(p->mbus_code));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_fmtdesc", v4l2_fmtdesc_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_fmtdesc_obj);
}

void trace_v4l2_frmsize_discrete_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_frmsize_discrete_obj = json_object_new_object();
	struct v4l2_frmsize_discrete *p = static_cast<struct v4l2_frmsize_discrete*>(arg);

	json_object_object_add(v4l2_frmsize_discrete_obj, "width", json_object_new_int64(p->width));
	json_object_object_add(v4l2_frmsize_discrete_obj, "height", json_object_new_int64(p->height));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_frmsize_discrete", v4l2_frmsize_discrete_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_frmsize_discrete_obj);
}

void trace_v4l2_frmsize_stepwise_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_frmsize_stepwise_obj = json_object_new_object();
	struct v4l2_frmsize_stepwise *p = static_cast<struct v4l2_frmsize_stepwise*>(arg);

	json_object_object_add(v4l2_frmsize_stepwise_obj, "min_width", json_object_new_int64(p->min_width));
	json_object_object_add(v4l2_frmsize_stepwise_obj, "max_width", json_object_new_int64(p->max_width));
	json_object_object_add(v4l2_frmsize_stepwise_obj, "step_width", json_object_new_int64(p->step_width));
	json_object_object_add(v4l2_frmsize_stepwise_obj, "min_height", json_object_new_int64(p->min_height));
	json_object_object_add(v4l2_frmsize_stepwise_obj, "max_height", json_object_new_int64(p->max_height));
	json_object_object_add(v4l2_frmsize_stepwise_obj, "step_height", json_object_new_int64(p->step_height));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_frmsize_stepwise", v4l2_frmsize_stepwise_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_frmsize_stepwise_obj);
}

void trace_v4l2_frmsizeenum_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_frmsizeenum_obj = json_object_new_object();
	struct v4l2_frmsizeenum *p = static_cast<struct v4l2_frmsizeenum*>(arg);

	json_object_object_add(v4l2_frmsizeenum_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_frmsizeenum_obj, "pixel_format", json_object_new_string(val2s(p->pixel_format, v4l2_pix_fmt_val_def).c_str()));
	json_object_object_add(v4l2_frmsizeenum_obj, "type", json_object_new_string(val2s(p->type, v4l2_frmsizetypes_val_def).c_str()));
	//union
	switch (p->type) {
	case V4L2_FRMSIZE_TYPE_DISCRETE:
		trace_v4l2_frmsize_discrete_gen(&p->discrete, v4l2_frmsizeenum_obj);
		break;
	case V4L2_FRMSIZE_TYPE_STEPWISE:
	case V4L2_FRMSIZE_TYPE_CONTINUOUS:
		trace_v4l2_frmsize_stepwise_gen(&p->stepwise, v4l2_frmsizeenum_obj);
		break;
	default:
		break;
	}
	//struct v4l2_frmsize_discrete	discrete;
	//struct v4l2_frmsize_stepwise	stepwise;
	//end of union 	};

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_frmsizeenum", v4l2_frmsizeenum_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_frmsizeenum_obj);
}

void trace_v4l2_frmival_stepwise_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_frmival_stepwise_obj = json_object_new_object();
	struct v4l2_frmival_stepwise *p = static_cast<struct v4l2_frmival_stepwise*>(arg);

	//struct v4l2_fract	min;
	trace_v4l2_fract_gen(&p->min, v4l2_frmival_stepwise_obj, "min");
	//struct v4l2_fract	max;
	trace_v4l2_fract_gen(&p->max, v4l2_frmival_stepwise_obj, "max");
	//struct v4l2_fract	step;
	trace_v4l2_fract_gen(&p->step, v4l2_frmival_stepwise_obj, "step");

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_frmival_stepwise", v4l2_frmival_stepwise_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_frmival_stepwise_obj);
}

void trace_v4l2_frmivalenum_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_frmivalenum_obj = json_object_new_object();
	struct v4l2_frmivalenum *p = static_cast<struct v4l2_frmivalenum*>(arg);

	json_object_object_add(v4l2_frmivalenum_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_frmivalenum_obj, "pixel_format", json_object_new_string(val2s(p->pixel_format, v4l2_pix_fmt_val_def).c_str()));
	json_object_object_add(v4l2_frmivalenum_obj, "width", json_object_new_int64(p->width));
	json_object_object_add(v4l2_frmivalenum_obj, "height", json_object_new_int64(p->height));
	json_object_object_add(v4l2_frmivalenum_obj, "type", json_object_new_string(val2s(p->type, v4l2_frmivaltypes_val_def).c_str()));
	//union
	switch (p->type) {
	case V4L2_FRMIVAL_TYPE_DISCRETE:
		trace_v4l2_fract_gen(&p->discrete, v4l2_frmivalenum_obj);
		break;
	case V4L2_FRMIVAL_TYPE_STEPWISE:
	case V4L2_FRMIVAL_TYPE_CONTINUOUS:
		trace_v4l2_frmival_stepwise_gen(&p->stepwise, v4l2_frmivalenum_obj);
		break;
	default:
		break;
	}
	//struct v4l2_fract		discrete;
	//struct v4l2_frmival_stepwise	stepwise;
	//end of union 	};

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_frmivalenum", v4l2_frmivalenum_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_frmivalenum_obj);
}

void trace_v4l2_timecode_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_timecode_obj = json_object_new_object();
	struct v4l2_timecode *p = static_cast<struct v4l2_timecode*>(arg);

	json_object_object_add(v4l2_timecode_obj, "type", json_object_new_string(val2s(p->type, nullptr).c_str()));
	json_object_object_add(v4l2_timecode_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));
	json_object_object_add(v4l2_timecode_obj, "frames", json_object_new_int(p->frames));
	json_object_object_add(v4l2_timecode_obj, "seconds", json_object_new_int(p->seconds));
	json_object_object_add(v4l2_timecode_obj, "minutes", json_object_new_int(p->minutes));
	json_object_object_add(v4l2_timecode_obj, "hours", json_object_new_int(p->hours));
	json_object_object_add(v4l2_timecode_obj, "userbits", json_object_new_string(reinterpret_cast<const char *>(p->userbits)));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_timecode", v4l2_timecode_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_timecode_obj);
}

void trace_v4l2_jpegcompression_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_jpegcompression_obj = json_object_new_object();
	struct v4l2_jpegcompression *p = static_cast<struct v4l2_jpegcompression*>(arg);

	json_object_object_add(v4l2_jpegcompression_obj, "quality", json_object_new_int(p->quality));
	json_object_object_add(v4l2_jpegcompression_obj, "APPn", json_object_new_int(p->APPn));
	json_object_object_add(v4l2_jpegcompression_obj, "APP_len", json_object_new_int(p->APP_len));
	json_object_object_add(v4l2_jpegcompression_obj, "APP_data", json_object_new_string(reinterpret_cast<const char *>(p->APP_data)));
	json_object_object_add(v4l2_jpegcompression_obj, "COM_len", json_object_new_int(p->COM_len));
	json_object_object_add(v4l2_jpegcompression_obj, "COM_data", json_object_new_string(reinterpret_cast<const char *>(p->COM_data)));
	json_object_object_add(v4l2_jpegcompression_obj, "jpeg_markers", json_object_new_int64(p->jpeg_markers));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_jpegcompression", v4l2_jpegcompression_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_jpegcompression_obj);
}

void trace_v4l2_requestbuffers_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_requestbuffers_obj = json_object_new_object();
	struct v4l2_requestbuffers *p = static_cast<struct v4l2_requestbuffers*>(arg);

	json_object_object_add(v4l2_requestbuffers_obj, "count", json_object_new_int64(p->count));
	json_object_object_add(v4l2_requestbuffers_obj, "type", json_object_new_string(val2s(p->type, v4l2_buf_type_val_def).c_str()));
	json_object_object_add(v4l2_requestbuffers_obj, "memory", json_object_new_string(val2s(p->memory, v4l2_memory_val_def).c_str()));
	json_object_object_add(v4l2_requestbuffers_obj, "capabilities", json_object_new_string(fl2s(p->capabilities, v4l2_buf_cap_flag_def).c_str()));
	json_object_object_add(v4l2_requestbuffers_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_memory_flag_def).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_requestbuffers", v4l2_requestbuffers_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_requestbuffers_obj);
}

void trace_v4l2_plane_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_plane_obj = json_object_new_object();
	struct v4l2_plane *p = static_cast<struct v4l2_plane*>(arg);

	json_object_object_add(v4l2_plane_obj, "bytesused", json_object_new_int64(p->bytesused));
	json_object_object_add(v4l2_plane_obj, "length", json_object_new_int64(p->length));
	//union
	//__u32		mem_offset;
	//unsigned long	userptr;
	//__s32		fd;
	//end of union 	} m;
	json_object_object_add(v4l2_plane_obj, "data_offset", json_object_new_int64(p->data_offset));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_plane", v4l2_plane_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_plane_obj);
}

void trace_v4l2_buffer_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_buffer_obj = json_object_new_object();
	struct v4l2_buffer *p = static_cast<struct v4l2_buffer*>(arg);

	json_object_object_add(v4l2_buffer_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_buffer_obj, "type", json_object_new_string(val2s(p->type, v4l2_buf_type_val_def).c_str()));
	json_object_object_add(v4l2_buffer_obj, "bytesused", json_object_new_int64(p->bytesused));
	json_object_object_add(v4l2_buffer_obj, "flags", json_object_new_string(fl2s_buffer(p->flags).c_str()));
	json_object_object_add(v4l2_buffer_obj, "field", json_object_new_string(val2s(p->field, v4l2_field_val_def).c_str()));
	//struct timeval		timestamp;
	//struct v4l2_timecode	timecode;
	trace_v4l2_timecode_gen(&p->timecode, v4l2_buffer_obj, "timecode");
	json_object_object_add(v4l2_buffer_obj, "sequence", json_object_new_int64(p->sequence));
	json_object_object_add(v4l2_buffer_obj, "memory", json_object_new_string(val2s(p->memory, v4l2_memory_val_def).c_str()));
	//union
	//__u32           offset;
	//unsigned long   userptr;
	//struct v4l2_plane *planes;
	//__s32		fd;
	//end of union 	} m;
	json_object_object_add(v4l2_buffer_obj, "length", json_object_new_int64(p->length));
	//union
	//__s32		request_fd;
	//end of union 	};

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_buffer", v4l2_buffer_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_buffer_obj);
}

void trace_v4l2_exportbuffer_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_exportbuffer_obj = json_object_new_object();
	struct v4l2_exportbuffer *p = static_cast<struct v4l2_exportbuffer*>(arg);

	json_object_object_add(v4l2_exportbuffer_obj, "type", json_object_new_string(val2s(p->type, v4l2_buf_type_val_def).c_str()));
	json_object_object_add(v4l2_exportbuffer_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_exportbuffer_obj, "plane", json_object_new_int64(p->plane));
	json_object_object_add(v4l2_exportbuffer_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));
	json_object_object_add(v4l2_exportbuffer_obj, "fd", json_object_new_int(p->fd));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_exportbuffer", v4l2_exportbuffer_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_exportbuffer_obj);
}

void trace_v4l2_framebuffer_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_framebuffer_obj = json_object_new_object();
	struct v4l2_framebuffer *p = static_cast<struct v4l2_framebuffer*>(arg);

	json_object_object_add(v4l2_framebuffer_obj, "capability", json_object_new_int64(p->capability));
	json_object_object_add(v4l2_framebuffer_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));
	//void                    *base;
	//struct {
	//__u32		width;
	//__u32		height;
	//__u32		pixelformat;
	//__u32		field;
	//__u32		bytesperline;
	//__u32		sizeimage;
	//__u32		colorspace;
	//__u32		priv;
	//end of struct 	} fmt;

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_framebuffer", v4l2_framebuffer_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_framebuffer_obj);
}

void trace_v4l2_clip_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_clip_obj = json_object_new_object();
	struct v4l2_clip *p = static_cast<struct v4l2_clip*>(arg);

	//struct v4l2_rect        c;
	trace_v4l2_rect_gen(&p->c, v4l2_clip_obj, "c");
	//struct v4l2_clip	*next;

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_clip", v4l2_clip_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_clip_obj);
}

void trace_v4l2_window_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_window_obj = json_object_new_object();
	struct v4l2_window *p = static_cast<struct v4l2_window*>(arg);

	//struct v4l2_rect        w;
	trace_v4l2_rect_gen(&p->w, v4l2_window_obj, "w");
	json_object_object_add(v4l2_window_obj, "field", json_object_new_string(val2s(p->field, v4l2_field_val_def).c_str()));
	json_object_object_add(v4l2_window_obj, "chromakey", json_object_new_int64(p->chromakey));
	//struct v4l2_clip	*clips;
	json_object_object_add(v4l2_window_obj, "clipcount", json_object_new_int64(p->clipcount));
	//void			*bitmap;
	json_object_object_add(v4l2_window_obj, "global_alpha", json_object_new_int(p->global_alpha));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_window", v4l2_window_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_window_obj);
}

void trace_v4l2_captureparm_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_captureparm_obj = json_object_new_object();
	struct v4l2_captureparm *p = static_cast<struct v4l2_captureparm*>(arg);

	json_object_object_add(v4l2_captureparm_obj, "capability", json_object_new_string(val2s(p->capability, streamparm_val_def).c_str()));
	json_object_object_add(v4l2_captureparm_obj, "capturemode", json_object_new_string(val2s(p->capturemode, streamparm_val_def).c_str()));
	//struct v4l2_fract  timeperframe;
	trace_v4l2_fract_gen(&p->timeperframe, v4l2_captureparm_obj, "timeperframe");
	json_object_object_add(v4l2_captureparm_obj, "extendedmode", json_object_new_int64(p->extendedmode));
	json_object_object_add(v4l2_captureparm_obj, "readbuffers", json_object_new_int64(p->readbuffers));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_captureparm", v4l2_captureparm_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_captureparm_obj);
}

void trace_v4l2_outputparm_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_outputparm_obj = json_object_new_object();
	struct v4l2_outputparm *p = static_cast<struct v4l2_outputparm*>(arg);

	json_object_object_add(v4l2_outputparm_obj, "capability", json_object_new_string(val2s(p->capability, streamparm_val_def).c_str()));
	json_object_object_add(v4l2_outputparm_obj, "outputmode", json_object_new_string(val2s(p->outputmode, streamparm_val_def).c_str()));
	//struct v4l2_fract  timeperframe;
	trace_v4l2_fract_gen(&p->timeperframe, v4l2_outputparm_obj, "timeperframe");
	json_object_object_add(v4l2_outputparm_obj, "extendedmode", json_object_new_int64(p->extendedmode));
	json_object_object_add(v4l2_outputparm_obj, "writebuffers", json_object_new_int64(p->writebuffers));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_outputparm", v4l2_outputparm_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_outputparm_obj);
}

void trace_v4l2_cropcap_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_cropcap_obj = json_object_new_object();
	struct v4l2_cropcap *p = static_cast<struct v4l2_cropcap*>(arg);

	json_object_object_add(v4l2_cropcap_obj, "type", json_object_new_string(val2s(p->type, v4l2_buf_type_val_def).c_str()));
	//struct v4l2_rect        bounds;
	trace_v4l2_rect_gen(&p->bounds, v4l2_cropcap_obj, "bounds");
	//struct v4l2_rect        defrect;
	trace_v4l2_rect_gen(&p->defrect, v4l2_cropcap_obj, "defrect");
	//struct v4l2_fract       pixelaspect;
	trace_v4l2_fract_gen(&p->pixelaspect, v4l2_cropcap_obj, "pixelaspect");

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_cropcap", v4l2_cropcap_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_cropcap_obj);
}

void trace_v4l2_crop_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_crop_obj = json_object_new_object();
	struct v4l2_crop *p = static_cast<struct v4l2_crop*>(arg);

	json_object_object_add(v4l2_crop_obj, "type", json_object_new_string(val2s(p->type, v4l2_buf_type_val_def).c_str()));
	//struct v4l2_rect        c;
	trace_v4l2_rect_gen(&p->c, v4l2_crop_obj, "c");

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_crop", v4l2_crop_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_crop_obj);
}

void trace_v4l2_selection_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_selection_obj = json_object_new_object();
	struct v4l2_selection *p = static_cast<struct v4l2_selection*>(arg);

	json_object_object_add(v4l2_selection_obj, "type", json_object_new_string(val2s(p->type, v4l2_buf_type_val_def).c_str()));
	json_object_object_add(v4l2_selection_obj, "target", json_object_new_string(val2s(p->target, selection_target_val_def).c_str()));
	json_object_object_add(v4l2_selection_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_sel_flag_def).c_str()));
	//struct v4l2_rect        r;
	trace_v4l2_rect_gen(&p->r, v4l2_selection_obj, "r");

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_selection", v4l2_selection_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_selection_obj);
}

void trace_v4l2_standard_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_standard_obj = json_object_new_object();
	struct v4l2_standard *p = static_cast<struct v4l2_standard*>(arg);

	json_object_object_add(v4l2_standard_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_standard_obj, "id", json_object_new_string(val2s(p->id, nullptr).c_str()));
	json_object_object_add(v4l2_standard_obj, "name", json_object_new_string(reinterpret_cast<const char *>(p->name)));
	//struct v4l2_fract    frameperiod;
	trace_v4l2_fract_gen(&p->frameperiod, v4l2_standard_obj, "frameperiod");
	json_object_object_add(v4l2_standard_obj, "framelines", json_object_new_int64(p->framelines));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_standard", v4l2_standard_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_standard_obj);
}

void trace_v4l2_bt_timings_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_bt_timings_obj = json_object_new_object();
	struct v4l2_bt_timings *p = static_cast<struct v4l2_bt_timings*>(arg);

	json_object_object_add(v4l2_bt_timings_obj, "width", json_object_new_int64(p->width));
	json_object_object_add(v4l2_bt_timings_obj, "height", json_object_new_int64(p->height));
	json_object_object_add(v4l2_bt_timings_obj, "interlaced", json_object_new_int64(p->interlaced));
	json_object_object_add(v4l2_bt_timings_obj, "polarities", json_object_new_int64(p->polarities));
	json_object_object_add(v4l2_bt_timings_obj, "pixelclock", json_object_new_uint64(p->pixelclock));
	json_object_object_add(v4l2_bt_timings_obj, "hfrontporch", json_object_new_int64(p->hfrontporch));
	json_object_object_add(v4l2_bt_timings_obj, "hsync", json_object_new_int64(p->hsync));
	json_object_object_add(v4l2_bt_timings_obj, "hbackporch", json_object_new_int64(p->hbackporch));
	json_object_object_add(v4l2_bt_timings_obj, "vfrontporch", json_object_new_int64(p->vfrontporch));
	json_object_object_add(v4l2_bt_timings_obj, "vsync", json_object_new_int64(p->vsync));
	json_object_object_add(v4l2_bt_timings_obj, "vbackporch", json_object_new_int64(p->vbackporch));
	json_object_object_add(v4l2_bt_timings_obj, "il_vfrontporch", json_object_new_int64(p->il_vfrontporch));
	json_object_object_add(v4l2_bt_timings_obj, "il_vsync", json_object_new_int64(p->il_vsync));
	json_object_object_add(v4l2_bt_timings_obj, "il_vbackporch", json_object_new_int64(p->il_vbackporch));
	json_object_object_add(v4l2_bt_timings_obj, "standards", json_object_new_int64(p->standards));
	json_object_object_add(v4l2_bt_timings_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));
	//struct v4l2_fract picture_aspect;
	trace_v4l2_fract_gen(&p->picture_aspect, v4l2_bt_timings_obj, "picture_aspect");
	json_object_object_add(v4l2_bt_timings_obj, "cea861_vic", json_object_new_int(p->cea861_vic));
	json_object_object_add(v4l2_bt_timings_obj, "hdmi_vic", json_object_new_int(p->hdmi_vic));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_bt_timings", v4l2_bt_timings_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_bt_timings_obj);
}

void trace_v4l2_dv_timings_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_dv_timings_obj = json_object_new_object();
	struct v4l2_dv_timings *p = static_cast<struct v4l2_dv_timings*>(arg);

	json_object_object_add(v4l2_dv_timings_obj, "type", json_object_new_string(val2s(p->type, nullptr).c_str()));
	//union
	//struct v4l2_bt_timings	bt;
	//end of union 	};

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_dv_timings", v4l2_dv_timings_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_dv_timings_obj);
}

void trace_v4l2_enum_dv_timings_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_enum_dv_timings_obj = json_object_new_object();
	struct v4l2_enum_dv_timings *p = static_cast<struct v4l2_enum_dv_timings*>(arg);

	json_object_object_add(v4l2_enum_dv_timings_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_enum_dv_timings_obj, "pad", json_object_new_int64(p->pad));
	//struct v4l2_dv_timings timings;
	trace_v4l2_dv_timings_gen(&p->timings, v4l2_enum_dv_timings_obj, "timings");

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_enum_dv_timings", v4l2_enum_dv_timings_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_enum_dv_timings_obj);
}

void trace_v4l2_bt_timings_cap_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_bt_timings_cap_obj = json_object_new_object();
	struct v4l2_bt_timings_cap *p = static_cast<struct v4l2_bt_timings_cap*>(arg);

	json_object_object_add(v4l2_bt_timings_cap_obj, "min_width", json_object_new_int64(p->min_width));
	json_object_object_add(v4l2_bt_timings_cap_obj, "max_width", json_object_new_int64(p->max_width));
	json_object_object_add(v4l2_bt_timings_cap_obj, "min_height", json_object_new_int64(p->min_height));
	json_object_object_add(v4l2_bt_timings_cap_obj, "max_height", json_object_new_int64(p->max_height));
	json_object_object_add(v4l2_bt_timings_cap_obj, "min_pixelclock", json_object_new_uint64(p->min_pixelclock));
	json_object_object_add(v4l2_bt_timings_cap_obj, "max_pixelclock", json_object_new_uint64(p->max_pixelclock));
	json_object_object_add(v4l2_bt_timings_cap_obj, "standards", json_object_new_int64(p->standards));
	json_object_object_add(v4l2_bt_timings_cap_obj, "capabilities", json_object_new_int64(p->capabilities));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_bt_timings_cap", v4l2_bt_timings_cap_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_bt_timings_cap_obj);
}

void trace_v4l2_dv_timings_cap_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_dv_timings_cap_obj = json_object_new_object();
	struct v4l2_dv_timings_cap *p = static_cast<struct v4l2_dv_timings_cap*>(arg);

	json_object_object_add(v4l2_dv_timings_cap_obj, "type", json_object_new_string(val2s(p->type, nullptr).c_str()));
	json_object_object_add(v4l2_dv_timings_cap_obj, "pad", json_object_new_int64(p->pad));
	//union
	//struct v4l2_bt_timings_cap bt;
	//end of union 	};

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_dv_timings_cap", v4l2_dv_timings_cap_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_dv_timings_cap_obj);
}

void trace_v4l2_input_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_input_obj = json_object_new_object();
	struct v4l2_input *p = static_cast<struct v4l2_input*>(arg);

	json_object_object_add(v4l2_input_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_input_obj, "name", json_object_new_string(reinterpret_cast<const char *>(p->name)));
	json_object_object_add(v4l2_input_obj, "type", json_object_new_string(val2s(p->type, input_type_val_def).c_str()));
	json_object_object_add(v4l2_input_obj, "audioset", json_object_new_int64(p->audioset));
	json_object_object_add(v4l2_input_obj, "tuner", json_object_new_int64(p->tuner));
	json_object_object_add(v4l2_input_obj, "std", json_object_new_uint64(p->std));
	json_object_object_add(v4l2_input_obj, "status", json_object_new_int64(p->status));
	json_object_object_add(v4l2_input_obj, "capabilities", json_object_new_int64(p->capabilities));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_input", v4l2_input_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_input_obj);
}

void trace_v4l2_output_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_output_obj = json_object_new_object();
	struct v4l2_output *p = static_cast<struct v4l2_output*>(arg);

	json_object_object_add(v4l2_output_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_output_obj, "name", json_object_new_string(reinterpret_cast<const char *>(p->name)));
	json_object_object_add(v4l2_output_obj, "type", json_object_new_string(val2s(p->type, output_type_val_def).c_str()));
	json_object_object_add(v4l2_output_obj, "audioset", json_object_new_int64(p->audioset));
	json_object_object_add(v4l2_output_obj, "modulator", json_object_new_int64(p->modulator));
	json_object_object_add(v4l2_output_obj, "std", json_object_new_uint64(p->std));
	json_object_object_add(v4l2_output_obj, "capabilities", json_object_new_int64(p->capabilities));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_output", v4l2_output_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_output_obj);
}

void trace_v4l2_control_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_control_obj = json_object_new_object();
	struct v4l2_control *p = static_cast<struct v4l2_control*>(arg);

	json_object_object_add(v4l2_control_obj, "id", json_object_new_string(val2s(p->id, control_val_def).c_str()));
	json_object_object_add(v4l2_control_obj, "value", json_object_new_int(p->value));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_control", v4l2_control_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_control_obj);
}

void trace_v4l2_ext_control_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_ext_control_obj = json_object_new_object();
	struct v4l2_ext_control *p = static_cast<struct v4l2_ext_control*>(arg);

	json_object_object_add(v4l2_ext_control_obj, "id", json_object_new_string(val2s(p->id, control_val_def).c_str()));
	json_object_object_add(v4l2_ext_control_obj, "size", json_object_new_int64(p->size));
	//union
	//__s32 value;
	//__s64 value64;
	//char *string;
	//__u8 *p_u8;
	//__u16 *p_u16;
	//__u32 *p_u32;
	//__s32 *p_s32;
	//__s64 *p_s64;
	//struct v4l2_area *p_area;
	//struct v4l2_rect *p_rect;
	//struct v4l2_ctrl_h264_sps *p_h264_sps;
	//struct v4l2_ctrl_h264_pps *p_h264_pps;
	//struct v4l2_ctrl_h264_scaling_matrix *p_h264_scaling_matrix;
	//struct v4l2_ctrl_h264_pred_weights *p_h264_pred_weights;
	//struct v4l2_ctrl_h264_slice_params *p_h264_slice_params;
	//struct v4l2_ctrl_h264_decode_params *p_h264_decode_params;
	//struct v4l2_ctrl_fwht_params *p_fwht_params;
	//struct v4l2_ctrl_vp8_frame *p_vp8_frame;
	//struct v4l2_ctrl_mpeg2_sequence *p_mpeg2_sequence;
	//struct v4l2_ctrl_mpeg2_picture *p_mpeg2_picture;
	//struct v4l2_ctrl_mpeg2_quantisation *p_mpeg2_quantisation;
	//struct v4l2_ctrl_vp9_compressed_hdr *p_vp9_compressed_hdr_probs;
	//struct v4l2_ctrl_vp9_frame *p_vp9_frame;
	//struct v4l2_ctrl_hevc_sps *p_hevc_sps;
	//struct v4l2_ctrl_hevc_pps *p_hevc_pps;
	//struct v4l2_ctrl_hevc_slice_params *p_hevc_slice_params;
	//struct v4l2_ctrl_hevc_scaling_matrix *p_hevc_scaling_matrix;
	//struct v4l2_ctrl_hevc_decode_params *p_hevc_decode_params;
	//struct v4l2_ctrl_av1_sequence *p_av1_sequence;
	//struct v4l2_ctrl_av1_tile_group_entry *p_av1_tile_group_entry;
	//struct v4l2_ctrl_av1_frame *p_av1_frame;
	//struct v4l2_ctrl_av1_film_grain *p_av1_film_grain;
	//struct v4l2_ctrl_hdr10_cll_info *p_hdr10_cll_info;
	//struct v4l2_ctrl_hdr10_mastering_display *p_hdr10_mastering_display;
	//void *ptr;
	//end of union 	} __attribute__ ((packed));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_ext_control", v4l2_ext_control_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_ext_control_obj);
}

void trace_v4l2_ext_controls_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_ext_controls_obj = json_object_new_object();
	struct v4l2_ext_controls *p = static_cast<struct v4l2_ext_controls*>(arg);

	//union
	//__u32 ctrl_class;
	//__u32 which;
	//end of union 	};
	json_object_object_add(v4l2_ext_controls_obj, "count", json_object_new_int64(p->count));
	json_object_object_add(v4l2_ext_controls_obj, "error_idx", json_object_new_int64(p->error_idx));
	json_object_object_add(v4l2_ext_controls_obj, "request_fd", json_object_new_int(p->request_fd));
	//struct v4l2_ext_control *controls;

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_ext_controls", v4l2_ext_controls_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_ext_controls_obj);
}

void trace_v4l2_queryctrl_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_queryctrl_obj = json_object_new_object();
	struct v4l2_queryctrl *p = static_cast<struct v4l2_queryctrl*>(arg);

	json_object_object_add(v4l2_queryctrl_obj, "id", json_object_new_string(val2s(p->id, control_val_def).c_str()));
	json_object_object_add(v4l2_queryctrl_obj, "type", json_object_new_string(val2s(p->type, v4l2_ctrl_type_val_def).c_str()));
	json_object_object_add(v4l2_queryctrl_obj, "name", json_object_new_string(reinterpret_cast<const char *>(p->name)));
	json_object_object_add(v4l2_queryctrl_obj, "minimum", json_object_new_int(p->minimum));
	json_object_object_add(v4l2_queryctrl_obj, "maximum", json_object_new_int(p->maximum));
	json_object_object_add(v4l2_queryctrl_obj, "step", json_object_new_int(p->step));
	json_object_object_add(v4l2_queryctrl_obj, "default_value", json_object_new_int(p->default_value));
	json_object_object_add(v4l2_queryctrl_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_ctrl_flag_def).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_queryctrl", v4l2_queryctrl_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_queryctrl_obj);
}

void trace_v4l2_query_ext_ctrl_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_query_ext_ctrl_obj = json_object_new_object();
	struct v4l2_query_ext_ctrl *p = static_cast<struct v4l2_query_ext_ctrl*>(arg);

	json_object_object_add(v4l2_query_ext_ctrl_obj, "id", json_object_new_string(val2s(p->id, control_val_def).c_str()));
	json_object_object_add(v4l2_query_ext_ctrl_obj, "type", json_object_new_string(val2s(p->type, v4l2_ctrl_type_val_def).c_str()));
	json_object_object_add(v4l2_query_ext_ctrl_obj, "name", json_object_new_string(reinterpret_cast<const char *>(p->name)));
	json_object_object_add(v4l2_query_ext_ctrl_obj, "minimum", json_object_new_int64(p->minimum));
	json_object_object_add(v4l2_query_ext_ctrl_obj, "maximum", json_object_new_int64(p->maximum));
	json_object_object_add(v4l2_query_ext_ctrl_obj, "step", json_object_new_uint64(p->step));
	json_object_object_add(v4l2_query_ext_ctrl_obj, "default_value", json_object_new_int64(p->default_value));
	json_object_object_add(v4l2_query_ext_ctrl_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_ctrl_flag_def).c_str()));
	json_object_object_add(v4l2_query_ext_ctrl_obj, "elem_size", json_object_new_int64(p->elem_size));
	json_object_object_add(v4l2_query_ext_ctrl_obj, "elems", json_object_new_int64(p->elems));
	json_object_object_add(v4l2_query_ext_ctrl_obj, "nr_of_dims", json_object_new_int64(p->nr_of_dims));
	/* __u32                dims[V4L2_CTRL_MAX_DIMS]; */
	json_object *dims_obj = json_object_new_array();
	for (int i = 0; i < (std::min((int) p->nr_of_dims, V4L2_CTRL_MAX_DIMS)); i++) {
		json_object_array_add(dims_obj, json_object_new_int64(p->dims[i]));
	}
	json_object_object_add(v4l2_query_ext_ctrl_obj, "dims", dims_obj);

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_query_ext_ctrl", v4l2_query_ext_ctrl_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_query_ext_ctrl_obj);
}

void trace_v4l2_querymenu_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_querymenu_obj = json_object_new_object();
	struct v4l2_querymenu *p = static_cast<struct v4l2_querymenu*>(arg);

	json_object_object_add(v4l2_querymenu_obj, "id", json_object_new_string(val2s(p->id, control_val_def).c_str()));
	json_object_object_add(v4l2_querymenu_obj, "index", json_object_new_int64(p->index));
	//union
	//__u8	name[32];
	//__s64	value;
	//end of union 	};

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_querymenu", v4l2_querymenu_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_querymenu_obj);
}

void trace_v4l2_tuner_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_tuner_obj = json_object_new_object();
	struct v4l2_tuner *p = static_cast<struct v4l2_tuner*>(arg);

	json_object_object_add(v4l2_tuner_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_tuner_obj, "name", json_object_new_string(reinterpret_cast<const char *>(p->name)));
	json_object_object_add(v4l2_tuner_obj, "type", json_object_new_string(val2s(p->type, v4l2_tuner_type_val_def).c_str()));
	json_object_object_add(v4l2_tuner_obj, "capability", json_object_new_string(fl2s(p->capability, tuner_cap_flag_def).c_str()));
	json_object_object_add(v4l2_tuner_obj, "rangelow", json_object_new_int64(p->rangelow));
	json_object_object_add(v4l2_tuner_obj, "rangehigh", json_object_new_int64(p->rangehigh));
	json_object_object_add(v4l2_tuner_obj, "rxsubchans", json_object_new_string(fl2s(p->rxsubchans, tuner_rxsub_flag_def).c_str()));
	json_object_object_add(v4l2_tuner_obj, "audmode", json_object_new_string(val2s(p->audmode, tuner_audmode_val_def).c_str()));
	json_object_object_add(v4l2_tuner_obj, "signal", json_object_new_int(p->signal));
	json_object_object_add(v4l2_tuner_obj, "afc", json_object_new_int(p->afc));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_tuner", v4l2_tuner_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_tuner_obj);
}

void trace_v4l2_modulator_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_modulator_obj = json_object_new_object();
	struct v4l2_modulator *p = static_cast<struct v4l2_modulator*>(arg);

	json_object_object_add(v4l2_modulator_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_modulator_obj, "name", json_object_new_string(reinterpret_cast<const char *>(p->name)));
	json_object_object_add(v4l2_modulator_obj, "capability", json_object_new_int64(p->capability));
	json_object_object_add(v4l2_modulator_obj, "rangelow", json_object_new_int64(p->rangelow));
	json_object_object_add(v4l2_modulator_obj, "rangehigh", json_object_new_int64(p->rangehigh));
	json_object_object_add(v4l2_modulator_obj, "txsubchans", json_object_new_int64(p->txsubchans));
	json_object_object_add(v4l2_modulator_obj, "type", json_object_new_string(val2s(p->type, nullptr).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_modulator", v4l2_modulator_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_modulator_obj);
}

void trace_v4l2_frequency_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_frequency_obj = json_object_new_object();
	struct v4l2_frequency *p = static_cast<struct v4l2_frequency*>(arg);

	json_object_object_add(v4l2_frequency_obj, "tuner", json_object_new_int64(p->tuner));
	json_object_object_add(v4l2_frequency_obj, "type", json_object_new_string(val2s(p->type, v4l2_tuner_type_val_def).c_str()));
	json_object_object_add(v4l2_frequency_obj, "frequency", json_object_new_int64(p->frequency));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_frequency", v4l2_frequency_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_frequency_obj);
}

void trace_v4l2_frequency_band_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_frequency_band_obj = json_object_new_object();
	struct v4l2_frequency_band *p = static_cast<struct v4l2_frequency_band*>(arg);

	json_object_object_add(v4l2_frequency_band_obj, "tuner", json_object_new_int64(p->tuner));
	json_object_object_add(v4l2_frequency_band_obj, "type", json_object_new_string(val2s(p->type, nullptr).c_str()));
	json_object_object_add(v4l2_frequency_band_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_frequency_band_obj, "capability", json_object_new_int64(p->capability));
	json_object_object_add(v4l2_frequency_band_obj, "rangelow", json_object_new_int64(p->rangelow));
	json_object_object_add(v4l2_frequency_band_obj, "rangehigh", json_object_new_int64(p->rangehigh));
	json_object_object_add(v4l2_frequency_band_obj, "modulation", json_object_new_int64(p->modulation));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_frequency_band", v4l2_frequency_band_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_frequency_band_obj);
}

void trace_v4l2_hw_freq_seek_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_hw_freq_seek_obj = json_object_new_object();
	struct v4l2_hw_freq_seek *p = static_cast<struct v4l2_hw_freq_seek*>(arg);

	json_object_object_add(v4l2_hw_freq_seek_obj, "tuner", json_object_new_int64(p->tuner));
	json_object_object_add(v4l2_hw_freq_seek_obj, "type", json_object_new_string(val2s(p->type, nullptr).c_str()));
	json_object_object_add(v4l2_hw_freq_seek_obj, "seek_upward", json_object_new_int64(p->seek_upward));
	json_object_object_add(v4l2_hw_freq_seek_obj, "wrap_around", json_object_new_int64(p->wrap_around));
	json_object_object_add(v4l2_hw_freq_seek_obj, "spacing", json_object_new_int64(p->spacing));
	json_object_object_add(v4l2_hw_freq_seek_obj, "rangelow", json_object_new_int64(p->rangelow));
	json_object_object_add(v4l2_hw_freq_seek_obj, "rangehigh", json_object_new_int64(p->rangehigh));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_hw_freq_seek", v4l2_hw_freq_seek_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_hw_freq_seek_obj);
}

void trace_v4l2_rds_data_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_rds_data_obj = json_object_new_object();
	struct v4l2_rds_data *p = static_cast<struct v4l2_rds_data*>(arg);

	json_object_object_add(v4l2_rds_data_obj, "lsb", json_object_new_int(p->lsb));
	json_object_object_add(v4l2_rds_data_obj, "msb", json_object_new_int(p->msb));
	json_object_object_add(v4l2_rds_data_obj, "block", json_object_new_int(p->block));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_rds_data", v4l2_rds_data_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_rds_data_obj);
}

void trace_v4l2_audio_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_audio_obj = json_object_new_object();
	struct v4l2_audio *p = static_cast<struct v4l2_audio*>(arg);

	json_object_object_add(v4l2_audio_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_audio_obj, "name", json_object_new_string(reinterpret_cast<const char *>(p->name)));
	json_object_object_add(v4l2_audio_obj, "capability", json_object_new_int64(p->capability));
	json_object_object_add(v4l2_audio_obj, "mode", json_object_new_int64(p->mode));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_audio", v4l2_audio_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_audio_obj);
}

void trace_v4l2_audioout_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_audioout_obj = json_object_new_object();
	struct v4l2_audioout *p = static_cast<struct v4l2_audioout*>(arg);

	json_object_object_add(v4l2_audioout_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_audioout_obj, "name", json_object_new_string(reinterpret_cast<const char *>(p->name)));
	json_object_object_add(v4l2_audioout_obj, "capability", json_object_new_int64(p->capability));
	json_object_object_add(v4l2_audioout_obj, "mode", json_object_new_int64(p->mode));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_audioout", v4l2_audioout_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_audioout_obj);
}

void trace_v4l2_enc_idx_entry_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_enc_idx_entry_obj = json_object_new_object();
	struct v4l2_enc_idx_entry *p = static_cast<struct v4l2_enc_idx_entry*>(arg);

	json_object_object_add(v4l2_enc_idx_entry_obj, "offset", json_object_new_uint64(p->offset));
	json_object_object_add(v4l2_enc_idx_entry_obj, "pts", json_object_new_uint64(p->pts));
	json_object_object_add(v4l2_enc_idx_entry_obj, "length", json_object_new_int64(p->length));
	json_object_object_add(v4l2_enc_idx_entry_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_enc_idx_entry", v4l2_enc_idx_entry_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_enc_idx_entry_obj);
}

void trace_v4l2_enc_idx_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_enc_idx_obj = json_object_new_object();
	struct v4l2_enc_idx *p = static_cast<struct v4l2_enc_idx*>(arg);

	json_object_object_add(v4l2_enc_idx_obj, "entries", json_object_new_int64(p->entries));
	json_object_object_add(v4l2_enc_idx_obj, "entries_cap", json_object_new_int64(p->entries_cap));
	//struct v4l2_enc_idx_entry entry[V4L2_ENC_IDX_ENTRIES];

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_enc_idx", v4l2_enc_idx_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_enc_idx_obj);
}

void trace_v4l2_encoder_cmd_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_encoder_cmd_obj = json_object_new_object();
	struct v4l2_encoder_cmd *p = static_cast<struct v4l2_encoder_cmd*>(arg);

	json_object_object_add(v4l2_encoder_cmd_obj, "cmd", json_object_new_string(val2s(p->cmd, encoder_cmd_val_def).c_str()));
	json_object_object_add(v4l2_encoder_cmd_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));
	//union
	//struct {
	//__u32 data[8];
	//end of union 		} raw;

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_encoder_cmd", v4l2_encoder_cmd_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_encoder_cmd_obj);
}

void trace_v4l2_decoder_cmd_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_decoder_cmd_obj = json_object_new_object();
	struct v4l2_decoder_cmd *p = static_cast<struct v4l2_decoder_cmd*>(arg);

	json_object_object_add(v4l2_decoder_cmd_obj, "cmd", json_object_new_string(val2s(p->cmd, decoder_cmd_val_def).c_str()));
	json_object_object_add(v4l2_decoder_cmd_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));
	//union
	//struct {
	//__u64 pts;
	//end of union 		} stop;
	//struct {
	//__s32 speed;
	//__u32 format;
	//end of struct 		} start;
	//struct {
	//__u32 data[16];
	//end of struct 		} raw;

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_decoder_cmd", v4l2_decoder_cmd_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_decoder_cmd_obj);
}

void trace_v4l2_vbi_format_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_vbi_format_obj = json_object_new_object();
	struct v4l2_vbi_format *p = static_cast<struct v4l2_vbi_format*>(arg);

	json_object_object_add(v4l2_vbi_format_obj, "sampling_rate", json_object_new_int64(p->sampling_rate));
	json_object_object_add(v4l2_vbi_format_obj, "offset", json_object_new_int64(p->offset));
	json_object_object_add(v4l2_vbi_format_obj, "samples_per_line", json_object_new_int64(p->samples_per_line));
	json_object_object_add(v4l2_vbi_format_obj, "sample_format", json_object_new_int64(p->sample_format));
	json_object_object_add(v4l2_vbi_format_obj, "start", json_object_new_string(reinterpret_cast<const char *>(p->start)));
	json_object_object_add(v4l2_vbi_format_obj, "count", json_object_new_string(reinterpret_cast<const char *>(p->count)));
	json_object_object_add(v4l2_vbi_format_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_vbi_format", v4l2_vbi_format_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_vbi_format_obj);
}

void trace_v4l2_sliced_vbi_format_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_sliced_vbi_format_obj = json_object_new_object();
	struct v4l2_sliced_vbi_format *p = static_cast<struct v4l2_sliced_vbi_format*>(arg);

	json_object_object_add(v4l2_sliced_vbi_format_obj, "service_set", json_object_new_int(p->service_set));
	//__u16   service_lines[2][24];
	json_object_object_add(v4l2_sliced_vbi_format_obj, "io_size", json_object_new_int64(p->io_size));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_sliced_vbi_format", v4l2_sliced_vbi_format_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_sliced_vbi_format_obj);
}

void trace_v4l2_sliced_vbi_cap_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_sliced_vbi_cap_obj = json_object_new_object();
	struct v4l2_sliced_vbi_cap *p = static_cast<struct v4l2_sliced_vbi_cap*>(arg);

	json_object_object_add(v4l2_sliced_vbi_cap_obj, "service_set", json_object_new_int(p->service_set));
	//__u16   service_lines[2][24];
	json_object_object_add(v4l2_sliced_vbi_cap_obj, "type", json_object_new_string(val2s(p->type, v4l2_buf_type_val_def).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_sliced_vbi_cap", v4l2_sliced_vbi_cap_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_sliced_vbi_cap_obj);
}

void trace_v4l2_sliced_vbi_data_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_sliced_vbi_data_obj = json_object_new_object();
	struct v4l2_sliced_vbi_data *p = static_cast<struct v4l2_sliced_vbi_data*>(arg);

	json_object_object_add(v4l2_sliced_vbi_data_obj, "id", json_object_new_string(val2s(p->id, nullptr).c_str()));
	json_object_object_add(v4l2_sliced_vbi_data_obj, "field", json_object_new_string(val2s(p->field, nullptr).c_str()));
	json_object_object_add(v4l2_sliced_vbi_data_obj, "line", json_object_new_int64(p->line));
	json_object_object_add(v4l2_sliced_vbi_data_obj, "data", json_object_new_string(reinterpret_cast<const char *>(p->data)));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_sliced_vbi_data", v4l2_sliced_vbi_data_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_sliced_vbi_data_obj);
}

void trace_v4l2_mpeg_vbi_itv0_line_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_mpeg_vbi_itv0_line_obj = json_object_new_object();
	struct v4l2_mpeg_vbi_itv0_line *p = static_cast<struct v4l2_mpeg_vbi_itv0_line*>(arg);

	json_object_object_add(v4l2_mpeg_vbi_itv0_line_obj, "id", json_object_new_string(val2s(p->id, nullptr).c_str()));
	json_object_object_add(v4l2_mpeg_vbi_itv0_line_obj, "data", json_object_new_string(reinterpret_cast<const char *>(p->data)));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_mpeg_vbi_itv0_line", v4l2_mpeg_vbi_itv0_line_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_mpeg_vbi_itv0_line_obj);
}

void trace_v4l2_mpeg_vbi_itv0_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_mpeg_vbi_itv0_obj = json_object_new_object();
	struct v4l2_mpeg_vbi_itv0 *p = static_cast<struct v4l2_mpeg_vbi_itv0*>(arg);

	json_object_object_add(v4l2_mpeg_vbi_itv0_obj, "linemask", json_object_new_string(reinterpret_cast<const char *>(p->linemask)));
	//struct v4l2_mpeg_vbi_itv0_line line[35];

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_mpeg_vbi_itv0", v4l2_mpeg_vbi_itv0_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_mpeg_vbi_itv0_obj);
}

void trace_v4l2_mpeg_vbi_fmt_ivtv_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_mpeg_vbi_fmt_ivtv_obj = json_object_new_object();
	struct v4l2_mpeg_vbi_fmt_ivtv *p = static_cast<struct v4l2_mpeg_vbi_fmt_ivtv*>(arg);

	json_object_object_add(v4l2_mpeg_vbi_fmt_ivtv_obj, "magic", json_object_new_string(reinterpret_cast<const char *>(p->magic)));
	//union
	//struct v4l2_mpeg_vbi_itv0 itv0;
	//struct v4l2_mpeg_vbi_ITV0 ITV0;
	//end of union 	};

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_mpeg_vbi_fmt_ivtv", v4l2_mpeg_vbi_fmt_ivtv_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_mpeg_vbi_fmt_ivtv_obj);
}

void trace_v4l2_plane_pix_format_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_plane_pix_format_obj = json_object_new_object();
	struct v4l2_plane_pix_format *p = static_cast<struct v4l2_plane_pix_format*>(arg);

	json_object_object_add(v4l2_plane_pix_format_obj, "sizeimage", json_object_new_int64(p->sizeimage));
	json_object_object_add(v4l2_plane_pix_format_obj, "bytesperline", json_object_new_int64(p->bytesperline));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_plane_pix_format", v4l2_plane_pix_format_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_plane_pix_format_obj);
}

void trace_v4l2_pix_format_mplane_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_pix_format_mplane_obj = json_object_new_object();
	struct v4l2_pix_format_mplane *p = static_cast<struct v4l2_pix_format_mplane*>(arg);

	json_object_object_add(v4l2_pix_format_mplane_obj, "width", json_object_new_int64(p->width));
	json_object_object_add(v4l2_pix_format_mplane_obj, "height", json_object_new_int64(p->height));
	json_object_object_add(v4l2_pix_format_mplane_obj, "pixelformat", json_object_new_string(val2s(p->pixelformat, v4l2_pix_fmt_val_def).c_str()));
	json_object_object_add(v4l2_pix_format_mplane_obj, "field", json_object_new_string(val2s(p->field, v4l2_field_val_def).c_str()));
	json_object_object_add(v4l2_pix_format_mplane_obj, "colorspace", json_object_new_string(val2s(p->colorspace, v4l2_colorspace_val_def).c_str()));
	//struct v4l2_plane_pix_format	plane_fmt[VIDEO_MAX_PLANES];
	json_object_object_add(v4l2_pix_format_mplane_obj, "num_planes", json_object_new_int(p->num_planes));
	json_object *plane_fmt_obj = json_object_new_array();
	for (int i = 0; i < (std::min((int) p->num_planes, VIDEO_MAX_PLANES)); i++) {
		json_object *element_obj = json_object_new_object();
		trace_v4l2_plane_pix_format_gen(&(p->plane_fmt[i]), element_obj);
		json_object *element_no_key_obj;
		json_object_object_get_ex(element_obj, "v4l2_plane_pix_format", &element_no_key_obj);
		json_object_array_add(plane_fmt_obj, element_no_key_obj);
	}
	json_object_object_add(v4l2_pix_format_mplane_obj, "plane_fmt", plane_fmt_obj);

	json_object_object_add(v4l2_pix_format_mplane_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_pix_fmt_flag_def).c_str()));
	//union
	json_object_object_add(v4l2_pix_format_mplane_obj, "ycbcr_enc", json_object_new_string(val2s(p->ycbcr_enc, v4l2_ycbcr_encoding_val_def).c_str()));
	json_object_object_add(v4l2_pix_format_mplane_obj, "hsv_enc", json_object_new_int(p->hsv_enc));
	//end of union 	};
	json_object_object_add(v4l2_pix_format_mplane_obj, "quantization", json_object_new_string(val2s(p->quantization, v4l2_quantization_val_def).c_str()));
	json_object_object_add(v4l2_pix_format_mplane_obj, "xfer_func", json_object_new_string(val2s(p->xfer_func, v4l2_xfer_func_val_def).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_pix_format_mplane", v4l2_pix_format_mplane_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_pix_format_mplane_obj);
}

void trace_v4l2_sdr_format_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_sdr_format_obj = json_object_new_object();
	struct v4l2_sdr_format *p = static_cast<struct v4l2_sdr_format*>(arg);

	json_object_object_add(v4l2_sdr_format_obj, "pixelformat", json_object_new_string(val2s(p->pixelformat, v4l2_pix_fmt_val_def).c_str()));
	json_object_object_add(v4l2_sdr_format_obj, "buffersize", json_object_new_int64(p->buffersize));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_sdr_format", v4l2_sdr_format_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_sdr_format_obj);
}

void trace_v4l2_meta_format_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_meta_format_obj = json_object_new_object();
	struct v4l2_meta_format *p = static_cast<struct v4l2_meta_format*>(arg);

	json_object_object_add(v4l2_meta_format_obj, "dataformat", json_object_new_int64(p->dataformat));
	json_object_object_add(v4l2_meta_format_obj, "buffersize", json_object_new_int64(p->buffersize));
	json_object_object_add(v4l2_meta_format_obj, "width", json_object_new_int64(p->width));
	json_object_object_add(v4l2_meta_format_obj, "height", json_object_new_int64(p->height));
	json_object_object_add(v4l2_meta_format_obj, "bytesperline", json_object_new_int64(p->bytesperline));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_meta_format", v4l2_meta_format_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_meta_format_obj);
}

void trace_v4l2_format_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_format_obj = json_object_new_object();
	struct v4l2_format *p = static_cast<struct v4l2_format*>(arg);

	json_object_object_add(v4l2_format_obj, "type", json_object_new_string(val2s(p->type, v4l2_buf_type_val_def).c_str()));
	//union
	switch (p->type) {
	case V4L2_BUF_TYPE_VIDEO_CAPTURE:
	case V4L2_BUF_TYPE_VIDEO_OUTPUT:
		trace_v4l2_pix_format_gen(&p->fmt.pix, v4l2_format_obj);
		break;
	case V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE:
	case V4L2_BUF_TYPE_VIDEO_OUTPUT_MPLANE:
		trace_v4l2_pix_format_mplane_gen(&p->fmt.pix, v4l2_format_obj);
		break;
	default:
		break;
	}
	//struct v4l2_pix_format		pix;
	//struct v4l2_pix_format_mplane	pix_mp;
	//struct v4l2_window		win;
	//struct v4l2_vbi_format		vbi;
	//struct v4l2_sliced_vbi_format	sliced;
	//struct v4l2_sdr_format		sdr;
	//struct v4l2_meta_format		meta;
	//end of union 	} fmt;

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_format", v4l2_format_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_format_obj);
}

void trace_v4l2_streamparm_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_streamparm_obj = json_object_new_object();
	struct v4l2_streamparm *p = static_cast<struct v4l2_streamparm*>(arg);

	json_object_object_add(v4l2_streamparm_obj, "type", json_object_new_string(val2s(p->type, v4l2_buf_type_val_def).c_str()));
	//union
	//struct v4l2_captureparm	capture;
	//struct v4l2_outputparm	output;
	//end of union 	} parm;

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_streamparm", v4l2_streamparm_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_streamparm_obj);
}

void trace_v4l2_event_vsync_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_event_vsync_obj = json_object_new_object();
	struct v4l2_event_vsync *p = static_cast<struct v4l2_event_vsync*>(arg);

	json_object_object_add(v4l2_event_vsync_obj, "field", json_object_new_string(val2s(p->field, v4l2_field_val_def).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_event_vsync", v4l2_event_vsync_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_event_vsync_obj);
}

void trace_v4l2_event_ctrl_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_event_ctrl_obj = json_object_new_object();
	struct v4l2_event_ctrl *p = static_cast<struct v4l2_event_ctrl*>(arg);

	json_object_object_add(v4l2_event_ctrl_obj, "changes", json_object_new_string(fl2s(p->changes, v4l2_event_ctrl_ch_flag_def).c_str()));
	json_object_object_add(v4l2_event_ctrl_obj, "type", json_object_new_string(val2s(p->type, v4l2_ctrl_type_val_def).c_str()));
	//union
	//__s32 value;
	//__s64 value64;
	//end of union 	};
	json_object_object_add(v4l2_event_ctrl_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_ctrl_flag_def).c_str()));
	json_object_object_add(v4l2_event_ctrl_obj, "minimum", json_object_new_int(p->minimum));
	json_object_object_add(v4l2_event_ctrl_obj, "maximum", json_object_new_int(p->maximum));
	json_object_object_add(v4l2_event_ctrl_obj, "step", json_object_new_int(p->step));
	json_object_object_add(v4l2_event_ctrl_obj, "default_value", json_object_new_int(p->default_value));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_event_ctrl", v4l2_event_ctrl_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_event_ctrl_obj);
}

void trace_v4l2_event_frame_sync_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_event_frame_sync_obj = json_object_new_object();
	struct v4l2_event_frame_sync *p = static_cast<struct v4l2_event_frame_sync*>(arg);

	json_object_object_add(v4l2_event_frame_sync_obj, "frame_sequence", json_object_new_int64(p->frame_sequence));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_event_frame_sync", v4l2_event_frame_sync_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_event_frame_sync_obj);
}

void trace_v4l2_event_src_change_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_event_src_change_obj = json_object_new_object();
	struct v4l2_event_src_change *p = static_cast<struct v4l2_event_src_change*>(arg);

	json_object_object_add(v4l2_event_src_change_obj, "changes", json_object_new_int64(p->changes));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_event_src_change", v4l2_event_src_change_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_event_src_change_obj);
}

void trace_v4l2_event_motion_det_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_event_motion_det_obj = json_object_new_object();
	struct v4l2_event_motion_det *p = static_cast<struct v4l2_event_motion_det*>(arg);

	json_object_object_add(v4l2_event_motion_det_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));
	json_object_object_add(v4l2_event_motion_det_obj, "frame_sequence", json_object_new_int64(p->frame_sequence));
	json_object_object_add(v4l2_event_motion_det_obj, "region_mask", json_object_new_int64(p->region_mask));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_event_motion_det", v4l2_event_motion_det_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_event_motion_det_obj);
}

void trace_v4l2_event_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_event_obj = json_object_new_object();
	struct v4l2_event *p = static_cast<struct v4l2_event*>(arg);

	json_object_object_add(v4l2_event_obj, "type", json_object_new_string(val2s(p->type, event_val_def).c_str()));
	//union
	switch (p->type) {
	case V4L2_EVENT_VSYNC:
		trace_v4l2_event_vsync_gen(&p->u, v4l2_event_obj);
		break;
	case V4L2_EVENT_CTRL:
		trace_v4l2_event_ctrl_gen(&p->u, v4l2_event_obj);
		break;
	case V4L2_EVENT_FRAME_SYNC:
		trace_v4l2_event_frame_sync_gen(&p->u, v4l2_event_obj);
		break;
	case V4L2_EVENT_SOURCE_CHANGE:
		trace_v4l2_event_src_change_gen(&p->u, v4l2_event_obj);
		break;
	case V4L2_EVENT_MOTION_DET:
		trace_v4l2_event_motion_det_gen(&p->u, v4l2_event_obj);
		break;
	default:
		break;
	}
	//struct v4l2_event_vsync		vsync;
	//struct v4l2_event_ctrl		ctrl;
	//struct v4l2_event_frame_sync	frame_sync;
	//struct v4l2_event_src_change	src_change;
	//struct v4l2_event_motion_det	motion_det;
	//__u8				data[64];
	//end of union 	} u;
	json_object_object_add(v4l2_event_obj, "pending", json_object_new_int64(p->pending));
	json_object_object_add(v4l2_event_obj, "sequence", json_object_new_int64(p->sequence));
	//struct timespec			timestamp;
	json_object_object_add(v4l2_event_obj, "id", json_object_new_string(val2s(p->id, nullptr).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_event", v4l2_event_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_event_obj);
}

void trace_v4l2_event_subscription_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_event_subscription_obj = json_object_new_object();
	struct v4l2_event_subscription *p = static_cast<struct v4l2_event_subscription*>(arg);

	json_object_object_add(v4l2_event_subscription_obj, "type", json_object_new_string(val2s(p->type, event_val_def).c_str()));
	json_object_object_add(v4l2_event_subscription_obj, "id", json_object_new_string(val2s(p->id, nullptr).c_str()));
	json_object_object_add(v4l2_event_subscription_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_event_sub_flag_def).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_event_subscription", v4l2_event_subscription_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_event_subscription_obj);
}

void trace_v4l2_dbg_match_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_dbg_match_obj = json_object_new_object();
	struct v4l2_dbg_match *p = static_cast<struct v4l2_dbg_match*>(arg);

	json_object_object_add(v4l2_dbg_match_obj, "type", json_object_new_string(val2s(p->type, nullptr).c_str()));
	//union
	//__u32 addr;
	//char name[32];
	//end of union 	};

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_dbg_match", v4l2_dbg_match_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_dbg_match_obj);
}

void trace_v4l2_dbg_register_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_dbg_register_obj = json_object_new_object();
	struct v4l2_dbg_register *p = static_cast<struct v4l2_dbg_register*>(arg);

	//struct v4l2_dbg_match match;
	trace_v4l2_dbg_match_gen(&p->match, v4l2_dbg_register_obj, "match");
	json_object_object_add(v4l2_dbg_register_obj, "size", json_object_new_int64(p->size));
	json_object_object_add(v4l2_dbg_register_obj, "reg", json_object_new_uint64(p->reg));
	json_object_object_add(v4l2_dbg_register_obj, "val", json_object_new_uint64(p->val));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_dbg_register", v4l2_dbg_register_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_dbg_register_obj);
}

void trace_v4l2_dbg_chip_info_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_dbg_chip_info_obj = json_object_new_object();
	struct v4l2_dbg_chip_info *p = static_cast<struct v4l2_dbg_chip_info*>(arg);

	//struct v4l2_dbg_match match;
	trace_v4l2_dbg_match_gen(&p->match, v4l2_dbg_chip_info_obj, "match");
	json_object_object_add(v4l2_dbg_chip_info_obj, "name", json_object_new_string(reinterpret_cast<const char *>(p->name)));
	json_object_object_add(v4l2_dbg_chip_info_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_dbg_chip_info", v4l2_dbg_chip_info_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_dbg_chip_info_obj);
}

void trace_v4l2_create_buffers_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_create_buffers_obj = json_object_new_object();
	struct v4l2_create_buffers *p = static_cast<struct v4l2_create_buffers*>(arg);

	json_object_object_add(v4l2_create_buffers_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_create_buffers_obj, "count", json_object_new_int64(p->count));
	json_object_object_add(v4l2_create_buffers_obj, "memory", json_object_new_string(val2s(p->memory, v4l2_memory_val_def).c_str()));
	//struct v4l2_format	format;
	trace_v4l2_format_gen(&p->format, v4l2_create_buffers_obj, "format");
	json_object_object_add(v4l2_create_buffers_obj, "capabilities", json_object_new_string(fl2s(p->capabilities, v4l2_buf_cap_flag_def).c_str()));
	json_object_object_add(v4l2_create_buffers_obj, "flags", json_object_new_string(fl2s(p->flags, v4l2_memory_flag_def).c_str()));
	json_object_object_add(v4l2_create_buffers_obj, "max_num_buffers", json_object_new_int64(p->max_num_buffers));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_create_buffers", v4l2_create_buffers_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_create_buffers_obj);
}

void trace_v4l2_remove_buffers_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_remove_buffers_obj = json_object_new_object();
	struct v4l2_remove_buffers *p = static_cast<struct v4l2_remove_buffers*>(arg);

	json_object_object_add(v4l2_remove_buffers_obj, "index", json_object_new_int64(p->index));
	json_object_object_add(v4l2_remove_buffers_obj, "count", json_object_new_int64(p->count));
	json_object_object_add(v4l2_remove_buffers_obj, "type", json_object_new_string(val2s(p->type, nullptr).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_remove_buffers", v4l2_remove_buffers_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_remove_buffers_obj);
}

void trace_media_device_info_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *media_device_info_obj = json_object_new_object();
	struct media_device_info *p = static_cast<struct media_device_info*>(arg);

	json_object_object_add(media_device_info_obj, "driver", json_object_new_string(reinterpret_cast<const char *>(p->driver)));
	json_object_object_add(media_device_info_obj, "model", json_object_new_string(reinterpret_cast<const char *>(p->model)));
	json_object_object_add(media_device_info_obj, "serial", json_object_new_string(reinterpret_cast<const char *>(p->serial)));
	json_object_object_add(media_device_info_obj, "bus_info", json_object_new_string(reinterpret_cast<const char *>(p->bus_info)));
	json_object_object_add(media_device_info_obj, "media_version", json_object_new_string(ver2s(p->media_version).c_str()));
	json_object_object_add(media_device_info_obj, "hw_revision", json_object_new_int64(p->hw_revision));
	json_object_object_add(media_device_info_obj, "driver_version", json_object_new_string(ver2s(p->driver_version).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "media_device_info", media_device_info_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), media_device_info_obj);
}

void trace_media_entity_desc_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *media_entity_desc_obj = json_object_new_object();
	struct media_entity_desc *p = static_cast<struct media_entity_desc*>(arg);

	json_object_object_add(media_entity_desc_obj, "id", json_object_new_string(val2s(p->id, nullptr).c_str()));
	json_object_object_add(media_entity_desc_obj, "name", json_object_new_string(reinterpret_cast<const char *>(p->name)));
	json_object_object_add(media_entity_desc_obj, "type", json_object_new_string(val2s(p->type, nullptr).c_str()));
	json_object_object_add(media_entity_desc_obj, "revision", json_object_new_int64(p->revision));
	json_object_object_add(media_entity_desc_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));
	json_object_object_add(media_entity_desc_obj, "group_id", json_object_new_int64(p->group_id));
	json_object_object_add(media_entity_desc_obj, "pads", json_object_new_int(p->pads));
	json_object_object_add(media_entity_desc_obj, "links", json_object_new_int(p->links));
	//union
	//struct {
	//__u32 major;
	//__u32 minor;
	//end of union 		} dev;
	//struct {
	//__u32 card;
	//__u32 device;
	//__u32 subdevice;
	//end of struct 		} alsa;
	//struct {
	//__u32 major;
	//__u32 minor;
	//end of struct 		} v4l;
	//struct {
	//__u32 major;
	//__u32 minor;
	//end of struct 		} fb;
	json_object_object_add(media_entity_desc_obj, "dvb", json_object_new_int(p->dvb));
	json_object_object_add(media_entity_desc_obj, "raw", json_object_new_string(reinterpret_cast<const char *>(p->raw)));

	if (key_name.empty())
		json_object_object_add(parent_obj, "media_entity_desc", media_entity_desc_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), media_entity_desc_obj);
}

void trace_media_pad_desc_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *media_pad_desc_obj = json_object_new_object();
	struct media_pad_desc *p = static_cast<struct media_pad_desc*>(arg);

	json_object_object_add(media_pad_desc_obj, "entity", json_object_new_int64(p->entity));
	json_object_object_add(media_pad_desc_obj, "index", json_object_new_int(p->index));
	json_object_object_add(media_pad_desc_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "media_pad_desc", media_pad_desc_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), media_pad_desc_obj);
}

void trace_media_link_desc_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *media_link_desc_obj = json_object_new_object();
	struct media_link_desc *p = static_cast<struct media_link_desc*>(arg);

	//struct media_pad_desc source;
	trace_media_pad_desc_gen(&p->source, media_link_desc_obj, "source");
	//struct media_pad_desc sink;
	trace_media_pad_desc_gen(&p->sink, media_link_desc_obj, "sink");
	json_object_object_add(media_link_desc_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "media_link_desc", media_link_desc_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), media_link_desc_obj);
}

void trace_media_links_enum_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *media_links_enum_obj = json_object_new_object();
	struct media_links_enum *p = static_cast<struct media_links_enum*>(arg);

	json_object_object_add(media_links_enum_obj, "entity", json_object_new_int64(p->entity));
	//struct media_pad_desc *pads;
	//struct media_link_desc *links;

	if (key_name.empty())
		json_object_object_add(parent_obj, "media_links_enum", media_links_enum_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), media_links_enum_obj);
}

void trace_media_v2_entity_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *media_v2_entity_obj = json_object_new_object();
	struct media_v2_entity *p = static_cast<struct media_v2_entity*>(arg);

	json_object_object_add(media_v2_entity_obj, "id", json_object_new_string(val2s(p->id, nullptr).c_str()));
	json_object_object_add(media_v2_entity_obj, "name", json_object_new_string(reinterpret_cast<const char *>(p->name)));
	json_object_object_add(media_v2_entity_obj, "function", json_object_new_int64(p->function));
	json_object_object_add(media_v2_entity_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "media_v2_entity", media_v2_entity_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), media_v2_entity_obj);
}

void trace_media_v2_intf_devnode_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *media_v2_intf_devnode_obj = json_object_new_object();
	struct media_v2_intf_devnode *p = static_cast<struct media_v2_intf_devnode*>(arg);

	json_object_object_add(media_v2_intf_devnode_obj, "major", json_object_new_int64(p->major));
	json_object_object_add(media_v2_intf_devnode_obj, "minor", json_object_new_int64(p->minor));

	if (key_name.empty())
		json_object_object_add(parent_obj, "media_v2_intf_devnode", media_v2_intf_devnode_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), media_v2_intf_devnode_obj);
}

void trace_media_v2_interface_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *media_v2_interface_obj = json_object_new_object();
	struct media_v2_interface *p = static_cast<struct media_v2_interface*>(arg);

	json_object_object_add(media_v2_interface_obj, "id", json_object_new_string(val2s(p->id, nullptr).c_str()));
	json_object_object_add(media_v2_interface_obj, "intf_type", json_object_new_int64(p->intf_type));
	json_object_object_add(media_v2_interface_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));
	//union
	//struct media_v2_intf_devnode devnode;
	//__u32 raw[16];
	//end of union 	};

	if (key_name.empty())
		json_object_object_add(parent_obj, "media_v2_interface", media_v2_interface_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), media_v2_interface_obj);
}

void trace_media_v2_pad_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *media_v2_pad_obj = json_object_new_object();
	struct media_v2_pad *p = static_cast<struct media_v2_pad*>(arg);

	json_object_object_add(media_v2_pad_obj, "id", json_object_new_string(val2s(p->id, nullptr).c_str()));
	json_object_object_add(media_v2_pad_obj, "entity_id", json_object_new_int64(p->entity_id));
	json_object_object_add(media_v2_pad_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));
	json_object_object_add(media_v2_pad_obj, "index", json_object_new_int64(p->index));

	if (key_name.empty())
		json_object_object_add(parent_obj, "media_v2_pad", media_v2_pad_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), media_v2_pad_obj);
}

void trace_media_v2_link_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *media_v2_link_obj = json_object_new_object();
	struct media_v2_link *p = static_cast<struct media_v2_link*>(arg);

	json_object_object_add(media_v2_link_obj, "id", json_object_new_string(val2s(p->id, nullptr).c_str()));
	json_object_object_add(media_v2_link_obj, "source_id", json_object_new_int64(p->source_id));
	json_object_object_add(media_v2_link_obj, "sink_id", json_object_new_int64(p->sink_id));
	json_object_object_add(media_v2_link_obj, "flags", json_object_new_string(fl2s(p->flags, nullptr).c_str()));

	if (key_name.empty())
		json_object_object_add(parent_obj, "media_v2_link", media_v2_link_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), media_v2_link_obj);
}

void trace_media_v2_topology_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *media_v2_topology_obj = json_object_new_object();
	struct media_v2_topology *p = static_cast<struct media_v2_topology*>(arg);

	json_object_object_add(media_v2_topology_obj, "topology_version", json_object_new_string(ver2s(p->topology_version).c_str()));
	json_object_object_add(media_v2_topology_obj, "num_entities", json_object_new_int64(p->num_entities));
	json_object_object_add(media_v2_topology_obj, "ptr_entities", json_object_new_uint64(p->ptr_entities));
	json_object_object_add(media_v2_topology_obj, "num_interfaces", json_object_new_int64(p->num_interfaces));
	json_object_object_add(media_v2_topology_obj, "ptr_interfaces", json_object_new_uint64(p->ptr_interfaces));
	json_object_object_add(media_v2_topology_obj, "num_pads", json_object_new_int64(p->num_pads));
	json_object_object_add(media_v2_topology_obj, "ptr_pads", json_object_new_uint64(p->ptr_pads));
	json_object_object_add(media_v2_topology_obj, "num_links", json_object_new_int64(p->num_links));
	json_object_object_add(media_v2_topology_obj, "ptr_links", json_object_new_uint64(p->ptr_links));

	if (key_name.empty())
		json_object_object_add(parent_obj, "media_v2_topology", media_v2_topology_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), media_v2_topology_obj);
}

void trace_v4l2_edid_gen(void *arg, json_object *parent_obj, std::string key_name = "")
{
	json_object *v4l2_edid_obj = json_object_new_object();
	struct v4l2_edid *p = static_cast<struct v4l2_edid*>(arg);

	json_object_object_add(v4l2_edid_obj, "pad", json_object_new_int64(p->pad));
	json_object_object_add(v4l2_edid_obj, "start_block", json_object_new_int64(p->start_block));
	json_object_object_add(v4l2_edid_obj, "blocks", json_object_new_int64(p->blocks));
	//__u8  *edid;

	if (key_name.empty())
		json_object_object_add(parent_obj, "v4l2_edid", v4l2_edid_obj);
	else
		json_object_object_add(parent_obj, key_name.c_str(), v4l2_edid_obj);
}
