Minutes from 46th OpenVDB TSC meeting, April 16th, 2020, (GMT)

Attendees: *Nick* A., *Jeff* L., *Ken* M., *Dan* B.

Additional Attendees: Johannes Meng (Intel), JT Nelson (Blender),
Peter Cheng (DW), Andre Pradhana (DW), Bruce Chernia (Intel)

Regrets: *Peter* C.

Agenda:

1) Confirm quorum
2) Secretary
3) Forum/Github Issues update
4) PR review
5) Google Summer of Code
6) Changing VDB background value in Houdini
7) Expected release date for 7.1.0?
8) OpenVDB & USD
9) Next meeting

1) Quorum was confirmed.

2) Secretary was Dan Bailey

3) Runtime Grids and Compile Times

Discussion about runtime grids and follow-on from last weeks discussion. In
general all in agreement that it would be useful and a nice new flexible
mechanism for the library. Preferred over continuing to add more compile-time
grid types. However, implementation is not trivial, including extending the file
format and figuring out a new value access mechanism.

Subsequent discussion about tackling the orthogonal, but related issue of
compile times in the library. In many cases this is down to using excessively
templated classes or functions in order to optimize inner loops, we should be
vigilant to ensure each template parameter is translating into improved runtime
performance to reduce the template bloat where possible.

There is also a general desire to reduce redundant template instantiation time
that is repeated across multiple translation units. Modules in C++17 will likely
improve our ability to address this, but that's a minimum of three or four years
away. An alternative approach is to perform compile-time registration of grid
types in the library requiring users to recompile the library itself if they
wish to add new types. General agreement to do this. Jeff cautioned that
explicit template instantiation can easily result in some messy preprocessor
code.

3) Forum/Github Issues update

One new issue concerning Python 3.8 - time.clock has been removed.
time.perf_counter can be used but is not available in Python 2.7. Will likely
need a solution that branches on Python version.

4) PR review

697 - Jeff has approved, can now be merged
692 - Dan has approved, ideally needs another reviewer to approve the code
style, Ken to review
690 - Dan to progress this soon
675 - Ken to discuss with Nick soon
671 - few minor doc updates needed then ready to merge, Nick to progress this
soon
670 - wider discussion needed about documenting package manager installation,
tabled for now
654 - mostly ready, solving a number of issues but not perfectly, Nick to break
it up into smaller PRs
652 - Dan and Nick to meet offline to discuss next steps with this PR along
with OVDB-116
651 - Dan to take this on at some point
650 - awaiting progress on 652
631 - Nick reviewed recently, Dan to finish
623/598 - Dan to progress this at some point
455 - awaiting Ken's final approval to progress this

5) Google Summer of Code

Plan is to formally ask for one slot. Dan and Nick to mentor.

6) Changing VDB background value in Houdini

No way to change the VDB background value in Houdini as the core VDB tool is not
currently exposed. Ken mentioned that at DWA they were initially reluctant to
offer this to the artists for fear it may get misused. General feeling that it
would be best to avoid a dedicated SOP if possible. One option is to add it to
the native Houdini primitive SOP, but other parameters relate to metadata so
performance cost may not be clear. All in favour of adding it to the newly
introduced VDB Activate SOP.

Nick mentioned that there will be functionality in AX to modify all inactive
values.

7) Expected release date for 7.1.0?

No rush for Houdini integration, some time before Siggraph is good.

8) OpenVDB & USD

Time. To discuss in a future meeting.

9) Next meeting

Johannes Meng has proposed that Intel will present on OpenVKL. Meeting to remain
open for all interested parties to attend, so Intel will present with that in
mind.

April 23rd 2020. 2pm-3pm EDT (GMT-4).
