; Copyright (C) 2013, Regents of the University of Texas
; Written by Matt Kaufmann, August, 2013
; License: A 3-clause BSD license.  See the LICENSE file distributed with ACL2.

; See make-event-keywords-or-exp.lisp.  We check here that the expansions are
; stored as expected.

(in-package "ACL2")

(include-book "make-event-keywords-or-exp") ; establishes dependency

(make-event
 (er-let* ((forms (read-file "make-event-keywords-or-exp.cert" state)))
   (cond
    ((equal
      (cadr (member-eq :expansion-alist forms))
      '((7 DEFUN F1 (X0 X1 X2 X3)
           (DECLARE (XARGS :MEASURE (ACL2-COUNT X2)))
           (IF (CONSP X0)
               (IF (CONSP X1)
                   (IF (CONSP X2)
                       (IF (CONSP X3)
                           (F1 (CONS X0 X0)
                               (CONS X1 X1)
                               (CDR X2)
                               (CDR X3))
                           X3)
                       X2)
                   X1)
               X0))
        (8 MAKE-EVENT
           '(:OR (:DO-PROOFS (DEFUN F1C (X0 X1 X2 X3)
                               (DECLARE (XARGS :MEASURE (ACL2-COUNT X0)))
                               (IF (CONSP X0)
                                   (IF (CONSP X1)
                                       (IF (CONSP X2)
                                           (IF (CONSP X3)
                                               (F1C (CONS X0 X0)
                                                    (CONS X1 X1)
                                                    (CDR X2)
                                                    (CDR X3))
                                               X3)
                                           X2)
                                       X1)
                                   X0)))
                 (:DO-PROOFS (DEFUN F1C (X0 X1 X2 X3)
                               (DECLARE (XARGS :MEASURE (ACL2-COUNT X1)))
                               (IF (CONSP X0)
                                   (IF (CONSP X1)
                                       (IF (CONSP X2)
                                           (IF (CONSP X3)
                                               (F1C (CONS X0 X0)
                                                    (CONS X1 X1)
                                                    (CDR X2)
                                                    (CDR X3))
                                               X3)
                                           X2)
                                       X1)
                                   X0)))
                 (:DO-PROOFS (DEFUN F1C (X0 X1 X2 X3)
                               (DECLARE (XARGS :MEASURE (ACL2-COUNT X2)))
                               (IF (CONSP X0)
                                   (IF (CONSP X1)
                                       (IF (CONSP X2)
                                           (IF (CONSP X3)
                                               (F1C (CONS X0 X0)
                                                    (CONS X1 X1)
                                                    (CDR X2)
                                                    (CDR X3))
                                               X3)
                                           X2)
                                       X1)
                                   X0)))
                 (:DO-PROOFS (DEFUN F1C (X0 X1 X2 X3)
                               (DECLARE (XARGS :MEASURE (ACL2-COUNT X3)))
                               (IF (CONSP X0)
                                   (IF (CONSP X1)
                                       (IF (CONSP X2)
                                           (IF (CONSP X3)
                                               (F1C (CONS X0 X0)
                                                    (CONS X1 X1)
                                                    (CDR X2)
                                                    (CDR X3))
                                               X3)
                                           X2)
                                       X1)
                                   X0))))
           :CHECK-EXPANSION (DEFUN F1C (X0 X1 X2 X3)
                              (DECLARE (XARGS :MEASURE (ACL2-COUNT X2)))
                              (IF (CONSP X0)
                                  (IF (CONSP X1)
                                      (IF (CONSP X2)
                                          (IF (CONSP X3)
                                              (F1C (CONS X0 X0)
                                                   (CONS X1 X1)
                                                   (CDR X2)
                                                   (CDR X3))
                                              X3)
                                          X2)
                                      X1)
                                  X0)))
        (16 VERIFY-GUARDS G1)
        (19 VALUE-TRIPLE NIL)
        (20 LOCAL (VALUE-TRIPLE :ELIDED))
        (21 LOCAL (VALUE-TRIPLE :ELIDED))
        (22 LOCAL (VALUE-TRIPLE :ELIDED))
        (26 MAKE-EVENT
            '(:OR (DEFUN FOO7 (X) X)
                  (DEFUN NOOP (X) X))
            :CHECK-EXPANSION (DEFUN FOO7 (X) X))
        (28 MAKE-EVENT '(LOCAL (DEFUN FOO8 (X) X))
            :CHECK-EXPANSION (LOCAL (DEFUN FOO8 (X) X)))
        (29 MAKE-EVENT '(LOCAL (DEFUN FOO8 (X) X))
            :CHECK-EXPANSION (LOCAL (DEFUN FOO8 (X) X)))))
     (value '(value-triple nil)))
    (t (er soft 'top
           "Unexpected form in make-event-keywords-or-exp.cert!")))))
