.TH sane\-abaton 5 "11 Jul 2008" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-abaton
.SH NAME
sane\-abaton \- SANE backend for Abaton flatbed scanners
.SH DESCRIPTION
The
.B sane\-abaton
library implements a SANE (Scanner Access Now Easy) backend that
provides access to Abaton flatbed scanners. At present, only the Scan
300/GS (8bit, 256 levels of gray) is fully supported, due to the
absence of programming information.  The Scan 300/S (black and white)
is recognized, but support for it is untested.
.PP
If you own a Abaton scanner other than the ones listed above that
works with this backend, or if you own an Abaton scanner that does not
work with this backend, please contact
.IR sane\-devel@alioth-lists.debian.net
with the model number, so that arrangements can be made to include
support for it. Have a look at
.I http://www.sane\-project.org/mailing\-lists.html
concerning subscription to sane\-devel.
.PP
Abaton is out of business, and these scanners are not supported by
Everex (the parent company of Abaton), nor is there any programming
information to be found.  This driver is therefore based on
information obtained by running Abaton's scanning desk accessory under
MacsBug and tracing the MacOS SCSI Manager calls it made during image
acquisition.
.PP
However, the protocol is very similar to, though not compatible with,
the one used by the Apple scanners, therefore, if this backend is ever
extended to support the other Abaton models (they also made a color
flatbed scanner), it may be possible to fill in some "missing pieces"
from the (quite detailed) Apple scanner documentation.

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.I special
.RE
.PP
Where
.I special
is the path-name for the special device that corresponds to a SCSI
scanner. For SCSI scanners, the special device name must be a generic
SCSI device or a symlink to such a device.  Under Linux, such a device
name takes a format such as
.I /dev/sga
or
.IR /dev/sg0 ,
for example.  See
.BR sane\-scsi (5)
for details.

.SH CONFIGURATION
The contents of the
.I abaton.conf
file is a list of device names that correspond to Abaton scanners.
Empty lines and lines starting with a hash mark (#) are ignored.  See
.BR sane\-scsi (5)
on details of what constitutes a valid device name.

.SH FILES
.TP
.I @CONFIGDIR@/abaton.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane\-abaton.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-abaton.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in
.IR @CONFIGDIR@ .
If the value of the environment variable ends with the directory separator
character, then the default directories are searched after the explicitly
specified directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories
.IR tmp/config ,
.IR . ,
and
.I @CONFIGDIR@
being searched (in this order).
.TP
.B SANE_DEBUG_ABATON
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 255 requests all debug output to be printed.  Smaller
levels reduce verbosity.

.SH BUGS
There are a few known ones, and definitely some unknown ones.
.TP
.B Scan area miscalculations
For the sake of programmer efficiency, this backend handles all
measurements in millimetres, and floors (rather than rounds) values to
avoid possible damage to the scanner mechanism.  Therefore, it may not
be possible to scan to the extreme right or bottom edges of the page.
.TP
.B Cancelling the scan
This might not work correctly, or it might abort the frontend.  The
former is more likely than the latter.
.PP
If you have found something that you think is a bug, please attempt to
recreate it with the SANE_DEBUG_ABATON environment variable set to
255, and send a report detailing the conditions surrounding the bug to
.IR sane\-devel@alioth-lists.debian.net .

.SH TODO
.TP
.B Implement non-blocking support
.TP
.B Finish reverse-engineering the MacOS driver
This will allow me to add support for other models with reasonable
confidence that it will work, as well as to fully exploit the
information returned by the INQUIRY command.

.SH "SEE ALSO"
.BR sane (7),
.BR sane\-scsi (5),
.BR scanimage (1)

.SH AUTHOR
The
.B sane\-abaton
backend was partially written by David Huggins-Daines,
based on the
.BR sane\-apple (5)
backend by Milon Firikis.
