/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef __nsSmtpServer_h_
#define __nsSmtpServer_h_

#include "nsString.h"
#include "nsISmtpServer.h"
#include "nsIPrefBranch.h"
#include "nsWeakReference.h"
#include "nsIObserver.h"

class nsSmtpServer : public nsISmtpServer,
                     public nsSupportsWeakReference,
                     public nsIObserver {
 public:
  nsSmtpServer();
  nsresult Init();

  NS_DECL_ISUPPORTS
  NS_DECL_NSISMTPSERVER
  NS_DECL_NSIOBSERVER

 private:
  virtual ~nsSmtpServer();
  nsCString mKey;
  nsCOMPtr<nsIPrefBranch> mPrefBranch;
  nsCOMPtr<nsIPrefBranch> mDefPrefBranch;

  nsresult getPrefs();
  void getIntPrefWithDefault(const char* prefName, int32_t* val,
                             int32_t defval);
  nsresult GetPasswordWithoutUI();
  nsCString GetServerURIInternal(const bool aIncludeUsername);
  nsresult OnUserOrHostNameChanged(const nsACString& oldName,
                                   const nsACString& newName,
                                   bool hostnameChanged);
  nsString m_password;
  bool m_logonFailed;
};

#endif
