// RUN: %clang_cc1 -std=c++17 -triple x86_64-unknown-unknown -ast-dump=json %s | FileCheck -strict-whitespace %s

template <typename Ty>
void a(Ty);

template <typename... Ty>
void b(Ty...);

template <class Ty, typename Uy>
void c(Ty);

template <>
void c<float, int>(float);

template <typename Ty, template<typename> typename Uy>
void d(Ty, Uy<Ty>);

template <class Ty>
void e(Ty);

template <int N>
void f(int i = N);

template <typename Ty = int>
void g(Ty);

template <typename = void>
void h();

template <typename Ty>
struct R {};

template <>
struct R<int> {};

template <typename Ty, class Uy>
struct S {};

template <typename Ty>
struct S<Ty, int> {};

template <auto>
struct T {};

template <decltype(auto)>
struct U {};

template <typename Ty>
struct V {
  template <typename Uy>
  void f();
};

template <typename Ty>
template <typename Uy>
void V<Ty>::f() {}

// NOTE: CHECK lines have been autogenerated by gen_ast_dump_json_test.py


// CHECK:  "kind": "TranslationUnitDecl",
// CHECK-NEXT:  "loc": {},
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {},
// CHECK-NEXT:   "end": {}
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__int128_t",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "__int128"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "BuiltinType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "__int128"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__uint128_t",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "unsigned __int128"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "BuiltinType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "unsigned __int128"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__NSConstantString",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "__NSConstantString_tag"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "RecordType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "__NSConstantString_tag"
// CHECK-NEXT:      },
// CHECK-NEXT:      "decl": {
// CHECK-NEXT:       "id": "0x{{.*}}",
// CHECK-NEXT:       "kind": "CXXRecordDecl",
// CHECK-NEXT:       "name": "__NSConstantString_tag"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__builtin_ms_va_list",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "char *"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "PointerType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "char *"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "BuiltinType",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "char"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__builtin_va_list",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "__va_list_tag [1]"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ConstantArrayType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "__va_list_tag [1]"
// CHECK-NEXT:      },
// CHECK-NEXT:      "size": 1,
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "RecordType",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "__va_list_tag"
// CHECK-NEXT:        },
// CHECK-NEXT:        "decl": {
// CHECK-NEXT:         "id": "0x{{.*}}",
// CHECK-NEXT:         "kind": "CXXRecordDecl",
// CHECK-NEXT:         "name": "__va_list_tag"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 142,
// CHECK-NEXT:     "file": "{{.*}}",
// CHECK-NEXT:     "line": 4,
// CHECK-NEXT:     "col": 6,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 114,
// CHECK-NEXT:      "line": 3,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 146,
// CHECK-NEXT:      "line": 4,
// CHECK-NEXT:      "col": 10,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "a",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 133,
// CHECK-NEXT:       "line": 3,
// CHECK-NEXT:       "col": 20,
// CHECK-NEXT:       "tokLen": 2
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 124,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 133,
// CHECK-NEXT:        "col": 20,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "Ty",
// CHECK-NEXT:      "tagUsed": "typename",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FunctionDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 142,
// CHECK-NEXT:       "line": 4,
// CHECK-NEXT:       "col": 6,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 137,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 146,
// CHECK-NEXT:        "col": 10,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "a",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "void (Ty)"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "ParmVarDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 146,
// CHECK-NEXT:         "col": 10,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 144,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 144,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "Ty"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 181,
// CHECK-NEXT:     "line": 7,
// CHECK-NEXT:     "col": 6,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 150,
// CHECK-NEXT:      "line": 6,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 188,
// CHECK-NEXT:      "line": 7,
// CHECK-NEXT:      "col": 13,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "b",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 172,
// CHECK-NEXT:       "line": 6,
// CHECK-NEXT:       "col": 23,
// CHECK-NEXT:       "tokLen": 2
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 160,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 172,
// CHECK-NEXT:        "col": 23,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "Ty",
// CHECK-NEXT:      "tagUsed": "typename",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0,
// CHECK-NEXT:      "isParameterPack": true
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FunctionDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 181,
// CHECK-NEXT:       "line": 7,
// CHECK-NEXT:       "col": 6,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 176,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 188,
// CHECK-NEXT:        "col": 13,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "b",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "void (Ty...)"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "ParmVarDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 188,
// CHECK-NEXT:         "col": 13,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 183,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 185,
// CHECK-NEXT:          "col": 10,
// CHECK-NEXT:          "tokLen": 3
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "Ty..."
// CHECK-NEXT:        },
// CHECK-NEXT:        "isParameterPack": true
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 230,
// CHECK-NEXT:     "line": 10,
// CHECK-NEXT:     "col": 6,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 192,
// CHECK-NEXT:      "line": 9,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 234,
// CHECK-NEXT:      "line": 10,
// CHECK-NEXT:      "col": 10,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "c",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 208,
// CHECK-NEXT:       "line": 9,
// CHECK-NEXT:       "col": 17,
// CHECK-NEXT:       "tokLen": 2
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 202,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 208,
// CHECK-NEXT:        "col": 17,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "Ty",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 221,
// CHECK-NEXT:       "col": 30,
// CHECK-NEXT:       "tokLen": 2
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 212,
// CHECK-NEXT:        "col": 21,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 221,
// CHECK-NEXT:        "col": 30,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "Uy",
// CHECK-NEXT:      "tagUsed": "typename",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FunctionDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 230,
// CHECK-NEXT:       "line": 10,
// CHECK-NEXT:       "col": 6,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 225,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 234,
// CHECK-NEXT:        "col": 10,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "c",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "void (Ty)"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "ParmVarDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 234,
// CHECK-NEXT:         "col": 10,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 232,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 232,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "Ty"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FunctionDecl",
// CHECK-NEXT:      "name": "c",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "void (float)"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 255,
// CHECK-NEXT:     "line": 13,
// CHECK-NEXT:     "col": 6,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 238,
// CHECK-NEXT:      "line": 12,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 274,
// CHECK-NEXT:      "line": 13,
// CHECK-NEXT:      "col": 25,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "previousDecl": "0x{{.*}}",
// CHECK-NEXT:    "name": "c",
// CHECK-NEXT:    "mangledName": "_Z1cIfiEvT_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void (float)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "kind": "TemplateArgument",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "float"
// CHECK-NEXT:      }
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "kind": "TemplateArgument",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      }
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 274,
// CHECK-NEXT:       "col": 25,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 269,
// CHECK-NEXT:        "col": 20,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 269,
// CHECK-NEXT:        "col": 20,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "float"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 338,
// CHECK-NEXT:     "line": 16,
// CHECK-NEXT:     "col": 6,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 278,
// CHECK-NEXT:      "line": 15,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 350,
// CHECK-NEXT:      "line": 16,
// CHECK-NEXT:      "col": 18,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "d",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 297,
// CHECK-NEXT:       "line": 15,
// CHECK-NEXT:       "col": 20,
// CHECK-NEXT:       "tokLen": 2
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 288,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 297,
// CHECK-NEXT:        "col": 20,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "Ty",
// CHECK-NEXT:      "tagUsed": "typename",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTemplateParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 329,
// CHECK-NEXT:       "col": 52,
// CHECK-NEXT:       "tokLen": 2
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 301,
// CHECK-NEXT:        "col": 24,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 329,
// CHECK-NEXT:        "col": 52,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "Uy",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 1,
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 318,
// CHECK-NEXT:         "col": 41,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 310,
// CHECK-NEXT:          "col": 33,
// CHECK-NEXT:          "tokLen": 8
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 310,
// CHECK-NEXT:          "col": 33,
// CHECK-NEXT:          "tokLen": 8
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "tagUsed": "typename",
// CHECK-NEXT:        "depth": 1,
// CHECK-NEXT:        "index": 0
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FunctionDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 338,
// CHECK-NEXT:       "line": 16,
// CHECK-NEXT:       "col": 6,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 333,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 350,
// CHECK-NEXT:        "col": 18,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "d",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "void (Ty, Uy<Ty>)"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "ParmVarDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 342,
// CHECK-NEXT:         "col": 10,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 340,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 340,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "Ty"
// CHECK-NEXT:        }
// CHECK-NEXT:       },
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "ParmVarDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 350,
// CHECK-NEXT:         "col": 18,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 344,
// CHECK-NEXT:          "col": 12,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 349,
// CHECK-NEXT:          "col": 17,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "Uy<Ty>"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 379,
// CHECK-NEXT:     "line": 19,
// CHECK-NEXT:     "col": 6,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 354,
// CHECK-NEXT:      "line": 18,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 383,
// CHECK-NEXT:      "line": 19,
// CHECK-NEXT:      "col": 10,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "e",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 370,
// CHECK-NEXT:       "line": 18,
// CHECK-NEXT:       "col": 17,
// CHECK-NEXT:       "tokLen": 2
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 364,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 370,
// CHECK-NEXT:        "col": 17,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "Ty",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FunctionDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 379,
// CHECK-NEXT:       "line": 19,
// CHECK-NEXT:       "col": 6,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 374,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 383,
// CHECK-NEXT:        "col": 10,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "e",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "void (Ty)"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "ParmVarDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 383,
// CHECK-NEXT:         "col": 10,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 381,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 381,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "Ty"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 409,
// CHECK-NEXT:     "line": 22,
// CHECK-NEXT:     "col": 6,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 387,
// CHECK-NEXT:      "line": 21,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 420,
// CHECK-NEXT:      "line": 22,
// CHECK-NEXT:      "col": 17,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "f",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "NonTypeTemplateParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 401,
// CHECK-NEXT:       "line": 21,
// CHECK-NEXT:       "col": 15,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 397,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 401,
// CHECK-NEXT:        "col": 15,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "N",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      },
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FunctionDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 409,
// CHECK-NEXT:       "line": 22,
// CHECK-NEXT:       "col": 6,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 404,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 420,
// CHECK-NEXT:        "col": 17,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "f",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "void (int)"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "ParmVarDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 415,
// CHECK-NEXT:         "col": 12,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 411,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 3
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 419,
// CHECK-NEXT:          "col": 16,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "name": "i",
// CHECK-NEXT:        "mangledName": "_ZZ1fiE1i",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "int"
// CHECK-NEXT:        },
// CHECK-NEXT:        "init": "c",
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "DeclRefExpr",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 419,
// CHECK-NEXT:            "col": 16,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 419,
// CHECK-NEXT:            "col": 16,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "int"
// CHECK-NEXT:          },
// CHECK-NEXT:          "valueCategory": "rvalue",
// CHECK-NEXT:          "referencedDecl": {
// CHECK-NEXT:           "id": "0x{{.*}}",
// CHECK-NEXT:           "kind": "NonTypeTemplateParmDecl",
// CHECK-NEXT:           "name": "N",
// CHECK-NEXT:           "type": {
// CHECK-NEXT:            "qualType": "int"
// CHECK-NEXT:           }
// CHECK-NEXT:          }
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 458,
// CHECK-NEXT:     "line": 25,
// CHECK-NEXT:     "col": 6,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 424,
// CHECK-NEXT:      "line": 24,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 462,
// CHECK-NEXT:      "line": 25,
// CHECK-NEXT:      "col": 10,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "g",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 443,
// CHECK-NEXT:       "line": 24,
// CHECK-NEXT:       "col": 20,
// CHECK-NEXT:       "tokLen": 2
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 434,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 448,
// CHECK-NEXT:        "col": 25,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "Ty",
// CHECK-NEXT:      "tagUsed": "typename",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0,
// CHECK-NEXT:      "defaultArg": {
// CHECK-NEXT:       "kind": "TemplateArgument",
// CHECK-NEXT:       "type": {
// CHECK-NEXT:        "qualType": "int"
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "kind": "TemplateArgument",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "int"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FunctionDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 458,
// CHECK-NEXT:       "line": 25,
// CHECK-NEXT:       "col": 6,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 453,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 462,
// CHECK-NEXT:        "col": 10,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "g",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "void (Ty)"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "ParmVarDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 462,
// CHECK-NEXT:         "col": 10,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 460,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 460,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 2
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "Ty"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 498,
// CHECK-NEXT:     "line": 28,
// CHECK-NEXT:     "col": 6,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 466,
// CHECK-NEXT:      "line": 27,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 500,
// CHECK-NEXT:      "line": 28,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "h",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 485,
// CHECK-NEXT:       "line": 27,
// CHECK-NEXT:       "col": 20,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 476,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 487,
// CHECK-NEXT:        "col": 22,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "tagUsed": "typename",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0,
// CHECK-NEXT:      "defaultArg": {
// CHECK-NEXT:       "kind": "TemplateArgument",
// CHECK-NEXT:       "type": {
// CHECK-NEXT:        "qualType": "void"
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "kind": "TemplateArgument",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "void"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FunctionDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 498,
// CHECK-NEXT:       "line": 28,
// CHECK-NEXT:       "col": 6,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 493,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 500,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "h",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "void ()"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "ClassTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 534,
// CHECK-NEXT:     "line": 31,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 504,
// CHECK-NEXT:      "line": 30,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 537,
// CHECK-NEXT:      "line": 31,
// CHECK-NEXT:      "col": 11,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "R",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 523,
// CHECK-NEXT:       "line": 30,
// CHECK-NEXT:       "col": 20,
// CHECK-NEXT:       "tokLen": 2
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 514,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 523,
// CHECK-NEXT:        "col": 20,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "Ty",
// CHECK-NEXT:      "tagUsed": "typename",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXRecordDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 534,
// CHECK-NEXT:       "line": 31,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 527,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 537,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "R",
// CHECK-NEXT:      "tagUsed": "struct",
// CHECK-NEXT:      "completeDefinition": true,
// CHECK-NEXT:      "definitionData": {
// CHECK-NEXT:       "canConstDefaultInit": true,
// CHECK-NEXT:       "copyAssign": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "copyCtor": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "defaultCtor": {
// CHECK-NEXT:        "defaultedIsConstexpr": true,
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "isConstexpr": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "dtor": {
// CHECK-NEXT:        "irrelevant": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:       "isAggregate": true,
// CHECK-NEXT:       "isEmpty": true,
// CHECK-NEXT:       "isLiteral": true,
// CHECK-NEXT:       "isPOD": true,
// CHECK-NEXT:       "isStandardLayout": true,
// CHECK-NEXT:       "isTrivial": true,
// CHECK-NEXT:       "isTriviallyCopyable": true,
// CHECK-NEXT:       "moveAssign": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "moveCtor": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXRecordDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 534,
// CHECK-NEXT:         "col": 8,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 527,
// CHECK-NEXT:          "col": 1,
// CHECK-NEXT:          "tokLen": 6
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 534,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "isImplicit": true,
// CHECK-NEXT:        "name": "R",
// CHECK-NEXT:        "tagUsed": "struct"
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ClassTemplateSpecializationDecl",
// CHECK-NEXT:      "name": "R"
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "ClassTemplateSpecializationDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 560,
// CHECK-NEXT:     "line": 34,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 541,
// CHECK-NEXT:      "line": 33,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 568,
// CHECK-NEXT:      "line": 34,
// CHECK-NEXT:      "col": 16,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "R",
// CHECK-NEXT:    "tagUsed": "struct",
// CHECK-NEXT:    "completeDefinition": true,
// CHECK-NEXT:    "definitionData": {
// CHECK-NEXT:     "canConstDefaultInit": true,
// CHECK-NEXT:     "canPassInRegisters": true,
// CHECK-NEXT:     "copyAssign": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "copyCtor": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "defaultCtor": {
// CHECK-NEXT:      "defaultedIsConstexpr": true,
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "isConstexpr": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "dtor": {
// CHECK-NEXT:      "irrelevant": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:     "isAggregate": true,
// CHECK-NEXT:     "isEmpty": true,
// CHECK-NEXT:     "isLiteral": true,
// CHECK-NEXT:     "isPOD": true,
// CHECK-NEXT:     "isStandardLayout": true,
// CHECK-NEXT:     "isTrivial": true,
// CHECK-NEXT:     "isTriviallyCopyable": true,
// CHECK-NEXT:     "moveAssign": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "moveCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "kind": "TemplateArgument",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      }
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXRecordDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 560,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 553,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 560,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isImplicit": true,
// CHECK-NEXT:      "name": "R",
// CHECK-NEXT:      "tagUsed": "struct"
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "ClassTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 612,
// CHECK-NEXT:     "line": 37,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 572,
// CHECK-NEXT:      "line": 36,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 615,
// CHECK-NEXT:      "line": 37,
// CHECK-NEXT:      "col": 11,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "S",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 591,
// CHECK-NEXT:       "line": 36,
// CHECK-NEXT:       "col": 20,
// CHECK-NEXT:       "tokLen": 2
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 582,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 591,
// CHECK-NEXT:        "col": 20,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "Ty",
// CHECK-NEXT:      "tagUsed": "typename",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 601,
// CHECK-NEXT:       "col": 30,
// CHECK-NEXT:       "tokLen": 2
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 595,
// CHECK-NEXT:        "col": 24,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 601,
// CHECK-NEXT:        "col": 30,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "Uy",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXRecordDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 612,
// CHECK-NEXT:       "line": 37,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 605,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 615,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "S",
// CHECK-NEXT:      "tagUsed": "struct",
// CHECK-NEXT:      "completeDefinition": true,
// CHECK-NEXT:      "definitionData": {
// CHECK-NEXT:       "canConstDefaultInit": true,
// CHECK-NEXT:       "copyAssign": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "copyCtor": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "defaultCtor": {
// CHECK-NEXT:        "defaultedIsConstexpr": true,
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "isConstexpr": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "dtor": {
// CHECK-NEXT:        "irrelevant": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:       "isAggregate": true,
// CHECK-NEXT:       "isEmpty": true,
// CHECK-NEXT:       "isLiteral": true,
// CHECK-NEXT:       "isPOD": true,
// CHECK-NEXT:       "isStandardLayout": true,
// CHECK-NEXT:       "isTrivial": true,
// CHECK-NEXT:       "isTriviallyCopyable": true,
// CHECK-NEXT:       "moveAssign": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "moveCtor": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXRecordDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 612,
// CHECK-NEXT:         "col": 8,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 605,
// CHECK-NEXT:          "col": 1,
// CHECK-NEXT:          "tokLen": 6
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 612,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "isImplicit": true,
// CHECK-NEXT:        "name": "S",
// CHECK-NEXT:        "tagUsed": "struct"
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "ClassTemplatePartialSpecializationDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 649,
// CHECK-NEXT:     "line": 40,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 619,
// CHECK-NEXT:      "line": 39,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 661,
// CHECK-NEXT:      "line": 40,
// CHECK-NEXT:      "col": 20,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "S",
// CHECK-NEXT:    "tagUsed": "struct",
// CHECK-NEXT:    "completeDefinition": true,
// CHECK-NEXT:    "definitionData": {
// CHECK-NEXT:     "canConstDefaultInit": true,
// CHECK-NEXT:     "copyAssign": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "copyCtor": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "defaultCtor": {
// CHECK-NEXT:      "defaultedIsConstexpr": true,
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "isConstexpr": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "dtor": {
// CHECK-NEXT:      "irrelevant": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:     "isAggregate": true,
// CHECK-NEXT:     "isEmpty": true,
// CHECK-NEXT:     "isLiteral": true,
// CHECK-NEXT:     "isPOD": true,
// CHECK-NEXT:     "isStandardLayout": true,
// CHECK-NEXT:     "isTrivial": true,
// CHECK-NEXT:     "isTriviallyCopyable": true,
// CHECK-NEXT:     "moveAssign": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "moveCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "kind": "TemplateArgument",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "type-parameter-0-0"
// CHECK-NEXT:      }
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "kind": "TemplateArgument",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      }
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 638,
// CHECK-NEXT:       "line": 39,
// CHECK-NEXT:       "col": 20,
// CHECK-NEXT:       "tokLen": 2
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 629,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 638,
// CHECK-NEXT:        "col": 20,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "Ty",
// CHECK-NEXT:      "tagUsed": "typename",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXRecordDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 649,
// CHECK-NEXT:       "line": 40,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 642,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 649,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isImplicit": true,
// CHECK-NEXT:      "name": "S",
// CHECK-NEXT:      "tagUsed": "struct"
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "ClassTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 688,
// CHECK-NEXT:     "line": 43,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 665,
// CHECK-NEXT:      "line": 42,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 691,
// CHECK-NEXT:      "line": 43,
// CHECK-NEXT:      "col": 11,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "T",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "NonTypeTemplateParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 679,
// CHECK-NEXT:       "line": 42,
// CHECK-NEXT:       "col": 15,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 675,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 675,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "auto"
// CHECK-NEXT:      },
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXRecordDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 688,
// CHECK-NEXT:       "line": 43,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 681,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 691,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "T",
// CHECK-NEXT:      "tagUsed": "struct",
// CHECK-NEXT:      "completeDefinition": true,
// CHECK-NEXT:      "definitionData": {
// CHECK-NEXT:       "canConstDefaultInit": true,
// CHECK-NEXT:       "copyAssign": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "copyCtor": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "defaultCtor": {
// CHECK-NEXT:        "defaultedIsConstexpr": true,
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "isConstexpr": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "dtor": {
// CHECK-NEXT:        "irrelevant": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:       "isAggregate": true,
// CHECK-NEXT:       "isEmpty": true,
// CHECK-NEXT:       "isLiteral": true,
// CHECK-NEXT:       "isPOD": true,
// CHECK-NEXT:       "isStandardLayout": true,
// CHECK-NEXT:       "isTrivial": true,
// CHECK-NEXT:       "isTriviallyCopyable": true,
// CHECK-NEXT:       "moveAssign": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "moveCtor": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXRecordDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 688,
// CHECK-NEXT:         "col": 8,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 681,
// CHECK-NEXT:          "col": 1,
// CHECK-NEXT:          "tokLen": 6
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 688,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "isImplicit": true,
// CHECK-NEXT:        "name": "T",
// CHECK-NEXT:        "tagUsed": "struct"
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "ClassTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 728,
// CHECK-NEXT:     "line": 46,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 695,
// CHECK-NEXT:      "line": 45,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 731,
// CHECK-NEXT:      "line": 46,
// CHECK-NEXT:      "col": 11,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "U",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "NonTypeTemplateParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 719,
// CHECK-NEXT:       "line": 45,
// CHECK-NEXT:       "col": 25,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 705,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 705,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "decltype(auto)"
// CHECK-NEXT:      },
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXRecordDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 728,
// CHECK-NEXT:       "line": 46,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 721,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 731,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "U",
// CHECK-NEXT:      "tagUsed": "struct",
// CHECK-NEXT:      "completeDefinition": true,
// CHECK-NEXT:      "definitionData": {
// CHECK-NEXT:       "canConstDefaultInit": true,
// CHECK-NEXT:       "copyAssign": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "copyCtor": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "defaultCtor": {
// CHECK-NEXT:        "defaultedIsConstexpr": true,
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "isConstexpr": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "dtor": {
// CHECK-NEXT:        "irrelevant": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:       "isAggregate": true,
// CHECK-NEXT:       "isEmpty": true,
// CHECK-NEXT:       "isLiteral": true,
// CHECK-NEXT:       "isPOD": true,
// CHECK-NEXT:       "isStandardLayout": true,
// CHECK-NEXT:       "isTrivial": true,
// CHECK-NEXT:       "isTriviallyCopyable": true,
// CHECK-NEXT:       "moveAssign": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "moveCtor": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXRecordDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 728,
// CHECK-NEXT:         "col": 8,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 721,
// CHECK-NEXT:          "col": 1,
// CHECK-NEXT:          "tokLen": 6
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 728,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "isImplicit": true,
// CHECK-NEXT:        "name": "U",
// CHECK-NEXT:        "tagUsed": "struct"
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "ClassTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 765,
// CHECK-NEXT:     "line": 49,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 735,
// CHECK-NEXT:      "line": 48,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 806,
// CHECK-NEXT:      "line": 52,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "V",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 754,
// CHECK-NEXT:       "line": 48,
// CHECK-NEXT:       "col": 20,
// CHECK-NEXT:       "tokLen": 2
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 745,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 754,
// CHECK-NEXT:        "col": 20,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "Ty",
// CHECK-NEXT:      "tagUsed": "typename",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXRecordDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 765,
// CHECK-NEXT:       "line": 49,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 758,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 806,
// CHECK-NEXT:        "line": 52,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "V",
// CHECK-NEXT:      "tagUsed": "struct",
// CHECK-NEXT:      "completeDefinition": true,
// CHECK-NEXT:      "definitionData": {
// CHECK-NEXT:       "canConstDefaultInit": true,
// CHECK-NEXT:       "copyAssign": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "copyCtor": {
// CHECK-NEXT:        "hasConstParam": true,
// CHECK-NEXT:        "implicitHasConstParam": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "defaultCtor": {
// CHECK-NEXT:        "defaultedIsConstexpr": true,
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "isConstexpr": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "dtor": {
// CHECK-NEXT:        "irrelevant": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:       "isAggregate": true,
// CHECK-NEXT:       "isEmpty": true,
// CHECK-NEXT:       "isLiteral": true,
// CHECK-NEXT:       "isPOD": true,
// CHECK-NEXT:       "isStandardLayout": true,
// CHECK-NEXT:       "isTrivial": true,
// CHECK-NEXT:       "isTriviallyCopyable": true,
// CHECK-NEXT:       "moveAssign": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       },
// CHECK-NEXT:       "moveCtor": {
// CHECK-NEXT:        "exists": true,
// CHECK-NEXT:        "needsImplicit": true,
// CHECK-NEXT:        "simple": true,
// CHECK-NEXT:        "trivial": true
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXRecordDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 765,
// CHECK-NEXT:         "line": 49,
// CHECK-NEXT:         "col": 8,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 758,
// CHECK-NEXT:          "col": 1,
// CHECK-NEXT:          "tokLen": 6
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 765,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "isImplicit": true,
// CHECK-NEXT:        "name": "V",
// CHECK-NEXT:        "tagUsed": "struct"
// CHECK-NEXT:       },
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "FunctionTemplateDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 801,
// CHECK-NEXT:         "line": 51,
// CHECK-NEXT:         "col": 8,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 771,
// CHECK-NEXT:          "line": 50,
// CHECK-NEXT:          "col": 3,
// CHECK-NEXT:          "tokLen": 8
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 803,
// CHECK-NEXT:          "line": 51,
// CHECK-NEXT:          "col": 10,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "name": "f",
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:          "loc": {
// CHECK-NEXT:           "offset": 790,
// CHECK-NEXT:           "line": 50,
// CHECK-NEXT:           "col": 22,
// CHECK-NEXT:           "tokLen": 2
// CHECK-NEXT:          },
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 781,
// CHECK-NEXT:            "col": 13,
// CHECK-NEXT:            "tokLen": 8
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 790,
// CHECK-NEXT:            "col": 22,
// CHECK-NEXT:            "tokLen": 2
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "name": "Uy",
// CHECK-NEXT:          "tagUsed": "typename",
// CHECK-NEXT:          "depth": 1,
// CHECK-NEXT:          "index": 0
// CHECK-NEXT:         },
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "CXXMethodDecl",
// CHECK-NEXT:          "loc": {
// CHECK-NEXT:           "offset": 801,
// CHECK-NEXT:           "line": 51,
// CHECK-NEXT:           "col": 8,
// CHECK-NEXT:           "tokLen": 1
// CHECK-NEXT:          },
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 796,
// CHECK-NEXT:            "col": 3,
// CHECK-NEXT:            "tokLen": 4
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 803,
// CHECK-NEXT:            "col": 10,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "name": "f",
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "void ()"
// CHECK-NEXT:          }
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 868,
// CHECK-NEXT:     "line": 56,
// CHECK-NEXT:     "col": 13,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 833,
// CHECK-NEXT:      "line": 55,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 873,
// CHECK-NEXT:      "line": 56,
// CHECK-NEXT:      "col": 18,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "parentDeclContextId": "0x{{.*}}",
// CHECK-NEXT:    "previousDecl": "0x{{.*}}",
// CHECK-NEXT:    "name": "f",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 852,
// CHECK-NEXT:       "line": 55,
// CHECK-NEXT:       "col": 20,
// CHECK-NEXT:       "tokLen": 2
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 843,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 852,
// CHECK-NEXT:        "col": 20,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "Uy",
// CHECK-NEXT:      "tagUsed": "typename",
// CHECK-NEXT:      "depth": 1,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXMethodDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 868,
// CHECK-NEXT:       "line": 56,
// CHECK-NEXT:       "col": 13,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 810,
// CHECK-NEXT:        "line": 54,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 8
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 873,
// CHECK-NEXT:        "line": 56,
// CHECK-NEXT:        "col": 18,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "parentDeclContextId": "0x{{.*}}",
// CHECK-NEXT:      "previousDecl": "0x{{.*}}",
// CHECK-NEXT:      "name": "f",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "void ()"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CompoundStmt",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 872,
// CHECK-NEXT:          "col": 17,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 873,
// CHECK-NEXT:          "col": 18,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }
