/*
 *  libgladexfce4 - libglade module for libxfcegui4
 *
 *  Copyright (c) 2007 Brian Tarricone <bjt23@cornell.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <gmodule.h>

#include <glade/glade.h>
#include <glade/glade-build.h>
#include <gtk/gtk.h>
#include <libxfcegui4/libxfcegui4.h>


static void
titled_dialog_build_children(GladeXML *xml,
                             GtkWidget *widget,
                             GladeWidgetInfo *info)
{
    GList *children, *l;
    GtkContainer *action_area;

    glade_standard_build_children(xml, widget, info);

    action_area = GTK_CONTAINER(GTK_DIALOG(widget)->action_area);
    if(!action_area)
        return;

    /* we have to repack all the widgets in the action area so they get
     * their response ids set properly, and so they actually emit the
     * response signal when activated */

    children = gtk_container_get_children(action_area);
    for(l = children; l; l = l->next) {
        g_object_ref(G_OBJECT(l->data));
        gtk_container_remove(action_area, GTK_WIDGET(l->data));
    }

    for(l = children; l; l = l->next) {
        gtk_dialog_add_action_widget(GTK_DIALOG(widget), GTK_WIDGET(l->data),
                                     GPOINTER_TO_INT(g_object_steal_data(G_OBJECT(l->data),
                                                                         "response_id")));
        g_object_unref(G_OBJECT(l->data));
    }

    g_list_free(children);
}

static GtkWidget *
titled_dialog_find_internal_child(GladeXML *xml,
                                  GtkWidget *parent,
                                  const gchar *child_name)
{
    if(!strcmp(child_name, "vbox"))
        return GTK_DIALOG(parent)->vbox;
    else if(!strcmp(child_name, "action_area"))
        return GTK_DIALOG(parent)->action_area;
    
    return NULL;
}

G_MODULE_EXPORT void
glade_module_register_widgets(void)
{
    glade_register_widget(XFCE_TYPE_APP_MENU_ITEM, NULL, NULL, NULL);
    glade_register_widget(XFCE_TYPE_HEADING, NULL, NULL, NULL);
    glade_register_widget(XFCE_TYPE_SCALED_IMAGE, NULL, NULL, NULL);
    glade_register_widget(XFCE_TYPE_TITLED_DIALOG, NULL,
                          titled_dialog_build_children,
                          titled_dialog_find_internal_child);
    
    glade_provide("xfce4");
}
