//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    /// <remarks>
    ///  A set of methods used to work with colors.
    ///  KColorScheme currently provides access to the system color palette that the
    ///  user has selected (in the future, it is expected to do more). As of KDE4,
    ///  this class is the correct way to look up colors from the system palette,
    ///  as opposed to KGlobalSettings (such usage is deprecated). It greatly expands
    ///  on KGlobalSettings and QPalette by providing five distinct "sets" with
    ///  several color choices each, covering background, foreground, and decoration
    ///  colors.
    ///  A KColorScheme instance represents colors corresponding to a "set", where a
    ///  set consists of those colors used to draw a particular type of element, such
    ///  as a menu, button, view, selected text, or tooltip. Each set has a distinct
    ///  set of colors, so you should always use the correct set for drawing and
    ///  never assume that a particular foreground for one set is the same as the
    ///  foreground for any other set. Individual colors may be quickly referenced by
    ///  creating an anonymous instance and invoking a lookup member.
    ///  @note
    ///  Historically, it was not needed for applications to give much concern to the
    ///  state of a widget (active, inactive, disabled) since only the disabled state
    ///  was different, and only slightly. As a result, the old KGlobalSettings color
    ///  getters did not care about the widget state. However, starting with KDE4,
    ///  the color palettes for the various states may be wildly different.
    ///  Therefore, it is important to take the state into account. This is why the
    ///  KColorScheme constructor requires a QPalette.ColorGroup as an argument.
    ///  To facilitate working with potentially-varying states, two convenience API's
    ///  are provided. These are KColorScheme.AdjustBackground and its sister
    ///  KColorScheme.AdjustForeground, and the helper class .KStatefulBrush.
    /// </remarks>        <short>    A set of methods used to work with colors.</short>
    ///         <see> KColorScheme.ColorSet</see>
    ///         <see> KColorScheme.ForegroundRole</see>
    ///         <see> KColorScheme.BackgroundRole</see>
    ///         <see> KColorScheme.DecorationRole</see>
    ///         <see> KColorScheme.ShadeRole</see>
    [SmokeClass("KColorScheme")]
    public class KColorScheme : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected KColorScheme(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KColorScheme), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static KColorScheme() {
            staticInterceptor = new SmokeInvocation(typeof(KColorScheme), null);
        }
        /// <remarks>
        ///  This enumeration describes the color set for which a color is being
        ///  selected.
        ///  Color sets define a color "environment", suitable for drawing all parts
        ///  of a given region. Colors from different sets should not be combined.
        ///      </remarks>        <short>    This enumeration describes the color set for which a color is being  selected.</short>
        public enum ColorSet {
            View = 0,
            Window = 1,
            Button = 2,
            Selection = 3,
            Tooltip = 4,
        }
        /// <remarks>
        ///  This enumeration describes the background color being selected from the
        ///  given set.
        ///  Background colors are suitable for drawing under text, and should never
        ///  be used to draw text. In combination with one of the overloads of
        ///  KColorScheme.Shade, they may be used to generate colors for drawing
        ///  frames, bevels, and similar decorations.
        ///      </remarks>        <short>    This enumeration describes the background color being selected from the  given set.</short>
        public enum BackgroundRole {
            NormalBackground = 0,
            AlternateBackground = 1,
            ActiveBackground = 2,
            LinkBackground = 3,
            VisitedBackground = 4,
            NegativeBackground = 5,
            NeutralBackground = 6,
            PositiveBackground = 7,
        }
        /// <remarks>
        ///  This enumeration describes the foreground color being selected from the
        ///  given set.
        ///  Foreground colors are suitable for drawing text or glyphs (such as the
        ///  symbols on window decoration buttons, assuming a suitable background
        ///  brush is used), and should never be used to draw backgrounds.
        ///  For window decorations, the following is suggested, but not set in
        ///  stone:
        /// 
        /// <li>
        /// Maximize - PositiveText
        /// </li>
        /// 
        /// <li>
        /// Minimize - NeutralText
        /// </li>
        /// 
        /// <li>
        /// Close - NegativeText
        /// </li>
        /// 
        /// <li>
        /// WhatsThis - LinkText
        /// </li>
        /// 
        /// <li>
        /// Sticky - ActiveText
        ///      
        /// </li></remarks>        <short>    This enumeration describes the foreground color being selected from the  given set.</short>
        public enum ForegroundRole {
            NormalText = 0,
            InactiveText = 1,
            ActiveText = 2,
            LinkText = 3,
            VisitedText = 4,
            NegativeText = 5,
            NeutralText = 6,
            PositiveText = 7,
        }
        /// <remarks>
        ///  This enumeration describes the decoration color being selected from the
        ///  given set.
        ///  Decoration colors are used to draw decorations (such as frames) for
        ///  special purposes. Like color shades, they are neither foreground nor
        ///  background colors. Text should not be painted over a decoration color,
        ///  and decoration colors should not be used to draw text.
        ///      </remarks>        <short>    This enumeration describes the decoration color being selected from the  given set.</short>
        public enum DecorationRole {
            FocusColor = 0,
            HoverColor = 1,
        }
        /// <remarks>
        ///  This enumeration describes the color shade being selected from the given
        ///  set.
        ///  Color shades are used to draw "3d" elements, such as frames and bevels.
        ///  They are neither foreground nor background colors. Text should not be
        ///  painted over a shade, and shades should not be used to draw text.
        ///      </remarks>        <short>    This enumeration describes the color shade being selected from the given  set.</short>
        public enum ShadeRole {
            LightShade = 0,
            MidlightShade = 1,
            MidShade = 2,
            DarkShade = 3,
            ShadowShade = 4,
        }
        /// <remarks> Construct a copy of another KColorScheme. </remarks>        <short>   Construct a copy of another KColorScheme.</short>
        public KColorScheme(KColorScheme arg1) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KColorScheme#", "KColorScheme(const KColorScheme&)", typeof(void), typeof(KColorScheme), arg1);
        }
        /// <remarks>
        ///  Construct a palette from given color set and state, using the colors
        ///  from the given KConfig (if null, the system colors are used).
        ///  @note KColorScheme provides direct access to the color scheme for users
        ///  that deal directly with widget states. Unless you are a low-level user
        ///  or have a legitimate reason to only care about a fixed, limited number
        ///  of states (e.g. windows that cannot be inactive), consider using a
        ///  .KStatefulBrush instead.
        ///      </remarks>        <short>    Construct a palette from given color set and state, using the colors  from the given KConfig (if null, the system colors are used).</short>
        public KColorScheme(QPalette.ColorGroup arg1, KColorScheme.ColorSet arg2, KSharedConfig arg3) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KColorScheme$$?", "KColorScheme(QPalette::ColorGroup, KColorScheme::ColorSet, KSharedPtr<KSharedConfig>)", typeof(void), typeof(QPalette.ColorGroup), arg1, typeof(KColorScheme.ColorSet), arg2, typeof(KSharedConfig), arg3);
        }
        public KColorScheme(QPalette.ColorGroup arg1, KColorScheme.ColorSet arg2) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KColorScheme$$", "KColorScheme(QPalette::ColorGroup, KColorScheme::ColorSet)", typeof(void), typeof(QPalette.ColorGroup), arg1, typeof(KColorScheme.ColorSet), arg2);
        }
        public KColorScheme(QPalette.ColorGroup arg1) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KColorScheme$", "KColorScheme(QPalette::ColorGroup)", typeof(void), typeof(QPalette.ColorGroup), arg1);
        }
        /// <remarks>
        ///  Retrieve the requested background brush.
        ///      </remarks>        <short>    Retrieve the requested background brush.</short>
        public QBrush Background(KColorScheme.BackgroundRole arg1) {
            return (QBrush) interceptor.Invoke("background$", "background(KColorScheme::BackgroundRole) const", typeof(QBrush), typeof(KColorScheme.BackgroundRole), arg1);
        }
        public QBrush Background() {
            return (QBrush) interceptor.Invoke("background", "background() const", typeof(QBrush));
        }
        /// <remarks>
        ///  Retrieve the requested foreground brush.
        ///      </remarks>        <short>    Retrieve the requested foreground brush.</short>
        public QBrush Foreground(KColorScheme.ForegroundRole arg1) {
            return (QBrush) interceptor.Invoke("foreground$", "foreground(KColorScheme::ForegroundRole) const", typeof(QBrush), typeof(KColorScheme.ForegroundRole), arg1);
        }
        public QBrush Foreground() {
            return (QBrush) interceptor.Invoke("foreground", "foreground() const", typeof(QBrush));
        }
        /// <remarks>
        ///  Retrieve the requested decoration brush.
        ///      </remarks>        <short>    Retrieve the requested decoration brush.</short>
        public QBrush Decoration(KColorScheme.DecorationRole arg1) {
            return (QBrush) interceptor.Invoke("decoration$", "decoration(KColorScheme::DecorationRole) const", typeof(QBrush), typeof(KColorScheme.DecorationRole), arg1);
        }
        /// <remarks>
        ///  Retrieve the requested shade color, using
        ///  KColorScheme.Background(KColorScheme.NormalBackground)
        ///  as the base color and the contrast setting from the KConfig used to
        ///  create this KColorScheme instance (the system contrast setting, if no
        ///  KConfig was specified).
        ///  @note Shades are chosen such that all shades would contrast with the
        ///  base color. This means that if base is very dark, the 'dark' shades will
        ///  be lighter than the base color, with midlight() == shadow().
        ///  Conversely, if the base color is very light, the 'light' shades will be
        ///  darker than the base color, with light() == mid().
        ///      </remarks>        <short>    Retrieve the requested shade color, using  KColorScheme.Background(KColorScheme.NormalBackground)  as the base color and the contrast setting from the KConfig used to  create this KColorScheme instance (the system contrast setting, if no  KConfig was specified).</short>
        public QColor Shade(KColorScheme.ShadeRole arg1) {
            return (QColor) interceptor.Invoke("shade$", "shade(KColorScheme::ShadeRole) const", typeof(QColor), typeof(KColorScheme.ShadeRole), arg1);
        }
        ~KColorScheme() {
            interceptor.Invoke("~KColorScheme", "~KColorScheme()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~KColorScheme", "~KColorScheme()", typeof(void));
        }
        /// <remarks>
        ///  Retrieve the requested shade color, using the specified color as the
        ///  base color and the system contrast setting.
        ///  @note Shades are chosen such that all shades would contrast with the
        ///  base color. This means that if base is very dark, the 'dark' shades will
        ///  be lighter than the base color, with midlight() == shadow().
        ///  Conversely, if the base color is very light, the 'light' shades will be
        ///  darker than the base color, with light() == mid().
        ///      </remarks>        <short>    Retrieve the requested shade color, using the specified color as the  base color and the system contrast setting.</short>
        public static QColor Shade(QColor arg1, KColorScheme.ShadeRole arg2) {
            return (QColor) staticInterceptor.Invoke("shade#$", "shade(const QColor&, KColorScheme::ShadeRole)", typeof(QColor), typeof(QColor), arg1, typeof(KColorScheme.ShadeRole), arg2);
        }
        /// <remarks>
        ///  Retrieve the requested shade color, using the specified color as the
        ///  base color and the specified contrast.
        /// <param> name="contrast" Amount roughly specifying the contrast by which to
        ///  adjust the base color, between -1.0 and 1.0 (values between 0.0 and 1.0
        ///  correspond to the value from KGlobalSettings.ContrastF)
        /// </param><param> name="chromaAdjust" (optional) Amount by which to adjust the chroma of
        ///  the shade (1.0 means no adjustment)
        /// </param> @note Shades are chosen such that all shades would contrast with the
        ///  base color. This means that if base is very dark, the 'dark' shades will
        ///  be lighter than the base color, with midlight() == shadow().
        ///  Conversely, if the base color is very light, the 'light' shades will be
        ///  darker than the base color, with light() == mid().
        /// </remarks>        <short>    Retrieve the requested shade color, using the specified color as the  base color and the specified contrast.</short>
        ///         <see> KColorUtils.Shade</see>
        public static QColor Shade(QColor arg1, KColorScheme.ShadeRole arg2, double contrast, double chromaAdjust) {
            return (QColor) staticInterceptor.Invoke("shade#$$$", "shade(const QColor&, KColorScheme::ShadeRole, qreal, qreal)", typeof(QColor), typeof(QColor), arg1, typeof(KColorScheme.ShadeRole), arg2, typeof(double), contrast, typeof(double), chromaAdjust);
        }
        public static QColor Shade(QColor arg1, KColorScheme.ShadeRole arg2, double contrast) {
            return (QColor) staticInterceptor.Invoke("shade#$$", "shade(const QColor&, KColorScheme::ShadeRole, qreal)", typeof(QColor), typeof(QColor), arg1, typeof(KColorScheme.ShadeRole), arg2, typeof(double), contrast);
        }
        /// <remarks>
        ///  Adjust a QPalette by replacing the specified QPalette.ColorRole with
        ///  the requested background color for all states. Using this method is
        ///  safer than replacing individual states, as it insulates you against
        ///  changes in QPalette.ColorGroup.
        ///  @note Although it is possible to replace a foreground color using this
        ///  method, it's bad usability to do so. Just say "no".
        ///      </remarks>        <short>    Adjust a QPalette by replacing the specified QPalette.ColorRole with  the requested background color for all states.</short>
        public static void AdjustBackground(QPalette arg1, KColorScheme.BackgroundRole newRole, QPalette.ColorRole color, KColorScheme.ColorSet set, KSharedConfig arg5) {
            staticInterceptor.Invoke("adjustBackground#$$$?", "adjustBackground(QPalette&, KColorScheme::BackgroundRole, QPalette::ColorRole, KColorScheme::ColorSet, KSharedPtr<KSharedConfig>)", typeof(void), typeof(QPalette), arg1, typeof(KColorScheme.BackgroundRole), newRole, typeof(QPalette.ColorRole), color, typeof(KColorScheme.ColorSet), set, typeof(KSharedConfig), arg5);
        }
        public static void AdjustBackground(QPalette arg1, KColorScheme.BackgroundRole newRole, QPalette.ColorRole color, KColorScheme.ColorSet set) {
            staticInterceptor.Invoke("adjustBackground#$$$", "adjustBackground(QPalette&, KColorScheme::BackgroundRole, QPalette::ColorRole, KColorScheme::ColorSet)", typeof(void), typeof(QPalette), arg1, typeof(KColorScheme.BackgroundRole), newRole, typeof(QPalette.ColorRole), color, typeof(KColorScheme.ColorSet), set);
        }
        public static void AdjustBackground(QPalette arg1, KColorScheme.BackgroundRole newRole, QPalette.ColorRole color) {
            staticInterceptor.Invoke("adjustBackground#$$", "adjustBackground(QPalette&, KColorScheme::BackgroundRole, QPalette::ColorRole)", typeof(void), typeof(QPalette), arg1, typeof(KColorScheme.BackgroundRole), newRole, typeof(QPalette.ColorRole), color);
        }
        public static void AdjustBackground(QPalette arg1, KColorScheme.BackgroundRole newRole) {
            staticInterceptor.Invoke("adjustBackground#$", "adjustBackground(QPalette&, KColorScheme::BackgroundRole)", typeof(void), typeof(QPalette), arg1, typeof(KColorScheme.BackgroundRole), newRole);
        }
        public static void AdjustBackground(QPalette arg1) {
            staticInterceptor.Invoke("adjustBackground#", "adjustBackground(QPalette&)", typeof(void), typeof(QPalette), arg1);
        }
        /// <remarks>
        ///  Adjust a QPalette by replacing the specified QPalette.ColorRole with
        ///  the requested foreground color for all states. Using this method is
        ///  safer than replacing individual states, as it insulates you against
        ///  changes in QPalette.ColorGroup.
        ///  @note Although it is possible to replace a background color using this
        ///  method, it's bad usability to do so. Just say "no".
        ///      </remarks>        <short>    Adjust a QPalette by replacing the specified QPalette.ColorRole with  the requested foreground color for all states.</short>
        public static void AdjustForeground(QPalette arg1, KColorScheme.ForegroundRole newRole, QPalette.ColorRole color, KColorScheme.ColorSet set, KSharedConfig arg5) {
            staticInterceptor.Invoke("adjustForeground#$$$?", "adjustForeground(QPalette&, KColorScheme::ForegroundRole, QPalette::ColorRole, KColorScheme::ColorSet, KSharedPtr<KSharedConfig>)", typeof(void), typeof(QPalette), arg1, typeof(KColorScheme.ForegroundRole), newRole, typeof(QPalette.ColorRole), color, typeof(KColorScheme.ColorSet), set, typeof(KSharedConfig), arg5);
        }
        public static void AdjustForeground(QPalette arg1, KColorScheme.ForegroundRole newRole, QPalette.ColorRole color, KColorScheme.ColorSet set) {
            staticInterceptor.Invoke("adjustForeground#$$$", "adjustForeground(QPalette&, KColorScheme::ForegroundRole, QPalette::ColorRole, KColorScheme::ColorSet)", typeof(void), typeof(QPalette), arg1, typeof(KColorScheme.ForegroundRole), newRole, typeof(QPalette.ColorRole), color, typeof(KColorScheme.ColorSet), set);
        }
        public static void AdjustForeground(QPalette arg1, KColorScheme.ForegroundRole newRole, QPalette.ColorRole color) {
            staticInterceptor.Invoke("adjustForeground#$$", "adjustForeground(QPalette&, KColorScheme::ForegroundRole, QPalette::ColorRole)", typeof(void), typeof(QPalette), arg1, typeof(KColorScheme.ForegroundRole), newRole, typeof(QPalette.ColorRole), color);
        }
        public static void AdjustForeground(QPalette arg1, KColorScheme.ForegroundRole newRole) {
            staticInterceptor.Invoke("adjustForeground#$", "adjustForeground(QPalette&, KColorScheme::ForegroundRole)", typeof(void), typeof(QPalette), arg1, typeof(KColorScheme.ForegroundRole), newRole);
        }
        public static void AdjustForeground(QPalette arg1) {
            staticInterceptor.Invoke("adjustForeground#", "adjustForeground(QPalette&)", typeof(void), typeof(QPalette), arg1);
        }
    }
}
