/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf.model;

import org.openrdf.model.impl.URIImpl;
import org.openrdf.sail.nativerdf.ValueStoreRevision;
import org.openrdf.sail.nativerdf.model.NativeResource;

public class NativeURI
extends URIImpl
implements NativeResource {
    private static final long serialVersionUID = -5888138591826143179L;
    private ValueStoreRevision revision;
    private int internalID;

    protected NativeURI(ValueStoreRevision revision, int internalID) {
        this.setInternalID(internalID, revision);
    }

    public NativeURI(ValueStoreRevision revision, String uri) {
        this(revision, uri, -1);
    }

    public NativeURI(ValueStoreRevision revision, String uri, int internalID) {
        super(uri);
        this.setInternalID(internalID, revision);
    }

    public NativeURI(ValueStoreRevision revision, String namespace, String localname) {
        this(revision, namespace + localname);
    }

    public NativeURI(ValueStoreRevision revision, String namespace, String localname, int internalID) {
        this(revision, namespace + localname, internalID);
    }

    public void setInternalID(int internalID, ValueStoreRevision revision) {
        this.internalID = internalID;
        this.revision = revision;
    }

    public ValueStoreRevision getValueStoreRevision() {
        return this.revision;
    }

    public int getInternalID() {
        return this.internalID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NativeURI && this.internalID != -1) {
            NativeURI otherNativeURI = (NativeURI)o;
            if (otherNativeURI.internalID != -1 && this.revision.equals(otherNativeURI.revision)) {
                return this.internalID == otherNativeURI.internalID;
            }
        }
        return super.equals(o);
    }
}

