/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class CompositeName
implements Name,
Cloneable,
Serializable {
    private transient Vector elts = new Vector();

    public CompositeName() {
    }

    protected CompositeName(Enumeration comps) {
        try {
            while (comps.hasMoreElements()) {
                this.elts.add(comps.nextElement());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public CompositeName(String n) throws InvalidNameException {
        char no_quote;
        char quote = no_quote = 'x';
        boolean escaped = false;
        StringBuffer new_element = new StringBuffer();
        for (int i = 0; i < n.length(); ++i) {
            char c = n.charAt(i);
            if (escaped) {
                escaped = false;
            } else {
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (quote != no_quote) {
                    if (quote == c) {
                        if (i + 1 < n.length() && n.charAt(i + 1) != '/') {
                            throw new InvalidNameException("close quote before end of component");
                        }
                        this.elts.add(new_element.toString());
                        new_element.setLength(0);
                        quote = no_quote;
                        continue;
                    }
                } else {
                    if (new_element.length() == 0 && (c == '\'' || c == '\"')) {
                        quote = c;
                        continue;
                    }
                    if (c == '/') {
                        this.elts.add(new_element.toString());
                        new_element.setLength(0);
                        continue;
                    }
                }
            }
            new_element.append(c);
        }
        if (new_element.length() != 0) {
            this.elts.add(new_element.toString());
        }
        if (quote != no_quote) {
            throw new InvalidNameException("unterminated quote");
        }
        if (escaped) {
            throw new InvalidNameException("trailing escape character");
        }
    }

    public Name add(int posn, String comp) throws InvalidNameException {
        this.elts.add(posn, comp);
        return this;
    }

    public Name add(String comp) throws InvalidNameException {
        this.elts.add(comp);
        return this;
    }

    public Name addAll(int posn, Name n) throws InvalidNameException {
        Enumeration e = n.getAll();
        try {
            while (e.hasMoreElements()) {
                this.elts.add(posn, e.nextElement());
                ++posn;
            }
        }
        catch (NoSuchElementException ignore) {
            // empty catch block
        }
        return this;
    }

    public Name addAll(Name suffix) throws InvalidNameException {
        Enumeration e = suffix.getAll();
        try {
            while (e.hasMoreElements()) {
                this.elts.add(e.nextElement());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    public Object clone() {
        return new CompositeName(this.elts.elements());
    }

    public int compareTo(Object obj) {
        if (obj == null || !(obj instanceof CompositeName)) {
            throw new ClassCastException("CompositeName.compareTo() expected CompositeName");
        }
        CompositeName cn = (CompositeName)obj;
        int last = Math.min(cn.elts.size(), this.elts.size());
        for (int i = 0; i < last; ++i) {
            String f = (String)this.elts.get(i);
            int comp = f.compareTo((String)cn.elts.get(i));
            if (comp == 0) continue;
            return comp;
        }
        return this.elts.size() - cn.elts.size();
    }

    public boolean endsWith(Name n) {
        if (!(n instanceof CompositeName)) {
            return false;
        }
        CompositeName cn = (CompositeName)n;
        if (cn.elts.size() > this.elts.size()) {
            return false;
        }
        int delta = this.elts.size() - cn.elts.size();
        for (int i = 0; i < cn.elts.size(); ++i) {
            if (cn.elts.get(i).equals(this.elts.get(delta + i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeName)) {
            return false;
        }
        CompositeName cn = (CompositeName)obj;
        return this.elts.equals(cn.elts);
    }

    public String get(int posn) {
        return (String)this.elts.get(posn);
    }

    public Enumeration getAll() {
        return this.elts.elements();
    }

    public Name getPrefix(int posn) {
        CompositeName cn = new CompositeName();
        for (int i = 0; i < posn; ++i) {
            cn.elts.add((String)this.elts.get(i));
        }
        return cn;
    }

    public Name getSuffix(int posn) {
        if (posn > this.elts.size()) {
            throw new ArrayIndexOutOfBoundsException(posn);
        }
        CompositeName cn = new CompositeName();
        for (int i = posn; i < this.elts.size(); ++i) {
            cn.elts.add((String)this.elts.get(i));
        }
        return cn;
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.elts.size(); ++i) {
            h += this.elts.get(i).hashCode();
        }
        return h;
    }

    public boolean isEmpty() {
        return this.elts.isEmpty();
    }

    public Object remove(int posn) throws InvalidNameException {
        return this.elts.remove(posn);
    }

    public int size() {
        return this.elts.size();
    }

    public boolean startsWith(Name n) {
        if (!(n instanceof CompositeName)) {
            return false;
        }
        CompositeName cn = (CompositeName)n;
        if (cn.elts.size() > this.elts.size()) {
            return false;
        }
        for (int i = 0; i < cn.elts.size(); ++i) {
            if (cn.elts.get(i).equals(this.elts.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.elts.size(); ++i) {
            String elt = (String)this.elts.get(i);
            if (i > 0 || i == this.elts.size() - 1 && elt.equals("")) {
                result.append('/');
            }
            for (int k = 0; k < elt.length(); ++k) {
                char c = elt.charAt(k);
                if (k == 0 && (c == '\"' || c == '\'') || c == '\\' && (k == elt.length() - 1 || "\\'\"/".indexOf(elt.charAt(k + 1)) != -1) || c == '/') {
                    result.append('\\');
                }
                result.append(c);
            }
        }
        return result.toString();
    }
}

