/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Arrays;

public class BitSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7997698588986878753L;
    private static final int LONG_MASK = 63;
    private long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException();
        }
        int length = nbits >>> 6;
        if ((nbits & 0x3F) != 0) {
            ++length;
        }
        this.bits = new long[length];
    }

    public void and(BitSet bs) {
        int i;
        int max = Math.min(this.bits.length, bs.bits.length);
        for (i = 0; i < max; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & bs.bits[i];
        }
        while (i < this.bits.length) {
            this.bits[i++] = 0L;
        }
    }

    public void andNot(BitSet bs) {
        int i = Math.min(this.bits.length, bs.bits.length);
        while (--i >= 0) {
            int n = i;
            this.bits[n] = this.bits[n] & (bs.bits[i] ^ (long)-1);
        }
    }

    public int cardinality() {
        int card = 0;
        for (int i = this.bits.length - 1; i >= 0; --i) {
            long a = this.bits[i];
            if (a == 0L) continue;
            if (a == (long)-1) {
                card += 64;
                continue;
            }
            a = (a >> 1 & 0x5555555555555555L) + (a & 0x5555555555555555L);
            a = (a >> 2 & 0x3333333333333333L) + (a & 0x3333333333333333L);
            int b = (int)(a >>> 32) + (int)a;
            b = (b >> 4 & 0xF0F0F0F) + (b & 0xF0F0F0F);
            b = (b >> 8 & 0xFF00FF) + (b & 0xFF00FF);
            card += (b >> 16 & 0xFFFF) + (b & 0xFFFF);
        }
        return card;
    }

    public void clear() {
        Arrays.fill(this.bits, 0L);
    }

    public void clear(int pos) {
        int offset = pos >> 6;
        this.ensure(offset);
        int n = offset;
        this.bits[n] = this.bits[n] & (1L << (pos & 0x3F) ^ (long)-1);
    }

    public void clear(int from, int to) {
        if (from < 0 || from > to) {
            throw new IndexOutOfBoundsException();
        }
        if (from == to) {
            return;
        }
        int lo_offset = from >>> 6;
        int hi_offset = to >>> 6;
        this.ensure(hi_offset);
        if (lo_offset == hi_offset) {
            int n = hi_offset;
            this.bits[n] = this.bits[n] & ((1L << (from & 0x3F)) - 1L | (long)-1 << (to & 0x3F));
            return;
        }
        int n = lo_offset;
        this.bits[n] = this.bits[n] & (1L << (from & 0x3F)) - 1L;
        int n2 = hi_offset;
        this.bits[n2] = this.bits[n2] & (long)-1 << (to & 0x3F);
        for (int i = lo_offset + 1; i < hi_offset; ++i) {
            this.bits[i] = 0L;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void e;
            BitSet bs = (BitSet)super.clone();
            bs.bits = (long[])this.bits.clone();
            return e;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        int j;
        if (!(obj instanceof BitSet)) {
            return false;
        }
        BitSet bs = (BitSet)obj;
        int max = Math.min(this.bits.length, bs.bits.length);
        for (int i = 0; i < max; ++i) {
            if (this.bits[i] == bs.bits[i]) continue;
            return false;
        }
        for (j = i; j < this.bits.length; ++j) {
            if (this.bits[j] == 0L) continue;
            return false;
        }
        for (j = i; j < bs.bits.length; ++j) {
            if (bs.bits[j] == 0L) continue;
            return false;
        }
        return true;
    }

    public void flip(int index) {
        int offset = index >> 6;
        this.ensure(offset);
        int n = offset;
        this.bits[n] = this.bits[n] ^ 1L << (index & 0x3F);
    }

    public void flip(int from, int to) {
        if (from < 0 || from > to) {
            throw new IndexOutOfBoundsException();
        }
        if (from == to) {
            return;
        }
        int lo_offset = from >>> 6;
        int hi_offset = to >>> 6;
        this.ensure(hi_offset);
        if (lo_offset == hi_offset) {
            int n = hi_offset;
            this.bits[n] = this.bits[n] ^ (long)-1 << (from & 0x3F) & (1L << (to & 0x3F)) - 1L;
            return;
        }
        int n = lo_offset;
        this.bits[n] = this.bits[n] ^ (long)-1 << (from & 0x3F);
        int n2 = hi_offset;
        this.bits[n2] = this.bits[n2] ^ (1L << (to & 0x3F)) - 1L;
        int i = lo_offset + 1;
        while (i < hi_offset) {
            int n3 = i++;
            this.bits[n3] = this.bits[n3] ^ (long)-1;
        }
    }

    public boolean get(int pos) {
        int offset = pos >> 6;
        if (offset >= this.bits.length) {
            return false;
        }
        return ((int)(this.bits[offset] >> (pos & 0x3F)) & 1) != 0;
    }

    public BitSet get(int from, int to) {
        if (from < 0 || from > to) {
            throw new IndexOutOfBoundsException();
        }
        BitSet bs = new BitSet(to - from);
        int lo_offset = from >>> 6;
        if (lo_offset >= this.bits.length) {
            return bs;
        }
        int lo_bit = from & 0x3F;
        int hi_offset = to >>> 6;
        if (lo_bit == 0) {
            int len = Math.min(hi_offset - lo_offset + 1, this.bits.length - lo_offset);
            System.arraycopy(this.bits, lo_offset, bs.bits, 0, len);
            if (hi_offset < this.bits.length) {
                int n = hi_offset - lo_offset;
                bs.bits[n] = bs.bits[n] & (1L << (to & 0x3F)) - 1L;
            }
            return bs;
        }
        int len = Math.min(hi_offset, this.bits.length - 1);
        int reverse = ~lo_bit;
        int i = 0;
        while (lo_offset < len) {
            bs.bits[i] = this.bits[lo_offset] >>> (lo_bit & 0x3F) | this.bits[lo_offset + 1] << (reverse & 0x3F);
            ++lo_offset;
            ++i;
        }
        if ((to & 0x3F) > lo_bit) {
            bs.bits[i++] = this.bits[lo_offset] >>> (lo_bit & 0x3F);
        }
        if (hi_offset < this.bits.length) {
            int n = i - 1;
            bs.bits[n] = bs.bits[n] & (1L << (to - from & 0x3F)) - 1L;
        }
        return bs;
    }

    public int hashCode() {
        long h = 1234;
        int i = this.bits.length;
        while (i > 0) {
            h ^= (long)i * this.bits[--i];
        }
        return (int)(h >> 32) ^ (int)h;
    }

    public boolean intersects(BitSet set) {
        int i = Math.min(this.bits.length, set.bits.length);
        while (--i >= 0) {
            if ((this.bits[i] & set.bits[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        for (int i = this.bits.length - 1; i >= 0; --i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public int length() {
        int i;
        for (i = this.bits.length - 1; i >= 0 && this.bits[i] == 0L; --i) {
        }
        if (i < 0) {
            return 0;
        }
        int len = (i + 1) * 64;
        for (long b = this.bits[i]; b >= 0L; b <<= 1) {
            --len;
        }
        return len;
    }

    public int nextClearBit(int from) {
        long mask = 1L << (from & 0x3F);
        for (int offset = from >> 6; offset < this.bits.length; ++offset) {
            long h = this.bits[offset];
            do {
                if ((h & mask) == 0L) {
                    return from;
                }
                ++from;
            } while ((mask <<= 1) != 0L);
            mask = 1L;
        }
        return from;
    }

    public int nextSetBit(int from) {
        long mask = 1L << (from & 0x3F);
        for (int offset = from >> 6; offset < this.bits.length; ++offset) {
            long h = this.bits[offset];
            do {
                if ((h & mask) != 0L) {
                    return from;
                }
                ++from;
            } while ((mask <<= 1) != 0L);
            mask = 1L;
        }
        return -1;
    }

    public void or(BitSet bs) {
        this.ensure(bs.bits.length - 1);
        for (int i = bs.bits.length - 1; i >= 0; --i) {
            int n = i;
            this.bits[n] = this.bits[n] | bs.bits[i];
        }
    }

    public void set(int pos) {
        int offset = pos >> 6;
        this.ensure(offset);
        int n = offset;
        this.bits[n] = this.bits[n] | 1L << (pos & 0x3F);
    }

    public void set(int index, boolean value) {
        if (value) {
            this.set(index);
        } else {
            this.clear(index);
        }
    }

    public void set(int from, int to) {
        if (from < 0 || from > to) {
            throw new IndexOutOfBoundsException();
        }
        if (from == to) {
            return;
        }
        int lo_offset = from >>> 6;
        int hi_offset = to >>> 6;
        this.ensure(hi_offset);
        if (lo_offset == hi_offset) {
            int n = hi_offset;
            this.bits[n] = this.bits[n] | (long)-1 << (from & 0x3F) & (1L << (to & 0x3F)) - 1L;
            return;
        }
        int n = lo_offset;
        this.bits[n] = this.bits[n] | (long)-1 << (from & 0x3F);
        int n2 = hi_offset;
        this.bits[n2] = this.bits[n2] | (1L << (to & 0x3F)) - 1L;
        for (int i = lo_offset + 1; i < hi_offset; ++i) {
            this.bits[i] = -1;
        }
    }

    public void set(int from, int to, boolean value) {
        if (value) {
            this.set(from, to);
        } else {
            this.clear(from, to);
        }
    }

    public int size() {
        return this.bits.length * 64;
    }

    public String toString() {
        StringBuffer r = new StringBuffer("{");
        boolean first = true;
        for (int i = 0; i < this.bits.length; ++i) {
            long bit = 1L;
            long word = this.bits[i];
            if (word == 0L) continue;
            for (int j = 0; j < 64; ++j) {
                if ((word & bit) != 0L) {
                    if (!first) {
                        r.append(", ");
                    }
                    r.append(64 * i + j);
                    first = false;
                }
                bit <<= 1;
            }
        }
        return r.append("}").toString();
    }

    public void xor(BitSet bs) {
        this.ensure(bs.bits.length - 1);
        for (int i = bs.bits.length - 1; i >= 0; --i) {
            int n = i;
            this.bits[n] = this.bits[n] ^ bs.bits[i];
        }
    }

    private final void ensure(int lastElt) {
        if (lastElt >= this.bits.length) {
            long[] nd = new long[lastElt + 1];
            System.arraycopy(this.bits, 0, nd, 0, this.bits.length);
            this.bits = nd;
        }
    }
}

