/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class PixelGrabber
implements ImageConsumer {
    int x;
    int y;
    int width;
    int height;
    int status;
    int scansize;
    int offset;
    ColorModel model;
    int[] pixel_bufferi;
    byte[] pixel_bufferb;
    boolean grabbing;
    ImageProducer ip;

    private /* synthetic */ void finit$() {
        this.model = ColorModel.getRGBdefault();
    }

    public PixelGrabber(Image img, int x, int y, int w, int h, int[] pix, int off, int scansize) {
        this(img.getSource(), x, y, w, h, pix, off, scansize);
    }

    public PixelGrabber(ImageProducer ip, int x, int y, int w, int h, int[] pix, int off, int scansize) {
        this.finit$();
        this.ip = ip;
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.pixel_bufferi = pix;
        this.offset = off;
        this.scansize = scansize;
        this.pixel_bufferb = new byte[pix.length * 4];
    }

    public PixelGrabber(Image img, int x, int y, int w, int h, boolean forceRGB) {
        this.finit$();
    }

    public synchronized void startGrabbing() {
        if (!this.grabbing) {
            this.grabbing = true;
            this.ip.startProduction(this);
        }
    }

    public synchronized void abortGrabbing() {
        if (this.grabbing) {
            this.grabbing = false;
            this.ip.removeConsumer(this);
        }
    }

    public boolean grabPixels() throws InterruptedException {
        return this.grabPixels(0L);
    }

    public synchronized boolean grabPixels(long ms) throws InterruptedException {
        this.startGrabbing();
        if (ms < 0L) {
            return this.status == 32;
        }
        this.wait(ms);
        return this.status == 32;
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized int getWidth() {
        return this.width;
    }

    public synchronized int getHeight() {
        return this.height;
    }

    public synchronized Object getPixels() {
        if (this.pixel_bufferi != null) {
            return this.pixel_bufferi;
        }
        return this.pixel_bufferb;
    }

    public synchronized ColorModel getColorModel() {
        return this.model;
    }

    public void setDimensions(int width, int height) {
    }

    public void setProperties(Hashtable props) {
    }

    public void setColorModel(ColorModel model) {
        this.model = model;
    }

    public void setHints(int flags) {
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        for (int xp = x; xp < x + w; ++xp) {
            for (int yp = y; yp < y + h; ++yp) {
                if (xp < this.x || yp < this.y || xp > this.x + this.width || yp > this.y + this.height) continue;
                this.pixel_bufferb[(yp - this.y) * this.scansize + (xp - this.x) + this.offset] = pixels[offset + yp * scansize + xp];
            }
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        for (int xp = x; xp < x + w; ++xp) {
            for (int yp = y; yp < y + h; ++yp) {
                if (xp < this.x || yp < this.y || xp > this.x + this.width || yp > this.y + this.height) continue;
                this.pixel_bufferi[(yp - this.y) * this.scansize + (xp - this.x) + this.offset] = pixels[offset + yp * scansize + xp];
            }
        }
    }

    public synchronized void imageComplete(int status) {
        this.status = status;
    }

    public synchronized int status() {
        return this.getStatus();
    }
}

