/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxMenuItemPeer;
import java.io.Serializable;

public class CheckboxMenuItem
extends MenuItem
implements ItemSelectable,
Serializable {
    private static final long serialVersionUID = 6190621106981774043L;
    private boolean state;
    private transient ItemListener item_listeners;

    public CheckboxMenuItem() {
        this("", false);
    }

    public CheckboxMenuItem(String label) {
        this(label, false);
    }

    public CheckboxMenuItem(String label, boolean state) {
        super(label);
        this.state = state;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public boolean getState() {
        return this.state;
    }

    public synchronized void setState(boolean state) {
        this.state = state;
        if (this.peer != null) {
            CheckboxMenuItemPeer cp = (CheckboxMenuItemPeer)this.peer;
            cp.setState(state);
        }
    }

    public Object[] getSelectedObjects() {
        if (!this.state) {
            return null;
        }
        Object[] obj = new Object[]{this.getLabel()};
        return obj;
    }

    public synchronized void addNotify() {
        if (this.peer != null) {
            this.peer = this.getToolkit().createCheckboxMenuItem(this);
        }
        super.addNotify();
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, listener);
        this.enableEvents(512);
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(event);
        }
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 701 && e.id >= 701 && (this.item_listeners != null || (this.eventMask & (long)512) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    public String paramString() {
        return "label=" + this.getLabel() + ",state=" + this.state + "," + super.paramString();
    }
}

