
#
# genexports.pl: create up-to-date export and .def files
#
# created 31 August 1997 by Mark Smith <mcs@netscape.com>

$type = $ARGV[0];
$tmplfile = $ARGV[1];
$expfile = $ARGV[2];
$buildtype = $ARGV[3];

if ( $type ne "Win16" && $type ne "Win16Rev" && $type ne "Win32" &&
	$type ne "WinBC" && $type ne "AIX" && $type ne "IRIX" &&
	$type ne "MacOS" && $type ne "SOLARIS" && $type ne "SunOS" &&
	$type ne "OS2" ) {
    usage();
}

if ( $tmplfile eq "" || $expfile eq "" ) {
    usage();
}

if ( $tmplfile ne "Standard" ) {
    open( TMPL, $tmplfile );
    while(<TMPL>) {
	$line = $_;
	&process_line( $type, $expfile, $line, $ARGV[3+1], $ARGV[3+2],
		$ARGV[3+3] );
    }
} else {
    if ( substr( $type, 0, 3 ) eq "Win" ) {
	&windows_std( $type, $expfile, $ARGV[3+1], $ARGV[3+2], $ARGV[3+3] );
    } elsif ( $type eq "SOLARIS" || $type eq "SunOS" ) {
	&solaris_std( $type, $expfile, $ARGV[3+1], $ARGV[3+2], $ARGV[3+3] );
    } else {
# Simple standard template just includes exports; this works for all others.
	&simple_std( $type, $expfile, $ARGV[3+1], $ARGV[3+2], $ARGV[3+3] );
    }
}


# process_line( type, expfile, line, arg1, arg2, arg3 )
sub
process_line {
    local( $type, $expfile, $line, $arg1, $arg2, $arg3 ) = @_;

    if ( $line eq "\$EXPORTS\n" ) {
	&print_exports( $type, $expfile ); 
    } else {
	$line =~ s/\$1/$arg1/;
	$line =~ s/\$2/$arg2/;
	$line =~ s/\$3/$arg3/;
	print $line;
    }
}


# usage()
sub
usage {
    print STDERR "usage: genexports.pl TYPE TMPLFILE|Standard EXPFILE BUILDTYPE [ARG1 [[ARG2] [ARG3]]] > OUTFILE\n";
    print STDERR "    where TYPE is Win16, Win16Rev, Win32, WinBC, AIX, IRIX, MacOS, or SOLARIS.\n";
    print STDERR "    and where BUILDTYPE is matched against last field in export file.\n";
    exit 1;
}


# print_exports( type, exports-file )
sub
print_exports {
    local( $type, $expfile ) = @_;

    open( EXP, $expfile );
    &print_comment( $type, "\n" );
    &print_comment( $type, "exports list (generated by genexports.pl)\n" );
    &print_comment( $type, "\n" );
    while( <EXP> ) {
	$line = $_;
	if ( substr( $line, 0, 1 ) eq "#" ) {
	    $line = substr( $line, 1 );
	    $_ = $line;
	    if ( /^[0-9]+[\t ]/ && $type ne "OS2" ) {
		&print_comment( $type, "" );
		&print_export( $type, $line );
	    } else {
		&print_comment( $type, $line );
	    }
	} elsif ( length( $line ) eq 1 && substr( $line, 0, 1 ) eq "\n" ) {
	    print "\n";
	} else {
	    &print_export( $type, $line );
	}
    }
    &print_comment( $type, "\n" );
    &print_comment( $type, "end of generated exports list.\n" );
}


# print_comment( type, s )
sub
print_comment {
# do not print comments for OS2
    if ( $type ne "OS2" ) {
      local( $type, $s ) = @_;

      if ( $type eq "AIX" ) {
          $prefix = "* ";
      } elsif ( substr( $type, 0, 3 ) ne "Win" ) {
          $prefix = "# ";
      } else {
          $prefix = "; ";
      }

      print $prefix,$s
    }
}


# print_export( type, expline )
sub
print_export {
    local( $type, $expline ) = @_;

# strip trailing newline
    $expline =~ s/\n$//;

# split into pieces
# lines look like:  ORDINAL SYMBOL [SYMTYPE]	[BUILDTYPE]
#	where SYMTYPE is "P" (for Pascal), "C", or "G" (for globals).
#		P is the default.
    ($ordinal,$symbol,$symtype,$bldtype) = split( /[ \t]+/, $expline, 4 );
    $upcase_symbol = $symbol;
    $upcase_symbol =~ tr/a-z/A-Z/;
    if ( $symtype eq "" ) {
	$symtype = "P";
    }

    if ( $bldtype ne "" && $bldtype ne $buildtype ) {
	return;
    }

# finally, print out an appropriate export line
    if ( $type eq "Win32" || $type eq "OS2" ) {
	if ( $symtype ne "G" ) {
	    print "\t$symbol\t\t\@$ordinal\n";
	}
    } elsif ( $type eq "Win16" ) {
	if ( $symtype eq "C" ) {
	    print "\t_$symbol\t\t\@$ordinal\n";
	} elsif ( $symtype eq "P" ) {
	    print "\t_$symbol=$upcase_symbol\t\t\@$ordinal\n";
	}
    } elsif ( $type eq "Win16Rev" ) {
	if ( $symtype ne "G" ) {
	    print "\t$upcase_symbol=_$symbol\t\t\@$ordinal\n";
	}
    } elsif ( $type eq "WinBC" ) {
	if ( $symtype ne "G" ) {
	    print "\t_$symbol=$symbol\t\t\@$ordinal\n";
	}
    } elsif ( $type eq "MacOS" ) {
	if ( $symtype ne "G" ) {
	    print "$symbol\n";
	}
    } elsif ( $type eq "AIX" || $type eq "IRIX" ) {
	print "$symbol\n";
    } elsif ( $type eq "SOLARIS" || $type eq "SunOS") {
	print "\t$symbol;\n";
    } else {
	print STDERR "print_export: unknown type <$type>\n";
	exit 1;
    }
}


# windows_std( type, expfile, arg1, arg2, arg3 )
sub
windows_std {
    local( $type, $expfile, $arg1, $arg2, $arg3 ) = @_;

    process_line( $type, $expfile, "LIBRARY\tNSLIB\$1\n" );
    if ( substr( $type, 0, 5 ) eq "Win16" ) {
	process_line( $type, $expfile, "CODE\tPRELOAD MOVEABLE DISCARDABLE\n" );
	process_line( $type, $expfile, "DATA\tPRELOAD MOVEABLE SINGLE\n" );
    }
    process_line( $type, $expfile, "VERSION\t\$2\n" );
    process_line( $type, $expfile, "HEAPSIZE\t4096\n" );
    process_line( $type, $expfile, "EXPORTS\n" );
    process_line( $type, $expfile, "\$EXPORTS\n" );
}


# solaris_std( type, expfile, arg1, arg2, arg3 )
sub
solaris_std {
    local( $type, $expfile, $arg1, $arg2, $arg3 ) = @_;

    process_line( $type, $expfile, "{\n" );
    process_line( $type, $expfile, "global:\n" );
    process_line( $type, $expfile, "\$EXPORTS\n" );
    process_line( $type, $expfile, "\n" );
    process_line( $type, $expfile, "local:\n" );
    process_line( $type, $expfile, "\t*;\n" );
    process_line( $type, $expfile, "};\n" );
}


# simple_std( type, expfile, arg1, arg2, arg3 )
sub
simple_std {
    local( $type, $expfile, $arg1, $arg2, $arg3 ) = @_;

    process_line( $type, $expfile, "\$EXPORTS\n" );
}

