/*
 This file is part of SLRN.

 Copyright (c) 1994, 1999 John E. Davis <davis@space.mit.edu>

 This program is free software; you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the Free
 Software Foundation; either version 2 of the License, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 more details.

 You should have received a copy of the GNU General Public License along
 with this program; if not, write to the Free Software Foundation, Inc.,
 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/* This file is only included by chmap.c.  It is separated from it for easy
 * maintainence of the various character sets.
 */

#define HAVE_KOI8_CHARMAP       1
#define HAVE_NEXT_CHARMAP	1
#define HAVE_IBM850_CHARMAP	1
#define HAVE_IBM852_CHARMAP	1
#define HAVE_IBM857_CHARMAP	1
#define HAVE_IBM737_CHARMAP	1

#define MAX_CHARMAPS		7      /* add 1 for ISO Latin (default) */

typedef struct
{
   char *map_name;
   unsigned char display_eight_bit;
   unsigned char to_iso_map [256];
   unsigned char from_iso_map [256];
}
CharMap_Type;

#define BAD 63	/* replace untranslatable chars with question marks */

#if HAVE_IBM850_CHARMAP
static CharMap_Type IBM850_Char_Map =
{
   "ibm850", 128,
     /* These mappings were generated mechanically by Free `recode' 3.5
      * and edited manually -- recode preserved the graphic chars of cp850
      * by representing them with the ISO control characters 0x80-0x9F;
      * however, some editors were reported to choke on those. */
   /* to_iso_map */
     {
	0,   1,   2,   3,   4,   5,   6,   7,	/*   0 -   7  */
	  8,   9,  10,  11,  12,  13,  14,  15,	/*   8 -  15  */
	  16,  17,  18,  19,  20,  21,  22,  23,	/*  16 -  23  */
	  24,  25,  26,  27,  28,  29,  30,  31,	/*  24 -  31  */
	  32,  33,  34,  35,  36,  37,  38,  39,	/*  32 -  39  */
	  40,  41,  42,  43,  44,  45,  46,  47,	/*  40 -  47  */
	  48,  49,  50,  51,  52,  53,  54,  55,	/*  48 -  55  */
	  56,  57,  58,  59,  60,  61,  62,  63,	/*  56 -  63  */
	  64,  65,  66,  67,  68,  69,  70,  71,	/*  64 -  71  */
	  72,  73,  74,  75,  76,  77,  78,  79,	/*  72 -  79  */
	  80,  81,  82,  83,  84,  85,  86,  87,	/*  80 -  87  */
	  88,  89,  90,  91,  92,  93,  94,  95,	/*  88 -  95  */
	  96,  97,  98,  99, 100, 101, 102, 103,	/*  96 - 103  */
	  104, 105, 106, 107, 108, 109, 110, 111,	/* 104 - 111  */
	  112, 113, 114, 115, 116, 117, 118, 119,	/* 112 - 119  */
	  120, 121, 122, 123, 124, 125, 126, 127,	/* 120 - 127  */
	  199, 252, 233, 226, 228, 224, 229, 231,	/* 128 - 135  */
	  234, 235, 232, 239, 238, 236, 196, 197,	/* 136 - 143  */
	  201, 230, 198, 244, 246, 242, 251, 249,	/* 144 - 151  */
	  255, 214, 220, 248, 163, 216, 215, BAD,	/* 152 - 159  */
	  225, 237, 243, 250, 241, 209, 170, 186,	/* 160 - 167  */
	  191, 174, 172, 189, 188, 161, 171, 187,	/* 168 - 175  */
	  BAD, BAD, BAD, BAD, BAD, 193, 194, 192,	/* 176 - 183  */
	  169, BAD, BAD, BAD, BAD, 162, 165, BAD,	/* 184 - 191  */
	  BAD, BAD, BAD, BAD, BAD, BAD, 227, 195,	/* 192 - 199  */
	  BAD, BAD, BAD, BAD, BAD, BAD, BAD, 164,	/* 200 - 207  */
	  240, 208, 202, 203, 200, BAD, 205, 206,	/* 208 - 215  */
	  207, BAD, BAD, BAD, BAD, 166, 204, BAD,	/* 216 - 223  */
	  211, 223, 212, 210, 245, 213, 181, 254,	/* 224 - 231  */
	  222, 218, 219, 217, 253, 221, 175, 180,	/* 232 - 239  */
	  173, 177, BAD, 190, 182, 167, 247, 184,	/* 240 - 247  */
	  176, 168, 183, 185, 179, 178, BAD, 160,	/* 248 - 255  */
     },
   /* from_iso_map */
     {
	0,   1,   2,   3,   4,   5,   6,   7,	/*   0 -   7  */
	  8,   9,  10,  11,  12,  13,  14,  15,	/*   8 -  15  */
	  16,  17,  18,  19,  20,  21,  22,  23,	/*  16 -  23  */
	  24,  25,  26,  27,  28,  29,  30,  31,	/*  24 -  31  */
	  32,  33,  34,  35,  36,  37,  38,  39,	/*  32 -  39  */
	  40,  41,  42,  43,  44,  45,  46,  47,	/*  40 -  47  */
	  48,  49,  50,  51,  52,  53,  54,  55,	/*  48 -  55  */
	  56,  57,  58,  59,  60,  61,  62,  63,	/*  56 -  63  */
	  64,  65,  66,  67,  68,  69,  70,  71,	/*  64 -  71  */
	  72,  73,  74,  75,  76,  77,  78,  79,	/*  72 -  79  */
	  80,  81,  82,  83,  84,  85,  86,  87,	/*  80 -  87  */
	  88,  89,  90,  91,  92,  93,  94,  95,	/*  88 -  95  */
	  96,  97,  98,  99, 100, 101, 102, 103,	/*  96 - 103  */
	  104, 105, 106, 107, 108, 109, 110, 111,	/* 104 - 111  */
	  112, 113, 114, 115, 116, 117, 118, 119,	/* 112 - 119  */
	  120, 121, 122, 123, 124, 125, 126, 127,	/* 120 - 127  */
	  BAD, BAD, BAD, BAD, BAD, BAD, BAD, BAD,	/* 128 - 135  */
	  BAD, BAD, BAD, BAD, BAD, BAD, BAD, BAD,	/* 136 - 143  */
	  BAD, BAD, BAD, BAD, BAD, BAD, BAD, BAD,	/* 144 - 151  */
	  BAD, BAD, BAD, BAD, BAD, BAD, BAD, BAD,	/* 152 - 159  */
	  255, 173, 189, 156, 207, 190, 221, 245,	/* 160 - 167  */
	  249, 184, 166, 174, 170, 240, 169, 238,	/* 168 - 175  */
	  248, 241, 253, 252, 239, 230, 244, 250,	/* 176 - 183  */
	  247, 251, 167, 175, 172, 171, 243, 168,	/* 184 - 191  */
	  183, 181, 182, 199, 142, 143, 146, 128,	/* 192 - 199  */
	  212, 144, 210, 211, 222, 214, 215, 216,	/* 200 - 207  */
	  209, 165, 227, 224, 226, 229, 153, 158,	/* 208 - 215  */
	  157, 235, 233, 234, 154, 237, 232, 225,	/* 216 - 223  */
	  133, 160, 131, 198, 132, 134, 145, 135,	/* 224 - 231  */
	  138, 130, 136, 137, 141, 161, 140, 139,	/* 232 - 239  */
	  208, 164, 149, 162, 147, 228, 148, 246,	/* 240 - 247  */
	  155, 151, 163, 150, 129, 236, 231, 152,	/* 248 - 255  */
     }
};
#endif

#if HAVE_IBM852_CHARMAP
static CharMap_Type IBM852_Char_Map =
{
   "ibm852", 128,
   /* to_iso_map */
     {
     /* Conversion table from `cp852' charset to `iso88592' charset.
      * Generated mechanically by transtab  0.97.
      */
	    0,     1,     2,     3,     4,     5,     6,     7,	/* 000-007 */
	    8,     9,    10,    11,    12,    13,    14,    15,	/* 008-015 */
	   16,    17,    18,    19,    20,    21,    22,    23,	/* 016-023 */
	   24,    25,    26,    27,    28,    29,    30,    31,	/* 024-031 */
	   32,    33,    34,    35,    36,    37,    38,    39,	/* 032-039 */
	   40,    41,    42,    43,    44,    45,    46,    47,	/* 040-047 */
	   48,    49,    50,    51,    52,    53,    54,    55,	/* 048-055 */
	   56,    57,    58,    59,    60,    61,    62,    63,	/* 056-063 */
	   64,    65,    66,    67,    68,    69,    70,    71,	/* 064-071 */
	   72,    73,    74,    75,    76,    77,    78,    79,	/* 072-079 */
	   80,    81,    82,    83,    84,    85,    86,    87,	/* 080-087 */
	   88,    89,    90,    91,    92,    93,    94,    95,	/* 088-095 */
	   96,    97,    98,    99,   100,   101,   102,   103,	/* 096-103 */
	  104,   105,   106,   107,   108,   109,   110,   111,	/* 104-111 */
	  112,   113,   114,   115,   116,   117,   118,   119,	/* 112-119 */
	  120,   121,   122,   123,   124,   125,   126,   127,	/* 120-127 */
	  199,   252,   233,   226,   228,   249,   230,   231,	/* 128-135 */
	  179,   235,   213,   245,   238,   172,   196,   198,	/* 136-143 */
	  201,   197,   229,   244,   246,   165,   181,   166,	/* 144-151 */
	  182,   214,   220,   171,   187,   163,   215,   232,	/* 152-159 */
	  225,   237,   243,   250,   161,   177,   174,   190,	/* 160-167 */
	  202,   234,   128,   188,   200,   186,   129,   130,	/* 168-175 */
	  131,   132,   133,   134,   135,   193,   194,   204,	/* 176-183 */
	  170,   136,   137,   138,   139,   175,   191,   140,	/* 184-191 */
	  141,   142,   143,   144,   145,   146,   195,   227,	/* 192-199 */
	  147,   148,   149,   150,   151,   152,   153,   164,	/* 200-207 */
	  240,   208,   207,   203,   239,   210,   205,   206,	/* 208-215 */
	  236,   154,   155,   156,   157,   222,   217,   158,	/* 216-223 */
	  211,   223,   212,   209,   241,   242,   169,   185,	/* 224-231 */
	  192,   218,   224,   219,   253,   221,   254,   180,	/* 232-239 */
	  173,   189,   178,   183,   162,   167,   247,   184,	/* 240-247 */
	  176,   168,   255,   251,   216,   248,   159,   160	/* 248-255 */
     },
   /* from_iso_map */
     {
     /* Conversion table from `iso88592' charset to `cp852' charset.
      * Generated mechanically by transtab  0.97.
      */
 	    0,     1,     2,     3,     4,     5,     6,     7,	/* 000-007 */
	    8,     9,    10,    11,    12,    13,    14,    15,	/* 008-015 */
	   16,    17,    18,    19,    20,    21,    22,    23,	/* 016-023 */
	   24,    25,    26,    27,    28,    29,    30,    31,	/* 024-031 */
	   32,    33,    34,    35,    36,    37,    38,    39,	/* 032-039 */
	   40,    41,    42,    43,    44,    45,    46,    47,	/* 040-047 */
	   48,    49,    50,    51,    52,    53,    54,    55,	/* 048-055 */
	   56,    57,    58,    59,    60,    61,    62,    63,	/* 056-063 */
	   64,    65,    66,    67,    68,    69,    70,    71,	/* 064-071 */
	   72,    73,    74,    75,    76,    77,    78,    79,	/* 072-079 */
	   80,    81,    82,    83,    84,    85,    86,    87,	/* 080-087 */
	   88,    89,    90,    91,    92,    93,    94,    95,	/* 088-095 */
	   96,    97,    98,    99,   100,   101,   102,   103,	/* 096-103 */
	  104,   105,   106,   107,   108,   109,   110,   111,	/* 104-111 */
	  112,   113,   114,   115,   116,   117,   118,   119,	/* 112-119 */
	  120,   121,   122,   123,   124,   125,   126,   127,	/* 120-127 */
	  170,   174,   175,   176,   177,   178,   179,   180,	/* 128-135 */
	  185,   186,   187,   188,   191,   192,   193,   194,	/* 136-143 */
	  195,   196,   197,   200,   201,   202,   203,   204,	/* 144-151 */
	  205,   206,   217,   218,   219,   220,   223,   254,	/* 152-159 */
	  255,   164,   244,   157,   207,   149,   151,   245,	/* 160-167 */
	  249,   230,   184,   155,   141,   240,   166,   189,	/* 168-175 */
	  248,   165,   242,   136,   239,   150,   152,   243,	/* 176-183 */
	  247,   231,   173,   156,   171,   241,   167,   190,	/* 184-191 */
	  232,   181,   182,   198,   142,   145,   143,   128,	/* 192-199 */
	  172,   144,   168,   211,   183,   214,   215,   210,	/* 200-207 */
	  209,   227,   213,   224,   226,   138,   153,   158,	/* 208-215 */
	  252,   222,   233,   235,   154,   237,   221,   225,	/* 216-223 */
	  234,   160,   131,   199,   132,   146,   134,   135,	/* 224-231 */
	  159,   130,   169,   137,   216,   161,   140,   212,	/* 232-239 */
	  208,   228,   229,   162,   147,   139,   148,   246,	/* 240-247 */
	  253,   133,   163,   251,   129,   236,   238,   250	/* 248-255 */

     }
};
#endif

#if HAVE_IBM857_CHARMAP
static CharMap_Type IBM857_Char_Map =
{
   "ibm857", 128,
   /* to_iso_map */
    {
     /* Conversion table from `cp857' charset to `iso88599' charset.
      * Generated mechanically by transtab  1.20.
      */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, /* 00-07 */
	0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, /* 08-0F */
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, /* 10-17 */
	0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, /* 18-1F */
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, /* 20-27 */
	0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, /* 28-2F */
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 30-37 */
	0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, /* 38-3F */
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, /* 40-47 */
	0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, /* 48-4F */
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, /* 50-57 */
	0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, /* 58-5F */
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, /* 60-67 */
	0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, /* 68-6F */
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, /* 70-77 */
	0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, /* 78-7F */
	0xC7, 0xFC, 0xE9, 0xE2, 0xE4, 0xE0, 0xE5, 0xE7, /* 80-87 */
	0xEA, 0xEB, 0xE8, 0xEF, 0xEE, 0xFD, 0xC4, 0xC5, /* 88-8F */
	0xC9, 0xE6, 0xC6, 0xF4, 0xF6, 0xF2, 0xFB, 0xF9, /* 90-97 */
	0xDD, 0xD6, 0xDC, 0xF8, 0xA3, 0xD8, 0xDE, 0xFE, /* 98-9F */
	0xE1, 0xED, 0xF3, 0xFA, 0xF1, 0xD1, 0xD0, 0xF0, /* A0-A7 */
	0xBF, 0xAE, 0xAC, 0xBD, 0xBC, 0xA1, 0xAB, 0xBB, /* A8-AF */
   	BAD,    BAD,    BAD,    BAD,    BAD, 	0xC1, 0xC2, 0xC0, /* B0-B7 */
   	0xA9, BAD,    BAD,    BAD,    BAD, 	0xA2, 0xA5,    BAD, /* B8-BF */
	BAD,    BAD,    BAD,    BAD,    BAD,    BAD, 	0xE3, 0xC3, /* C0-C7 */
	BAD,    BAD,    BAD,    BAD,    BAD,    BAD,    BAD, 	0xA4, /* C8-CF */
	0xBA, 0xAA, 0xCA, 0xCB, 0xC8, BAD, 	0xCD, 0xCE, /* D0-D7 */
	0xCF, BAD,    BAD,    BAD,    BAD, 0xA6, 	0xCC,    BAD, /* D8-DF */
	0xD3, 0xDF, 0xD4, 0xD2, 0xF5, 0xD5, 0xB5,    BAD, /* E0-E7 */
	0xD7, 0xDA, 0xDB, 0xD9, 0xEC, 0xFF, 0xAF, 0xB4, /* E8-EF */
	0xAD, 0xB1,    BAD, 0xBE, 0xB6, 0xA7, 0xF7, 0xB8, /* F0-F7 */
	0xB0, 0xA8, 0xB7, 0xB9, 0xB3, 0xB2,    BAD, 0xA0  /* F8-FF */
    },
   /* from_iso_map */
    {
     /* Conversion table from `iso88599' charset to `cp857' charset.
      * Generated mechanically by transtab  1.20.
      */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, /* 00-07 */
	0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, /* 08-0F */
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, /* 10-17 */
	0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, /* 18-1F */
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, /* 20-27 */
	0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, /* 28-2F */
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 30-37 */
	0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, /* 38-3F */
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, /* 40-47 */
	0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, /* 48-4F */
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, /* 50-57 */
	0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, /* 58-5F */
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, /* 60-67 */
	0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, /* 68-6F */
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, /* 70-77 */
	0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, /* 78-7F */
   	BAD,    BAD,    BAD,    BAD,    BAD,    BAD,    BAD,    BAD,	/* 80-87 */
	BAD,    BAD,    BAD,    BAD,    BAD,    BAD,    BAD,    BAD, 	/* 88-8F */
	BAD,    BAD,    BAD,    BAD,    BAD,    BAD,    BAD,    BAD, 	/* 90-97 */
	BAD,    BAD,    BAD,    BAD,    BAD,    BAD,    BAD,    BAD, 	/* 98-9F */
	0xFF, 0xAD, 0xBD, 0x9C, 0xCF, 0xBE, 0xDD, 0xF5, /* A0-A7 */
	0xF9, 0xB8, 0xD1, 0xAE, 0xAA, 0xF0, 0xA9, 0xEE, /* A8-AF */
	0xF8, 0xF1, 0xFD, 0xFC, 0xEF, 0xE6, 0xF4, 0xFA, /* B0-B7 */
	0xF7, 0xFB, 0xD0, 0xAF, 0xAC, 0xAB, 0xF3, 0xA8, /* B8-BF */
	0xB7, 0xB5, 0xB6, 0xC7, 0x8E, 0x8F, 0x92, 0x80, /* C0-C7 */
	0xD4, 0x90, 0xD2, 0xD3, 0xDE, 0xD6, 0xD7, 0xD8, /* C8-CF */
	0xA6, 0xA5, 0xE3, 0xE0, 0xE2, 0xE5, 0x99, 0xE8, /* D0-D7 */
	0x9D, 0xEB, 0xE9, 0xEA, 0x9A, 0x98, 0x9E, 0xE1, /* D8-DF */
	0x85, 0xA0, 0x83, 0xC6, 0x84, 0x86, 0x91, 0x87, /* E0-E7 */
	0x8A, 0x82, 0x88, 0x89, 0xEC, 0xA1, 0x8C, 0x8B, /* E8-EF */
	0xA7, 0xA4, 0x95, 0xA2, 0x93, 0xE4, 0x94, 0xF6, /* F0-F7 */
	0x9B, 0x97, 0xA3, 0x96, 0x81, 0x8D, 0x9F, 0xED  /* F8-FF */

    }
};
#endif

#if HAVE_IBM737_CHARMAP
static CharMap_Type IBM737_Char_Map =
{
   "ibm737", 128,
   /* to_iso_map */
     {
     /* Conversion table from `cp737' charset to `iso88597' charset.
      * Generated mechanically by transtab  0.97.
      */
	    0,     1,     2,     3,     4,     5,     6,     7,	/* 000-007 */
	    8,     9,    10,    11,    12,    13,    14,    15,	/* 008-015 */
	   16,    17,    18,    19,    20,    21,    22,    23,	/* 016-023 */
	   24,    25,    26,    27,    28,    29,    30,    31,	/* 024-031 */
	   32,    33,    34,    35,    36,    37,    38,    39,	/* 032-039 */
	   40,    41,    42,    43,    44,    45,    46,    47,	/* 040-047 */
	   48,    49,    50,    51,    52,    53,    54,    55,	/* 048-055 */
	   56,    57,    58,    59,    60,    61,    62,    63,	/* 056-063 */
	   64,    65,    66,    67,    68,    69,    70,    71,	/* 064-071 */
	   72,    73,    74,    75,    76,    77,    78,    79,	/* 072-079 */
	   80,    81,    82,    83,    84,    85,    86,    87,	/* 080-087 */
	   88,    89,    90,    91,    92,    93,    94,    95,	/* 088-095 */
	   96,    97,    98,    99,   100,   101,   102,   103,	/* 096-103 */
	  104,   105,   106,   107,   108,   109,   110,   111,	/* 104-111 */
	  112,   113,   114,   115,   116,   117,   118,   119,	/* 112-119 */
	  120,   121,   122,   123,   124,   125,   126,   127,	/* 120-127 */
	  193,   194,   195,   196,   197,   198,   199,   200,	/* 128-135 */
	  201,   202,   203,   204,   205,   206,   207,   208,	/* 136-143 */
	  209,   211,   212,   213,   214,   215,   216,   217,	/* 144-151 */
	  225,   226,   227,   228,   229,   230,   231,   232,	/* 152-159 */
	  233,   234,   235,   236,   237,   238,   239,   240,	/* 160-167 */
	  241,   243,   242,   244,   245,   246,   247,   248,	/* 168-175 */
	  BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,	/* 176-183 */
	  BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,	/* 184-191 */
	  BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,	/* 192-199 */
	  BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,	/* 200-207 */
	  BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,	/* 208-215 */
	  BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,	/* 216-223 */
	  249,   220,   221,   222,   250,   223,   252,   253,	/* 224-231 */
	  251,   254,   182,   184,   185,   186,   188,   190,	/* 232-239 */
	  191,   177,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,	/* 240-247 */
	  176,   163,   183,   BAD,   BAD,   178,   BAD,   160	/* 248-255 */
     },
   /* from_iso_map */
     {
     /* Conversion table from `iso88597' charset to `cp737' charset.
      * Generated mechanically by transtab  0.97.
      */
 	    0,     1,     2,     3,     4,     5,     6,     7,	/* 000-007 */
	    8,     9,    10,    11,    12,    13,    14,    15,	/* 008-015 */
	   16,    17,    18,    19,    20,    21,    22,    23,	/* 016-023 */
	   24,    25,    26,    27,    28,    29,    30,    31,	/* 024-031 */
	   32,    33,    34,    35,    36,    37,    38,    39,	/* 032-039 */
	   40,    41,    42,    43,    44,    45,    46,    47,	/* 040-047 */
	   48,    49,    50,    51,    52,    53,    54,    55,	/* 048-055 */
	   56,    57,    58,    59,    60,    61,    62,    63,	/* 056-063 */
	   64,    65,    66,    67,    68,    69,    70,    71,	/* 064-071 */
	   72,    73,    74,    75,    76,    77,    78,    79,	/* 072-079 */
	   80,    81,    82,    83,    84,    85,    86,    87,	/* 080-087 */
	   88,    89,    90,    91,    92,    93,    94,    95,	/* 088-095 */
	   96,    97,    98,    99,   100,   101,   102,   103,	/* 096-103 */
	  104,   105,   106,   107,   108,   109,   110,   111,	/* 104-111 */
	  112,   113,   114,   115,   116,   117,   118,   119,	/* 112-119 */
	  120,   121,   122,   123,   124,   125,   126,   127,	/* 120-127 */
	  BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,	/* 128-135 */
	  BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,	/* 136-143 */
	  BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,	/* 144-151 */
	  BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,	/* 152-159 */
	  255,   BAD,   BAD,   249,   BAD,   BAD,   BAD,   BAD,	/* 160-167 */
	  BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,   BAD,	/* 168-175 */
	  248,   241,   253,   BAD,   BAD,   BAD,   234,   250,	/* 176-183 */
	  235,   236,   237,   BAD,   238,   BAD,   239,   240,	/* 184-191 */
	  BAD,   128,   129,   130,   131,   132,   133,   134,	/* 192-199 */
	  135,   136,   137,   138,   139,   140,   141,   142,	/* 200-207 */
	  143,   144,   BAD,   145,   146,   147,   148,   149,	/* 208-215 */
	  150,   151,   BAD,   BAD,   225,   226,   227,   229,	/* 216-223 */
	  BAD,   152,   153,   154,   155,   156,   157,   158,	/* 224-231 */
	  159,   160,   161,   162,   163,   164,   165,   166,	/* 232-239 */
	  167,   168,   170,   169,   171,   172,   173,   174,	/* 240-247 */
	  175,   224,   228,   232,   230,   231,   233,   BAD	/* 248-255 */

     }
};
#endif

#if HAVE_NEXT_CHARMAP
static CharMap_Type NeXT_Char_Map =
{
   "NeXT", 128,
   
   /* to_iso_map */
     {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
	0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
	0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
	0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
	0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,
	0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,
	0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
	0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,
	0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
	0xa0,0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc7,
	0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
	0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd9,
	0xda,0xdb,0xdc,0xdd,0xde,0xb5,0xd7,0xf7,
	0xa9,0xa1,0xa2,0xa3,0x2f,0xa5,0x66,0xa7,
	0xa4,0xb4,0x22,0xab,0x5b,0x5d,0x3f,0x3f,
	0xae,0x3f,0x3f,0x3f,0xb7,0xa6,0xb6,0xb7,
	0xb8,0x22,0x22,0xbb,0xb0,0x3f,0xac,0xbf,
	0xb9,0x60,0xb4,0x5e,0x7e,0xaf,0x3f,0xb7,
	0xa8,0x82,0xb0,0xb8,0xb3,0xa8,0x3f,0x3f,
	0x3f,0xb1,0xbc,0xbd,0xbe,0xe0,0xe1,0xe2,
	0xe3,0xe4,0xe5,0xe7,0xe8,0xe9,0xea,0xeb,
	0xec,0xc6,0xed,0xaa,0xee,0xef,0xf0,0xf1,
	0xa3,0xd8,0x4f,0xba,0xf2,0xf3,0xf4,0xf5,
	0xf6,0xe6,0xf9,0xfa,0xfb,0x69,0xfc,0xfd,
	0x6c,0xf8,0x6f,0xdf,0xfe,0xff,0x3f,0x3f
     },
   
   /* from_iso_map */
     {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
	0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
	0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
	0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
	0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,
	0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,
	0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
	0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,
	0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x80,0xa1,0xa2,0xa3,0xa8,0xa5,0xb5,0xa7,
	0xc8,0xa0,0xe3,0xab,0xbe,0x2d,0xb0,0xc5,
	0xca,0xd1,0xc9,0xcc,0xc2,0x9d,0xb6,0xb4,
	0xcb,0xc0,0xeb,0xbb,0xd2,0xd3,0xd4,0xbf,
	0x81,0x82,0x83,0x84,0x85,0x86,0xe1,0x87,
	0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x9e,
	0xe9,0x97,0x98,0x99,0x9a,0x9b,0x9c,0xfb,
	0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xf1,0xdb,
	0xdc,0xdd,0xde,0xdf,0xe0,0xe2,0xe4,0xe5,
	0xe6,0xe7,0xec,0xed,0xee,0xef,0xf0,0x9f,
	0xf9,0xf2,0xf3,0xf4,0xf6,0xf7,0xfc,0xfd
     }
};
#endif

#if HAVE_KOI8_CHARMAP 
static CharMap_Type KOI8_Char_Map =
{
   "koi8", 128,
   /* to_iso_map */
   {
   /* trivial translation, we assume that users of the koi8 encoding
    * already have the right characters in their videoboards.
    */
     0 , 1 , 2 , 3 , 4 , 5 , 6 , 7 , 8 , 9 , 10 , 
     11 , 12 , 13 , 14 , 15 , 16 , 17 , 18 , 19 , 20 , 
     21 , 22 , 23 , 24 , 25 , 26 , 27 , 28 , 29 , 30 , 
     31 , 32 , 33 , 34 , 35 , 36 , 37 , 38 , 39 , 40 , 
     41 , 42 , 43 , 44 , 45 , 46 , 47 , 48 , 49 , 50 , 
     51 , 52 , 53 , 54 , 55 , 56 , 57 , 58 , 59 , 60 , 
     61 , 62 , 63 , 64 , 65 , 66 , 67 , 68 , 69 , 70 , 
     71 , 72 , 73 , 74 , 75 , 76 , 77 , 78 , 79 , 80 , 
     81 , 82 , 83 , 84 , 85 , 86 , 87 , 88 , 89 , 90 , 
     91 , 92 , 93 , 94 , 95 , 96 , 97 , 98 , 99 , 100 , 
     101 , 102 , 103 , 104 , 105 , 106 , 107 , 108 , 109 , 
     110 , 111 , 112 , 113 , 114 , 115 , 116 , 117 , 118 , 
     119 , 120 , 121 , 122 , 123 , 124 , 125 , 126 , 127 , 
     128 , 129 , 130 , 131 , 132 , 133 , 134 , 135 , 136 , 
     137 , 138 , 139 , 140 , 141 , 142 , 143 , 144 , 145 , 
     146 , 147 , 148 , 149 , 150 , 151 , 152 , 153 , 154 , 
     155 , 156 , 157 , 158 , 159 , 160 , 161 , 162 , 163 , 
     164 , 165 , 166 , 167 , 168 , 169 , 170 , 171 , 172 , 
     173 , 174 , 175 , 176 , 177 , 178 , 179 , 180 , 181 , 
     182 , 183 , 184 , 185 , 186 , 187 , 188 , 189 , 190 , 
     191 , 192 , 193 , 194 , 195 , 196 , 197 , 198 , 199 , 
     200 , 201 , 202 , 203 , 204 , 205 , 206 , 207 , 208 , 
     209 , 210 , 211 , 212 , 213 , 214 , 215 , 216 , 217 , 
     218 , 219 , 220 , 221 , 222 , 223 , 224 , 225 , 226 , 
     227 , 228 , 229 , 230 , 231 , 232 , 233 , 234 , 235 , 
     236 , 237 , 238 , 239 , 240 , 241 , 242 , 243 , 244 , 
     245 , 246 , 247 , 248 , 249 , 250 , 251 , 252 , 253 , 
     254 , 255 
   },
    /* from_iso_map */
   {
   /* trivial translation, we assume that users of the koi8 encoding
    * already have the right characters in their videoboards.
    */
     0 , 1 , 2 , 3 , 4 , 5 , 6 , 7 , 8 , 9 , 10 , 
     11 , 12 , 13 , 14 , 15 , 16 , 17 , 18 , 19 , 20 , 
     21 , 22 , 23 , 24 , 25 , 26 , 27 , 28 , 29 , 30 , 
     31 , 32 , 33 , 34 , 35 , 36 , 37 , 38 , 39 , 40 , 
     41 , 42 , 43 , 44 , 45 , 46 , 47 , 48 , 49 , 50 , 
     51 , 52 , 53 , 54 , 55 , 56 , 57 , 58 , 59 , 60 , 
     61 , 62 , 63 , 64 , 65 , 66 , 67 , 68 , 69 , 70 , 
     71 , 72 , 73 , 74 , 75 , 76 , 77 , 78 , 79 , 80 , 
     81 , 82 , 83 , 84 , 85 , 86 , 87 , 88 , 89 , 90 , 
     91 , 92 , 93 , 94 , 95 , 96 , 97 , 98 , 99 , 100 , 
     101 , 102 , 103 , 104 , 105 , 106 , 107 , 108 , 109 , 
     110 , 111 , 112 , 113 , 114 , 115 , 116 , 117 , 118 , 
     119 , 120 , 121 , 122 , 123 , 124 , 125 , 126 , 127 , 
     128 , 129 , 130 , 131 , 132 , 133 , 134 , 135 , 136 , 
     137 , 138 , 139 , 140 , 141 , 142 , 143 , 144 , 145 , 
     146 , 147 , 148 , 149 , 150 , 151 , 152 , 153 , 154 , 
     155 , 156 , 157 , 158 , 159 , 160 , 161 , 162 , 163 , 
     164 , 165 , 166 , 167 , 168 , 169 , 170 , 171 , 172 , 
     173 , 174 , 175 , 176 , 177 , 178 , 179 , 180 , 181 , 
     182 , 183 , 184 , 185 , 186 , 187 , 188 , 189 , 190 , 
     191 , 192 , 193 , 194 , 195 , 196 , 197 , 198 , 199 , 
     200 , 201 , 202 , 203 , 204 , 205 , 206 , 207 , 208 , 
     209 , 210 , 211 , 212 , 213 , 214 , 215 , 216 , 217 , 
     218 , 219 , 220 , 221 , 222 , 223 , 224 , 225 , 226 , 
     227 , 228 , 229 , 230 , 231 , 232 , 233 , 234 , 235 , 
     236 , 237 , 238 , 239 , 240 , 241 , 242 , 243 , 244 , 
     245 , 246 , 247 , 248 , 249 , 250 , 251 , 252 , 253 , 
     254 , 255 
    }
};
#endif 				       /* HAVE_KOI8_CHARMAP */

#if HAVE_IBM850_CHARMAP && defined(IBMPC_SYSTEM)
# define DEFAULT_CHARSET_NAME "ibm850"
#else
# if HAVE_NEXT_CHARMAP && defined(__NeXT__)
#  define DEFAULT_CHARSET_NAME "NeXT"
# endif
#endif

#ifndef DEFAULT_CHARSET_NAME
# define DEFAULT_CHARSET_NAME "isolatin"
#endif

static CharMap_Type *Char_Maps [MAX_CHARMAPS] =
{
#if HAVE_IBM850_CHARMAP
   &IBM850_Char_Map,
#endif
#if HAVE_IBM852_CHARMAP
   &IBM852_Char_Map,
#endif
#if HAVE_IBM857_CHARMAP
   &IBM857_Char_Map,
#endif
#if HAVE_IBM737_CHARMAP
   &IBM737_Char_Map,
#endif
#if HAVE_NEXT_CHARMAP
   &NeXT_Char_Map,
#endif
#if HAVE_KOI8_CHARMAP
   &KOI8_Char_Map,
#endif
   NULL				       /* MUST be NULL terminated */
};


