/* This file is part of the KDE project
   Copyright (C) 2001 Simon Hausmann <hausmann@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the Artistic License.
*/
#ifndef __topic_h__
#define __topic_h__

#include <qlabel.h>
#include <qlineedit.h>
#include <qpopupmenu.h>
#include <qguardedptr.h>

class KSircTopicEditor;

class KSircTopic : public QLabel
{
    Q_OBJECT
public:
    KSircTopic( QWidget *parent, const char *name = 0 );

signals:
    void topicChange( const QString &newTopic );

protected:
    virtual void mouseDoubleClickEvent( QMouseEvent * );
    virtual void mouseReleaseEvent( QMouseEvent * );

private slots:
    void setNewTopic();

private:
    QGuardedPtr<KSircTopicEditor> m_editor;
    bool m_doEdit;
};

class KSircTopicEditor : public QLineEdit
{
public:
    KSircTopicEditor( QWidget *parent, const char *name = 0 );

protected:
    virtual void keyPressEvent( QKeyEvent *ev );
    virtual void focusOutEvent( QFocusEvent * );
    virtual QPopupMenu *createPopupMenu();

private:
    QGuardedPtr<QPopupMenu> m_popup;
};

#endif
