/***************************************************************************
                          vumeter.cpp  -  description
                             -------------------
    begin                : Mon Jul 22 2002
    copyright            : (C) 2002 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "vumeter.h"

#include <ktoolbar.h>
#include <qpainter.h>

VUMeter::VUMeter(KToolBar *parent, const char *name ) : QFrame(parent,name) {
	setBackgroundColor( QColor(120,120,120) );
	setFrameStyle( Panel|Sunken );
	setLineWidth( 1 );
	setMinimumSize( 10, 10 );

	i_left = i_right = 0.0;
}

VUMeter::~VUMeter(){
}

void VUMeter::drawContents( QPainter *p ){
	QRect leftRect = contentsRect();
	QRect rightRect = contentsRect();
	if( contentsRect().width() > contentsRect().height() )
	{
		// Meter from left to right
		leftRect.setHeight( leftRect.height() / 2 );
		rightRect.setTop( leftRect.bottom() + 1 );
		leftRect.setWidth( leftRect.width() * i_left );
		rightRect.setWidth( rightRect.width() * i_right );
	}
	else
	{
		// Meter from bottom to top
		leftRect.setWidth( leftRect.width() / 2 );
		rightRect.setLeft( leftRect.right() + 1 );
		leftRect.setTop( leftRect.bottom() - int( leftRect.height() * i_left ) );
		rightRect.setTop( rightRect.bottom() - int( rightRect.height() * i_right ) );
	}
	QRegion eraseRegion = contentsRect();
	eraseRegion = eraseRegion.subtract( leftRect );
	eraseRegion = eraseRegion.subtract( rightRect );
	erase( eraseRegion );

	p->fillRect( leftRect, color( i_left ) );
	p->fillRect( rightRect, color( i_right ) );

}

void VUMeter::newSValue( float left, float right ){
	i_left = (left<=1)?left:1;
	i_right = (right<=1)?right:1;
	repaint( false );
}

QColor VUMeter::color( float value ){
	float red = (value<=0.5)?255*2*value:255;
	float green = (value>0.5)?255-255*2*(value-0.5):255;
	return QColor( red, green, 0 );
}

#include "vumeter.moc"

// vim:sw=4:ts=4
