/***************************************************************************
                          session.h  -  description
                             -------------------
    begin                : Die Jun 18 2002
    copyright            : (C) 2002 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SESSION_H
#define SESSION_H

#include <qobject.h>
#include <klistview.h>
#include <qstring.h>

class QPixmap;
class KActionMenu;
class KAction;
class KToggleAction;
class RecordFile;

/**
  *@author Arnold Krille
  */

class Session : public QObject, public KListViewItem
{
	Q_OBJECT
public:
	/// Constructor
	Session( QString nprefix, KListView *parent=0, QObject *parObj=0 );
	/// Initializes the variables.
	void init( QString );
	/// Destructor
	~Session();
	/// Identificationnumber
	/**
		Returns 1002.
	*/
	int rtti() const { return 1002; }
public slots:
	/// Returns the prefix.
	QString prefix() { return i_prefix; }
	/// Returns the actual takenumber.
	int take() { return i_takecount; }
	/// Returns the next takenumber.
	int nexttake() { i_takecount++; return i_takecount; }

	/// Is called when a new file wants to be recorded.
	void newRecFile( RecordFile* file ) { emit sNewRecFile( file ); }
	/// Is called when a new file wants to be played.
	void newPlayFile( RecordFile* file ) { emit sNewPlayFile( file ); }

	/// Returns the pixmap if i != 0.
	const QPixmap* pixmap( int i=0) const;
	/// Opens the tree.
	void setOpen( bool open );
	/// Returns the Contextmenu.
	KActionMenu* menu() { return i_menu; }

protected slots:
	/// Creates a new file.
	void newFile();

signals:
	/// Is emitted when a new file wants to be recorded.
	void sNewRecFile( RecordFile* );
	/// Is emitted when a new file wants to be played.
	void sNewPlayFile( RecordFile* );

private:
	/// Sets the prefix.
	void prefix( QString nprefix ) { i_prefix = nprefix; }

	QString i_prefix;
	int i_takecount;
	QPixmap *pix;
	QPixmap *folder_open;
	QPixmap *folder_closed;
	KActionMenu* i_menu;
	KToggleAction* a_open;
	KAction *a_newFile, *a_closeSession;
};

#endif

// vim:sw=4:ts=4
