/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __monitorpageimpl_h__
#define __monitorpageimpl_h__

#include "monitorpage.h"

#include "kxpage.h"

#include "kxdata.h"

class MonitorPage : public MonitorPageBase, public KXPage
{
    Q_OBJECT
    Q_PROPERTY( QString quickHelp READ quickHelp )

public:
    MonitorPage( QWidget *parent, const char *name = 0 );
    virtual ~MonitorPage();

    QString quickHelp() const;

    // reimplemented from KXPage
    virtual void load();
    virtual void save();

signals:
    void enableForward( bool enable );
    void changed();
    void status( const QString & );

private slots:
    void monitorSelected( QListViewItem *item );
    void vendorSelected( QListViewItem *item );

    void checkHSync();
    void checkVSync();

private:
    void displayMonitorDetails();
    void clearMonitorDetails();

    KXMonitorData m_current;
};

#endif
