/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "kxpage.h"
#include "kxdata.h"

#include <qwidget.h>

#include <kdebug.h>

KXPage::KXPage()
{
    m_data = KXData::global();
    m_savingDirty = false;
    m_loadingDirty = true;
    m_forwardEnabled = false;
}

void KXPage::setData( KXData *data )
{
    m_data = data;
    m_loadingDirty = true;
}

void KXPage::savePage()
{
    if ( !m_savingDirty )
    {
        kdDebug() << "savePage() : not dirty!" << endl;
        return;
    }

    kdDebug() << "savePage() : saving..." << endl;

    save();
    m_savingDirty = false;
}

void KXPage::loadPage()
{
    if ( !m_loadingDirty )
    {
        kdDebug() << "loadPage() : not dirty!" << endl;
        return;
    }

    kdDebug() << "loadPage() : loading..." << endl;

    load();
    m_loadingDirty = false;
}

KXPageHandler::KXPageHandler( QObject *parent, const char *name )
    : QObject( parent, name )
{
}

KXPageHandler::~KXPageHandler()
{
}

void KXPageHandler::addPage( QWidget *page )
{
    assert( page );

    KXPage *pg = dynamic_cast<KXPage *>( page );

    assert( pg != 0 );

    if ( m_pages.findRef( pg ) != -1 )
        return;

    m_pages.append( pg );

    connect( page, SIGNAL( changed() ),
             this, SLOT( slotChanged() ) );

    page->installEventFilter( this );
}

bool KXPageHandler::eventFilter( QObject *obj, QEvent *ev )
{
    if ( ev->type() != QEvent::Show &&
         ev->type() != QEvent::Hide )
        return false;

    KXPage *page = dynamic_cast<KXPage *>( obj );

    if ( !page )
    {
        kdDebug() << "weird! received event from object <" << obj->className() << "> , not inheritting from KXPage!" << endl;
        return false;
    }

    if ( ev->type() == QEvent::Show )
    {
        emit enableForward( page->isForwardEnabled() );
        page->loadPage();
    }
    else
    {
        bool dirty = page->isSavingDirty();

        page->savePage();

        if ( dirty )
        {
            int idx = m_pages.findRef( page );
            assert( idx != -1 );

            for ( unsigned int i = idx + 1; i < m_pages.count(); ++i )
                m_pages.at( i )->setLoadingDirty( true );
        }
    }

    return false;
}

void KXPageHandler::slotChanged()
{
    QObject *obj = const_cast<QObject *>( sender() );

    KXPage *page = dynamic_cast<KXPage *>( obj );

    if ( !page )
    {
        kdDebug() << "weird! received changed() signal from object <" << obj->className() << "> , not inheritting from KXPage!" << endl;
        return;
    }

    kdDebug() << "slotChanged() " << obj->className() << endl;

    page->setSavingDirty( true );
}

#include "kxpage.moc"
