/*
 *  Copyright (C) 2003  Tommi Komulainen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */ 

#ifndef GUL_GUI_OPTION_H
#define GUL_GUI_OPTION_H 1

#include <gtk/gtkoptionmenu.h>

G_BEGIN_DECLS

typedef struct _GulGuiOption GulGuiOption;
struct _GulGuiOption
{
	/*< public >*/
	char *title;
	char *value;
	
	/*< protected >*/
	char *key;
};

GulGuiOption *gul_gui_option_new                (const char *title,
		                                 const char *value);

GSList       *gul_gui_option_list_new           (const GulGuiOption *options,
		                                 guint n_options);

GSList       *gul_gui_option_list_insert_sorted (GSList *options,
		                                 GulGuiOption *item);

GSList       *gul_gui_option_list_sort          (GSList *options);

GulGuiOption *gul_gui_option_list_find          (GSList *option,
		                                 const char *value);

void          gul_gui_option_list_free          (GSList *options);

void          gul_gui_option_menu_set_options   (GtkOptionMenu *optionmenu,
		                                 GSList *options);

GulGuiOption *gul_gui_option_menu_get_option    (GtkOptionMenu *optionmenu);

const char   *gul_gui_option_menu_get_value     (GtkOptionMenu *optionmenu);

void          gul_gui_option_menu_set_value     (GtkOptionMenu *optionmenu,
		                                 const char *value);

G_END_DECLS

#endif /* GUL_GUI_OPTION_H */
