/*
 *  Copyright (C) 2002 Jorn Baayen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#ifndef __GALEON_FAVICON_CACHE_H
#define __GALEON_FAVICON_CACHE_H

G_BEGIN_DECLS

#define GALEON_TYPE_FAVICON_CACHE         (galeon_favicon_cache_get_type ())
#define GALEON_FAVICON_CACHE(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GALEON_TYPE_FAVICON_CACHE, GaleonFaviconCache))
#define GALEON_FAVICON_CACHE_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), GALEON_TYPE_FAVICON_CACHE, GaleonFaviconCacheClass))
#define GALEON_IS_FAVICON_CACHE(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GALEON_TYPE_FAVICON_CACHE))
#define GALEON_IS_FAVICON_CACHE_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GALEON_TYPE_FAVICON_CACHE))
#define GALEON_FAVICON_CACHE_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GALEON_TYPE_FAVICON_CACHE, GaleonFaviconCacheClass))

typedef struct GaleonFaviconCachePrivate GaleonFaviconCachePrivate;

typedef struct
{
	GObject parent;

	GaleonFaviconCachePrivate *priv;
} GaleonFaviconCache;

typedef struct
{
	GObjectClass parent_class;

	void (*changed) (GaleonFaviconCache *cache, const char *url);
} GaleonFaviconCacheClass;

GType               galeon_favicon_cache_get_type        (void);

GaleonFaviconCache *galeon_favicon_cache_new             (void);

GdkPixbuf          *galeon_favicon_cache_lookup          (GaleonFaviconCache *cache,
						          const char *url);

GdkPixbuf          *galeon_favicon_cache_lookup_direct   (GaleonFaviconCache *cache,
						          const char *cache_url);

char 		   *galeon_favicon_cache_url		 (const char *url);

void                galeon_favicon_cache_insert_from_url (GaleonFaviconCache *cache,
							  const char *url,
							  const char *favicon_url);

gboolean            galeon_favicon_cache_url_equal       (const char *a,
						          const char *b);

G_END_DECLS

#endif /* __GALEON_FAVICON_CACHE_H */
