#
# Makefile of rules for creating dependencies using the 'makedepend'
# program. DEPFILE contains the name of the file wherein the dependencies
# should be placed. This defaults to 'dependencies.mk' in the local directory.
# It may, however, be changed to 'Makefile' without harm.
#
# If you want the dependencies to include the full pathname of each include
# file, you must specify the '-p' flag in the DEPFLAGS variable.
#
# If the SRCS variable is defined, the 'depend' target will be set up
# to create dependencies for all files in that variable.
#
# The MAKEDEPEND rule will pass all -I and -D flags given in the CFLAGS
# variable to makedepend. Usage is like this:
#
# depend : $(LIBSRCS) $(PROGSRC) MAKEDEPEND
# 
DEPFLAGS	?=

#if defined(SRCS) && !defined(NODEPEND)
depend		: $(SRCS) MAKEDEPEND .NOTMAIN
#endif

DEPFILE		?= dependencies.mk

MAKEDEPEND	: .USE
#
# Make sure the DEPFILE exists since makedepend will complain otherwise
#
	test -f $(DEPFILE) || touch $(DEPFILE)
#if !empty(.CURDIR:M.)
	$(MKDEP) $(CFLAGS:M-[ID]*) $(DEPFLAGS) -f $(DEPFILE) $(.ALLSRC)
#else
#
# This is tricky because we want to run makedepend in the source directory
# so all paths turn out relative to where pmake was started, not relative to
# the $(MAKEOBJDIR).
# Edit the include directories and source file names to strip initial
# $(.CURDIR).  Also copy the DEPFILE from its current location to where
# makedepend can find it, and back to the target location when finished.
#
	cp $(DEPFILE) /tmp/mkdep$$$$; \
	(cd $(.CURDIR); \
	$(MKDEP) \
		$(CFLAGS:M-[ID]*:S@^-I$(.CURDIR)$@-I.@g:S@^-I$(.CURDIR)/@-I@g) \
		$(DEPFLAGS) \
		-f /tmp/mkdep$$$$ \
		$(.ALLSRC:S@^$(.CURDIR)/@@g)) ; \
	mv $(DEPFILE) $(DEPFILE).bak ; \
	mv /tmp/mkdep$$$$ $(DEPFILE); \
	rm -f /tmp/mkdep$$$$.bak
#endif
