#!/bin/sh
#
# needed --
#	Figure out which of a given list of functions are not in libc
#
#	usage: needed compile symbol ...
#
#	returns list of 'symbol.o ...'
#
#	$Header: /usr/src/local/icsi/pmake/lib/sprite/../../etc/RCS/needed.sh,v 1.2 1998/04/04 15:36:57 stolcke Exp $
#
CC=$1
shift

cfile=needed$$.c
ofile=needed$$.o
errfile=needed$$.err

trap "rm -f $cfile $ofile $errfile; exit" 0 1 2 15

{
	echo 'main () {'
	for symbol
	do
		echo "$symbol();"
	done
	echo '}'
} > $cfile
$CC $cfile -o $ofile > $errfile 2>&1
for symbol
do
	if grep $symbol $errfile >/dev/null; then
		echo $symbol.o
	fi
done

