/* -*- c-file-style: "java"; indent-tabs-mode: nil -*-
 * 
 * distcc -- A simple distributed compiler system
 *
 * Copyright (C) 2003 by Martin Pool <mbp@samba.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef _DISTCC_MON_H
#define _DISTCC_MON_H

#ifdef __cplusplus
extern "C" {
#endif


/**
 * List element representing status of a distcc process.
 **/
struct dcc_mon_list {
    unsigned int cpid;          /**< Client pid */
    char *file;                 /**< Filename */
    char *host;                 /**< Host description */
    char *state;                /**< Description of state, see state.h */

    struct dcc_mon_list *next;
};


/**
 * Read the list of running processes for this user.
 *
 * @param ppl On return, recieves a pointer to the start of a list of
 * status elements, representing the running processes.  *ppl will be
 * NULL if there are no processes running.
 *
 * @return 0 for success or an error from exitcode.h.
 *
 * The list is not sorted in any particular order, but it will tend to
 * remain stable from one call to the next.
 *
 * The caller should free the list through dcc_mon_list_free().
 **/
int dcc_mon_poll(struct dcc_mon_list **ppl);

/**
 * Free a list of dcc_mon_list elements, including all their contents.
 **/
int dcc_mon_list_free(struct dcc_mon_list *);


/**
 * Set up to notify the monitor when the compiler state changes.
 *
 * On successful return, @p dummy_fd receives the file descriptor of a
 * pipe.  When the state changes, a single byte will be written to
 * that pipe.  By including the pipe fd in a select() or poll() set,
 * the monitor will be woken when the state has changed.
 *
 * The client should do a nonblocking read from the pipe to empty it
 * out each time a notification is received.
 *
 * This is currently only implemented on Linux.
 *
 * @return 0 for success or an exitcode.h value.  In particular,
 * returns EXIT_IO_ERROR if notifications are not available on this
 * system.
 **/
int dcc_mon_setup_notify (int *dummy_fd);

#ifdef __cplusplus
}
#endif

#endif /* _DISTCC_MON_H */
