# 
# -- START --
# $Id: postinstall.linux.sh,v 1.6 2001/12/12 01:54:49 papowell Exp papowell $
#
#  If you are building an RPM package,  please see the
#  DISTRIBUTIONS/RPM directory(s) for a RPM Spec file
#  that makes a package
# This script is used from the Makefile when we are doing
#  a source level install and NOT building a package.
# We first install the sample files
#
echo RUNNING postinstall.linux.sh MAKEPACKAGE="$MAKEPACKAGE" MAKEINSTALL="$MAKEINSTALL" PREFIX="$PREFIX" DESTDIR="$DESTDIR" cwd `pwd`
#/usr/bin/printenv
if [ "$VERBOSE_INSTALL" != "" ] ; then set -x; fi
fix () {
	v=`echo $1 | sed -e 's/[:;].*//'`;
    p=`echo $2 | sed -e 's/:.*//'`; d=`dirname $p`;
	if expr "$p" : "\|" >/dev/null ; then
		echo "$v is a filter '$p'" 
		exit 0
	fi
	echo "Checking for $v.sample in $d"
	if [ ! -d "$d" ] ; then
		echo "Directory $d does not exist!"
		mkdir -p $d;
	fi
	if [ -f $v.sample ] ; then
		if [ $v.sample != $p.sample ] ; then cp $v.sample $p.sample; fi
	elif [ -f $v ] ; then
		if [ $v != $p.sample ] ; then cp $v $p.sample; fi
	else
		echo "Do not have $v.sample or $v"
	fi
	if [ ! -f $p.sample ] ; then
		echo "Do not have $p.sample"
	else
		if [ -f $p ] ; then
			date=`date | awk '{ print $6, $2, $3, $4;}' | sed -e 's/  */_/g' `
			echo "Saving $p in $p.$date"
			mv $p $p.$date
		fi
		chmod 644 $p.sample
		cp $p.sample $p;
		chmod 644 $p;
	fi;
}
echo "Installing configuration files"
if [ "X$MAKEINSTALL" = "XYES" ] ; then
	fix ifhp.conf "${DESTDIR}${IFHP_CONF}"
else
	fix "${IFHP_CONF}" "${DESTDIR}${IFHP_CONF}"
fi;
