/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.ServerSocketAdaptor;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.SocketOpts;
import sun.nio.ch.SocketOptsImpl;
import sun.nio.ch.Util;

class ServerSocketChannelImpl
extends ServerSocketChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    private final FileDescriptor fd;
    private int fdVal;
    private volatile long thread = 0L;
    private final Object lock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_INUSE = 0;
    private static final int ST_KILLED = 1;
    private int state = 0;
    private SocketAddress localAddress = null;
    private SocketOpts.IP.TCP options = null;
    ServerSocket socket;
    static final /* synthetic */ boolean $assertionsDisabled;

    public int getFDVal() {
        return this.fdVal;
    }

    static {
        $assertionsDisabled = !ServerSocketChannelImpl.class.desiredAssertionStatus();
        Util.load();
        ServerSocketChannelImpl.initIDs();
        nd = new SocketDispatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            nd.preClose(this.fd);
            long l2 = this.thread;
            if (l2 != 0L) {
                NativeThread.signal(l2);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1) {
                return;
            }
            if (this.state == -1) {
                this.state = 1;
                return;
            }
            if (!$assertionsDisabled && (this.isOpen() || this.isRegistered())) {
                throw new AssertionError();
            }
            nd.close(this.fd);
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress != null;
        }
    }

    protected void implConfigureBlocking(boolean bl2) throws IOException {
        IOUtil.configureBlocking(this.fd, bl2);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    private static native void listen(FileDescriptor var0, int var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        if (!this.isOpen()) {
            stringBuffer.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.localAddress() == null) {
                    stringBuffer.append("unbound");
                } else {
                    stringBuffer.append(this.localAddress().toString());
                }
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSocket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = ServerSocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.isBound()) {
                throw new AlreadyBoundException();
            }
            InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(inetSocketAddress.getPort());
            }
            Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            ServerSocketChannelImpl.listen(this.fd, n2 < 1 ? 50 : n2);
            Object object2 = this.stateLock;
            synchronized (object2) {
                this.localAddress = Net.localAddress(this.fd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SocketChannel accept() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            InetSocketAddress[] inetSocketAddressArray;
            FileDescriptor fileDescriptor;
            int n2;
            SocketChannelImpl socketChannelImpl;
            block16: {
                boolean bl2;
                SocketChannel socketChannel;
                block15: {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    if (!this.isBound()) {
                        throw new NotYetBoundException();
                    }
                    socketChannelImpl = null;
                    n2 = 0;
                    fileDescriptor = new FileDescriptor();
                    inetSocketAddressArray = new InetSocketAddress[1];
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            socketChannel = null;
                            Object var8_8 = null;
                            this.thread = 0L;
                            bl2 = n2 > 0;
                            break block15;
                        }
                        this.thread = NativeThread.current();
                        while ((n2 = this.accept0(this.fd, fileDescriptor, inetSocketAddressArray)) == -3 && this.isOpen()) {
                        }
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        this.thread = 0L;
                        this.end(n2 > 0);
                        if (!$assertionsDisabled && !IOStatus.check(n2)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                return socketChannel;
            }
            Object var8_9 = null;
            this.thread = 0L;
            this.end(n2 > 0);
            if (!$assertionsDisabled && !IOStatus.check(n2)) {
                throw new AssertionError();
            }
            if (n2 < 1) {
                return null;
            }
            IOUtil.configureBlocking(fileDescriptor, true);
            InetSocketAddress inetSocketAddress = inetSocketAddressArray[0];
            socketChannelImpl = new SocketChannelImpl(this.provider(), fileDescriptor, inetSocketAddress);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkAccept(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                }
                catch (SecurityException securityException) {
                    socketChannelImpl.close();
                    throw securityException;
                }
            }
            return socketChannelImpl;
        }
    }

    public ServerSocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = Net.serverSocket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
    }

    public boolean translateReadyOps(int n2, int n3, SelectionKeyImpl selectionKeyImpl) {
        int n4 = selectionKeyImpl.interestOps();
        int n5 = selectionKeyImpl.readyOps();
        int n6 = n3;
        if ((n2 & 0x20) != 0) {
            return false;
        }
        if ((n2 & 0x18) != 0) {
            n6 = n4;
            selectionKeyImpl.readyOps(n6);
            return (n6 & ~n5) != 0;
        }
        if ((n2 & 1) != 0 && (n4 & 0x10) != 0) {
            n6 |= 0x10;
        }
        selectionKeyImpl.readyOps(n6);
        return (n6 & ~n5) != 0;
    }

    public void translateAndSetInterestOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = 0;
        if ((n2 & 0x10) != 0) {
            n3 |= 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n3);
    }

    public boolean translateAndSetReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n2, 0, selectionKeyImpl);
    }

    public boolean translateAndUpdateReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n2, selectionKeyImpl.readyOps(), selectionKeyImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketOpts options() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.options == null) {
                SocketOptsImpl.Dispatcher dispatcher = new SocketOptsImpl.Dispatcher(){

                    int getInt(int n2) throws IOException {
                        return Net.getIntOption(ServerSocketChannelImpl.this.fd, n2);
                    }

                    void setInt(int n2, int n3) throws IOException {
                        Net.setIntOption(ServerSocketChannelImpl.this.fd, n2, n3);
                    }
                };
                this.options = new SocketOptsImpl.IP.TCP(dispatcher);
            }
            return this.options;
        }
    }

    private native int accept0(FileDescriptor var1, FileDescriptor var2, InetSocketAddress[] var3) throws IOException;
}

