/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.IOException;
import java.util.Properties;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.CharInfo;
import org.apache.xalan.serialize.ElemDesc;
import org.apache.xalan.serialize.Encodings;
import org.apache.xalan.serialize.SerializerToXML;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.Trie;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SerializerToHTML
extends SerializerToXML {
    protected BoolStack m_isRawStack = new BoolStack();
    private boolean m_inBlockElem = false;
    protected static CharInfo m_htmlcharInfo = new CharInfo(CharInfo.HTML_ENTITIES_RESOURCE);
    static Trie m_elementFlags = new Trie();
    private static ElemDesc m_dummy;
    private boolean m_specialEscapeURLs = true;
    private boolean m_omitMetaTag = false;
    private String m_currentElementName = null;

    static {
        m_elementFlags.put("BASEFONT", new ElemDesc(2));
        m_elementFlags.put("FRAME", new ElemDesc(10));
        m_elementFlags.put("FRAMESET", new ElemDesc(8));
        m_elementFlags.put("NOFRAMES", new ElemDesc(8));
        m_elementFlags.put("ISINDEX", new ElemDesc(10));
        m_elementFlags.put("APPLET", new ElemDesc(0x200000));
        m_elementFlags.put("CENTER", new ElemDesc(8));
        m_elementFlags.put("DIR", new ElemDesc(8));
        m_elementFlags.put("MENU", new ElemDesc(8));
        m_elementFlags.put("TT", new ElemDesc(4096));
        m_elementFlags.put("I", new ElemDesc(4096));
        m_elementFlags.put("B", new ElemDesc(4096));
        m_elementFlags.put("BIG", new ElemDesc(4096));
        m_elementFlags.put("SMALL", new ElemDesc(4096));
        m_elementFlags.put("EM", new ElemDesc(8192));
        m_elementFlags.put("STRONG", new ElemDesc(8192));
        m_elementFlags.put("DFN", new ElemDesc(8192));
        m_elementFlags.put("CODE", new ElemDesc(8192));
        m_elementFlags.put("SAMP", new ElemDesc(8192));
        m_elementFlags.put("KBD", new ElemDesc(8192));
        m_elementFlags.put("VAR", new ElemDesc(8192));
        m_elementFlags.put("CITE", new ElemDesc(8192));
        m_elementFlags.put("ABBR", new ElemDesc(8192));
        m_elementFlags.put("ACRONYM", new ElemDesc(8192));
        m_elementFlags.put("SUP", new ElemDesc(98304));
        m_elementFlags.put("SUB", new ElemDesc(98304));
        m_elementFlags.put("SPAN", new ElemDesc(98304));
        m_elementFlags.put("BDO", new ElemDesc(98304));
        m_elementFlags.put("BR", new ElemDesc(98314));
        m_elementFlags.put("BODY", new ElemDesc(8));
        m_elementFlags.put("ADDRESS", new ElemDesc(56));
        m_elementFlags.put("DIV", new ElemDesc(56));
        m_elementFlags.put("A", new ElemDesc(32768));
        m_elementFlags.put("MAP", new ElemDesc(98312));
        m_elementFlags.put("AREA", new ElemDesc(10));
        m_elementFlags.put("LINK", new ElemDesc(131082));
        m_elementFlags.put("IMG", new ElemDesc(2195458));
        m_elementFlags.put("OBJECT", new ElemDesc(2326528));
        m_elementFlags.put("PARAM", new ElemDesc(2));
        m_elementFlags.put("HR", new ElemDesc(58));
        m_elementFlags.put("P", new ElemDesc(56));
        m_elementFlags.put("H1", new ElemDesc(262152));
        m_elementFlags.put("H2", new ElemDesc(262152));
        m_elementFlags.put("H3", new ElemDesc(262152));
        m_elementFlags.put("H4", new ElemDesc(262152));
        m_elementFlags.put("H5", new ElemDesc(262152));
        m_elementFlags.put("H6", new ElemDesc(262152));
        m_elementFlags.put("PRE", new ElemDesc(0x100008));
        m_elementFlags.put("Q", new ElemDesc(98304));
        m_elementFlags.put("BLOCKQUOTE", new ElemDesc(56));
        m_elementFlags.put("INS", new ElemDesc(0));
        m_elementFlags.put("DEL", new ElemDesc(0));
        m_elementFlags.put("DL", new ElemDesc(56));
        m_elementFlags.put("DT", new ElemDesc(8));
        m_elementFlags.put("DD", new ElemDesc(8));
        m_elementFlags.put("OL", new ElemDesc(524296));
        m_elementFlags.put("UL", new ElemDesc(524296));
        m_elementFlags.put("LI", new ElemDesc(8));
        m_elementFlags.put("FORM", new ElemDesc(8));
        m_elementFlags.put("LABEL", new ElemDesc(16384));
        m_elementFlags.put("INPUT", new ElemDesc(18434));
        m_elementFlags.put("SELECT", new ElemDesc(18432));
        m_elementFlags.put("OPTGROUP", new ElemDesc(0));
        m_elementFlags.put("OPTION", new ElemDesc(0));
        m_elementFlags.put("TEXTAREA", new ElemDesc(18432));
        m_elementFlags.put("FIELDSET", new ElemDesc(24));
        m_elementFlags.put("LEGEND", new ElemDesc(0));
        m_elementFlags.put("BUTTON", new ElemDesc(18432));
        m_elementFlags.put("TABLE", new ElemDesc(56));
        m_elementFlags.put("CAPTION", new ElemDesc(8));
        m_elementFlags.put("THEAD", new ElemDesc(8));
        m_elementFlags.put("TFOOT", new ElemDesc(8));
        m_elementFlags.put("TBODY", new ElemDesc(8));
        m_elementFlags.put("COLGROUP", new ElemDesc(8));
        m_elementFlags.put("COL", new ElemDesc(10));
        m_elementFlags.put("TR", new ElemDesc(8));
        m_elementFlags.put("TH", new ElemDesc(0));
        m_elementFlags.put("TD", new ElemDesc(0));
        m_elementFlags.put("HEAD", new ElemDesc(0x400008));
        m_elementFlags.put("TITLE", new ElemDesc(8));
        m_elementFlags.put("BASE", new ElemDesc(10));
        m_elementFlags.put("META", new ElemDesc(131082));
        m_elementFlags.put("STYLE", new ElemDesc(131336));
        m_elementFlags.put("SCRIPT", new ElemDesc(229632));
        m_elementFlags.put("NOSCRIPT", new ElemDesc(56));
        m_elementFlags.put("HTML", new ElemDesc(8));
        m_elementFlags.put("FONT", new ElemDesc(4096));
        m_elementFlags.put("S", new ElemDesc(4096));
        m_elementFlags.put("STRIKE", new ElemDesc(4096));
        m_elementFlags.put("U", new ElemDesc(4096));
        m_elementFlags.put("NOBR", new ElemDesc(4096));
        m_elementFlags.put("IFRAME", new ElemDesc(56));
        m_elementFlags.put("LAYER", new ElemDesc(56));
        m_elementFlags.put("ILAYER", new ElemDesc(56));
        ElemDesc elemDesc = (ElemDesc)m_elementFlags.get("AREA");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NOHREF", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BASE");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("BLOCKQUOTE");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("Q");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INS");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DEL");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("A");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NAME", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("LINK");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INPUT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("CHECKED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SELECT");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("MULTIPLE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTGROUP");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTION");
        elemDesc.setAttr("SELECTED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("TEXTAREA");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BUTTON");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SCRIPT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("FOR", 2);
        elemDesc.setAttr("DEFER", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("IMG");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OBJECT");
        elemDesc.setAttr("CLASSID", 2);
        elemDesc.setAttr("CODEBASE", 2);
        elemDesc.setAttr("DATA", 2);
        elemDesc.setAttr("ARCHIVE", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("DECLARE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("FORM");
        elemDesc.setAttr("ACTION", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("HEAD");
        elemDesc.setAttr("PROFILE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("FRAME");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("IFRAME");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("LAYER");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("ILAYER");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DIV");
        elemDesc.setAttr("SRC", 2);
        m_dummy = new ElemDesc(8);
    }

    public SerializerToHTML() {
        this.m_charInfo = m_htmlcharInfo;
    }

    public void startDocument() throws SAXException {
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        this.m_shouldNotWriteXMLHeader = true;
        if (this.m_needToOutputDocTypeDecl && (null != this.m_doctypeSystem || null != this.m_doctypePublic)) {
            this.accum("<!DOCTYPE HTML");
            if (null != this.m_doctypePublic) {
                this.accum(" PUBLIC \"");
                this.accum(this.m_doctypePublic);
                this.accum("\"");
            }
            if (null != this.m_doctypeSystem) {
                if (null == this.m_doctypePublic) {
                    this.accum(" SYSTEM \"");
                } else {
                    this.accum(" \"");
                }
                this.accum(this.m_doctypeSystem);
                this.accum("\"");
            }
            this.accum(">");
            this.outputLineSep();
        }
        this.m_needToOutputDocTypeDecl = false;
    }

    public boolean getOmitMetaTag() {
        return this.m_omitMetaTag;
    }

    public boolean getSpecialEscapeURLs() {
        return this.m_specialEscapeURLs;
    }

    private boolean isASCIIDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    public void setOmitMetaTag(boolean bl2) {
        this.m_omitMetaTag = bl2;
    }

    public void setSpecialEscapeURLs(boolean bl2) {
        this.m_specialEscapeURLs = bl2;
    }

    public void cdata(char[] cArray, int n2, int n3) throws SAXException {
        if (null != this.m_currentElementName && (this.m_currentElementName.equalsIgnoreCase("SCRIPT") || this.m_currentElementName.equalsIgnoreCase("STYLE"))) {
            try {
                this.writeParentTagEnd();
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                this.writeNormalizedChars(cArray, n2, n3, true);
            }
            catch (IOException iOException) {
                throw new SAXException(XSLMessages.createXPATHMessage("ER_OIERROR", null), iOException);
            }
        } else {
            super.cdata(cArray, n2, n3);
        }
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.m_isRawStack.peekOrFalse()) {
            try {
                this.writeParentTagEnd();
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                this.writeNormalizedChars(cArray, n2, n3, false);
                return;
            }
            catch (IOException iOException) {
                throw new SAXException(XSLMessages.createXPATHMessage("ER_OIERROR", null), iOException);
            }
        }
        super.characters(cArray, n2, n3);
    }

    private String makeHHString(int n2) {
        String string = Integer.toHexString(n2).toUpperCase();
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    public void entityReference(String string) throws SAXException {
        this.accum("&");
        this.accum(string);
        this.accum(";");
    }

    private boolean isHHSign(String string) {
        boolean bl2 = true;
        try {
            char c2 = (char)Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            bl2 = false;
        }
        return bl2;
    }

    private int copyEntityIntoBuf(String string, int n2) throws SAXException {
        int n3 = string.length();
        this.accum('&');
        for (int i2 = 0; i2 < n3; ++i2) {
            this.accum(string.charAt(i2));
        }
        this.accum(';');
        return n2;
    }

    public void writeAttrURI(String string, boolean bl2) throws SAXException {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (c2 < ' ' || c2 > '~') {
                if (bl2) {
                    int n3;
                    int n4;
                    int n5;
                    if (c2 <= '\u007f') {
                        this.accum('%');
                        this.accum(this.makeHHString(c2));
                        continue;
                    }
                    if (c2 <= '\u07ff') {
                        n5 = c2 >> 6 | 0xC0;
                        n4 = c2 & 0x3F | 0x80;
                        this.accum('%');
                        this.accum(this.makeHHString(n5));
                        this.accum('%');
                        this.accum(this.makeHHString(n4));
                        continue;
                    }
                    if (SerializerToHTML.isUTF16Surrogate(c2)) {
                        n5 = c2 & 0x3FF;
                        n4 = (n5 & 0x3C0) >> 6;
                        n3 = n4 + 1;
                        int n6 = (n5 & 0x3C) >> 2;
                        int n7 = (n5 & 3) << 4 & 0x30;
                        c2 = cArray[++i2];
                        int n8 = c2 & 0x3FF;
                        int n9 = n8 & 0x3F;
                        int n10 = 0xF0 | n3 >> 2;
                        int n11 = 0x80 | (n3 & 3) << 4 & 0x30 | n6;
                        int n12 = 0x80 | (n7 |= (n8 & 0x3C0) >> 6);
                        int n13 = 0x80 | n9;
                        this.accum('%');
                        this.accum(this.makeHHString(n10));
                        this.accum('%');
                        this.accum(this.makeHHString(n11));
                        this.accum('%');
                        this.accum(this.makeHHString(n12));
                        this.accum('%');
                        this.accum(this.makeHHString(n13));
                        continue;
                    }
                    n5 = c2 >> 12 | 0xE0;
                    n4 = (c2 & 0xFC0) >> 6 | 0x80;
                    n3 = c2 & 0x3F | 0x80;
                    this.accum('%');
                    this.accum(this.makeHHString(n5));
                    this.accum('%');
                    this.accum(this.makeHHString(n4));
                    this.accum('%');
                    this.accum(this.makeHHString(n3));
                    continue;
                }
                if (this.canConvert(c2)) {
                    this.accum(c2);
                    continue;
                }
                this.accum("&#");
                this.accum(Integer.toString(c2));
                this.accum(';');
                continue;
            }
            if ('%' == c2) {
                this.accum(c2);
                continue;
            }
            if (c2 == '\"') {
                if (bl2) {
                    this.accum("%22");
                    continue;
                }
                this.accum("&quot;");
                continue;
            }
            this.accum(c2);
        }
    }

    public void setOutputFormat(Properties properties) {
        this.m_specialEscapeURLs = OutputProperties.getBooleanProperty(OutputProperties.S_USE_URL_ESCAPING, properties);
        this.m_omitMetaTag = OutputProperties.getBooleanProperty(OutputProperties.S_OMIT_META_TAG, properties);
        super.setOutputFormat(properties);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (string.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (string.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            this.writeParentTagEnd();
            if (this.shouldIndent()) {
                this.indent(this.m_currentIndent);
            }
            this.accum("<?" + string);
            if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
                this.accum(" ");
            }
            this.accum(string2 + ">");
            if (this.m_elemStack.isEmpty()) {
                this.outputLineSep();
            }
            this.m_startNewLine = true;
        }
    }

    public void writeAttrString(String string, String string2) throws SAXException {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3;
            char c2 = cArray[i2];
            if (this.canConvert(c2) && !this.m_charInfo.isSpecial(c2)) {
                this.accum(c2);
                continue;
            }
            if ('<' == c2 || '>' == c2) {
                this.accum(c2);
                continue;
            }
            if ('&' == c2 && i2 + 1 < n2 && '{' == cArray[i2 + 1]) {
                this.accum(c2);
                continue;
            }
            int n3 = this.accumDefaultEntity(c2, i2, cArray, n2, false);
            if (i2 != n3) {
                i2 = n3 - 1;
                continue;
            }
            if (SerializerToHTML.isUTF16Surrogate(c2)) {
                try {
                    i2 = this.writeUTF16Surrogate(c2, cArray, i2, n2);
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
            if (null != (string3 = this.m_charInfo.getEntityNameForChar(c2))) {
                this.accum('&');
                this.accum(string3);
                this.accum(';');
                continue;
            }
            if (this.canConvert(c2)) {
                this.accum(c2);
                continue;
            }
            this.accum("&#");
            this.accum(Integer.toString(c2));
            this.accum(';');
        }
    }

    ElemDesc getElemDesc(String string) {
        Object object;
        if (null != string && null != (object = m_elementFlags.get(string))) {
            return (ElemDesc)object;
        }
        return m_dummy;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (null != string && string.length() > 0) {
            super.endElement(string, string2, string3);
            return;
        }
        this.m_currentIndent -= this.m_indentAmount;
        boolean bl2 = this.childNodesWereAdded();
        this.m_isRawStack.pop();
        ElemDesc elemDesc = this.getElemDesc(string3);
        boolean bl3 = elemDesc.is(8);
        boolean bl4 = false;
        if (this.m_ispreserve) {
            this.m_ispreserve = false;
        } else if (this.m_doIndent && (!this.m_inBlockElem || bl3)) {
            this.m_startNewLine = true;
            bl4 = true;
        }
        boolean bl5 = this.m_inBlockElem = !bl3;
        if (bl2) {
            if (bl4) {
                this.indent(this.m_currentIndent);
            }
            this.accum("</");
            this.accum(string3);
            this.accum('>');
            this.m_currentElementName = string3;
        } else if (!elemDesc.is(2)) {
            this.accum('>');
            this.accum('<');
            this.accum('/');
            this.accum(string3);
            this.accum('>');
        } else {
            this.accum('>');
        }
        if (elemDesc.is(0x200000)) {
            this.m_ispreserve = true;
        }
        if (bl2 && !this.m_preserves.isEmpty()) {
            this.m_preserves.pop();
        }
        this.m_isprevtext = false;
        this.m_cdataSectionStates.pop();
    }

    protected void processAttribute(String string, ElemDesc elemDesc, String string2) throws SAXException {
        this.accum(' ');
        if ((string2.length() == 0 || string2.equalsIgnoreCase(string)) && elemDesc.isAttrFlagSet(string, 4)) {
            this.accum(string);
        } else {
            this.accum(string);
            this.accum('=');
            this.accum('\"');
            if (elemDesc.isAttrFlagSet(string, 2)) {
                this.writeAttrURI(string2, this.m_specialEscapeURLs);
            } else {
                this.writeAttrString(string2, this.m_encoding);
            }
            this.accum('\"');
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (null != string && string.length() > 0) {
            super.startElement(string, string2, string3, attributes);
            return;
        }
        boolean bl2 = this.m_doIndent;
        this.writeParentTagEnd();
        this.pushState(string, string2, this.m_cdataSectionNames, this.m_cdataSectionStates);
        ElemDesc elemDesc = this.getElemDesc(string3);
        boolean bl3 = elemDesc.is(8);
        boolean bl4 = elemDesc.is(0x400000);
        if (this.m_ispreserve) {
            this.m_ispreserve = false;
        } else if (this.m_doIndent && null != this.m_currentElementName && (!this.m_inBlockElem || bl3)) {
            this.m_startNewLine = true;
            this.indent(this.m_currentIndent);
        }
        this.m_inBlockElem = !bl3;
        this.m_isRawStack.push(elemDesc.is(256));
        this.m_currentElementName = string3;
        this.accum('<');
        this.accum(string3);
        int n2 = attributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.processAttribute(attributes.getQName(i2), elemDesc, attributes.getValue(i2));
        }
        this.openElementForChildren();
        this.m_currentIndent += this.m_indentAmount;
        this.m_isprevtext = false;
        this.m_doIndent = bl2;
        if (bl4) {
            this.writeParentTagEnd();
            if (!this.m_omitMetaTag) {
                if (this.m_doIndent) {
                    this.indent(this.m_currentIndent);
                }
                this.accum("<META http-equiv=\"Content-Type\" content=\"text/html; charset=");
                String string4 = Encodings.getMimeEncoding(this.m_encoding);
                this.accum(string4);
                this.accum('\"');
                this.accum('>');
            }
        }
    }
}

